/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.InputStream;
/*      */ import java.io.Reader;
/*      */ import java.sql.Blob;
/*      */ import java.sql.Clob;
/*      */ import java.sql.PreparedStatement;
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLWarning;
/*      */ import java.sql.Statement;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Iterator;
/*      */ import oracle.jdbc.OracleResultSet.AuthorizationIndicator;
/*      */ import oracle.sql.BLOB;
/*      */ import oracle.sql.CLOB;
/*      */ import oracle.sql.Datum;
/*      */ 
/*      */ class UpdatableResultSet extends GeneratedUpdatableResultSet
/*      */ {
/*      */   static final int concurrencyType = 1008;
/*      */   static final int BEGIN_COLUMN_INDEX = 0;
/*      */   private int wasNull;
/*   59 */   private static int _MIN_STREAM_SIZE = 4000;
/*      */   OracleResultSet resultSet;
/*      */   boolean isCachedRset;
/*      */   OracleStatement scrollStmt;
/*      */   ResultSetMetaData rsetMetaData;
/*      */   private int columnCount;
/*      */   private OraclePreparedStatement deleteStmt;
/*      */   private OraclePreparedStatement insertStmt;
/*      */   private OraclePreparedStatement updateStmt;
/*      */   private int[] indexColsChanged;
/*      */   private Object[] rowBuffer;
/*      */   private boolean[] m_nullIndicator;
/*      */   private int[][] typeInfo;
/*      */   private boolean isInserting;
/*      */   private boolean isUpdating;
/*  550 */   ArrayList tempClobsToFree = null;
/*  551 */   ArrayList tempBlobsToFree = null;
/*      */ 
/* 1638 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   UpdatableResultSet(OracleStatement paramOracleStatement, OracleResultSet paramOracleResultSet)
/*      */     throws SQLException
/*      */   {
/*   98 */     super(paramOracleStatement, paramOracleResultSet);
/*      */ 
/*  101 */     this.resultSet = paramOracleResultSet;
/*  102 */     this.scrollStmt = paramOracleStatement;
/*      */ 
/*  104 */     this.deleteStmt = null;
/*  105 */     this.insertStmt = null;
/*  106 */     this.updateStmt = null;
/*  107 */     this.indexColsChanged = null;
/*  108 */     this.rowBuffer = null;
/*  109 */     this.m_nullIndicator = null;
/*  110 */     this.typeInfo = ((int[][])null);
/*  111 */     this.isInserting = false;
/*  112 */     this.isUpdating = false;
/*  113 */     this.wasNull = -1;
/*  114 */     this.rsetMetaData = null;
/*  115 */     this.columnCount = 0;
/*      */ 
/*  117 */     getInternalMetadata();
/*      */ 
/*  119 */     this.isCachedRset = true;
/*      */   }
/*      */ 
/*      */   void ensureOpen()
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/*  125 */     if (this.closed)
/*      */     {
/*  127 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10);
/*  128 */       localSQLException.fillInStackTrace();
/*  129 */       throw localSQLException;
/*      */     }
/*      */ 
/*  132 */     if ((this.resultSet == null) || (this.scrollStmt == null) || (this.scrollStmt.closed))
/*      */     {
/*  135 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  136 */       localSQLException.fillInStackTrace();
/*  137 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void close()
/*      */     throws SQLException
/*      */   {
/*  151 */     if (this.closed) return;
/*  152 */     synchronized (this.connection)
/*      */     {
/*  160 */       super.close();
/*      */ 
/*  162 */       if (this.resultSet != null)
/*  163 */         this.resultSet.close();
/*  164 */       if (this.insertStmt != null)
/*  165 */         this.insertStmt.close();
/*  166 */       if (this.updateStmt != null)
/*  167 */         this.updateStmt.close();
/*  168 */       if (this.deleteStmt != null)
/*  169 */         this.deleteStmt.close();
/*  170 */       if (this.scrollStmt != null) {
/*  171 */         this.scrollStmt.notifyCloseRset();
/*      */       }
/*  173 */       cancelRowInserts();
/*      */ 
/*  175 */       this.connection = LogicalConnection.closedConnection;
/*  176 */       this.resultSet = null;
/*  177 */       this.scrollStmt = null;
/*  178 */       this.rsetMetaData = null;
/*  179 */       this.scrollStmt = null;
/*  180 */       this.deleteStmt = null;
/*  181 */       this.insertStmt = null;
/*  182 */       this.updateStmt = null;
/*  183 */       this.indexColsChanged = null;
/*  184 */       this.rowBuffer = null;
/*  185 */       this.m_nullIndicator = null;
/*  186 */       this.typeInfo = ((int[][])null);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean wasNull()
/*      */     throws SQLException
/*      */   {
/*  193 */     synchronized (this.connection)
/*      */     {
/*  200 */       ensureOpen();
/*  201 */       switch (this.wasNull)
/*      */       {
/*      */       case 1:
/*  205 */         return true;
/*      */       case 2:
/*  208 */         return false;
/*      */       case 4:
/*  211 */         return this.resultSet.wasNull();
/*      */       case 3:
/*      */       }
/*      */ 
/*  217 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 24);
/*  218 */       localSQLException.fillInStackTrace();
/*  219 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Statement getStatement()
/*      */     throws SQLException
/*      */   {
/*  231 */     synchronized (this.connection)
/*      */     {
/*  238 */       ensureOpen();
/*  239 */       return this.scrollStmt;
/*      */     }
/*      */   }
/*      */ 
/*      */   public SQLWarning getWarnings()
/*      */     throws SQLException
/*      */   {
/*  246 */     synchronized (this.connection)
/*      */     {
/*  253 */       ensureOpen();
/*  254 */       SQLWarning localSQLWarning1 = this.resultSet.getWarnings();
/*      */ 
/*  256 */       if (this.sqlWarning == null) {
/*  257 */         return localSQLWarning1;
/*      */       }
/*      */ 
/*  260 */       SQLWarning localSQLWarning2 = this.sqlWarning;
/*      */ 
/*  262 */       while (localSQLWarning2.getNextWarning() != null) {
/*  263 */         localSQLWarning2 = localSQLWarning2.getNextWarning();
/*      */       }
/*  265 */       localSQLWarning2.setNextWarning(localSQLWarning1);
/*      */ 
/*  268 */       return this.sqlWarning;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void clearWarnings()
/*      */     throws SQLException
/*      */   {
/*  275 */     synchronized (this.connection)
/*      */     {
/*  282 */       ensureOpen();
/*  283 */       this.sqlWarning = null;
/*      */ 
/*  285 */       this.resultSet.clearWarnings();
/*      */     }
/*      */   }
/*      */ 
/*      */   public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  293 */     synchronized (this.connection)
/*      */     {
/*  300 */       ensureOpen();
/*  301 */       if (this.isRowDeleted) {
/*  302 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  303 */         localSQLException.fillInStackTrace();
/*  304 */         throw localSQLException;
/*      */       }
/*  306 */       return this.resultSet.getAuthorizationIndicator(paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean next()
/*      */     throws SQLException
/*      */   {
/*  317 */     synchronized (this.connection)
/*      */     {
/*  324 */       ensureOpen();
/*  325 */       cancelRowChanges();
/*  326 */       if (this.isRowDeleted) {
/*  327 */         this.isRowDeleted = false;
/*  328 */         return this.resultSet.isValidRow();
/*      */       }
/*  330 */       return this.resultSet.next();
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isBeforeFirst()
/*      */     throws SQLException
/*      */   {
/*  337 */     synchronized (this.connection)
/*      */     {
/*  344 */       ensureOpen();
/*  345 */       if (this.isRowDeleted) return this.resultSet.isFirst();
/*  346 */       return this.resultSet.isBeforeFirst();
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isAfterLast()
/*      */     throws SQLException
/*      */   {
/*  353 */     synchronized (this.connection)
/*      */     {
/*  360 */       ensureOpen();
/*  361 */       return this.resultSet.isAfterLast();
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isFirst()
/*      */     throws SQLException
/*      */   {
/*  368 */     synchronized (this.connection)
/*      */     {
/*  375 */       ensureOpen();
/*  376 */       if (this.isRowDeleted) {
/*  377 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  378 */         localSQLException.fillInStackTrace();
/*  379 */         throw localSQLException;
/*      */       }
/*  381 */       return this.resultSet.isFirst();
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isLast()
/*      */     throws SQLException
/*      */   {
/*  388 */     synchronized (this.connection)
/*      */     {
/*  395 */       ensureOpen();
/*  396 */       if (this.isRowDeleted) {
/*  397 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  398 */         localSQLException.fillInStackTrace();
/*  399 */         throw localSQLException;
/*      */       }
/*  401 */       return this.resultSet.isLast();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void beforeFirst()
/*      */     throws SQLException
/*      */   {
/*  408 */     synchronized (this.connection)
/*      */     {
/*  415 */       ensureOpen();
/*  416 */       cancelRowChanges();
/*  417 */       this.isRowDeleted = false;
/*  418 */       this.resultSet.beforeFirst();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void afterLast()
/*      */     throws SQLException
/*      */   {
/*  425 */     synchronized (this.connection)
/*      */     {
/*  432 */       ensureOpen();
/*  433 */       cancelRowChanges();
/*  434 */       this.isRowDeleted = false;
/*  435 */       this.resultSet.afterLast();
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean first()
/*      */     throws SQLException
/*      */   {
/*  442 */     synchronized (this.connection)
/*      */     {
/*  449 */       ensureOpen();
/*  450 */       cancelRowChanges();
/*  451 */       this.isRowDeleted = false;
/*  452 */       return this.resultSet.first();
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean last()
/*      */     throws SQLException
/*      */   {
/*  459 */     synchronized (this.connection)
/*      */     {
/*  466 */       ensureOpen();
/*  467 */       cancelRowChanges();
/*  468 */       this.isRowDeleted = false;
/*  469 */       return this.resultSet.last();
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getRow()
/*      */     throws SQLException
/*      */   {
/*  476 */     synchronized (this.connection)
/*      */     {
/*  483 */       ensureOpen();
/*  484 */       if (this.isRowDeleted) {
/*  485 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  486 */         localSQLException.fillInStackTrace();
/*  487 */         throw localSQLException;
/*      */       }
/*  489 */       return this.resultSet.getRow();
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean absolute(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  496 */     synchronized (this.connection)
/*      */     {
/*  503 */       ensureOpen();
/*  504 */       cancelRowChanges();
/*  505 */       this.isRowDeleted = false;
/*  506 */       return this.resultSet.absolute(paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean relative(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  513 */     synchronized (this.connection)
/*      */     {
/*  520 */       ensureOpen();
/*  521 */       cancelRowChanges();
/*  522 */       if (this.isRowDeleted) {
/*  523 */         paramInt--;
/*  524 */         this.isRowDeleted = false;
/*      */       }
/*  526 */       return this.resultSet.relative(paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean previous()
/*      */     throws SQLException
/*      */   {
/*  533 */     synchronized (this.connection)
/*      */     {
/*  540 */       ensureOpen();
/*  541 */       cancelRowChanges();
/*  542 */       this.isRowDeleted = false;
/*  543 */       return this.resultSet.previous();
/*      */     }
/*      */   }
/*      */ 
/*      */   void addToTempLobsToFree(Clob paramClob)
/*      */   {
/*  556 */     if (this.tempClobsToFree == null)
/*  557 */       this.tempClobsToFree = new ArrayList();
/*  558 */     this.tempClobsToFree.add(paramClob);
/*      */   }
/*      */ 
/*      */   void addToTempLobsToFree(Blob paramBlob)
/*      */   {
/*  565 */     if (this.tempBlobsToFree == null)
/*  566 */       this.tempBlobsToFree = new ArrayList();
/*  567 */     this.tempBlobsToFree.add(paramBlob);
/*      */   }
/*      */ 
/*      */   void cleanTempLobs()
/*      */   {
/*  574 */     cleanTempClobs(this.tempClobsToFree);
/*  575 */     cleanTempBlobs(this.tempBlobsToFree);
/*  576 */     this.tempClobsToFree = null;
/*  577 */     this.tempBlobsToFree = null;
/*      */   }
/*      */ 
/*      */   void cleanTempBlobs(ArrayList paramArrayList)
/*      */   {
/*  584 */     if (paramArrayList != null)
/*      */     {
/*  586 */       Iterator localIterator = paramArrayList.iterator();
/*      */ 
/*  588 */       while (localIterator.hasNext())
/*      */       {
/*      */         try
/*      */         {
/*  592 */           ((BLOB)localIterator.next()).freeTemporary();
/*      */         }
/*      */         catch (SQLException localSQLException)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void cleanTempClobs(ArrayList paramArrayList)
/*      */   {
/*  606 */     if (paramArrayList != null)
/*      */     {
/*  608 */       Iterator localIterator = paramArrayList.iterator();
/*      */ 
/*  610 */       while (localIterator.hasNext())
/*      */       {
/*      */         try
/*      */         {
/*  614 */           ((CLOB)localIterator.next()).freeTemporary();
/*      */         }
/*      */         catch (SQLException localSQLException)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public ResultSetMetaData getMetaData()
/*      */     throws SQLException
/*      */   {
/*  636 */     return this.resultSet.getMetaData();
/*      */   }
/*      */ 
/*      */   public int findColumn(String paramString)
/*      */     throws SQLException
/*      */   {
/*  642 */     synchronized (this.connection)
/*      */     {
/*  649 */       ensureOpen();
/*  650 */       return this.resultSet.findColumn(paramString);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setFetchDirection(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  661 */     synchronized (this.connection)
/*      */     {
/*  668 */       ensureOpen();
/*  669 */       this.resultSet.setFetchDirection(paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getFetchDirection()
/*      */     throws SQLException
/*      */   {
/*  676 */     synchronized (this.connection)
/*      */     {
/*  683 */       ensureOpen();
/*  684 */       return this.resultSet.getFetchDirection();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setFetchSize(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  691 */     synchronized (this.connection)
/*      */     {
/*  698 */       ensureOpen();
/*  699 */       this.resultSet.setFetchSize(paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getFetchSize()
/*      */     throws SQLException
/*      */   {
/*  706 */     synchronized (this.connection)
/*      */     {
/*  713 */       ensureOpen();
/*  714 */       return this.resultSet.getFetchSize();
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getType()
/*      */     throws SQLException
/*      */   {
/*  727 */     ensureOpen();
/*  728 */     return this.scrollStmt.realRsetType.getType();
/*      */   }
/*      */ 
/*      */   public int getConcurrency()
/*      */     throws SQLException
/*      */   {
/*  740 */     ensureOpen();
/*  741 */     return 1008;
/*      */   }
/*      */ 
/*      */   public String getCursorName()
/*      */     throws SQLException
/*      */   {
/*  747 */     synchronized (this.connection)
/*      */     {
/*  755 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 23, "getCursorName");
/*  756 */       localSQLException.fillInStackTrace();
/*  757 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean rowUpdated()
/*      */     throws SQLException
/*      */   {
/*  775 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean rowInserted()
/*      */     throws SQLException
/*      */   {
/*  787 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean rowDeleted()
/*      */     throws SQLException
/*      */   {
/*  799 */     return this.isRowDeleted;
/*      */   }
/*      */ 
/*      */   public void insertRow()
/*      */     throws SQLException
/*      */   {
/*  805 */     synchronized (this.connection)
/*      */     {
/*  812 */       ensureOpen();
/*      */       SQLException localSQLException;
/*  813 */       if (this.isRowDeleted) {
/*  814 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  815 */         localSQLException.fillInStackTrace();
/*  816 */         throw localSQLException;
/*      */       }
/*  818 */       if (!isOnInsertRow())
/*      */       {
/*  820 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 83);
/*  821 */         localSQLException.fillInStackTrace();
/*  822 */         throw localSQLException;
/*      */       }
/*      */ 
/*  825 */       prepareInsertRowStatement();
/*  826 */       prepareInsertRowBinds();
/*  827 */       executeInsertRow();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateRow()
/*      */     throws SQLException
/*      */   {
/*  834 */     synchronized (this.connection)
/*      */     {
/*  841 */       ensureOpen();
/*      */       SQLException localSQLException;
/*  842 */       if (this.isRowDeleted) {
/*  843 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  844 */         localSQLException.fillInStackTrace();
/*  845 */         throw localSQLException;
/*      */       }
/*      */ 
/*  849 */       if (isOnInsertRow())
/*      */       {
/*  851 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 84);
/*  852 */         localSQLException.fillInStackTrace();
/*  853 */         throw localSQLException;
/*      */       }
/*      */ 
/*  856 */       int i = getNumColumnsChanged();
/*      */ 
/*  858 */       if (i > 0)
/*      */       {
/*  860 */         prepareUpdateRowStatement(i);
/*  861 */         prepareUpdateRowBinds(i);
/*  862 */         executeUpdateRow();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void deleteRow()
/*      */     throws SQLException
/*      */   {
/*  870 */     synchronized (this.connection)
/*      */     {
/*  877 */       ensureOpen();
/*      */       SQLException localSQLException;
/*  879 */       if (this.isRowDeleted) {
/*  880 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  881 */         localSQLException.fillInStackTrace();
/*  882 */         throw localSQLException;
/*      */       }
/*      */ 
/*  885 */       if (isOnInsertRow())
/*      */       {
/*  887 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 84);
/*  888 */         localSQLException.fillInStackTrace();
/*  889 */         throw localSQLException;
/*      */       }
/*      */ 
/*  892 */       prepareDeleteRowStatement();
/*  893 */       prepareDeleteRowBinds();
/*  894 */       executeDeleteRow();
/*  895 */       this.isRowDeleted = true;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void refreshRow()
/*      */     throws SQLException
/*      */   {
/*  902 */     synchronized (this.connection)
/*      */     {
/*  909 */       ensureOpen();
/*      */       SQLException localSQLException;
/*  910 */       if (this.isRowDeleted) {
/*  911 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  912 */         localSQLException.fillInStackTrace();
/*  913 */         throw localSQLException;
/*      */       }
/*      */ 
/*  916 */       if (isOnInsertRow())
/*      */       {
/*  918 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 84);
/*  919 */         localSQLException.fillInStackTrace();
/*  920 */         throw localSQLException;
/*      */       }
/*      */ 
/*  923 */       this.resultSet.refreshRow();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void cancelRowUpdates()
/*      */     throws SQLException
/*      */   {
/*  930 */     synchronized (this.connection)
/*      */     {
/*  937 */       ensureOpen();
/*  938 */       if (this.isUpdating)
/*      */       {
/*  940 */         this.isUpdating = false;
/*      */ 
/*  942 */         clearRowBuffer();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void moveToInsertRow()
/*      */     throws SQLException
/*      */   {
/*  950 */     synchronized (this.connection)
/*      */     {
/*  957 */       ensureOpen();
/*  958 */       if (isOnInsertRow())
/*  959 */         return;
/*  960 */       this.isRowDeleted = false;
/*  961 */       this.isInserting = true;
/*      */ 
/*  964 */       if (this.rowBuffer == null) {
/*  965 */         this.rowBuffer = new Object[getColumnCount()];
/*      */       }
/*  967 */       if (this.m_nullIndicator == null) {
/*  968 */         this.m_nullIndicator = new boolean[getColumnCount()];
/*      */       }
/*  970 */       clearRowBuffer();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void moveToCurrentRow()
/*      */     throws SQLException
/*      */   {
/*  977 */     synchronized (this.connection)
/*      */     {
/*  984 */       ensureOpen();
/*  985 */       if (this.isRowDeleted) {
/*  986 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  987 */         localSQLException.fillInStackTrace();
/*  988 */         throw localSQLException;
/*      */       }
/*  990 */       cancelRowInserts();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateNull(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1001 */     synchronized (this.connection)
/*      */     {
/* 1008 */       if (this.isRowDeleted) {
/* 1009 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1010 */         localSQLException.fillInStackTrace();
/* 1011 */         throw localSQLException;
/*      */       }
/* 1013 */       setRowBufferAt(paramInt, null);
/*      */     }
/*      */   }
/*      */ 
/*      */   int getColumnCount()
/*      */     throws SQLException
/*      */   {
/* 1028 */     if (this.columnCount == 0) {
/* 1029 */       this.columnCount = this.resultSet.getColumnCount();
/*      */     }
/* 1031 */     return this.columnCount;
/*      */   }
/*      */ 
/*      */   ResultSetMetaData getInternalMetadata()
/*      */     throws SQLException
/*      */   {
/* 1041 */     if (this.rsetMetaData == null) {
/* 1042 */       this.rsetMetaData = this.resultSet.getMetaData();
/*      */     }
/* 1044 */     return this.rsetMetaData;
/*      */   }
/*      */ 
/*      */   private void cancelRowChanges()
/*      */     throws SQLException
/*      */   {
/* 1050 */     synchronized (this.connection)
/*      */     {
/* 1052 */       if (this.isInserting) {
/* 1053 */         cancelRowInserts();
/*      */       }
/* 1055 */       if (this.isUpdating)
/* 1056 */         cancelRowUpdates();
/*      */     }
/*      */   }
/*      */ 
/*      */   boolean isOnInsertRow()
/*      */   {
/* 1067 */     return this.isInserting;
/*      */   }
/*      */ 
/*      */   private void cancelRowInserts()
/*      */   {
/* 1077 */     if (this.isInserting)
/*      */     {
/* 1079 */       this.isInserting = false;
/*      */ 
/* 1081 */       clearRowBuffer();
/*      */     }
/*      */   }
/*      */ 
/*      */   boolean isUpdatingRow()
/*      */   {
/* 1092 */     return this.isUpdating;
/*      */   }
/*      */ 
/*      */   private void clearRowBuffer()
/*      */   {
/*      */     int i;
/* 1102 */     if (this.rowBuffer != null)
/*      */     {
/* 1104 */       for (i = 0; i < this.rowBuffer.length; i++) {
/* 1105 */         this.rowBuffer[i] = null;
/*      */       }
/*      */     }
/* 1108 */     if (this.m_nullIndicator != null)
/*      */     {
/* 1110 */       for (i = 0; i < this.m_nullIndicator.length; i++) {
/* 1111 */         this.m_nullIndicator[i] = false;
/*      */       }
/*      */     }
/* 1114 */     if (this.typeInfo != null)
/*      */     {
/* 1116 */       for (i = 0; i < this.typeInfo.length; i++) {
/* 1117 */         if (this.typeInfo[i] != null)
/* 1118 */           for (int j = 0; j < this.typeInfo[i].length; j++)
/* 1119 */             this.typeInfo[i][j] = 0;
/*      */       }
/*      */     }
/* 1122 */     cleanTempLobs();
/*      */   }
/*      */ 
/*      */   protected void setRowBufferAt(int paramInt, Datum paramDatum)
/*      */     throws SQLException
/*      */   {
/* 1133 */     setRowBufferAt(paramInt, paramDatum, (int[])null);
/*      */   }
/*      */ 
/*      */   protected void setRowBufferAt(int paramInt, Object paramObject, int[] paramArrayOfInt)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 1144 */     if (!this.isInserting)
/*      */     {
/* 1146 */       if ((isBeforeFirst()) || (isAfterLast()) || (getRow() == 0))
/*      */       {
/* 1148 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1149 */         localSQLException.fillInStackTrace();
/* 1150 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1153 */       this.isUpdating = true;
/*      */     }
/*      */ 
/* 1156 */     if ((paramInt < 1) || (paramInt > getColumnCount()))
/*      */     {
/* 1158 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "setRowBufferAt");
/* 1159 */       localSQLException.fillInStackTrace();
/* 1160 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1163 */     if (this.rowBuffer == null) {
/* 1164 */       this.rowBuffer = new Object[getColumnCount()];
/*      */     }
/* 1166 */     if (this.m_nullIndicator == null)
/*      */     {
/* 1168 */       this.m_nullIndicator = new boolean[getColumnCount()];
/*      */ 
/* 1170 */       for (int i = 0; i < getColumnCount(); i++) {
/* 1171 */         this.m_nullIndicator[i] = false;
/*      */       }
/*      */     }
/* 1174 */     if (paramArrayOfInt != null)
/*      */     {
/* 1176 */       if (this.typeInfo == null)
/*      */       {
/* 1178 */         this.typeInfo = new int[getColumnCount()][];
/*      */       }
/*      */ 
/* 1181 */       this.typeInfo[(paramInt - 1)] = paramArrayOfInt;
/*      */     }
/*      */ 
/* 1184 */     this.rowBuffer[(paramInt - 1)] = paramObject;
/* 1185 */     this.m_nullIndicator[(paramInt - 1)] = (paramObject == null ? 1 : false);
/*      */   }
/*      */ 
/*      */   protected Datum getRowBufferDatumAt(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1195 */     if ((paramInt < 1) || (paramInt > getColumnCount()))
/*      */     {
/* 1197 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "getRowBufferDatumAt");
/* 1198 */       ((SQLException)localObject1).fillInStackTrace();
/* 1199 */       throw ((Throwable)localObject1);
/*      */     }
/*      */ 
/* 1202 */     Object localObject1 = null;
/*      */ 
/* 1204 */     if (this.rowBuffer != null)
/*      */     {
/* 1206 */       Object localObject2 = this.rowBuffer[(paramInt - 1)];
/*      */ 
/* 1208 */       if (localObject2 != null)
/*      */       {
/* 1210 */         if ((localObject2 instanceof Datum))
/*      */         {
/* 1212 */           localObject1 = (Datum)localObject2;
/*      */         }
/*      */         else
/*      */         {
/* 1216 */           OracleResultSetMetaData localOracleResultSetMetaData = (OracleResultSetMetaData)getInternalMetadata();
/* 1217 */           localObject1 = SQLUtil.makeOracleDatum(this.connection, localObject2, localOracleResultSetMetaData.getColumnType(paramInt), null, localOracleResultSetMetaData.isNCHAR(paramInt));
/*      */ 
/* 1221 */           this.rowBuffer[(paramInt - 1)] = localObject1;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1226 */     return localObject1;
/*      */   }
/*      */ 
/*      */   protected Object getRowBufferAt(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1236 */     if ((paramInt < 1) || (paramInt > getColumnCount()))
/*      */     {
/* 1238 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "getRowBufferDatumAt");
/* 1239 */       localSQLException.fillInStackTrace();
/* 1240 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1243 */     if (this.rowBuffer != null)
/*      */     {
/* 1245 */       return this.rowBuffer[(paramInt - 1)];
/*      */     }
/*      */ 
/* 1248 */     return null;
/*      */   }
/*      */ 
/*      */   protected boolean isRowBufferUpdatedAt(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1255 */     if ((paramInt < 1) || (paramInt > getColumnCount()))
/*      */     {
/* 1257 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "getRowBufferDatumAt");
/* 1258 */       localSQLException.fillInStackTrace();
/* 1259 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1262 */     if (this.rowBuffer == null) return false;
/* 1263 */     return (this.rowBuffer[(paramInt - 1)] != null) || (this.m_nullIndicator[(paramInt - 1)] != 0);
/*      */   }
/*      */ 
/*      */   private void prepareInsertRowStatement()
/*      */     throws SQLException
/*      */   {
/* 1274 */     if (this.insertStmt == null) {
/* 1275 */       String str = this.scrollStmt.sqlObject.getInsertSqlForUpdatableResultSet(this);
/* 1276 */       PreparedStatement localPreparedStatement = this.connection.prepareStatement(str);
/* 1277 */       this.insertStmt = ((OraclePreparedStatement)((OraclePreparedStatementWrapper)localPreparedStatement).preparedStatement);
/* 1278 */       this.insertStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
/* 1279 */       if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing())
/* 1280 */         this.insertStmt.setEscapeProcessing(true);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void prepareInsertRowBinds()
/*      */     throws SQLException
/*      */   {
/* 1290 */     int i = 1;
/*      */ 
/* 1293 */     i = prepareSubqueryBinds(this.insertStmt, i);
/*      */ 
/* 1295 */     OracleResultSetMetaData localOracleResultSetMetaData = (OracleResultSetMetaData)getInternalMetadata();
/*      */ 
/* 1297 */     for (int j = 1; j <= getColumnCount(); j++) {
/* 1298 */       Object localObject = getRowBufferAt(j);
/* 1299 */       if (localObject != null) {
/* 1300 */         if ((localObject instanceof Reader)) {
/* 1301 */           if (localOracleResultSetMetaData.isNCHAR(j)) {
/* 1302 */             this.insertStmt.setFormOfUse(i + j - 1, (short)2);
/*      */           }
/* 1304 */           this.insertStmt.setCharacterStream(i + j - 1, (Reader)localObject, this.typeInfo[(j - 1)][0]);
/*      */         }
/* 1307 */         else if ((localObject instanceof InputStream)) {
/* 1308 */           if (this.typeInfo[(j - 1)][1] == 2) {
/* 1309 */             this.insertStmt.setBinaryStream(i + j - 1, (InputStream)localObject, this.typeInfo[(j - 1)][0]);
/*      */           }
/* 1313 */           else if (this.typeInfo[(j - 1)][1] == 1) {
/* 1314 */             this.insertStmt.setAsciiStream(i + j - 1, (InputStream)localObject, this.typeInfo[(j - 1)][0]);
/*      */           }
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/* 1320 */           Datum localDatum = getRowBufferDatumAt(j);
/* 1321 */           if (localOracleResultSetMetaData.isNCHAR(j)) {
/* 1322 */             this.insertStmt.setFormOfUse(i + j - 1, (short)2);
/*      */           }
/*      */ 
/* 1325 */           this.insertStmt.setOracleObject(i + j - 1, localDatum);
/*      */         }
/*      */       }
/*      */       else {
/* 1329 */         int k = getInternalMetadata().getColumnType(j);
/* 1330 */         if ((k == 2006) || (k == 2002) || (k == 2008) || (k == 2007) || (k == 2003) || (k == 2009))
/*      */         {
/* 1334 */           this.insertStmt.setNull(i + j - 1, k, getInternalMetadata().getColumnTypeName(j));
/*      */         }
/*      */         else
/*      */         {
/* 1339 */           this.insertStmt.setNull(i + j - 1, k);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void executeInsertRow()
/*      */     throws SQLException
/*      */   {
/* 1352 */     if (this.insertStmt.executeUpdate() != 1)
/*      */     {
/* 1354 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 85);
/* 1355 */       localSQLException.fillInStackTrace();
/* 1356 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   private int getNumColumnsChanged()
/*      */     throws SQLException
/*      */   {
/* 1369 */     int i = 0;
/*      */ 
/* 1371 */     if (this.indexColsChanged == null) {
/* 1372 */       this.indexColsChanged = new int[getColumnCount()];
/*      */     }
/* 1374 */     if (this.rowBuffer != null)
/*      */     {
/* 1376 */       for (int j = 0; j < getColumnCount(); j++)
/*      */       {
/* 1378 */         if ((this.rowBuffer[j] != null) || ((this.rowBuffer[j] == null) && (this.m_nullIndicator[j] != 0)))
/*      */         {
/* 1381 */           this.indexColsChanged[(i++)] = j;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1386 */     return i;
/*      */   }
/*      */ 
/*      */   private void prepareUpdateRowStatement(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1400 */     if (this.updateStmt != null) this.updateStmt.close();
/*      */ 
/* 1402 */     String str = this.scrollStmt.sqlObject.getUpdateSqlForUpdatableResultSet(this, paramInt, this.rowBuffer, this.indexColsChanged);
/*      */ 
/* 1407 */     PreparedStatement localPreparedStatement = this.connection.prepareStatement(str);
/* 1408 */     this.updateStmt = ((OraclePreparedStatement)((OraclePreparedStatementWrapper)localPreparedStatement).preparedStatement);
/* 1409 */     this.updateStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
/* 1410 */     if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing())
/* 1411 */       this.updateStmt.setEscapeProcessing(true);
/*      */   }
/*      */ 
/*      */   private void prepareUpdateRowBinds(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1422 */     int i = 1;
/*      */ 
/* 1425 */     i = prepareSubqueryBinds(this.updateStmt, i);
/*      */ 
/* 1427 */     OracleResultSetMetaData localOracleResultSetMetaData = (OracleResultSetMetaData)getInternalMetadata();
/*      */ 
/* 1429 */     for (int j = 0; j < paramInt; j++) {
/* 1430 */       int k = this.indexColsChanged[j];
/* 1431 */       Object localObject = getRowBufferAt(k + 1);
/*      */ 
/* 1433 */       if (localObject != null) {
/* 1434 */         if ((localObject instanceof Reader)) {
/* 1435 */           if (localOracleResultSetMetaData.isNCHAR(k + 1))
/* 1436 */             this.updateStmt.setFormOfUse(i, (short)2);
/* 1437 */           this.updateStmt.setCharacterStream(i++, (Reader)localObject, this.typeInfo[k][0]);
/*      */         }
/* 1440 */         else if ((localObject instanceof InputStream)) {
/* 1441 */           if (this.typeInfo[k][1] == 2)
/*      */           {
/* 1444 */             this.updateStmt.setBinaryStream(i++, (InputStream)localObject, this.typeInfo[k][0]);
/*      */           }
/* 1446 */           else if (this.typeInfo[k][1] == 1)
/*      */           {
/* 1448 */             this.updateStmt.setAsciiStream(i++, (InputStream)localObject, this.typeInfo[k][0]);
/*      */           }
/*      */         }
/*      */         else {
/* 1452 */           Datum localDatum = getRowBufferDatumAt(k + 1);
/*      */ 
/* 1454 */           if (localOracleResultSetMetaData.isNCHAR(k + 1))
/* 1455 */             this.updateStmt.setFormOfUse(i, (short)2);
/* 1456 */           this.updateStmt.setOracleObject(i++, localDatum);
/*      */         }
/*      */       }
/*      */       else {
/* 1460 */         int m = getInternalMetadata().getColumnType(k + 1);
/*      */ 
/* 1462 */         if ((m == 2006) || (m == 2002) || (m == 2008) || (m == 2007) || (m == 2003) || (m == 2009))
/*      */         {
/* 1466 */           this.updateStmt.setNull(i++, m, getInternalMetadata().getColumnTypeName(k + 1));
/*      */         }
/*      */         else
/*      */         {
/* 1470 */           if (localOracleResultSetMetaData.isNCHAR(k + 1)) {
/* 1471 */             this.updateStmt.setFormOfUse(i, (short)2);
/*      */           }
/* 1473 */           this.updateStmt.setNull(i++, m);
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1479 */     prepareCompareSelfBinds(this.updateStmt, i);
/*      */   }
/*      */ 
/*      */   private void executeUpdateRow()
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 1489 */       if (this.updateStmt.executeUpdate() == 0)
/*      */       {
/* 1491 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 85);
/* 1492 */         localSQLException.fillInStackTrace();
/* 1493 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1498 */       if (this.isCachedRset)
/*      */       {
/* 1500 */         refreshRows(getRow(), 1);
/* 1501 */         cancelRowUpdates();
/*      */       }
/*      */     }
/*      */     finally {
/* 1505 */       if (this.updateStmt != null) {
/* 1506 */         this.updateStmt.close();
/* 1507 */         this.updateStmt = null;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   int refreshRows(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1523 */     return this.resultSet.refreshRows(paramInt1, paramInt2);
/*      */   }
/*      */ 
/*      */   private void prepareDeleteRowStatement()
/*      */     throws SQLException
/*      */   {
/* 1533 */     if (this.deleteStmt == null) {
/* 1534 */       String str = this.scrollStmt.sqlObject.getDeleteSqlForUpdatableResultSet(this);
/* 1535 */       PreparedStatement localPreparedStatement = this.connection.prepareStatement(str);
/* 1536 */       this.deleteStmt = ((OraclePreparedStatement)((OraclePreparedStatementWrapper)localPreparedStatement).preparedStatement);
/* 1537 */       this.deleteStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
/* 1538 */       if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing())
/* 1539 */         this.deleteStmt.setEscapeProcessing(true);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void prepareDeleteRowBinds()
/*      */     throws SQLException
/*      */   {
/* 1550 */     int i = 1;
/*      */ 
/* 1553 */     i = prepareSubqueryBinds(this.deleteStmt, i);
/*      */ 
/* 1556 */     prepareCompareSelfBinds(this.deleteStmt, i);
/*      */   }
/*      */ 
/*      */   private void executeDeleteRow()
/*      */     throws SQLException
/*      */   {
/* 1568 */     if (this.deleteStmt.executeUpdate() == 0)
/*      */     {
/* 1570 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 85);
/* 1571 */       localSQLException.fillInStackTrace();
/* 1572 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1577 */     if (this.isCachedRset) removeCurrentRowFromCache();
/*      */   }
/*      */ 
/*      */   void removeCurrentRowFromCache()
/*      */     throws SQLException
/*      */   {
/* 1583 */     this.resultSet.removeCurrentRowFromCache();
/*      */   }
/*      */ 
/*      */   private int prepareCompareSelfBinds(OraclePreparedStatement paramOraclePreparedStatement, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1592 */     paramOraclePreparedStatement.setRowId(paramInt, ((InsensitiveScrollableResultSet)this.resultSet).getPrependedRowId());
/*      */ 
/* 1594 */     return paramInt + 1;
/*      */   }
/*      */ 
/*      */   private int prepareSubqueryBinds(OraclePreparedStatement paramOraclePreparedStatement, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1602 */     return paramInt + this.scrollStmt.copyBinds(paramOraclePreparedStatement, paramInt - 1);
/*      */   }
/*      */ 
/*      */   protected void setIsNull(int paramInt)
/*      */   {
/* 1609 */     this.wasNull = paramInt;
/*      */   }
/*      */ 
/*      */   protected void setIsNull(boolean paramBoolean)
/*      */   {
/* 1616 */     setIsNull(paramBoolean ? 1 : 2);
/*      */   }
/*      */ 
/*      */   protected void doneFetchingRows(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1622 */     this.resultSet.doneFetchingRows(paramBoolean);
/*      */   }
/*      */ 
/*      */   OracleStatement getOracleStatement()
/*      */     throws SQLException
/*      */   {
/* 1633 */     return this.resultSet == null ? null : this.resultSet.getOracleStatement();
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.UpdatableResultSet
 * JD-Core Version:    0.6.2
 */