/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.oracore.OracleType;
/*     */ 
/*     */ abstract class TypeAccessor extends Accessor
/*     */ {
/* 101 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   TypeAccessor(Representation paramRepresentation, OracleStatement paramOracleStatement, int paramInt, boolean paramBoolean)
/*     */   {
/*  23 */     super(paramRepresentation, paramOracleStatement, paramInt, paramBoolean);
/*     */   }
/*     */ 
/*     */   abstract OracleType otypeFromName(String paramString)
/*     */     throws SQLException;
/*     */ 
/*     */   void initForDescribe(int paramInt1, int paramInt2, boolean paramBoolean, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, short paramShort, String paramString)
/*     */     throws SQLException
/*     */   {
/*  33 */     this.describeTypeName = paramString;
/*     */ 
/*  35 */     initForDescribe(paramInt1, paramInt2, paramBoolean, paramInt4, paramInt5, paramInt3, paramInt6, paramInt7, paramShort);
/*     */   }
/*     */ 
/*     */   byte[] pickledBytes(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  43 */     return getBytesInternal(paramInt);
/*     */   }
/*     */ 
/*     */   void initForDataAccess(int paramInt1, int paramInt2, String paramString)
/*     */     throws SQLException
/*     */   {
/*  51 */     if (paramInt1 != 0)
/*  52 */       this.externalType = paramInt1;
/*  53 */     this.internalTypeName = paramString;
/*     */   }
/*     */ 
/*     */   void initMetadata()
/*     */     throws SQLException
/*     */   {
/*  70 */     if ((this.describeOtype == null) && (this.describeTypeName != null)) {
/*  71 */       this.describeOtype = otypeFromName(this.describeTypeName);
/*     */     }
/*  73 */     if ((this.internalOtype == null) && (this.internalTypeName != null))
/*  74 */       this.internalOtype = otypeFromName(this.internalTypeName);
/*     */   }
/*     */ 
/*     */   long updateChecksum(long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  81 */     byte[] arrayOfByte = pickledBytes(paramInt);
/*  82 */     if ((arrayOfByte == null) || (arrayOfByte.length == 0))
/*     */     {
/*  84 */       paramLong = CRC64.updateChecksum(paramLong, NULL_DATA_BYTES, 0, NULL_DATA_BYTES.length);
/*     */     }
/*     */     else
/*     */     {
/*  90 */       paramLong = CRC64.updateChecksum(paramLong, arrayOfByte, 0, arrayOfByte.length);
/*     */     }
/*     */ 
/*  96 */     return paramLong;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.TypeAccessor
 * JD-Core Version:    0.6.2
 */