/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Calendar;
/*     */ import java.util.Map;
/*     */ import java.util.TimeZone;
/*     */ import oracle.sql.DATE;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.TIMESTAMP;
/*     */ import oracle.sql.TIMESTAMPTZ;
/*     */ import oracle.sql.TIMEZONETAB;
/*     */ import oracle.sql.ZONEIDMAP;
/*     */ 
/*     */ class TimestamptzAccessor extends DateTimeCommonAccessor
/*     */ {
/*     */   static final int MAXLENGTH = 13;
/*  30 */   TimestampTzConverter tstzConverter = null;
/*     */ 
/* 227 */   static int OFFSET_HOUR = 20;
/* 228 */   static int OFFSET_MINUTE = 60;
/*     */ 
/* 231 */   static byte REGIONIDBIT = -128;
/*     */ 
/* 697 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   TimestamptzAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*  35 */     super(Representation.TIMESTAMPTZ, paramOracleStatement, 13, paramBoolean);
/*     */ 
/*  37 */     init(paramOracleStatement, 181, 181, paramShort, paramBoolean);
/*  38 */     initForDataAccess(paramInt2, paramInt1, null);
/*     */ 
/*  40 */     if (this.statement.connection.timestamptzInGmt)
/*  41 */       this.tstzConverter = new GmtTimestampTzConverter();
/*     */     else
/*  43 */       this.tstzConverter = new OldTimestampTzConverter();
/*     */   }
/*     */ 
/*     */   TimestamptzAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  51 */     super(Representation.TIMESTAMPTZ, paramOracleStatement, 13, false);
/*     */ 
/*  53 */     init(paramOracleStatement, 181, 181, paramShort, false);
/*  54 */     initForDescribe(181, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, null);
/*     */ 
/*  56 */     initForDataAccess(0, paramInt1, null);
/*     */ 
/*  58 */     if (this.statement.connection.timestamptzInGmt)
/*  59 */       this.tstzConverter = new GmtTimestampTzConverter();
/*     */     else
/*  61 */       this.tstzConverter = new OldTimestampTzConverter();
/*     */   }
/*     */ 
/*     */   String getString(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  69 */     if (isNull(paramInt)) {
/*  70 */       return null;
/*     */     }
/*     */ 
/*  74 */     int i = 0;
/*  75 */     getBytesInternal(paramInt, this.tmpBytes);
/*     */     String str;
/*  77 */     if ((oracleTZ1(this.tmpBytes) & REGIONIDBIT) != 0) {
/*  78 */       i = getHighOrderbits(oracleTZ1(this.tmpBytes));
/*  79 */       i += getLowOrderbits(oracleTZ2(this.tmpBytes));
/*     */ 
/*  82 */       TIMEZONETAB localTIMEZONETAB1 = this.statement.connection.getTIMEZONETAB();
/*  83 */       if (localTIMEZONETAB1.checkID(i)) {
/*  84 */         localTIMEZONETAB1.updateTable(this.statement.connection, i);
/*     */       }
/*     */ 
/*  87 */       str = ZONEIDMAP.getRegion(i);
/*     */     }
/*     */     else {
/*  90 */       int j = oracleTZ1(this.tmpBytes) - OFFSET_HOUR;
/*  91 */       k = oracleTZ2(this.tmpBytes) - OFFSET_MINUTE;
/*     */ 
/*  93 */       str = new StringBuilder().append("GMT").append(j < 0 ? "-" : "+").append(Math.abs(j)).append(":").append(k < 10 ? "0" : "").append(k).toString();
/*     */     }
/*     */ 
/* 101 */     Calendar localCalendar = (Calendar)this.statement.getGMTCalendar().clone();
/*     */ 
/* 103 */     int k = oracleYear(this.tmpBytes);
/*     */ 
/* 105 */     localCalendar.set(1, k);
/* 106 */     localCalendar.set(2, oracleMonth(this.tmpBytes));
/* 107 */     localCalendar.set(5, oracleDay(this.tmpBytes));
/* 108 */     localCalendar.set(11, oracleHour(this.tmpBytes));
/* 109 */     localCalendar.set(12, oracleMin(this.tmpBytes));
/* 110 */     localCalendar.set(13, oracleSec(this.tmpBytes));
/* 111 */     localCalendar.set(14, 0);
/*     */ 
/* 113 */     if ((oracleTZ1(this.tmpBytes) & REGIONIDBIT) != 0) {
/* 114 */       TIMEZONETAB localTIMEZONETAB2 = this.statement.connection.getTIMEZONETAB();
/*     */ 
/* 117 */       n = localTIMEZONETAB2.getOffset(localCalendar, i);
/*     */ 
/* 120 */       localCalendar.add(14, n);
/*     */     }
/*     */     else {
/* 123 */       localCalendar.add(10, oracleTZ1(this.tmpBytes) - OFFSET_HOUR);
/* 124 */       localCalendar.add(12, oracleTZ2(this.tmpBytes) - OFFSET_MINUTE);
/*     */     }
/*     */ 
/* 128 */     k = localCalendar.get(1);
/*     */ 
/* 130 */     int m = localCalendar.get(2) + 1;
/* 131 */     int n = localCalendar.get(5);
/* 132 */     int i1 = localCalendar.get(11);
/* 133 */     int i2 = localCalendar.get(12);
/* 134 */     int i3 = localCalendar.get(13);
/* 135 */     boolean bool = i1 < 12;
/* 136 */     if ((str.length() > 3) && (str.startsWith("GMT"))) {
/* 137 */       str = str.substring(3);
/*     */     }
/*     */ 
/* 140 */     int i4 = oracleNanos(this.tmpBytes);
/*     */ 
/* 142 */     return toText(k, m, n, i1, i2, i3, i4, bool, str);
/*     */   }
/*     */ 
/*     */   java.sql.Date getDate(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 149 */     return this.tstzConverter.getDate(paramInt);
/*     */   }
/*     */ 
/*     */   java.sql.Date getDate(int paramInt, Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/* 157 */     return getDate(paramInt);
/*     */   }
/*     */ 
/*     */   Time getTime(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 164 */     return this.tstzConverter.getTime(paramInt);
/*     */   }
/*     */ 
/*     */   Time getTime(int paramInt, Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/* 172 */     return getTime(paramInt);
/*     */   }
/*     */ 
/*     */   Timestamp getTimestamp(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 179 */     return this.tstzConverter.getTimestamp(paramInt);
/*     */   }
/*     */ 
/*     */   Timestamp getTimestamp(int paramInt, Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/* 187 */     return getTimestamp(paramInt);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt) throws SQLException
/*     */   {
/* 192 */     return this.tstzConverter.getObject(paramInt);
/*     */   }
/*     */ 
/*     */   Datum getOracleObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 198 */     return this.tstzConverter.getOracleObject(paramInt);
/*     */   }
/*     */ 
/*     */   DATE getDATE(int paramInt) throws SQLException
/*     */   {
/* 203 */     TIMESTAMPTZ localTIMESTAMPTZ = this.tstzConverter.getTIMESTAMPTZ(paramInt);
/* 204 */     if (localTIMESTAMPTZ == null) {
/* 205 */       return null;
/*     */     }
/* 207 */     return TIMESTAMPTZ.toDATE(this.statement.connection, localTIMESTAMPTZ.getBytes());
/*     */   }
/*     */ 
/*     */   TIMESTAMP getTIMESTAMP(int paramInt) throws SQLException
/*     */   {
/* 212 */     TIMESTAMPTZ localTIMESTAMPTZ = this.tstzConverter.getTIMESTAMPTZ(paramInt);
/* 213 */     if (localTIMESTAMPTZ == null) {
/* 214 */       return null;
/*     */     }
/* 216 */     return TIMESTAMPTZ.toTIMESTAMP(this.statement.connection, localTIMESTAMPTZ.getBytes());
/*     */   }
/*     */ 
/*     */   TIMESTAMPTZ getTIMESTAMPTZ(int paramInt) throws SQLException
/*     */   {
/* 221 */     return this.tstzConverter.getTIMESTAMPTZ(paramInt);
/*     */   }
/*     */ 
/*     */   static int setHighOrderbits(int paramInt)
/*     */   {
/* 241 */     return (paramInt & 0x1FC0) >> 6;
/*     */   }
/*     */ 
/*     */   static int setLowOrderbits(int paramInt)
/*     */   {
/* 249 */     return (paramInt & 0x3F) << 2;
/*     */   }
/*     */ 
/*     */   static int getHighOrderbits(int paramInt)
/*     */   {
/* 257 */     return (paramInt & 0x7F) << 6;
/*     */   }
/*     */ 
/*     */   static int getLowOrderbits(int paramInt)
/*     */   {
/* 264 */     return (paramInt & 0xFC) >> 2;
/*     */   }
/*     */ 
/*     */   abstract class TimestampTzConverter
/*     */   {
/*     */     TimestampTzConverter()
/*     */     {
/*     */     }
/*     */ 
/*     */     abstract java.sql.Date getDate(int paramInt)
/*     */       throws SQLException;
/*     */ 
/*     */     abstract Time getTime(int paramInt)
/*     */       throws SQLException;
/*     */ 
/*     */     abstract Timestamp getTimestamp(int paramInt)
/*     */       throws SQLException;
/*     */ 
/*     */     Object getObject(int paramInt)
/*     */       throws SQLException
/*     */     {
/* 672 */       return getTIMESTAMPTZ(paramInt);
/*     */     }
/*     */ 
/*     */     Datum getOracleObject(int paramInt)
/*     */       throws SQLException
/*     */     {
/* 680 */       return getTIMESTAMPTZ(paramInt);
/*     */     }
/*     */ 
/*     */     Object getObject(int paramInt, Map paramMap)
/*     */       throws SQLException
/*     */     {
/* 688 */       return getTIMESTAMPTZ(paramInt);
/*     */     }
/*     */ 
/*     */     abstract TIMESTAMPTZ getTIMESTAMPTZ(int paramInt)
/*     */       throws SQLException;
/*     */   }
/*     */ 
/*     */   class GmtTimestampTzConverter extends TimestamptzAccessor.TimestampTzConverter
/*     */   {
/*     */     GmtTimestampTzConverter()
/*     */     {
/* 543 */       super();
/*     */     }
/*     */ 
/*     */     java.sql.Date getDate(int paramInt)
/*     */       throws SQLException
/*     */     {
/* 552 */       if (TimestamptzAccessor.this.isNull(paramInt)) {
/* 553 */         return null;
/*     */       }
/*     */ 
/* 556 */       Calendar localCalendar = (Calendar)TimestamptzAccessor.this.statement.getGMTCalendar().clone();
/* 557 */       TimestamptzAccessor.this.getBytesInternal(paramInt, TimestamptzAccessor.this.tmpBytes);
/*     */ 
/* 559 */       int i = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
/*     */ 
/* 561 */       localCalendar.set(1, i);
/* 562 */       localCalendar.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
/* 563 */       localCalendar.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
/* 564 */       localCalendar.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
/* 565 */       localCalendar.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
/* 566 */       localCalendar.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
/* 567 */       localCalendar.set(14, 0);
/*     */ 
/* 570 */       long l = localCalendar.getTimeInMillis();
/*     */ 
/* 573 */       return new java.sql.Date(l);
/*     */     }
/*     */ 
/*     */     Time getTime(int paramInt)
/*     */       throws SQLException
/*     */     {
/* 583 */       if (TimestamptzAccessor.this.isNull(paramInt)) {
/* 584 */         return null;
/*     */       }
/*     */ 
/* 587 */       Calendar localCalendar = (Calendar)TimestamptzAccessor.this.statement.getGMTCalendar().clone();
/* 588 */       TimestamptzAccessor.this.getBytesInternal(paramInt, TimestamptzAccessor.this.tmpBytes);
/*     */ 
/* 590 */       int i = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
/*     */ 
/* 592 */       localCalendar.set(1, i);
/* 593 */       localCalendar.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
/* 594 */       localCalendar.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
/* 595 */       localCalendar.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
/* 596 */       localCalendar.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
/* 597 */       localCalendar.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
/* 598 */       localCalendar.set(14, 0);
/*     */ 
/* 600 */       return new Time(localCalendar.getTimeInMillis());
/*     */     }
/*     */ 
/*     */     Timestamp getTimestamp(int paramInt)
/*     */       throws SQLException
/*     */     {
/* 610 */       if (TimestamptzAccessor.this.isNull(paramInt)) {
/* 611 */         return null;
/*     */       }
/*     */ 
/* 614 */       Calendar localCalendar = (Calendar)TimestamptzAccessor.this.statement.getGMTCalendar().clone();
/* 615 */       TimestamptzAccessor.this.getBytesInternal(paramInt, TimestamptzAccessor.this.tmpBytes);
/*     */ 
/* 617 */       int i = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
/*     */ 
/* 619 */       localCalendar.set(1, i);
/* 620 */       localCalendar.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
/* 621 */       localCalendar.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
/* 622 */       localCalendar.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
/* 623 */       localCalendar.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
/* 624 */       localCalendar.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
/* 625 */       localCalendar.set(14, 0);
/*     */ 
/* 628 */       long l = localCalendar.getTimeInMillis();
/*     */ 
/* 631 */       Timestamp localTimestamp = new Timestamp(l);
/*     */ 
/* 634 */       int j = TimestamptzAccessor.this.oracleNanos(TimestamptzAccessor.this.tmpBytes);
/*     */ 
/* 637 */       localTimestamp.setNanos(j);
/*     */ 
/* 639 */       return localTimestamp;
/*     */     }
/*     */ 
/*     */     TIMESTAMPTZ getTIMESTAMPTZ(int paramInt)
/*     */       throws SQLException
/*     */     {
/* 648 */       if (TimestamptzAccessor.this.isNull(paramInt)) return null;
/* 649 */       return new TIMESTAMPTZ(TimestamptzAccessor.this.getBytesInternal(paramInt));
/*     */     }
/*     */   }
/*     */ 
/*     */   class OldTimestampTzConverter extends TimestamptzAccessor.TimestampTzConverter
/*     */   {
/*     */     OldTimestampTzConverter()
/*     */     {
/* 273 */       super();
/*     */     }
/*     */ 
/*     */     java.sql.Date getDate(int paramInt)
/*     */       throws SQLException
/*     */     {
/* 280 */       if (TimestamptzAccessor.this.isNull(paramInt)) return null;
/*     */ 
/* 282 */       TimeZone localTimeZone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
/* 283 */       Calendar localCalendar = Calendar.getInstance(localTimeZone);
/*     */ 
/* 285 */       TimestamptzAccessor.this.getBytesInternal(paramInt, TimestamptzAccessor.this.tmpBytes);
/*     */ 
/* 287 */       int i = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
/*     */ 
/* 289 */       localCalendar.set(1, i);
/* 290 */       localCalendar.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
/* 291 */       localCalendar.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
/* 292 */       localCalendar.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
/* 293 */       localCalendar.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
/* 294 */       localCalendar.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
/* 295 */       localCalendar.set(14, 0);
/*     */ 
/* 297 */       if ((TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) & TimestamptzAccessor.REGIONIDBIT) != 0)
/*     */       {
/* 301 */         int j = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes));
/* 302 */         j += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes));
/*     */ 
/* 304 */         TIMEZONETAB localTIMEZONETAB = TimestamptzAccessor.this.statement.connection.getTIMEZONETAB();
/*     */ 
/* 306 */         if (localTIMEZONETAB.checkID(j)) {
/* 307 */           localTIMEZONETAB.updateTable(TimestamptzAccessor.this.statement.connection, j);
/*     */         }
/* 309 */         int k = localTIMEZONETAB.getOffset(localCalendar, j);
/*     */ 
/* 311 */         boolean bool1 = localTimeZone.inDaylightTime(localCalendar.getTime());
/* 312 */         boolean bool2 = localTimeZone.inDaylightTime(new java.util.Date(localCalendar.getTimeInMillis() + k));
/*     */ 
/* 319 */         if ((!bool1) && (bool2))
/*     */         {
/* 321 */           localCalendar.add(14, -1 * localTimeZone.getDSTSavings());
/*     */         }
/* 329 */         else if ((bool1) && (!bool2))
/*     */         {
/* 331 */           localCalendar.add(14, localTimeZone.getDSTSavings());
/*     */         }
/*     */ 
/* 336 */         localCalendar.add(10, k / 3600000);
/* 337 */         localCalendar.add(12, k % 3600000 / 60000);
/*     */       }
/*     */       else
/*     */       {
/* 341 */         localCalendar.add(10, TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) - TimestamptzAccessor.OFFSET_HOUR);
/* 342 */         localCalendar.add(12, TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes) - TimestamptzAccessor.OFFSET_MINUTE);
/*     */       }
/*     */ 
/* 346 */       long l = localCalendar.getTimeInMillis();
/*     */ 
/* 349 */       return new java.sql.Date(l);
/*     */     }
/*     */ 
/*     */     Time getTime(int paramInt)
/*     */       throws SQLException
/*     */     {
/* 358 */       if (TimestamptzAccessor.this.isNull(paramInt)) return null;
/*     */ 
/* 360 */       TimeZone localTimeZone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
/* 361 */       Calendar localCalendar = Calendar.getInstance(localTimeZone);
/*     */ 
/* 363 */       TimestamptzAccessor.this.getBytesInternal(paramInt, TimestamptzAccessor.this.tmpBytes);
/*     */ 
/* 365 */       int i = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
/*     */ 
/* 367 */       localCalendar.set(1, i);
/* 368 */       localCalendar.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
/* 369 */       localCalendar.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
/* 370 */       localCalendar.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
/* 371 */       localCalendar.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
/* 372 */       localCalendar.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
/* 373 */       localCalendar.set(14, 0);
/*     */ 
/* 375 */       if ((TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) & TimestamptzAccessor.REGIONIDBIT) != 0)
/*     */       {
/* 379 */         int j = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes));
/* 380 */         j += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes));
/*     */ 
/* 382 */         TIMEZONETAB localTIMEZONETAB = TimestamptzAccessor.this.statement.connection.getTIMEZONETAB();
/*     */ 
/* 384 */         if (localTIMEZONETAB.checkID(j)) {
/* 385 */           localTIMEZONETAB.updateTable(TimestamptzAccessor.this.statement.connection, j);
/*     */         }
/* 387 */         int k = localTIMEZONETAB.getOffset(localCalendar, j);
/*     */ 
/* 389 */         boolean bool1 = localTimeZone.inDaylightTime(localCalendar.getTime());
/* 390 */         boolean bool2 = localTimeZone.inDaylightTime(new java.util.Date(localCalendar.getTimeInMillis() + k));
/*     */ 
/* 397 */         if ((!bool1) && (bool2))
/*     */         {
/* 399 */           localCalendar.add(14, -1 * localTimeZone.getDSTSavings());
/*     */         }
/* 407 */         else if ((bool1) && (!bool2))
/*     */         {
/* 409 */           localCalendar.add(14, localTimeZone.getDSTSavings());
/*     */         }
/*     */ 
/* 413 */         localCalendar.add(10, k / 3600000);
/* 414 */         localCalendar.add(12, k % 3600000 / 60000);
/*     */       }
/*     */       else
/*     */       {
/* 418 */         localCalendar.add(10, TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) - TimestamptzAccessor.OFFSET_HOUR);
/* 419 */         localCalendar.add(12, TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes) - TimestamptzAccessor.OFFSET_MINUTE);
/*     */       }
/*     */ 
/* 423 */       long l = localCalendar.getTimeInMillis();
/*     */ 
/* 426 */       return new Time(l);
/*     */     }
/*     */ 
/*     */     Timestamp getTimestamp(int paramInt)
/*     */       throws SQLException
/*     */     {
/* 436 */       if (TimestamptzAccessor.this.isNull(paramInt)) return null;
/*     */ 
/* 438 */       TimeZone localTimeZone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
/* 439 */       Calendar localCalendar1 = Calendar.getInstance(localTimeZone);
/* 440 */       Calendar localCalendar2 = (Calendar)TimestamptzAccessor.this.statement.getGMTCalendar().clone();
/*     */ 
/* 442 */       TimestamptzAccessor.this.getBytesInternal(paramInt, TimestamptzAccessor.this.tmpBytes);
/*     */ 
/* 444 */       int i = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
/*     */ 
/* 446 */       localCalendar1.set(1, i);
/* 447 */       localCalendar1.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
/* 448 */       localCalendar1.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
/* 449 */       localCalendar1.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
/* 450 */       localCalendar1.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
/* 451 */       localCalendar1.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
/* 452 */       localCalendar1.set(14, 0);
/*     */ 
/* 454 */       localCalendar2.set(1, i);
/* 455 */       localCalendar2.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
/* 456 */       localCalendar2.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
/* 457 */       localCalendar2.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
/* 458 */       localCalendar2.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
/* 459 */       localCalendar2.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
/* 460 */       localCalendar2.set(14, 0);
/*     */ 
/* 462 */       if ((TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) & TimestamptzAccessor.REGIONIDBIT) != 0)
/*     */       {
/* 465 */         int j = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes));
/* 466 */         j += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes));
/*     */ 
/* 469 */         TIMEZONETAB localTIMEZONETAB = TimestamptzAccessor.this.statement.connection.getTIMEZONETAB();
/* 470 */         if (localTIMEZONETAB.checkID(j)) {
/* 471 */           localTIMEZONETAB.updateTable(TimestamptzAccessor.this.statement.connection, j);
/*     */         }
/*     */ 
/* 474 */         int k = localTIMEZONETAB.getOffset(localCalendar2, j);
/*     */ 
/* 476 */         boolean bool1 = localTimeZone.inDaylightTime(localCalendar1.getTime());
/* 477 */         boolean bool2 = localTimeZone.inDaylightTime(new java.util.Date(localCalendar1.getTimeInMillis() + k));
/*     */ 
/* 485 */         if ((!bool1) && (bool2))
/*     */         {
/* 487 */           localCalendar1.add(14, -1 * localTimeZone.getDSTSavings());
/*     */         }
/* 496 */         else if ((bool1) && (!bool2)) {
/* 497 */           localCalendar1.add(14, localTimeZone.getDSTSavings());
/*     */         }
/*     */ 
/* 501 */         localCalendar1.add(10, k / 3600000);
/* 502 */         localCalendar1.add(12, k % 3600000 / 60000);
/*     */       }
/*     */       else {
/* 505 */         localCalendar1.add(10, TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) - TimestamptzAccessor.OFFSET_HOUR);
/* 506 */         localCalendar1.add(12, TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes) - TimestamptzAccessor.OFFSET_MINUTE);
/*     */       }
/*     */ 
/* 510 */       long l = localCalendar1.getTimeInMillis();
/*     */ 
/* 513 */       Timestamp localTimestamp = new Timestamp(l);
/*     */ 
/* 516 */       int m = TimestamptzAccessor.this.oracleNanos(TimestamptzAccessor.this.tmpBytes);
/*     */ 
/* 519 */       localTimestamp.setNanos(m);
/*     */ 
/* 521 */       return localTimestamp;
/*     */     }
/*     */ 
/*     */     TIMESTAMPTZ getTIMESTAMPTZ(int paramInt)
/*     */       throws SQLException
/*     */     {
/* 531 */       if (TimestamptzAccessor.this.isNull(paramInt)) return null;
/* 532 */       return new TIMESTAMPTZ(TimestamptzAccessor.this.getBytesInternal(paramInt));
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.TimestamptzAccessor
 * JD-Core Version:    0.6.2
 */