/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.Date;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Calendar;
/*     */ import java.util.Map;
/*     */ import java.util.TimeZone;
/*     */ import oracle.sql.DATE;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.OffsetDST;
/*     */ import oracle.sql.TIMESTAMP;
/*     */ import oracle.sql.TIMESTAMPLTZ;
/*     */ import oracle.sql.TIMESTAMPTZ;
/*     */ import oracle.sql.TIMEZONETAB;
/*     */ import oracle.sql.ZONEIDMAP;
/*     */ 
/*     */ class TimestampltzAccessor extends DateTimeCommonAccessor
/*     */ {
/*     */   static final int MAXLENGTH = 11;
/* 586 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   TimestampltzAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*  32 */     super(Representation.TIMESTAMPLTZ, paramOracleStatement, 11, paramBoolean);
/*     */ 
/*  34 */     init(paramOracleStatement, 231, 231, paramShort, paramBoolean);
/*  35 */     initForDataAccess(paramInt2, paramInt1, null);
/*     */   }
/*     */ 
/*     */   TimestampltzAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  43 */     super(Representation.TIMESTAMPLTZ, paramOracleStatement, 11, false);
/*     */ 
/*  45 */     init(paramOracleStatement, 231, 231, paramShort, false);
/*  46 */     initForDescribe(231, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, null);
/*     */ 
/*  48 */     initForDataAccess(0, paramInt1, null);
/*     */   }
/*     */ 
/*     */   String getString(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  57 */     if (isNull(paramInt)) {
/*  58 */       return null;
/*     */     }
/*     */ 
/*  62 */     Calendar localCalendar1 = this.statement.connection.getDbTzCalendar();
/*     */ 
/*  66 */     String str1 = this.statement.connection.getSessionTimeZone();
/*     */ 
/*  68 */     if (str1 == null)
/*     */     {
/*  70 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 198);
/*  71 */       ((SQLException)localObject).fillInStackTrace();
/*  72 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/*  76 */     Object localObject = TimeZone.getTimeZone(str1);
/*  77 */     Calendar localCalendar2 = Calendar.getInstance((TimeZone)localObject);
/*     */ 
/*  79 */     getBytesInternal(paramInt, this.tmpBytes);
/*     */ 
/*  81 */     int i = oracleYear(this.tmpBytes);
/*     */ 
/*  83 */     localCalendar1.set(1, i);
/*  84 */     localCalendar1.set(2, oracleMonth(this.tmpBytes));
/*  85 */     localCalendar1.set(5, oracleDay(this.tmpBytes));
/*  86 */     localCalendar1.set(11, oracleHour(this.tmpBytes));
/*  87 */     localCalendar1.set(12, oracleMin(this.tmpBytes));
/*  88 */     localCalendar1.set(13, oracleSec(this.tmpBytes));
/*  89 */     localCalendar1.set(14, 0);
/*     */ 
/*  92 */     TimeZoneAdjust(localCalendar1, localCalendar2);
/*     */ 
/*  95 */     i = localCalendar2.get(1);
/*     */ 
/*  97 */     int j = localCalendar2.get(2) + 1;
/*  98 */     int k = localCalendar2.get(5);
/*  99 */     int m = localCalendar2.get(11);
/* 100 */     int n = localCalendar2.get(12);
/* 101 */     int i1 = localCalendar2.get(13);
/* 102 */     int i2 = 0;
/* 103 */     boolean bool = m < 12;
/*     */ 
/* 105 */     String str2 = localCalendar2.getTimeZone().getID();
/* 106 */     if ((str2.length() > 3) && (str2.startsWith("GMT"))) {
/* 107 */       str2 = str2.substring(3);
/*     */     }
/*     */ 
/* 110 */     if (getLength(paramInt) == 11) {
/* 111 */       i2 = oracleNanos(this.tmpBytes);
/*     */     }
/*     */ 
/* 114 */     return toText(i, j, k, m, n, i1, i2, bool, str2);
/*     */   }
/*     */ 
/*     */   Date getDate(int paramInt, Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/* 125 */     return getDate(paramInt);
/*     */   }
/*     */ 
/*     */   Date getDate(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 133 */     if (isNull(paramInt)) {
/* 134 */       return null;
/*     */     }
/*     */ 
/* 138 */     Calendar localCalendar1 = this.statement.connection.getDbTzCalendar();
/*     */ 
/* 142 */     String str = this.statement.connection.getSessionTimeZone();
/*     */ 
/* 144 */     if (str == null)
/*     */     {
/* 146 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 198);
/* 147 */       ((SQLException)localObject).fillInStackTrace();
/* 148 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 152 */     Object localObject = TimeZone.getTimeZone(str);
/* 153 */     Calendar localCalendar2 = Calendar.getInstance((TimeZone)localObject);
/*     */ 
/* 155 */     getBytesInternal(paramInt, this.tmpBytes);
/*     */ 
/* 157 */     int i = oracleYear(this.tmpBytes);
/*     */ 
/* 159 */     localCalendar1.set(1, i);
/* 160 */     localCalendar1.set(2, oracleMonth(this.tmpBytes));
/* 161 */     localCalendar1.set(5, oracleDay(this.tmpBytes));
/* 162 */     localCalendar1.set(11, oracleHour(this.tmpBytes));
/* 163 */     localCalendar1.set(12, oracleMin(this.tmpBytes));
/* 164 */     localCalendar1.set(13, oracleSec(this.tmpBytes));
/* 165 */     localCalendar1.set(14, 0);
/*     */ 
/* 167 */     long l = TimeZoneAdjustUTC(localCalendar1);
/*     */ 
/* 169 */     return new Date(l);
/*     */   }
/*     */ 
/*     */   Time getTime(int paramInt, Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/* 179 */     return getTime(paramInt);
/*     */   }
/*     */ 
/*     */   Time getTime(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 187 */     if (isNull(paramInt)) {
/* 188 */       return null;
/*     */     }
/*     */ 
/* 192 */     Calendar localCalendar1 = this.statement.connection.getDbTzCalendar();
/*     */ 
/* 196 */     String str = this.statement.connection.getSessionTimeZone();
/*     */ 
/* 198 */     if (str == null)
/*     */     {
/* 200 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 198);
/* 201 */       ((SQLException)localObject).fillInStackTrace();
/* 202 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 206 */     Object localObject = TimeZone.getTimeZone(str);
/*     */ 
/* 208 */     Calendar localCalendar2 = Calendar.getInstance((TimeZone)localObject);
/*     */ 
/* 210 */     getBytesInternal(paramInt, this.tmpBytes);
/*     */ 
/* 212 */     int i = oracleYear(this.tmpBytes);
/*     */ 
/* 214 */     localCalendar1.set(1, i);
/* 215 */     localCalendar1.set(2, oracleMonth(this.tmpBytes));
/* 216 */     localCalendar1.set(5, oracleDay(this.tmpBytes));
/* 217 */     localCalendar1.set(11, oracleHour(this.tmpBytes));
/* 218 */     localCalendar1.set(12, oracleMin(this.tmpBytes));
/* 219 */     localCalendar1.set(13, oracleSec(this.tmpBytes));
/* 220 */     localCalendar1.set(14, 0);
/*     */ 
/* 223 */     long l = TimeZoneAdjustUTC(localCalendar1);
/*     */ 
/* 225 */     return new Time(l);
/*     */   }
/*     */ 
/*     */   Timestamp getTimestamp(int paramInt, Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/* 235 */     return getTimestamp(paramInt);
/*     */   }
/*     */ 
/*     */   Timestamp getTimestamp(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 243 */     if (isNull(paramInt)) {
/* 244 */       return null;
/*     */     }
/*     */ 
/* 248 */     Calendar localCalendar1 = this.statement.connection.getDbTzCalendar();
/*     */ 
/* 252 */     String str = this.statement.connection.getSessionTimeZone();
/*     */ 
/* 254 */     if (str == null)
/*     */     {
/* 256 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 198);
/* 257 */       ((SQLException)localObject).fillInStackTrace();
/* 258 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 262 */     Object localObject = TimeZone.getTimeZone(str);
/* 263 */     Calendar localCalendar2 = Calendar.getInstance((TimeZone)localObject);
/*     */ 
/* 265 */     getBytesInternal(paramInt, this.tmpBytes);
/*     */ 
/* 267 */     int i = oracleYear(this.tmpBytes);
/*     */ 
/* 269 */     localCalendar1.set(1, i);
/* 270 */     localCalendar1.set(2, oracleMonth(this.tmpBytes));
/* 271 */     localCalendar1.set(5, oracleDay(this.tmpBytes));
/* 272 */     localCalendar1.set(11, oracleHour(this.tmpBytes));
/* 273 */     localCalendar1.set(12, oracleMin(this.tmpBytes));
/* 274 */     localCalendar1.set(13, oracleSec(this.tmpBytes));
/* 275 */     localCalendar1.set(14, 0);
/*     */ 
/* 278 */     long l = TimeZoneAdjustUTC(localCalendar1);
/*     */ 
/* 280 */     Timestamp localTimestamp = new Timestamp(l);
/*     */ 
/* 282 */     if (getLength(paramInt) == 11)
/*     */     {
/* 284 */       localTimestamp.setNanos(oracleNanos(this.tmpBytes));
/*     */     }
/*     */ 
/* 287 */     return localTimestamp;
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 295 */     return getTIMESTAMPLTZ(paramInt);
/*     */   }
/*     */ 
/*     */   Datum getOracleObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 303 */     return getTIMESTAMPLTZ(paramInt);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 311 */     return getTIMESTAMPLTZ(paramInt);
/*     */   }
/*     */ 
/*     */   TIMESTAMPLTZ getTIMESTAMPLTZ(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 319 */     if (isNull(paramInt)) {
/* 320 */       return null;
/*     */     }
/*     */ 
/* 323 */     return new TIMESTAMPLTZ(getBytesInternal(paramInt));
/*     */   }
/*     */ 
/*     */   TIMESTAMPTZ getTIMESTAMPTZ(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 331 */     if (isNull(paramInt)) {
/* 332 */       return null;
/*     */     }
/*     */ 
/* 335 */     return TIMESTAMPLTZ.toTIMESTAMPTZ(this.statement.connection, getBytesInternal(paramInt));
/*     */   }
/*     */ 
/*     */   TIMESTAMP getTIMESTAMP(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 345 */     if (isNull(paramInt)) {
/* 346 */       return null;
/*     */     }
/* 348 */     TIMESTAMPTZ localTIMESTAMPTZ = getTIMESTAMPTZ(paramInt);
/* 349 */     return TIMESTAMPTZ.toTIMESTAMP(this.statement.connection, localTIMESTAMPTZ.getBytes());
/*     */   }
/*     */ 
/*     */   DATE getDATE(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 357 */     if (isNull(paramInt)) {
/* 358 */       return null;
/*     */     }
/* 360 */     TIMESTAMPTZ localTIMESTAMPTZ = getTIMESTAMPTZ(paramInt);
/* 361 */     return TIMESTAMPTZ.toDATE(this.statement.connection, localTIMESTAMPTZ.getBytes());
/*     */   }
/*     */ 
/*     */   void TimeZoneAdjust(Calendar paramCalendar1, Calendar paramCalendar2)
/*     */     throws SQLException
/*     */   {
/* 374 */     String str1 = paramCalendar1.getTimeZone().getID();
/* 375 */     String str2 = paramCalendar2.getTimeZone().getID();
/*     */ 
/* 378 */     if (!str2.equals(str1)) {
/* 379 */       OffsetDST localOffsetDST = new OffsetDST();
/*     */ 
/* 382 */       k = getZoneOffset(paramCalendar1, localOffsetDST);
/*     */ 
/* 384 */       m = localOffsetDST.getOFFSET();
/*     */ 
/* 387 */       paramCalendar1.add(11, -(m / 3600000));
/* 388 */       paramCalendar1.add(12, -(m % 3600000) / 60000);
/*     */       int i;
/* 394 */       if ((str2.equals("Custom")) || ((str2.startsWith("GMT")) && (str2.length() > 3)))
/*     */       {
/* 397 */         i = paramCalendar2.getTimeZone().getRawOffset();
/*     */       }
/*     */       else
/*     */       {
/* 401 */         n = ZONEIDMAP.getID(str2);
/*     */ 
/* 403 */         if (!ZONEIDMAP.isValidID(n))
/*     */         {
/* 405 */           localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 199);
/* 406 */           ((SQLException)localObject).fillInStackTrace();
/* 407 */           throw ((Throwable)localObject);
/*     */         }
/*     */ 
/* 411 */         Object localObject = this.statement.connection.getTIMEZONETAB();
/* 412 */         if (((TIMEZONETAB)localObject).checkID(n)) {
/* 413 */           ((TIMEZONETAB)localObject).updateTable(this.statement.connection, n);
/*     */         }
/*     */ 
/* 416 */         Calendar localCalendar = (Calendar)this.statement.getGMTCalendar().clone();
/*     */ 
/* 418 */         localCalendar.set(0, paramCalendar1.get(0));
/* 419 */         localCalendar.set(1, paramCalendar1.get(1));
/* 420 */         localCalendar.set(2, paramCalendar1.get(2));
/* 421 */         localCalendar.set(5, paramCalendar1.get(5));
/* 422 */         localCalendar.set(11, paramCalendar1.get(11));
/* 423 */         localCalendar.set(12, paramCalendar1.get(12));
/* 424 */         localCalendar.set(13, paramCalendar1.get(13));
/* 425 */         localCalendar.set(14, paramCalendar1.get(14));
/*     */ 
/* 428 */         i = ((TIMEZONETAB)localObject).getOffset(localCalendar, n);
/*     */       }
/*     */ 
/* 432 */       paramCalendar1.add(11, i / 3600000);
/* 433 */       paramCalendar1.add(12, i % 3600000 / 60000);
/*     */     }
/*     */ 
/* 440 */     if (((str2.equals("Custom")) && (str1.equals("Custom"))) || ((str2.startsWith("GMT")) && (str2.length() > 3) && (str1.startsWith("GMT")) && (str1.length() > 3)))
/*     */     {
/* 444 */       j = paramCalendar1.getTimeZone().getRawOffset();
/* 445 */       k = paramCalendar2.getTimeZone().getRawOffset();
/* 446 */       m = 0;
/*     */ 
/* 449 */       if (j != k)
/*     */       {
/* 451 */         m = j - k;
/* 452 */         m = m > 0 ? m : -m;
/*     */       }
/*     */ 
/* 455 */       if (j > k) {
/* 456 */         m = -m;
/*     */       }
/*     */ 
/* 459 */       paramCalendar1.add(11, m / 3600000);
/* 460 */       paramCalendar1.add(12, m % 3600000 / 60000);
/*     */     }
/*     */ 
/* 464 */     int j = paramCalendar1.get(1);
/* 465 */     int k = paramCalendar1.get(2);
/* 466 */     int m = paramCalendar1.get(5);
/* 467 */     int n = paramCalendar1.get(11);
/* 468 */     int i1 = paramCalendar1.get(12);
/* 469 */     int i2 = paramCalendar1.get(13);
/* 470 */     int i3 = paramCalendar1.get(14);
/*     */ 
/* 473 */     paramCalendar2.set(0, paramCalendar1.get(0));
/* 474 */     paramCalendar2.set(1, j);
/* 475 */     paramCalendar2.set(2, k);
/* 476 */     paramCalendar2.set(5, m);
/* 477 */     paramCalendar2.set(11, n);
/* 478 */     paramCalendar2.set(12, i1);
/* 479 */     paramCalendar2.set(13, i2);
/* 480 */     paramCalendar2.set(14, i3);
/*     */   }
/*     */ 
/*     */   long TimeZoneAdjustUTC(Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/* 490 */     String str = paramCalendar.getTimeZone().getID();
/*     */ 
/* 492 */     if ((str.equals("Custom")) || ((str.startsWith("GMT")) && (str.length() > 3)))
/*     */     {
/* 495 */       int i = paramCalendar.getTimeZone().getRawOffset();
/* 496 */       paramCalendar.add(11, -(i / 3600000));
/* 497 */       paramCalendar.add(12, -(i % 3600000) / 60000);
/*     */     }
/* 499 */     else if ((!str.equals("GMT")) && (!str.equals("UTC"))) {
/* 500 */       OffsetDST localOffsetDST = new OffsetDST();
/*     */ 
/* 503 */       k = getZoneOffset(paramCalendar, localOffsetDST);
/*     */ 
/* 505 */       m = localOffsetDST.getOFFSET();
/*     */ 
/* 509 */       paramCalendar.add(11, -(m / 3600000));
/* 510 */       paramCalendar.add(12, -(m % 3600000) / 60000);
/*     */     }
/*     */ 
/* 518 */     int j = paramCalendar.get(1);
/* 519 */     int k = paramCalendar.get(2);
/* 520 */     int m = paramCalendar.get(5);
/* 521 */     int n = paramCalendar.get(11);
/* 522 */     int i1 = paramCalendar.get(12);
/* 523 */     int i2 = paramCalendar.get(13);
/* 524 */     int i3 = paramCalendar.get(14);
/*     */ 
/* 526 */     Calendar localCalendar = (Calendar)this.statement.getGMTCalendar().clone();
/*     */ 
/* 529 */     localCalendar.set(0, paramCalendar.get(0));
/* 530 */     localCalendar.set(1, j);
/* 531 */     localCalendar.set(2, k);
/* 532 */     localCalendar.set(5, m);
/* 533 */     localCalendar.set(11, n);
/* 534 */     localCalendar.set(12, i1);
/* 535 */     localCalendar.set(13, i2);
/* 536 */     localCalendar.set(14, i3);
/*     */ 
/* 538 */     long l = localCalendar.getTimeInMillis();
/*     */ 
/* 540 */     return l;
/*     */   }
/*     */ 
/*     */   byte getZoneOffset(Calendar paramCalendar, OffsetDST paramOffsetDST)
/*     */     throws SQLException
/*     */   {
/* 548 */     byte b = 0;
/*     */ 
/* 551 */     String str = paramCalendar.getTimeZone().getID();
/*     */ 
/* 554 */     if ((str == "Custom") || ((str.startsWith("GMT")) && (str.length() > 3)))
/*     */     {
/* 558 */       paramOffsetDST.setOFFSET(paramCalendar.getTimeZone().getRawOffset());
/*     */     }
/*     */     else
/*     */     {
/* 562 */       int i = ZONEIDMAP.getID(str);
/*     */ 
/* 564 */       if (!ZONEIDMAP.isValidID(i))
/*     */       {
/* 566 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 199);
/* 567 */         ((SQLException)localObject).fillInStackTrace();
/* 568 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 572 */       Object localObject = this.statement.connection.getTIMEZONETAB();
/* 573 */       if (((TIMEZONETAB)localObject).checkID(i)) {
/* 574 */         ((TIMEZONETAB)localObject).updateTable(this.statement.connection, i);
/*     */       }
/*     */ 
/* 578 */       b = ((TIMEZONETAB)localObject).getLocalOffset(paramCalendar, i, paramOffsetDST);
/*     */     }
/*     */ 
/* 581 */     return b;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.TimestampltzAccessor
 * JD-Core Version:    0.6.2
 */