/*       */ package oracle.jdbc.driver;
/*       */ 
/*       */ import java.sql.SQLException;
/*       */ import java.sql.Timestamp;
/*       */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*       */ 
/*       */ class TimestampBinder extends DateCommonBinder
/*       */ {
/* 21183 */   Binder theTimestampCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimestampCopyingBinder;
/*       */ 
/* 21263 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*       */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*       */   public static final boolean TRACE = false;
/*       */ 
/*       */   static void init(Binder paramBinder)
/*       */   {
/* 21189 */     paramBinder.type = 180;
/* 21190 */     paramBinder.bytelen = 11;
/*       */   }
/*       */ 
/*       */   TimestampBinder()
/*       */   {
/* 21197 */     init(this);
/*       */   }
/*       */ 
/*       */   Binder copyingBinder()
/*       */   {
/* 21204 */     return this.theTimestampCopyingBinder;
/*       */   }
/*       */ 
/*       */   long bind(OraclePreparedStatement paramOraclePreparedStatement, int paramInt1, int paramInt2, int paramInt3, byte[] paramArrayOfByte, char[] paramArrayOfChar, short[] paramArrayOfShort, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, int paramInt9, boolean paramBoolean, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 21216 */     Timestamp[] arrayOfTimestamp = paramOraclePreparedStatement.parameterTimestamp[paramInt3];
/* 21217 */     Timestamp localTimestamp = arrayOfTimestamp[paramInt1];
/*       */ 
/* 21219 */     if (paramBoolean) {
/* 21220 */       arrayOfTimestamp[paramInt1] = null;
/*       */     }
/* 21222 */     if (localTimestamp == null)
/*       */     {
/* 21224 */       paramArrayOfShort[paramInt9] = -1;
/*       */     }
/*       */     else
/*       */     {
/* 21228 */       paramArrayOfShort[paramInt9] = 0;
/*       */ 
/* 21230 */       setOracleHMS(setOracleCYMD(localTimestamp.getTime(), paramArrayOfByte, paramInt6, paramOraclePreparedStatement), paramArrayOfByte, paramInt6);
/*       */ 
/* 21233 */       int i = localTimestamp.getNanos();
/*       */ 
/* 21235 */       if (i != 0)
/*       */       {
/* 21237 */         setOracleNanos(i, paramArrayOfByte, paramInt6);
/*       */ 
/* 21239 */         paramArrayOfShort[paramInt8] = ((short)paramInt4);
/*       */       }
/*       */       else
/*       */       {
/* 21245 */         paramArrayOfShort[paramInt8] = 7;
/*       */       }
/*       */     }
/* 21248 */     if (paramOraclePreparedStatement.connection.checksumMode.needToCalculateBindChecksum()) {
/* 21249 */       if (paramArrayOfShort[paramInt9] == -1) {
/* 21250 */         paramLong = CRC64.updateChecksum(paramLong, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length);
/*       */       }
/*       */       else
/*       */       {
/* 21254 */         paramLong = CRC64.updateChecksum(paramLong, localTimestamp.getTime());
/*       */       }
/*       */     }
/*       */ 
/* 21258 */     return paramLong;
/*       */   }
/*       */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.TimestampBinder
 * JD-Core Version:    0.6.2
 */