/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.sql.Datum;
/*     */ 
/*     */ class TimestampAccessor extends DateTimeCommonAccessor
/*     */ {
/*     */   static final int MAXLENGTH = 11;
/* 135 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   TimestampAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*  27 */     super(Representation.TIMESTAMP, paramOracleStatement, 11, paramBoolean);
/*     */ 
/*  29 */     init(paramOracleStatement, 180, 180, paramShort, paramBoolean);
/*  30 */     initForDataAccess(paramInt2, paramInt1, null);
/*     */   }
/*     */ 
/*     */   TimestampAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  38 */     super(Representation.TIMESTAMP, paramOracleStatement, 11, false);
/*     */ 
/*  40 */     init(paramOracleStatement, 180, 180, paramShort, false);
/*  41 */     initForDescribe(180, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, null);
/*     */ 
/*  43 */     initForDataAccess(0, paramInt1, null);
/*     */   }
/*     */ 
/*     */   String getString(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  51 */     if (isNull(paramInt)) {
/*  52 */       return null;
/*     */     }
/*     */ 
/*  55 */     getBytesInternal(paramInt, this.tmpBytes);
/*  56 */     int i = getLength(paramInt);
/*     */ 
/*  58 */     int j = oracleYear(this.tmpBytes);
/*  59 */     int k = -1;
/*     */ 
/*  61 */     if (i == 11)
/*     */     {
/*  63 */       k = oracleNanos(this.tmpBytes);
/*     */     }
/*     */ 
/*  66 */     int m = oracleHour(this.tmpBytes);
/*  67 */     String str = toText(j, oracleMonth(this.tmpBytes) + 1, oracleDay(this.tmpBytes), m, oracleMin(this.tmpBytes), oracleSec(this.tmpBytes), k, m < 12, null);
/*     */ 
/*  76 */     return str;
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  85 */     if (isNull(paramInt)) return null;
/*     */ 
/*  87 */     if (this.externalType == 0)
/*     */     {
/*  89 */       if (this.statement.connection.j2ee13Compliant)
/*     */       {
/*  92 */         return getTimestamp(paramInt);
/*     */       }
/*     */ 
/*  96 */       return getTIMESTAMP(paramInt);
/*     */     }
/*     */ 
/* 101 */     switch (this.externalType)
/*     */     {
/*     */     case 93:
/* 104 */       return getTimestamp(paramInt);
/*     */     }
/*     */ 
/* 107 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/*     */ 
/* 109 */     localSQLException.fillInStackTrace();
/* 110 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   Datum getOracleObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 122 */     return getTIMESTAMP(paramInt);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 130 */     return getObject(paramInt);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.TimestampAccessor
 * JD-Core Version:    0.6.2
 */