/*       */ package oracle.jdbc.driver;
/*       */ 
/*       */ import java.sql.SQLException;
/*       */ import java.sql.Time;
/*       */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*       */ 
/*       */ class TimeBinder extends DateCommonBinder
/*       */ {
/* 21078 */   Binder theTimeCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimeCopyingBinder;
/*       */ 
/* 21159 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*       */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*       */   public static final boolean TRACE = false;
/*       */ 
/*       */   static void init(Binder paramBinder)
/*       */   {
/* 21084 */     paramBinder.type = 12;
/* 21085 */     paramBinder.bytelen = 7;
/*       */   }
/*       */ 
/*       */   TimeBinder()
/*       */   {
/* 21092 */     init(this);
/*       */   }
/*       */ 
/*       */   Binder copyingBinder()
/*       */   {
/* 21099 */     return this.theTimeCopyingBinder;
/*       */   }
/*       */ 
/*       */   long bind(OraclePreparedStatement paramOraclePreparedStatement, int paramInt1, int paramInt2, int paramInt3, byte[] paramArrayOfByte, char[] paramArrayOfChar, short[] paramArrayOfShort, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, int paramInt9, boolean paramBoolean, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 21111 */     Time[] arrayOfTime = paramOraclePreparedStatement.parameterTime[paramInt3];
/* 21112 */     Time localTime = arrayOfTime[paramInt1];
/*       */ 
/* 21114 */     if (paramBoolean) {
/* 21115 */       arrayOfTime[paramInt1] = null;
/*       */     }
/* 21117 */     if (localTime == null)
/*       */     {
/* 21119 */       paramArrayOfShort[paramInt9] = -1;
/*       */     }
/*       */     else
/*       */     {
/* 21123 */       paramArrayOfShort[paramInt9] = 0;
/*       */ 
/* 21125 */       setOracleHMS(setOracleCYMD(localTime.getTime(), paramArrayOfByte, paramInt6, paramOraclePreparedStatement), paramArrayOfByte, paramInt6);
/*       */ 
/* 21129 */       paramArrayOfByte[(0 + paramInt6)] = 119;
/* 21130 */       paramArrayOfByte[(2 + paramInt6)] = 1;
/* 21131 */       paramArrayOfByte[(3 + paramInt6)] = 1;
/*       */ 
/* 21133 */       if (paramOraclePreparedStatement.connection.use1900AsYearForTime)
/*       */       {
/* 21135 */         paramArrayOfByte[(1 + paramInt6)] = 100;
/*       */       }
/*       */       else
/*       */       {
/* 21139 */         paramArrayOfByte[(1 + paramInt6)] = -86;
/*       */       }
/*       */ 
/* 21142 */       paramArrayOfShort[paramInt8] = ((short)paramInt4);
/*       */     }
/* 21144 */     if (paramOraclePreparedStatement.connection.checksumMode.needToCalculateBindChecksum()) {
/* 21145 */       if (paramArrayOfShort[paramInt9] == -1) {
/* 21146 */         paramLong = CRC64.updateChecksum(paramLong, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length);
/*       */       }
/*       */       else
/*       */       {
/* 21150 */         paramLong = CRC64.updateChecksum(paramLong, localTime.getTime());
/*       */       }
/*       */     }
/*       */ 
/* 21154 */     return paramLong;
/*       */   }
/*       */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.TimeBinder
 * JD-Core Version:    0.6.2
 */