/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ class T4Ctoh
/*     */ {
/*     */   static final int TOPLVL_KPCTOH = 1;
/*     */   static final int SERBEG_KPCTOH = 2;
/*     */   static final int SEREND_KPCTOH = 4;
/*     */   static final int SERONE_KPCTOH = 8;
/*     */   static final int NEW_KPCTOH = 16;
/*     */   static final int UPDATE_KPCTOH = 32;
/*     */   static final int DELETE_KPCTOH = 64;
/*     */   static final int LAST_KPCTOH = 128;
/*     */   static final int NOOBJ_KPCTOH = 256;
/*     */   static final int NNO_KPCTOH = 512;
/*     */   static final int RAWSTR_KPCTOH = 1024;
/*  71 */   static final byte[] EOID_KOTTD = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1 };
/*     */   static final byte KORFPFNNL = 2;
/*     */   static final byte EXTENT_OID = 8;
/*     */   static final int DONE_KPCTOC = 0;
/*     */   static final int MORE_KPCTOC = -1;
/*     */   static final int IGNORE_KPCTOC = -2;
/*     */   static final int KOLRUG_ENABLE = 1;
/*  91 */   static final byte[] ANYDATA_TOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 17 };
/*     */   static final int KOIDFLEN = 16;
/*     */   static final int KOIDSLEN = 8;
/*  99 */   byte[] toid = null;
/* 100 */   byte[] oid = null;
/* 101 */   byte[] snapshot = null;
/* 102 */   int versionNumber = 0;
/* 103 */   int imageLength = 0;
/* 104 */   int flags = 0;
/*     */ 
/* 106 */   int[] intArr = new int[1];
/*     */ 
/* 198 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   void init(byte[] paramArrayOfByte, int paramInt)
/*     */   {
/* 118 */     if ((this.toid == null) || (this.toid.length != 36)) {
/* 119 */       this.toid = new byte[36];
/*     */     }
/* 121 */     this.toid[0] = 0;
/* 122 */     this.toid[1] = 36;
/*     */ 
/* 124 */     this.toid[2] = 2;
/* 125 */     this.toid[3] = 8;
/*     */ 
/* 127 */     System.arraycopy(paramArrayOfByte, 0, this.toid, 4, 16);
/*     */ 
/* 129 */     System.arraycopy(EOID_KOTTD, 0, this.toid, 20, 16);
/* 130 */     this.imageLength = paramInt;
/*     */ 
/* 132 */     this.oid = null;
/* 133 */     this.snapshot = null;
/* 134 */     this.versionNumber = 0;
/* 135 */     this.flags = 1;
/*     */   }
/*     */ 
/*     */   void marshal(T4CMAREngine paramT4CMAREngine)
/*     */     throws IOException
/*     */   {
/* 144 */     if (this.toid == null) {
/* 145 */       paramT4CMAREngine.marshalUB4(0L);
/*     */     }
/*     */     else {
/* 148 */       paramT4CMAREngine.marshalUB4(this.toid.length);
/* 149 */       paramT4CMAREngine.marshalCLR(this.toid, 0, this.toid.length);
/*     */     }
/* 151 */     if (this.oid == null) {
/* 152 */       paramT4CMAREngine.marshalUB4(0L);
/*     */     }
/*     */     else {
/* 155 */       paramT4CMAREngine.marshalUB4(this.oid.length);
/* 156 */       paramT4CMAREngine.marshalCLR(this.oid, 0, this.oid.length);
/*     */     }
/* 158 */     if (this.snapshot == null) {
/* 159 */       paramT4CMAREngine.marshalUB4(0L);
/*     */     }
/*     */     else {
/* 162 */       paramT4CMAREngine.marshalUB4(this.snapshot.length);
/* 163 */       paramT4CMAREngine.marshalCLR(this.snapshot, 0, this.snapshot.length);
/*     */     }
/* 165 */     paramT4CMAREngine.marshalUB2(this.versionNumber);
/* 166 */     paramT4CMAREngine.marshalUB4(this.imageLength);
/* 167 */     paramT4CMAREngine.marshalUB2(this.flags);
/*     */   }
/*     */ 
/*     */   void unmarshal(T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException, IOException
/*     */   {
/* 176 */     int i = (int)paramT4CMAREngine.unmarshalUB4();
/* 177 */     if ((this.toid == null) || (this.toid.length != i))
/* 178 */       this.toid = new byte[i];
/* 179 */     if (i > 0) {
/* 180 */       paramT4CMAREngine.unmarshalCLR(this.toid, 0, this.intArr, i);
/*     */     }
/* 182 */     int j = (int)paramT4CMAREngine.unmarshalUB4();
/* 183 */     this.oid = new byte[j];
/* 184 */     if (j > 0) {
/* 185 */       paramT4CMAREngine.unmarshalCLR(this.oid, 0, this.intArr, j);
/*     */     }
/* 187 */     int k = (int)paramT4CMAREngine.unmarshalUB4();
/* 188 */     this.snapshot = new byte[k];
/* 189 */     if (k > 0) {
/* 190 */       paramT4CMAREngine.unmarshalCLR(this.snapshot, 0, this.intArr, k);
/*     */     }
/* 192 */     this.versionNumber = paramT4CMAREngine.unmarshalUB2();
/* 193 */     this.imageLength = ((int)paramT4CMAREngine.unmarshalUB4());
/* 194 */     this.flags = paramT4CMAREngine.unmarshalUB2();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4Ctoh
 * JD-Core Version:    0.6.2
 */