/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.aq.AQEnqueueOptions;
/*     */ import oracle.jdbc.aq.AQEnqueueOptions.DeliveryMode;
/*     */ import oracle.jdbc.aq.AQEnqueueOptions.SequenceDeviationOption;
/*     */ import oracle.jdbc.aq.AQEnqueueOptions.VisibilityOption;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ final class T4Caqe extends T4CTTIfun
/*     */ {
/*     */   static final int KPD_AQ_BUFMSG = 2;
/*     */   static final int KPD_AQ_EITHER = 16;
/*     */   static final int OCI_COMMIT_ON_SUCCESS = 32;
/*     */   static final int ATTR_TRANSFORMATION = 196;
/*     */   T4CTTIaqm aqm;
/*     */   T4Ctoh toh;
/* 236 */   private byte[] queueNameBytes = null;
/* 237 */   private AQEnqueueOptions enqueueOptions = null;
/* 238 */   private AQMessagePropertiesI messageProperties = null;
/* 239 */   private byte[] messageData = null;
/* 240 */   private byte[] messageOid = null;
/* 241 */   private boolean isRawQueue = false;
/* 242 */   private int nbExtensions = 0;
/* 243 */   private byte[][] extensionTextValues = (byte[][])null;
/* 244 */   private byte[][] extensionBinaryValues = (byte[][])null;
/* 245 */   private int[] extensionKeywords = null;
/* 246 */   private AQAgentI[] attrRecipientList = null;
/* 247 */   private byte[][] recipientTextValues = (byte[][])null;
/* 248 */   private byte[][] recipientBinaryValues = (byte[][])null;
/* 249 */   private int[] recipientKeywords = null;
/*     */   private byte[] aqmcorBytes;
/*     */   private byte[] aqmeqnBytes;
/* 252 */   private boolean retrieveMessageId = false;
/* 253 */   private byte[] outMsgid = null;
/* 254 */   private byte[] senderAgentName = null;
/* 255 */   private byte[] senderAgentAddress = null;
/* 256 */   private byte senderAgentProtocol = 0;
/*     */ 
/* 594 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4Caqe(T4CConnection paramT4CConnection)
/*     */   {
/* 229 */     super(paramT4CConnection, (byte)3);
/*     */ 
/* 231 */     setFunCode((short)121);
/* 232 */     this.toh = new T4Ctoh();
/* 233 */     this.aqm = new T4CTTIaqm(this.connection, this.toh);
/*     */   }
/*     */ 
/*     */   void doOAQEQ(String paramString, AQEnqueueOptions paramAQEnqueueOptions, AQMessagePropertiesI paramAQMessagePropertiesI, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, boolean paramBoolean)
/*     */     throws SQLException, IOException
/*     */   {
/* 270 */     this.enqueueOptions = paramAQEnqueueOptions;
/* 271 */     this.messageProperties = paramAQMessagePropertiesI;
/*     */ 
/* 273 */     String str1 = this.messageProperties.getCorrelation();
/* 274 */     if ((str1 != null) && (str1.length() != 0))
/* 275 */       this.aqmcorBytes = this.meg.conv.StringToCharBytes(str1);
/*     */     else
/* 277 */       this.aqmcorBytes = null;
/* 278 */     String str2 = this.messageProperties.getExceptionQueue();
/* 279 */     if ((str2 != null) && (str2.length() != 0))
/* 280 */       this.aqmeqnBytes = this.meg.conv.StringToCharBytes(str2);
/*     */     else {
/* 282 */       this.aqmeqnBytes = null;
/*     */     }
/* 284 */     AQAgentI localAQAgentI = (AQAgentI)this.messageProperties.getSender();
/* 285 */     if (localAQAgentI != null)
/*     */     {
/* 287 */       if (localAQAgentI.getName() != null) {
/* 288 */         this.senderAgentName = this.meg.conv.StringToCharBytes(localAQAgentI.getName());
/*     */       }
/*     */       else
/* 291 */         this.senderAgentName = null;
/* 292 */       if (localAQAgentI.getAddress() != null) {
/* 293 */         this.senderAgentAddress = this.meg.conv.StringToCharBytes(localAQAgentI.getAddress());
/*     */       }
/*     */       else
/* 296 */         this.senderAgentAddress = null;
/* 297 */       this.senderAgentProtocol = ((byte)localAQAgentI.getProtocol());
/*     */     }
/*     */     else
/*     */     {
/* 301 */       this.senderAgentName = null;
/* 302 */       this.senderAgentAddress = null;
/* 303 */       this.senderAgentProtocol = 0;
/*     */     }
/*     */ 
/* 306 */     this.messageData = paramArrayOfByte1;
/* 307 */     this.messageOid = paramArrayOfByte2;
/* 308 */     this.isRawQueue = paramBoolean;
/* 309 */     if ((paramString != null) && (paramString.length() != 0))
/* 310 */       this.queueNameBytes = this.meg.conv.StringToCharBytes(paramString);
/*     */     else {
/* 312 */       this.queueNameBytes = null;
/*     */     }
/* 314 */     this.attrRecipientList = ((AQAgentI[])this.messageProperties.getRecipientList());
/*     */ 
/* 316 */     if ((this.attrRecipientList != null) && (this.attrRecipientList.length > 0))
/*     */     {
/* 318 */       this.recipientTextValues = new byte[this.attrRecipientList.length * 3][];
/* 319 */       this.recipientBinaryValues = new byte[this.attrRecipientList.length * 3][];
/* 320 */       this.recipientKeywords = new int[this.attrRecipientList.length * 3];
/* 321 */       for (int i = 0; i < this.attrRecipientList.length; i++)
/*     */       {
/* 323 */         if (this.attrRecipientList[i].getName() != null) {
/* 324 */           this.recipientTextValues[(3 * i)] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i].getName());
/*     */         }
/*     */ 
/* 327 */         if (this.attrRecipientList[i].getAddress() != null) {
/* 328 */           this.recipientTextValues[(3 * i + 1)] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i].getAddress());
/*     */         }
/*     */ 
/* 331 */         this.recipientBinaryValues[(3 * i + 2)] = new byte[1];
/* 332 */         this.recipientBinaryValues[(3 * i + 2)][0] = ((byte)this.attrRecipientList[i].getProtocol());
/* 333 */         this.recipientKeywords[(3 * i)] = (3 * i);
/* 334 */         this.recipientKeywords[(3 * i + 1)] = (3 * i + 1);
/* 335 */         this.recipientKeywords[(3 * i + 2)] = (3 * i + 2);
/*     */       }
/*     */     }
/*     */ 
/* 339 */     String str3 = this.enqueueOptions.getTransformation();
/* 340 */     if ((str3 != null) && (str3.length() > 0))
/*     */     {
/* 342 */       this.nbExtensions = 1;
/* 343 */       this.extensionTextValues = new byte[this.nbExtensions][];
/* 344 */       this.extensionBinaryValues = new byte[this.nbExtensions][];
/* 345 */       this.extensionKeywords = new int[this.nbExtensions];
/* 346 */       this.extensionTextValues[0] = this.meg.conv.StringToCharBytes(str3);
/* 347 */       this.extensionBinaryValues[0] = null;
/* 348 */       this.extensionKeywords[0] = 196;
/*     */     }
/*     */     else {
/* 351 */       this.nbExtensions = 0;
/* 352 */     }this.outMsgid = null;
/* 353 */     doRPC();
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 364 */     if ((this.queueNameBytes != null) && (this.queueNameBytes.length != 0))
/*     */     {
/* 366 */       this.meg.marshalPTR();
/* 367 */       this.meg.marshalSWORD(this.queueNameBytes.length);
/*     */     }
/*     */     else
/*     */     {
/* 371 */       this.meg.marshalNULLPTR();
/* 372 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 375 */     this.aqm.initToDefaultValues();
/* 376 */     this.aqm.aqmpri = this.messageProperties.getPriority();
/* 377 */     this.aqm.aqmdel = this.messageProperties.getDelay();
/* 378 */     this.aqm.aqmexp = this.messageProperties.getExpiration();
/* 379 */     this.aqm.aqmcorBytes = this.aqmcorBytes;
/* 380 */     this.aqm.aqmeqnBytes = this.aqmeqnBytes;
/* 381 */     this.aqm.senderAgentName = this.senderAgentName;
/* 382 */     this.aqm.senderAgentAddress = this.senderAgentAddress;
/* 383 */     this.aqm.senderAgentProtocol = this.senderAgentProtocol;
/* 384 */     this.aqm.originalMsgId = this.messageProperties.getPreviousQueueMessageId();
/* 385 */     this.aqm.marshal();
/*     */ 
/* 387 */     AQAgentI[] arrayOfAQAgentI = (AQAgentI[])this.messageProperties.getRecipientList();
/*     */ 
/* 391 */     if ((arrayOfAQAgentI != null) && (arrayOfAQAgentI.length > 0))
/*     */     {
/* 393 */       this.meg.marshalPTR();
/* 394 */       this.meg.marshalSWORD(arrayOfAQAgentI.length * 3);
/*     */     }
/*     */     else
/*     */     {
/* 398 */       this.meg.marshalNULLPTR();
/* 399 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 403 */     this.meg.marshalSB4(this.enqueueOptions.getVisibility().getCode());
/*     */ 
/* 406 */     int i = 0;
/* 407 */     if ((this.enqueueOptions.getRelativeMessageId() != null) && (this.enqueueOptions.getRelativeMessageId().length > 0))
/*     */     {
/* 410 */       i = 1;
/* 411 */       this.meg.marshalPTR();
/* 412 */       this.meg.marshalSWORD(this.enqueueOptions.getRelativeMessageId().length);
/*     */     }
/*     */     else
/*     */     {
/* 416 */       this.meg.marshalNULLPTR();
/* 417 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 420 */     this.meg.marshalSWORD(this.enqueueOptions.getSequenceDeviation().getCode());
/*     */ 
/* 423 */     this.meg.marshalPTR();
/* 424 */     this.meg.marshalSWORD(16);
/*     */ 
/* 426 */     this.meg.marshalUB2(1);
/* 427 */     if (!this.isRawQueue)
/*     */     {
/* 430 */       this.meg.marshalPTR();
/*     */ 
/* 432 */       this.meg.marshalNULLPTR();
/*     */ 
/* 434 */       this.meg.marshalUB4(0L);
/*     */     }
/*     */     else
/*     */     {
/* 439 */       this.meg.marshalNULLPTR();
/*     */ 
/* 441 */       this.meg.marshalPTR();
/*     */ 
/* 443 */       this.meg.marshalUB4(this.messageData.length);
/*     */     }
/* 445 */     if (this.enqueueOptions.getRetrieveMessageId())
/*     */     {
/* 447 */       this.retrieveMessageId = true;
/*     */ 
/* 449 */       this.meg.marshalPTR();
/*     */ 
/* 451 */       this.meg.marshalSWORD(16);
/*     */     }
/*     */     else
/*     */     {
/* 455 */       this.retrieveMessageId = false;
/*     */ 
/* 457 */       this.meg.marshalNULLPTR();
/*     */ 
/* 459 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 463 */     int j = 0;
/* 464 */     if (this.connection.autocommit)
/* 465 */       j = 32;
/* 466 */     if (this.enqueueOptions.getDeliveryMode() == AQEnqueueOptions.DeliveryMode.BUFFERED)
/* 467 */       j |= 2;
/* 468 */     this.meg.marshalUB4(j);
/*     */ 
/* 470 */     this.meg.marshalNULLPTR();
/*     */ 
/* 472 */     this.meg.marshalNULLPTR();
/*     */ 
/* 476 */     if (this.nbExtensions > 0)
/*     */     {
/* 478 */       this.meg.marshalPTR();
/* 479 */       this.meg.marshalSWORD(this.nbExtensions);
/*     */     }
/*     */     else
/*     */     {
/* 484 */       this.meg.marshalNULLPTR();
/*     */ 
/* 486 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 490 */     this.meg.marshalNULLPTR();
/*     */ 
/* 492 */     this.meg.marshalSWORD(0);
/*     */ 
/* 494 */     this.meg.marshalNULLPTR();
/*     */ 
/* 496 */     this.meg.marshalSWORD(0);
/*     */ 
/* 498 */     this.meg.marshalNULLPTR();
/*     */ 
/* 500 */     if (this.connection.getTTCVersion() >= 4)
/*     */     {
/* 505 */       this.meg.marshalNULLPTR();
/*     */ 
/* 507 */       this.meg.marshalSWORD(0);
/*     */ 
/* 509 */       this.meg.marshalNULLPTR();
/*     */ 
/* 511 */       this.meg.marshalSWORD(0);
/*     */ 
/* 513 */       this.meg.marshalNULLPTR();
/*     */ 
/* 515 */       this.meg.marshalSWORD(0);
/*     */ 
/* 517 */       this.meg.marshalNULLPTR();
/*     */ 
/* 519 */       this.meg.marshalNULLPTR();
/*     */     }
/*     */ 
/* 524 */     if ((this.queueNameBytes != null) && (this.queueNameBytes.length != 0)) {
/* 525 */       this.meg.marshalCHR(this.queueNameBytes);
/*     */     }
/* 527 */     if ((arrayOfAQAgentI != null) && (arrayOfAQAgentI.length > 0))
/*     */     {
/* 529 */       this.meg.marshalKPDKV(this.recipientTextValues, this.recipientBinaryValues, this.recipientKeywords);
/*     */     }
/*     */ 
/* 535 */     if (i != 0) {
/* 536 */       this.meg.marshalB1Array(this.enqueueOptions.getRelativeMessageId());
/*     */     }
/*     */ 
/* 539 */     this.meg.marshalB1Array(this.messageOid);
/*     */ 
/* 542 */     if (!this.isRawQueue)
/*     */     {
/* 544 */       this.toh.init(this.messageOid, this.messageData.length);
/* 545 */       this.toh.marshal(this.meg);
/* 546 */       this.meg.marshalCLR(this.messageData, 0, this.messageData.length);
/*     */     }
/*     */     else {
/* 549 */       this.meg.marshalB1Array(this.messageData);
/*     */     }
/* 551 */     if (this.nbExtensions > 0)
/* 552 */       this.meg.marshalKPDKV(this.extensionTextValues, this.extensionBinaryValues, this.extensionKeywords);
/*     */   }
/*     */ 
/*     */   byte[] getMessageId()
/*     */   {
/* 560 */     return this.outMsgid;
/*     */   }
/*     */ 
/*     */   void readRPA()
/*     */     throws SQLException, IOException
/*     */   {
/* 567 */     if (this.retrieveMessageId)
/*     */     {
/* 569 */       this.outMsgid = new byte[16];
/* 570 */       this.meg.unmarshalBuffer(this.outMsgid, 0, 16);
/*     */     }
/* 572 */     int i = this.meg.unmarshalUB2();
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 589 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4Caqe
 * JD-Core Version:    0.6.2
 */