/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.aq.AQAgent;
/*     */ import oracle.jdbc.aq.AQDequeueOptions;
/*     */ import oracle.jdbc.aq.AQDequeueOptions.DeliveryFilter;
/*     */ import oracle.jdbc.aq.AQDequeueOptions.DequeueMode;
/*     */ import oracle.jdbc.aq.AQDequeueOptions.NavigationOption;
/*     */ import oracle.jdbc.aq.AQDequeueOptions.VisibilityOption;
/*     */ import oracle.jdbc.aq.AQMessageProperties.DeliveryMode;
/*     */ import oracle.jdbc.aq.AQMessageProperties.MessageState;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.TIMESTAMP;
/*     */ 
/*     */ final class T4Caqdq extends T4CTTIfun
/*     */ {
/*     */   T4CTTIaqm aqm;
/*     */   T4Ctoh toh;
/*     */   private String queueName;
/* 100 */   private AQDequeueOptions dequeueOptions = null;
/* 101 */   private byte[] payloadToid = null;
/* 102 */   private byte[] queueNameBytes = null;
/* 103 */   private byte[] consumerNameBytes = null;
/* 104 */   private byte[] correlationBytes = null;
/* 105 */   private byte[] conditionBytes = null;
/* 106 */   private int nbExtensions = 0;
/* 107 */   private byte[][] extensionTextValues = (byte[][])null;
/* 108 */   private byte[][] extensionBinaryValues = (byte[][])null;
/* 109 */   private int[] extensionKeywords = null;
/*     */ 
/* 112 */   private byte[] payload = null;
/* 113 */   private boolean hasAMessageBeenDequeued = false;
/* 114 */   private byte[] dequeuedMessageId = null;
/* 115 */   private boolean isRawQueue = false;
/* 116 */   private AQMessagePropertiesI properties = null;
/*     */ 
/* 508 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4Caqdq(T4CConnection paramT4CConnection)
/*     */   {
/*  91 */     super(paramT4CConnection, (byte)3);
/*     */ 
/*  93 */     setFunCode((short)122);
/*  94 */     this.toh = new T4Ctoh();
/*  95 */     this.aqm = new T4CTTIaqm(this.connection, this.toh);
/*     */   }
/*     */ 
/*     */   void doOAQDQ(String paramString, AQDequeueOptions paramAQDequeueOptions, byte[] paramArrayOfByte, boolean paramBoolean, AQMessagePropertiesI paramAQMessagePropertiesI)
/*     */     throws SQLException, IOException
/*     */   {
/* 127 */     this.queueName = paramString;
/* 128 */     this.dequeueOptions = paramAQDequeueOptions;
/* 129 */     this.payloadToid = paramArrayOfByte;
/* 130 */     this.isRawQueue = paramBoolean;
/* 131 */     this.properties = paramAQMessagePropertiesI;
/*     */ 
/* 134 */     if ((this.queueName != null) && (this.queueName.length() != 0))
/* 135 */       this.queueNameBytes = this.meg.conv.StringToCharBytes(this.queueName);
/*     */     else {
/* 137 */       this.queueNameBytes = null;
/*     */     }
/* 139 */     String str1 = this.dequeueOptions.getConsumerName();
/*     */ 
/* 141 */     if ((str1 != null) && (str1.length() > 0))
/*     */     {
/* 143 */       this.consumerNameBytes = this.meg.conv.StringToCharBytes(str1);
/*     */     }
/*     */     else {
/* 146 */       this.consumerNameBytes = null;
/*     */     }
/* 148 */     String str2 = this.dequeueOptions.getCorrelation();
/* 149 */     if ((str2 != null) && (str2.length() != 0))
/* 150 */       this.correlationBytes = this.meg.conv.StringToCharBytes(str2);
/*     */     else {
/* 152 */       this.correlationBytes = null;
/*     */     }
/* 154 */     String str3 = this.dequeueOptions.getCondition();
/* 155 */     if ((str3 != null) && (str3.length() > 0))
/* 156 */       this.conditionBytes = this.meg.conv.StringToCharBytes(str3);
/*     */     else {
/* 158 */       this.conditionBytes = null;
/*     */     }
/* 160 */     String str4 = this.dequeueOptions.getTransformation();
/* 161 */     if ((str4 != null) && (str4.length() > 0))
/*     */     {
/* 163 */       this.nbExtensions = 1;
/* 164 */       this.extensionTextValues = new byte[this.nbExtensions][];
/* 165 */       this.extensionBinaryValues = new byte[this.nbExtensions][];
/* 166 */       this.extensionKeywords = new int[this.nbExtensions];
/* 167 */       this.extensionTextValues[0] = this.meg.conv.StringToCharBytes(str4);
/* 168 */       this.extensionBinaryValues[0] = null;
/* 169 */       this.extensionKeywords[0] = 196;
/*     */     }
/*     */     else {
/* 172 */       this.nbExtensions = 0;
/*     */     }
/* 174 */     this.hasAMessageBeenDequeued = false;
/* 175 */     this.dequeuedMessageId = null;
/* 176 */     this.payload = null;
/*     */ 
/* 178 */     doRPC();
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 189 */     if ((this.queueNameBytes != null) && (this.queueNameBytes.length != 0))
/*     */     {
/* 191 */       this.meg.marshalPTR();
/* 192 */       this.meg.marshalSWORD(this.queueNameBytes.length);
/*     */     }
/*     */     else
/*     */     {
/* 196 */       this.meg.marshalNULLPTR();
/* 197 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 202 */     this.meg.marshalPTR();
/* 203 */     this.meg.marshalPTR();
/*     */ 
/* 207 */     this.meg.marshalPTR();
/* 208 */     this.meg.marshalPTR();
/*     */ 
/* 212 */     if ((this.consumerNameBytes != null) && (this.consumerNameBytes.length != 0))
/*     */     {
/* 214 */       this.meg.marshalPTR();
/* 215 */       this.meg.marshalSWORD(this.consumerNameBytes.length);
/*     */     }
/*     */     else
/*     */     {
/* 219 */       this.meg.marshalNULLPTR();
/* 220 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 224 */     this.meg.marshalSB4(this.dequeueOptions.getDequeueMode().getCode());
/*     */ 
/* 227 */     this.meg.marshalSB4(this.dequeueOptions.getNavigation().getCode());
/*     */ 
/* 230 */     this.meg.marshalSB4(this.dequeueOptions.getVisibility().getCode());
/*     */ 
/* 233 */     this.meg.marshalSB4(this.dequeueOptions.getWait());
/*     */ 
/* 237 */     byte[] arrayOfByte = this.dequeueOptions.getDequeueMessageId();
/* 238 */     int i = 0;
/* 239 */     if ((arrayOfByte != null) && (arrayOfByte.length > 0))
/*     */     {
/* 241 */       this.meg.marshalPTR();
/* 242 */       this.meg.marshalSWORD(arrayOfByte.length);
/* 243 */       i = 1;
/*     */     }
/*     */     else
/*     */     {
/* 247 */       this.meg.marshalNULLPTR();
/* 248 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 253 */     if ((this.correlationBytes != null) && (this.correlationBytes.length != 0))
/*     */     {
/* 255 */       this.meg.marshalPTR();
/* 256 */       this.meg.marshalSWORD(this.correlationBytes.length);
/*     */     }
/*     */     else
/*     */     {
/* 260 */       this.meg.marshalNULLPTR();
/* 261 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 266 */     this.meg.marshalPTR();
/* 267 */     this.meg.marshalSWORD(this.payloadToid.length);
/*     */ 
/* 270 */     this.meg.marshalUB2(1);
/*     */ 
/* 273 */     this.meg.marshalPTR();
/*     */ 
/* 278 */     if (this.dequeueOptions.getRetrieveMessageId())
/*     */     {
/* 280 */       this.meg.marshalPTR();
/* 281 */       this.meg.marshalSWORD(16);
/*     */     }
/*     */     else
/*     */     {
/* 285 */       this.meg.marshalNULLPTR();
/* 286 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 290 */     int j = 0;
/* 291 */     if (this.connection.autocommit)
/* 292 */       j = 32;
/* 293 */     if (this.dequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.BUFFERED)
/* 294 */       j |= 2;
/* 295 */     else if (this.dequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.PERSISTENT_OR_BUFFERED)
/*     */     {
/* 297 */       j |= 16;
/* 298 */     }this.meg.marshalUB4(j);
/*     */ 
/* 302 */     if ((this.conditionBytes != null) && (this.conditionBytes.length > 0))
/*     */     {
/* 304 */       this.meg.marshalPTR();
/* 305 */       this.meg.marshalSWORD(this.conditionBytes.length);
/*     */     }
/*     */     else
/*     */     {
/* 309 */       this.meg.marshalNULLPTR();
/* 310 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 315 */     if (this.nbExtensions > 0)
/*     */     {
/* 317 */       this.meg.marshalPTR();
/* 318 */       this.meg.marshalSWORD(this.nbExtensions);
/*     */     }
/*     */     else
/*     */     {
/* 322 */       this.meg.marshalNULLPTR();
/* 323 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 328 */     if ((this.queueNameBytes != null) && (this.queueNameBytes.length != 0)) {
/* 329 */       this.meg.marshalCHR(this.queueNameBytes);
/*     */     }
/*     */ 
/* 332 */     if ((this.consumerNameBytes != null) && (this.consumerNameBytes.length != 0)) {
/* 333 */       this.meg.marshalCHR(this.consumerNameBytes);
/*     */     }
/*     */ 
/* 336 */     if (i != 0) {
/* 337 */       this.meg.marshalB1Array(arrayOfByte);
/*     */     }
/*     */ 
/* 340 */     if ((this.correlationBytes != null) && (this.correlationBytes.length != 0)) {
/* 341 */       this.meg.marshalCHR(this.correlationBytes);
/*     */     }
/*     */ 
/* 344 */     this.meg.marshalB1Array(this.payloadToid);
/*     */ 
/* 346 */     if ((this.conditionBytes != null) && (this.conditionBytes.length > 0)) {
/* 347 */       this.meg.marshalCHR(this.conditionBytes);
/*     */     }
/* 349 */     if (this.nbExtensions > 0)
/* 350 */       this.meg.marshalKPDKV(this.extensionTextValues, this.extensionBinaryValues, this.extensionKeywords);
/*     */   }
/*     */ 
/*     */   byte[] getPayload()
/*     */   {
/* 358 */     return this.payload;
/*     */   }
/*     */ 
/*     */   boolean hasAMessageBeenDequeued()
/*     */   {
/* 364 */     return this.hasAMessageBeenDequeued;
/*     */   }
/*     */ 
/*     */   byte[] getDequeuedMessageId()
/*     */   {
/* 370 */     return this.dequeuedMessageId;
/*     */   }
/*     */ 
/*     */   void readRPA()
/*     */     throws SQLException, IOException
/*     */   {
/* 377 */     this.hasAMessageBeenDequeued = true;
/*     */ 
/* 379 */     int i = (int)this.meg.unmarshalUB4();
/* 380 */     if (i > 0)
/*     */     {
/* 382 */       this.aqm.initToDefaultValues();
/* 383 */       this.aqm.receive();
/* 384 */       this.properties.setPriority(this.aqm.aqmpri);
/* 385 */       this.properties.setDelay(this.aqm.aqmdel);
/* 386 */       this.properties.setExpiration(this.aqm.aqmexp);
/* 387 */       if (this.aqm.aqmcorBytes != null)
/*     */       {
/* 389 */         localObject = this.meg.conv.CharBytesToString(this.aqm.aqmcorBytes, this.aqm.aqmcorBytesLength, true);
/*     */ 
/* 391 */         this.properties.setCorrelation((String)localObject);
/*     */       }
/* 393 */       this.properties.setAttempts(this.aqm.aqmatt);
/* 394 */       if (this.aqm.aqmeqnBytes != null)
/*     */       {
/* 396 */         localObject = this.meg.conv.CharBytesToString(this.aqm.aqmeqnBytes, this.aqm.aqmeqnBytesLength, true);
/*     */ 
/* 398 */         this.properties.setExceptionQueue((String)localObject);
/*     */       }
/* 400 */       this.properties.setMessageState(AQMessageProperties.MessageState.getMessageState(this.aqm.aqmsta));
/* 401 */       this.properties.setEnqueueTime(this.aqm.aqmeqt.timestampValue());
/* 402 */       Object localObject = new AQAgentI();
/* 403 */       if (this.aqm.senderAgentName != null) {
/* 404 */         ((AQAgentI)localObject).setName(this.meg.conv.CharBytesToString(this.aqm.senderAgentName, this.aqm.senderAgentNameLength, true));
/*     */       }
/*     */ 
/* 408 */       if (this.aqm.senderAgentAddress != null) {
/* 409 */         ((AQAgentI)localObject).setAddress(this.meg.conv.CharBytesToString(this.aqm.senderAgentAddress, this.aqm.senderAgentAddressLength, true));
/*     */       }
/*     */ 
/* 413 */       ((AQAgentI)localObject).setProtocol(this.aqm.senderAgentProtocol);
/*     */ 
/* 415 */       this.properties.setSender((AQAgent)localObject);
/* 416 */       this.properties.setPreviousQueueMessageId(this.aqm.originalMsgId);
/* 417 */       this.properties.setDeliveryMode(AQMessageProperties.DeliveryMode.getDeliveryMode(this.aqm.aqmflg));
/*     */ 
/* 420 */       if (this.aqm.aqmetiBytes != null)
/*     */       {
/* 422 */         String str = this.meg.conv.CharBytesToString(this.aqm.aqmetiBytes, this.aqm.aqmetiBytes.length, true);
/*     */ 
/* 424 */         this.properties.setTransactionGroup(str);
/*     */       }
/*     */     }
/*     */ 
/* 428 */     int j = (int)this.meg.unmarshalUB4();
/*     */ 
/* 431 */     this.toh.unmarshal(this.meg);
/* 432 */     int k = this.toh.imageLength;
/*     */ 
/* 435 */     if (k > 0)
/*     */     {
/* 438 */       int m = k;
/*     */       byte[] arrayOfByte2;
/*     */       int[] arrayOfInt;
/* 440 */       if (this.isRawQueue)
/*     */       {
/* 445 */         if (k > 4) {
/* 446 */           m -= 4;
/*     */         }
/*     */ 
/* 450 */         m = Math.min(m, this.dequeueOptions.getMaximumBufferLength());
/*     */ 
/* 453 */         arrayOfByte2 = new byte[m];
/* 454 */         arrayOfInt = new int[1];
/* 455 */         if (k > 4)
/* 456 */           this.meg.unmarshalCLR(arrayOfByte2, 0L, arrayOfInt, arrayOfByte2.length, 4);
/*     */         else
/* 458 */           this.meg.unmarshalCLR(arrayOfByte2, 0, arrayOfInt, arrayOfByte2.length);
/* 459 */         this.payload = arrayOfByte2;
/*     */       }
/*     */       else
/*     */       {
/* 464 */         arrayOfByte2 = new byte[m];
/* 465 */         arrayOfInt = new int[1];
/* 466 */         this.meg.unmarshalCLR(arrayOfByte2, 0, arrayOfInt, arrayOfByte2.length);
/* 467 */         this.payload = arrayOfByte2;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 472 */     if (this.dequeueOptions.getRetrieveMessageId())
/*     */     {
/* 474 */       byte[] arrayOfByte1 = new byte[16];
/* 475 */       this.meg.unmarshalBuffer(arrayOfByte1, 0, 16);
/* 476 */       this.dequeuedMessageId = arrayOfByte1;
/*     */     }
/*     */   }
/*     */ 
/*     */   void processError()
/*     */     throws SQLException
/*     */   {
/* 484 */     if (this.oer.retCode != 25228)
/*     */     {
/* 486 */       this.oer.processError();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 503 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4Caqdq
 * JD-Core Version:    0.6.2
 */