/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.sql.SQLException;
/*      */ import javax.sql.XAConnection;
/*      */ import javax.transaction.xa.XAException;
/*      */ import javax.transaction.xa.XAResource;
/*      */ import javax.transaction.xa.Xid;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.xa.OracleXAConnection;
/*      */ import oracle.jdbc.xa.OracleXAException;
/*      */ import oracle.jdbc.xa.OracleXid;
/*      */ import oracle.jdbc.xa.client.OracleXADataSource;
/*      */ import oracle.jdbc.xa.client.OracleXAResource;
/*      */ 
/*      */ class T4CXAResource extends OracleXAResource
/*      */ {
/*      */   T4CConnection physicalConn;
/*   35 */   int[] applicationValueArr = new int[1];
/*   36 */   boolean isTransLoose = false;
/*      */   byte[] context;
/*      */   int errorNumber;
/*      */   private String password;
/* 1060 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   T4CXAResource(T4CConnection paramT4CConnection, OracleXAConnection paramOracleXAConnection, boolean paramBoolean)
/*      */     throws XAException
/*      */   {
/*   46 */     super(paramT4CConnection, paramOracleXAConnection);
/*      */ 
/*   48 */     this.physicalConn = paramT4CConnection;
/*   49 */     this.isTransLoose = paramBoolean;
/*      */   }
/*      */ 
/*      */   protected int doStart(Xid paramXid, int paramInt)
/*      */     throws XAException
/*      */   {
/*   57 */     synchronized (this.physicalConn)
/*      */     {
/*   59 */       int i = -1;
/*      */ 
/*   83 */       if (this.isTransLoose) {
/*   84 */         paramInt |= 65536;
/*      */       }
/*      */ 
/*   91 */       int j = paramInt & 0x8200000;
/*      */ 
/*   94 */       if ((j == 134217728) && (OracleXid.isLocalTransaction(paramXid))) {
/*   95 */         return 0;
/*      */       }
/*      */ 
/*  134 */       this.applicationValueArr[0] = 0;
/*      */       try
/*      */       {
/*      */         try
/*      */         {
/*  140 */           T4CTTIOtxse localT4CTTIOtxse = this.physicalConn.otxse;
/*  141 */           localObject1 = null;
/*  142 */           byte[] arrayOfByte1 = paramXid.getGlobalTransactionId();
/*  143 */           byte[] arrayOfByte2 = paramXid.getBranchQualifier();
/*      */ 
/*  145 */           int k = 0;
/*  146 */           int m = 0;
/*      */ 
/*  148 */           if ((arrayOfByte1 != null) && (arrayOfByte2 != null))
/*      */           {
/*  150 */             k = Math.min(arrayOfByte1.length, 64);
/*  151 */             m = Math.min(arrayOfByte2.length, 64);
/*  152 */             localObject1 = new byte[''];
/*      */ 
/*  154 */             System.arraycopy(arrayOfByte1, 0, localObject1, 0, k);
/*  155 */             System.arraycopy(arrayOfByte2, 0, localObject1, k, m);
/*      */           }
/*      */ 
/*  158 */           int n = 0;
/*      */ 
/*  161 */           if (((paramInt & 0x200000) != 0) || ((paramInt & 0x8000000) != 0))
/*  162 */             n |= 4;
/*      */           else {
/*  164 */             n |= 1;
/*      */           }
/*  166 */           if ((paramInt & 0x100) != 0) {
/*  167 */             n |= 256;
/*      */           }
/*  169 */           if ((paramInt & 0x200) != 0) {
/*  170 */             n |= 512;
/*      */           }
/*  172 */           if ((paramInt & 0x400) != 0) {
/*  173 */             n |= 1024;
/*      */           }
/*  175 */           if ((paramInt & 0x10000) != 0) {
/*  176 */             n |= 65536;
/*      */           }
/*      */ 
/*  182 */           this.physicalConn.needLine();
/*  183 */           localT4CTTIOtxse.doOTXSE(1, null, (byte[])localObject1, paramXid.getFormatId(), k, m, this.timeout, n, this.applicationValueArr);
/*      */ 
/*  187 */           this.applicationValueArr[0] = localT4CTTIOtxse.getApplicationValue();
/*  188 */           byte[] arrayOfByte3 = localT4CTTIOtxse.getContext();
/*      */ 
/*  192 */           if (arrayOfByte3 != null) {
/*  193 */             this.context = arrayOfByte3;
/*      */           }
/*  195 */           i = 0;
/*  196 */           this.physicalConn.currentlyInTransaction = true;
/*      */         }
/*      */         catch (IOException localIOException)
/*      */         {
/*  205 */           Object localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  206 */           ((SQLException)localObject1).fillInStackTrace();
/*  207 */           throw ((Throwable)localObject1);
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/*  215 */         i = localSQLException.getErrorCode();
/*      */ 
/*  219 */         if (i == 0) {
/*  220 */           throw new XAException(-6);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  260 */       return i;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected int doEnd(Xid paramXid, int paramInt, boolean paramBoolean)
/*      */     throws XAException
/*      */   {
/*  269 */     synchronized (this.physicalConn)
/*      */     {
/*  271 */       int i = -1;
/*      */       try
/*      */       {
/*      */         try
/*      */         {
/*  294 */           T4CTTIOtxse localT4CTTIOtxse = this.physicalConn.otxse;
/*  295 */           localObject1 = null;
/*  296 */           byte[] arrayOfByte1 = paramXid.getGlobalTransactionId();
/*  297 */           byte[] arrayOfByte2 = paramXid.getBranchQualifier();
/*      */ 
/*  299 */           int j = 0;
/*  300 */           int k = 0;
/*      */ 
/*  302 */           if ((arrayOfByte1 != null) && (arrayOfByte2 != null))
/*      */           {
/*  304 */             j = Math.min(arrayOfByte1.length, 64);
/*  305 */             k = Math.min(arrayOfByte2.length, 64);
/*  306 */             localObject1 = new byte[''];
/*      */ 
/*  308 */             System.arraycopy(arrayOfByte1, 0, localObject1, 0, j);
/*  309 */             System.arraycopy(arrayOfByte2, 0, localObject1, j, k);
/*      */           }
/*      */ 
/*  314 */           if (this.context == null)
/*      */           {
/*  316 */             i = doStart(paramXid, 134217728);
/*      */ 
/*  318 */             if (i != 0) {
/*  319 */               return i;
/*      */             }
/*      */           }
/*  322 */           byte[] arrayOfByte3 = this.context;
/*  323 */           int m = 0;
/*  324 */           if ((paramInt & 0x2) == 2)
/*      */           {
/*  326 */             m = 1048576;
/*  327 */           } else if (((paramInt & 0x2000000) == 33554432) && ((paramInt & 0x100000) != 1048576))
/*      */           {
/*  340 */             m = 1048576;
/*      */           }
/*      */ 
/*  346 */           this.applicationValueArr[0] >>= 16;
/*      */ 
/*  354 */           this.physicalConn.needLine();
/*  355 */           localT4CTTIOtxse.doOTXSE(2, arrayOfByte3, (byte[])localObject1, paramXid.getFormatId(), j, k, this.timeout, m, this.applicationValueArr);
/*      */ 
/*  359 */           this.applicationValueArr[0] = localT4CTTIOtxse.getApplicationValue();
/*  360 */           byte[] arrayOfByte4 = localT4CTTIOtxse.getContext();
/*      */ 
/*  363 */           if (arrayOfByte4 != null) {
/*  364 */             this.context = arrayOfByte4;
/*      */           }
/*  366 */           i = 0;
/*  367 */           this.physicalConn.currentlyInTransaction = false;
/*      */         }
/*      */         catch (IOException localIOException)
/*      */         {
/*  376 */           Object localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  377 */           ((SQLException)localObject1).fillInStackTrace();
/*  378 */           throw ((Throwable)localObject1);
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/*  386 */         i = localSQLException.getErrorCode();
/*      */ 
/*  390 */         if (i == 0) {
/*  391 */           throw new XAException(-6);
/*      */         }
/*      */       }
/*  394 */       return i;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void doCommit(Xid paramXid, boolean paramBoolean)
/*      */     throws SQLException, XAException
/*      */   {
/*  413 */     synchronized (this.physicalConn)
/*      */     {
/*  416 */       int i = paramBoolean ? 4 : 2;
/*      */       try
/*      */       {
/*  420 */         int j = doTransaction(paramXid, 1, i);
/*      */ 
/*  423 */         if ((!paramBoolean) || ((j != 2) && (j != 4)))
/*      */         {
/*  429 */           if ((paramBoolean) || (j != 5))
/*      */           {
/*  433 */             if (j == 8) {
/*  434 */               throw new XAException(106);
/*      */             }
/*  436 */             throw new XAException(-6); } 
/*  437 */         }this.physicalConn.currentlyInTransaction = false;
/*      */       }
/*      */       catch (SQLException localSQLException1)
/*      */       {
/*  441 */         int k = localSQLException1.getErrorCode();
/*  442 */         if (k == 24756)
/*      */         {
/*  446 */           kputxrec(paramXid, 1, this.timeout + 120, localSQLException1);
/*      */         }
/*  448 */         else if (k == 24780)
/*      */         {
/*  452 */           OracleXADataSource localOracleXADataSource = null;
/*  453 */           XAConnection localXAConnection = null;
/*      */           try
/*      */           {
/*  457 */             localOracleXADataSource = new OracleXADataSource();
/*      */ 
/*  459 */             localOracleXADataSource.setURL(this.physicalConn.url);
/*  460 */             localOracleXADataSource.setUser(this.physicalConn.userName);
/*  461 */             this.physicalConn.getPasswordInternal(this);
/*  462 */             localOracleXADataSource.setPassword(this.password);
/*      */ 
/*  464 */             localXAConnection = localOracleXADataSource.getXAConnection();
/*      */ 
/*  466 */             XAResource localXAResource = localXAConnection.getXAResource();
/*      */ 
/*  468 */             localXAResource.commit(paramXid, paramBoolean);
/*  469 */             this.physicalConn.currentlyInTransaction = false;
/*      */           }
/*      */           catch (SQLException localSQLException2)
/*      */           {
/*  475 */             XAException localXAException = new XAException(-6);
/*  476 */             localXAException.initCause(localSQLException2);
/*  477 */             throw localXAException;
/*      */           }
/*      */           finally
/*      */           {
/*      */             try
/*      */             {
/*  483 */               if (localXAConnection != null) {
/*  484 */                 localXAConnection.close();
/*      */               }
/*  486 */               if (localOracleXADataSource != null)
/*  487 */                 localOracleXADataSource.close();
/*      */             }
/*      */             catch (Exception localException2)
/*      */             {
/*      */             }
/*      */           }
/*      */         }
/*      */         else {
/*  495 */           throw localSQLException1;
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected int doPrepare(Xid paramXid)
/*      */     throws XAException, SQLException
/*      */   {
/*  506 */     synchronized (this.physicalConn)
/*      */     {
/*  508 */       int i = -1;
/*      */       try {
/*  510 */         int j = doTransaction(paramXid, 3, 0);
/*      */ 
/*  513 */         if (j == 8)
/*      */         {
/*  516 */           throw new XAException(106);
/*      */         }
/*  518 */         if (j == 4)
/*      */         {
/*  521 */           i = 3;
/*      */         }
/*  523 */         else if (j == 1)
/*      */         {
/*  526 */           i = 0;
/*      */         } else {
/*  528 */           if (j == 3)
/*      */           {
/*  533 */             throw new XAException(100);
/*      */           }
/*      */ 
/*  538 */           throw new XAException(-6);
/*      */         }
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/*  543 */         int k = localSQLException.getErrorCode();
/*      */ 
/*  549 */         if (k == 25351)
/*      */         {
/*  552 */           XAException localXAException = new XAException(-6);
/*  553 */           localXAException.initCause(localSQLException);
/*  554 */           throw localXAException;
/*      */         }
/*  556 */         throw localSQLException;
/*      */       }
/*  558 */       return i;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected int doForget(Xid paramXid)
/*      */     throws XAException, SQLException
/*      */   {
/*  567 */     synchronized (this.physicalConn)
/*      */     {
/*  569 */       int i = 0;
/*      */ 
/*  571 */       if (OracleXid.isLocalTransaction(paramXid)) {
/*  572 */         return 24771;
/*      */       }
/*      */ 
/*  576 */       int j = doStart(paramXid, 134217728);
/*      */ 
/*  578 */       if (j != 24756)
/*      */       {
/*  582 */         if (j == 0)
/*      */         {
/*      */           try
/*      */           {
/*  588 */             doEnd(paramXid, 0, false);
/*      */           }
/*      */           catch (Exception localException)
/*      */           {
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  596 */         if ((j == 0) || (j == 2079) || (j == 24754) || (j == 24761) || (j == 24774) || (j == 24776) || (j == 25351))
/*      */         {
/*  603 */           return 24769;
/*  604 */         }if (j == 24752) {
/*  605 */           return 24771;
/*      */         }
/*  607 */         return j;
/*      */       }
/*      */ 
/*  610 */       kputxrec(paramXid, 4, 1, null);
/*      */ 
/*  612 */       return i;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void doRollback(Xid paramXid)
/*      */     throws XAException, SQLException
/*      */   {
/*  620 */     synchronized (this.physicalConn)
/*      */     {
/*      */       try
/*      */       {
/*  624 */         int i = doTransaction(paramXid, 2, 3);
/*      */ 
/*  627 */         if (i == 8)
/*  628 */           throw new XAException(106);
/*  629 */         if (i != 3)
/*      */         {
/*  634 */           throw new XAException(-6);
/*  635 */         }this.physicalConn.currentlyInTransaction = false;
/*      */       }
/*      */       catch (SQLException localSQLException1)
/*      */       {
/*  639 */         int j = localSQLException1.getErrorCode();
/*      */ 
/*  642 */         if (j == 24756)
/*      */         {
/*  646 */           kputxrec(paramXid, 2, this.timeout + 120, localSQLException1);
/*      */         }
/*  648 */         else if (j == 24780)
/*      */         {
/*  653 */           OracleXADataSource localOracleXADataSource = null;
/*  654 */           XAConnection localXAConnection = null;
/*      */           try
/*      */           {
/*  658 */             localOracleXADataSource = new OracleXADataSource();
/*      */ 
/*  660 */             localOracleXADataSource.setURL(this.physicalConn.url);
/*  661 */             localOracleXADataSource.setUser(this.physicalConn.userName);
/*  662 */             this.physicalConn.getPasswordInternal(this);
/*  663 */             localOracleXADataSource.setPassword(this.password);
/*      */ 
/*  665 */             localXAConnection = localOracleXADataSource.getXAConnection();
/*      */ 
/*  667 */             XAResource localXAResource = localXAConnection.getXAResource();
/*      */ 
/*  669 */             localXAResource.rollback(paramXid);
/*  670 */             this.physicalConn.currentlyInTransaction = false;
/*      */           }
/*      */           catch (SQLException localSQLException2)
/*      */           {
/*  675 */             XAException localXAException = new XAException(-6);
/*  676 */             localXAException.initCause(localSQLException2);
/*  677 */             throw localXAException;
/*      */           }
/*      */           finally
/*      */           {
/*      */             try
/*      */             {
/*  683 */               if (localXAConnection != null) {
/*  684 */                 localXAConnection.close();
/*      */               }
/*  686 */               if (localOracleXADataSource != null)
/*  687 */                 localOracleXADataSource.close();
/*      */             } catch (Exception localException2) {
/*      */             }
/*      */           }
/*      */         }
/*  692 */         else if (j != 25402)
/*      */         {
/*  698 */           throw localSQLException1;
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   int doTransaction(Xid paramXid, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  719 */     int i = -1;
/*      */     try
/*      */     {
/*  725 */       T4CTTIOtxen localT4CTTIOtxen = this.physicalConn.otxen;
/*  726 */       localObject = null;
/*  727 */       byte[] arrayOfByte1 = paramXid.getGlobalTransactionId();
/*  728 */       byte[] arrayOfByte2 = paramXid.getBranchQualifier();
/*      */ 
/*  730 */       int j = 0;
/*  731 */       int k = 0;
/*      */ 
/*  733 */       if ((arrayOfByte1 != null) && (arrayOfByte2 != null))
/*      */       {
/*  735 */         j = Math.min(arrayOfByte1.length, 64);
/*  736 */         k = Math.min(arrayOfByte2.length, 64);
/*  737 */         localObject = new byte[''];
/*      */ 
/*  739 */         System.arraycopy(arrayOfByte1, 0, localObject, 0, j);
/*  740 */         System.arraycopy(arrayOfByte2, 0, localObject, j, k);
/*      */       }
/*      */ 
/*  743 */       byte[] arrayOfByte3 = this.context;
/*      */ 
/*  745 */       this.physicalConn.needLine();
/*  746 */       localT4CTTIOtxen.doOTXEN(paramInt1, arrayOfByte3, (byte[])localObject, paramXid.getFormatId(), j, k, this.timeout, paramInt2, 0);
/*      */ 
/*  748 */       i = localT4CTTIOtxen.getOutStateFromServer();
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  761 */       this.physicalConn.handleIOException(localIOException);
/*      */ 
/*  763 */       Object localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  764 */       ((SQLException)localObject).fillInStackTrace();
/*  765 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/*  769 */     return i;
/*      */   }
/*      */ 
/*      */   protected void kputxrec(Xid paramXid, int paramInt1, int paramInt2, SQLException paramSQLException)
/*      */     throws XAException, SQLException
/*      */   {
/*      */     int i;
/*  786 */     switch (paramInt1)
/*      */     {
/*      */     case 1:
/*  790 */       i = 3;
/*      */ 
/*  792 */       break;
/*      */     case 4:
/*  795 */       i = 2;
/*      */ 
/*  797 */       break;
/*      */     default:
/*  800 */       i = 0;
/*      */     }
/*      */ 
/*  804 */     int j = 0;
/*      */ 
/*  807 */     while (paramInt2-- > 0)
/*      */     {
/*  809 */       j = doTransaction(paramXid, 5, i);
/*      */ 
/*  811 */       if (j != 7) {
/*      */         break;
/*      */       }
/*      */       try
/*      */       {
/*  816 */         Thread.sleep(1000L);
/*      */       }
/*      */       catch (Exception localException)
/*      */       {
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  828 */     if (j == 7)
/*      */     {
/*  832 */       throw new XAException(-6);
/*      */     }
/*      */ 
/*  841 */     int m = -1;
/*      */ 
/*  843 */     switch (j)
/*      */     {
/*      */     case 3:
/*  847 */       if (paramInt1 == 1) {
/*  848 */         k = 7;
/*      */       }
/*      */       else
/*      */       {
/*  852 */         k = 8;
/*  853 */         m = -3;
/*      */       }
/*      */ 
/*  856 */       break;
/*      */     case 0:
/*  859 */       if (paramInt1 == 4)
/*      */       {
/*  861 */         k = 8;
/*  862 */         m = -3;
/*      */       }
/*      */       else
/*      */       {
/*  866 */         k = 7;
/*  867 */         if (paramInt1 == 1)
/*  868 */           m = -4;  } break;
/*      */     case 2:
/*  874 */       if (paramInt1 == 4)
/*      */       {
/*  876 */         k = 8;
/*      */ 
/*  879 */         m = -6;
/*  880 */       }break;
/*      */     case 5:
/*  883 */       if (paramInt1 == 4)
/*      */       {
/*  885 */         k = 7;
/*      */       }
/*      */       else
/*      */       {
/*  889 */         m = 7;
/*  890 */         k = 8;
/*      */       }
/*  892 */       break;
/*      */     case 4:
/*  895 */       if (paramInt1 == 4)
/*      */       {
/*  897 */         k = 7;
/*      */       }
/*      */       else
/*      */       {
/*  901 */         m = 6;
/*  902 */         k = 8;
/*      */       }
/*  904 */       break;
/*      */     case 6:
/*  907 */       if (paramInt1 == 4)
/*      */       {
/*  909 */         k = 7;
/*      */       }
/*      */       else
/*      */       {
/*  913 */         m = 5;
/*  914 */         k = 8;
/*      */       }
/*      */ 
/*  917 */       break;
/*      */     case 1:
/*      */     }
/*  920 */     m = -3;
/*  921 */     int k = 8;
/*      */ 
/*  926 */     T4CTTIk2rpc localT4CTTIk2rpc = this.physicalConn.k2rpc;
/*      */     try
/*      */     {
/*  930 */       localT4CTTIk2rpc.doOK2RPC(3, k);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  935 */       localXAException = new XAException(-7);
/*  936 */       localXAException.initCause(localIOException);
/*  937 */       throw localXAException;
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*  942 */       XAException localXAException = new XAException(-6);
/*  943 */       localXAException.initCause(localSQLException);
/*  944 */       throw localXAException;
/*      */     }
/*      */ 
/*  947 */     if (m != -1)
/*      */     {
/*  951 */       OracleXAException localOracleXAException = null;
/*  952 */       if (paramSQLException != null)
/*      */       {
/*  954 */         localOracleXAException = new OracleXAException(paramSQLException.getErrorCode(), m);
/*  955 */         localOracleXAException.initCause(paramSQLException);
/*      */       }
/*      */       else {
/*  958 */         localOracleXAException = new OracleXAException(0, m);
/*      */       }
/*  960 */       throw localOracleXAException;
/*      */     }
/*      */   }
/*      */ 
/*      */   final void setPasswordInternal(String paramString)
/*      */   {
/*  969 */     this.password = paramString;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/*  983 */     return this.physicalConn;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CXAResource
 * JD-Core Version:    0.6.2
 */