/*    */ package oracle.jdbc.driver;
/*    */ 
/*    */ import java.sql.Connection;
/*    */ import javax.transaction.xa.XAException;
/*    */ import javax.transaction.xa.XAResource;
/*    */ import oracle.jdbc.babelfish.BabelfishConnection;
/*    */ import oracle.jdbc.proxy._Proxy_;
/*    */ import oracle.jdbc.xa.OracleXAResource;
/*    */ import oracle.jdbc.xa.client.OracleXAConnection;
/*    */ 
/*    */ public class T4CXAConnection extends OracleXAConnection
/*    */ {
/*    */   T4CTTIOtxen otxen;
/*    */   T4CTTIOtxse otxse;
/*    */   T4CConnection physicalConnection;
/* 82 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*    */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*    */   public static final boolean TRACE = false;
/*    */ 
/*    */   public T4CXAConnection(Connection paramConnection)
/*    */     throws XAException
/*    */   {
/* 32 */     super(paramConnection);
/*    */ 
/* 40 */     if ((paramConnection instanceof BabelfishConnection))
/*    */     {
/* 42 */       this.physicalConnection = ((T4CConnection)((_Proxy_)paramConnection)._getDelegate_());
/*    */     }
/*    */     else
/*    */     {
/* 46 */       this.physicalConnection = ((T4CConnection)paramConnection);
/*    */     }
/*    */ 
/* 50 */     this.xaResource = null;
/*    */   }
/*    */ 
/*    */   public synchronized XAResource getXAResource()
/*    */   {
/*    */     try
/*    */     {
/* 59 */       if (this.xaResource == null)
/*    */       {
/* 61 */         this.xaResource = new T4CXAResource(this.physicalConnection, this, this.isXAResourceTransLoose);
/*    */ 
/* 64 */         if (this.logicalHandle != null)
/*    */         {
/* 68 */           ((OracleXAResource)this.xaResource).setLogicalConnection(this.logicalHandle);
/*    */         }
/*    */       }
/*    */ 
/*    */     }
/*    */     catch (Exception localException)
/*    */     {
/* 75 */       this.xaResource = null;
/*    */     }
/* 77 */     return this.xaResource;
/*    */   }
/*    */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CXAConnection
 * JD-Core Version:    0.6.2
 */