/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.PrintStream;
/*      */ import java.math.BigDecimal;
/*      */ import java.sql.Date;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.Time;
/*      */ import java.sql.Timestamp;
/*      */ import java.text.DateFormatSymbols;
/*      */ import java.util.Calendar;
/*      */ import java.util.GregorianCalendar;
/*      */ import java.util.Properties;
/*      */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*      */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*      */ import oracle.sql.DATE;
/*      */ import oracle.sql.Datum;
/*      */ import oracle.sql.NUMBER;
/*      */ import oracle.sql.RAW;
/*      */ import oracle.sql.TIMESTAMP;
/*      */ import oracle.sql.TIMESTAMPLTZ;
/*      */ import oracle.sql.TIMESTAMPTZ;
/*      */ 
/*      */ class T4CVarcharAccessor extends VarcharAccessor
/*      */   implements T4CAccessor
/*      */ {
/*      */   T4CMAREngine mare;
/*      */   static final int MAX_CALL_LENGTH_PRE102 = 4001;
/*      */   static final int MIN_SQL_LENGTH = 32;
/*   58 */   boolean underlyingLong = false;
/*      */ 
/*  708 */   private T4CMarshaller marshaller = null;
/*      */   static final int NONE = -1;
/*      */   static final int DAY = 1;
/*      */   static final int MM_MONTH = 2;
/*      */   static final int FULL_MONTH = 3;
/*      */   static final int MON_MONTH = 4;
/*      */   static final int YY_YEAR = 5;
/*      */   static final int RR_YEAR = 6;
/*      */   static final int HH_HOUR = 7;
/*      */   static final int HH24_HOUR = 8;
/*      */   static final int MINUTE = 9;
/*      */   static final int SECOND = 10;
/*      */   static final int NSECOND = 11;
/*      */   static final int AM = 12;
/*      */   static final int TZR = 13;
/*      */   static final int TZH = 14;
/*      */   static final int TZM = 15;
/* 1247 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   T4CVarcharAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean, T4CMAREngine paramT4CMAREngine)
/*      */     throws SQLException
/*      */   {
/*   64 */     super(paramOracleStatement, paramInt1, paramShort, paramInt2, paramBoolean);
/*      */ 
/*   66 */     this.mare = paramT4CMAREngine;
/*      */ 
/*   68 */     calculateSizeTmpByteArray();
/*      */   }
/*      */ 
/*      */   T4CVarcharAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, int paramInt7, int paramInt8, int paramInt9, T4CMAREngine paramT4CMAREngine)
/*      */     throws SQLException
/*      */   {
/*   78 */     super(paramOracleStatement, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort);
/*      */ 
/*   82 */     this.mare = paramT4CMAREngine;
/*   83 */     this.definedColumnType = paramInt8;
/*   84 */     this.definedColumnSize = paramInt9;
/*      */ 
/*   86 */     calculateSizeTmpByteArray();
/*      */ 
/*   92 */     this.oacmxl = paramInt7;
/*      */ 
/*   94 */     if (this.oacmxl == -1)
/*      */     {
/*   96 */       this.underlyingLong = true;
/*   97 */       this.oacmxl = 4000;
/*      */     }
/*      */   }
/*      */ 
/*      */   public T4CMAREngine getMAREngine()
/*      */   {
/*  103 */     return this.mare;
/*      */   }
/*      */ 
/*      */   public void unmarshalColumnMetadata()
/*      */     throws SQLException, IOException
/*      */   {
/*  112 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*      */     {
/*  115 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*      */     }
/*      */   }
/*      */ 
/*      */   public void processIndicator(int paramInt)
/*      */     throws IOException, SQLException
/*      */   {
/*  122 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*      */     {
/*  129 */       this.mare.unmarshalUB2();
/*  130 */       this.mare.unmarshalUB2();
/*      */     }
/*  132 */     else if (this.statement.connection.versionNumber < 9200)
/*      */     {
/*  136 */       this.mare.unmarshalSB2();
/*      */ 
/*  138 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/*  139 */         this.mare.unmarshalSB2();
/*      */     }
/*  141 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/*  142 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   int getPreviousRowProcessed()
/*      */   {
/*  148 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/*  149 */     return this.previousRowProcessed;
/*      */   }
/*      */ 
/*      */   void copyRow()
/*      */     throws SQLException, IOException
/*      */   {
/*  159 */     if (this.isNullByDescribe) {
/*  160 */       setNull(this.lastRowProcessed, true);
/*      */     }
/*  162 */     else if (this.lastRowProcessed == 0)
/*      */     {
/*  167 */       if (this.previousRowProcessed == -1)
/*  168 */         this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/*  169 */       long l = getOffset(this.previousRowProcessed);
/*  170 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/*  171 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/*  172 */       if (!isNull(this.previousRowProcessed)) {
/*  173 */         setOffset(this.lastRowProcessed);
/*  174 */         ((DynamicByteArray)this.rowData).copyLeft(l, getLength(this.previousRowProcessed));
/*  175 */         setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  180 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/*  181 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/*  182 */       setOffset(this.lastRowProcessed, getOffset(this.previousRowProcessed));
/*  183 */       setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*      */     }
/*  185 */     this.previousRowProcessed = this.lastRowProcessed;
/*  186 */     this.lastRowProcessed += 1;
/*      */   }
/*      */ 
/*      */   boolean unmarshalOneRow()
/*      */     throws SQLException, IOException
/*      */   {
/*  195 */     return getMarshaller().unmarshalOneRow(this);
/*      */   }
/*      */ 
/*      */   int readStreamFromWire(byte[] paramArrayOfByte, int paramInt1, int paramInt2, int[] paramArrayOfInt, boolean[] paramArrayOfBoolean1, boolean[] paramArrayOfBoolean2, T4CMAREngine paramT4CMAREngine, T4CTTIoer paramT4CTTIoer)
/*      */     throws SQLException, IOException
/*      */   {
/*  206 */     return getMarshaller().readStreamFromWire(paramArrayOfByte, paramInt1, paramInt2, paramArrayOfInt, paramArrayOfBoolean1, paramArrayOfBoolean2, paramT4CMAREngine, paramT4CTTIoer);
/*      */   }
/*      */ 
/*      */   NUMBER getNUMBER(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  216 */     NUMBER localNUMBER = null;
/*      */ 
/*  218 */     if (this.definedColumnType == 0) {
/*  219 */       localNUMBER = super.getNUMBER(paramInt);
/*      */     } else {
/*  221 */       String str = getString(paramInt);
/*  222 */       if (str != null) return StringToNUMBER(str.trim());
/*      */     }
/*  224 */     return localNUMBER;
/*      */   }
/*      */ 
/*      */   DATE getDATE(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  231 */     DATE localDATE = null;
/*      */ 
/*  233 */     if (this.definedColumnType == 0) {
/*  234 */       localDATE = super.getDATE(paramInt);
/*      */     }
/*      */     else {
/*  237 */       Date localDate = getDate(paramInt);
/*  238 */       if (localDate != null)
/*      */       {
/*  247 */         localDATE = new DATE(localDate);
/*      */       }
/*      */     }
/*      */ 
/*  251 */     return localDATE;
/*      */   }
/*      */ 
/*      */   TIMESTAMP getTIMESTAMP(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  259 */     TIMESTAMP localTIMESTAMP = null;
/*      */ 
/*  261 */     if (this.definedColumnType == 0) {
/*  262 */       localTIMESTAMP = super.getTIMESTAMP(paramInt);
/*      */     }
/*      */     else {
/*  265 */       String str = getString(paramInt);
/*  266 */       if (str != null)
/*      */       {
/*  276 */         int[] arrayOfInt = new int[1];
/*  277 */         Calendar localCalendar = DATEStringToCalendar(str, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), arrayOfInt);
/*      */ 
/*  280 */         Timestamp localTimestamp = new Timestamp(localCalendar.getTimeInMillis());
/*  281 */         localTimestamp.setNanos(arrayOfInt[0]);
/*  282 */         localTIMESTAMP = new TIMESTAMP(localTimestamp);
/*      */       }
/*      */     }
/*      */ 
/*  286 */     return localTIMESTAMP;
/*      */   }
/*      */ 
/*      */   TIMESTAMPTZ getTIMESTAMPTZ(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  293 */     TIMESTAMPTZ localTIMESTAMPTZ = null;
/*      */ 
/*  295 */     if (this.definedColumnType == 0) {
/*  296 */       localTIMESTAMPTZ = super.getTIMESTAMPTZ(paramInt);
/*      */     }
/*      */     else {
/*  299 */       String str = getString(paramInt);
/*  300 */       if (str != null)
/*      */       {
/*  311 */         int[] arrayOfInt = new int[1];
/*  312 */         Calendar localCalendar = DATEStringToCalendar(str, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), arrayOfInt);
/*      */ 
/*  315 */         Timestamp localTimestamp = new Timestamp(localCalendar.getTimeInMillis());
/*  316 */         localTimestamp.setNanos(arrayOfInt[0]);
/*  317 */         localTIMESTAMPTZ = new TIMESTAMPTZ(this.statement.connection, localTimestamp, localCalendar);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  323 */     return localTIMESTAMPTZ;
/*      */   }
/*      */ 
/*      */   TIMESTAMPLTZ getTIMESTAMPLTZ(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  330 */     TIMESTAMPLTZ localTIMESTAMPLTZ = null;
/*      */ 
/*  332 */     if (this.definedColumnType == 0) {
/*  333 */       localTIMESTAMPLTZ = super.getTIMESTAMPLTZ(paramInt);
/*      */     }
/*      */     else {
/*  336 */       String str = getString(paramInt);
/*  337 */       if (str != null)
/*      */       {
/*  348 */         int[] arrayOfInt = new int[1];
/*  349 */         Calendar localCalendar = DATEStringToCalendar(str, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), arrayOfInt);
/*      */ 
/*  352 */         Timestamp localTimestamp = new Timestamp(localCalendar.getTimeInMillis());
/*  353 */         localTimestamp.setNanos(arrayOfInt[0]);
/*  354 */         localTIMESTAMPLTZ = new TIMESTAMPLTZ(this.statement.connection, localTimestamp, localCalendar);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  360 */     return localTIMESTAMPLTZ;
/*      */   }
/*      */ 
/*      */   RAW getRAW(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  367 */     RAW localRAW = null;
/*      */ 
/*  369 */     if (this.definedColumnType == 0) {
/*  370 */       localRAW = super.getRAW(paramInt);
/*      */     }
/*  373 */     else if (this.rowNull[paramInt] == 0)
/*      */     {
/*  375 */       if ((this.definedColumnType == -2) || (this.definedColumnType == -3) || (this.definedColumnType == -4))
/*      */       {
/*  378 */         localRAW = new RAW(getBytesFromHexChars(paramInt));
/*      */       }
/*  380 */       else localRAW = new RAW(super.getBytes(paramInt));
/*      */ 
/*      */     }
/*      */ 
/*  384 */     return localRAW;
/*      */   }
/*      */ 
/*      */   Datum getOracleObject(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  391 */     if (this.definedColumnType == 0) {
/*  392 */       return super.getOracleObject(paramInt);
/*      */     }
/*      */ 
/*  395 */     Datum localDatum = null;
/*      */     SQLException localSQLException;
/*  397 */     if (this.rowNull == null)
/*      */     {
/*  399 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 21);
/*  400 */       localSQLException.fillInStackTrace();
/*  401 */       throw localSQLException;
/*      */     }
/*      */ 
/*  404 */     if (this.rowNull[paramInt] == 0)
/*      */     {
/*  406 */       switch (this.definedColumnType)
/*      */       {
/*      */       case -16:
/*      */       case -15:
/*      */       case -9:
/*      */       case -1:
/*      */       case 1:
/*      */       case 12:
/*  415 */         return super.getOracleObject(paramInt);
/*      */       case -7:
/*      */       case -6:
/*      */       case -5:
/*      */       case 2:
/*      */       case 3:
/*      */       case 4:
/*      */       case 5:
/*      */       case 6:
/*      */       case 7:
/*      */       case 8:
/*      */       case 16:
/*  438 */         return getNUMBER(paramInt);
/*      */       case 91:
/*  441 */         return getDATE(paramInt);
/*      */       case 92:
/*  444 */         return getDATE(paramInt);
/*      */       case 93:
/*  447 */         return getTIMESTAMP(paramInt);
/*      */       case -101:
/*  450 */         return getTIMESTAMPTZ(paramInt);
/*      */       case -102:
/*  453 */         return getTIMESTAMPLTZ(paramInt);
/*      */       case -4:
/*      */       case -3:
/*      */       case -2:
/*  460 */         return getRAW(paramInt);
/*      */       case -8:
/*  463 */         return getROWID(paramInt);
/*      */       }
/*      */ 
/*  467 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/*  468 */       localSQLException.fillInStackTrace();
/*  469 */       throw localSQLException;
/*      */     }
/*      */ 
/*  475 */     return localDatum;
/*      */   }
/*      */ 
/*      */   byte getByte(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  485 */     byte b = 0;
/*      */ 
/*  487 */     if (this.definedColumnType == 0) {
/*  488 */       b = super.getByte(paramInt);
/*      */     }
/*      */     else {
/*  491 */       NUMBER localNUMBER = getNUMBER(paramInt);
/*  492 */       if (localNUMBER != null) {
/*  493 */         b = localNUMBER.byteValue();
/*      */       }
/*      */     }
/*  496 */     return b;
/*      */   }
/*      */ 
/*      */   int getInt(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  504 */     int i = 0;
/*      */ 
/*  506 */     if (this.definedColumnType == 0) {
/*  507 */       i = super.getInt(paramInt);
/*      */     }
/*      */     else {
/*  510 */       NUMBER localNUMBER = getNUMBER(paramInt);
/*  511 */       if (localNUMBER != null) {
/*  512 */         i = localNUMBER.intValue();
/*      */       }
/*      */     }
/*  515 */     return i;
/*      */   }
/*      */ 
/*      */   short getShort(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  523 */     short s = 0;
/*      */ 
/*  525 */     if (this.definedColumnType == 0) {
/*  526 */       s = super.getShort(paramInt);
/*      */     }
/*      */     else {
/*  529 */       NUMBER localNUMBER = getNUMBER(paramInt);
/*  530 */       if (localNUMBER != null) {
/*  531 */         s = localNUMBER.shortValue();
/*      */       }
/*      */     }
/*  534 */     return s;
/*      */   }
/*      */ 
/*      */   long getLong(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  542 */     long l = 0L;
/*      */ 
/*  544 */     if (this.definedColumnType == 0) {
/*  545 */       l = super.getLong(paramInt);
/*      */     }
/*      */     else {
/*  548 */       NUMBER localNUMBER = getNUMBER(paramInt);
/*  549 */       if (localNUMBER != null) {
/*  550 */         l = localNUMBER.longValue();
/*      */       }
/*      */     }
/*  553 */     return l;
/*      */   }
/*      */ 
/*      */   float getFloat(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  561 */     float f = 0.0F;
/*      */ 
/*  563 */     if (this.definedColumnType == 0) {
/*  564 */       f = super.getFloat(paramInt);
/*      */     }
/*      */     else {
/*  567 */       NUMBER localNUMBER = getNUMBER(paramInt);
/*  568 */       if (localNUMBER != null) {
/*  569 */         f = localNUMBER.floatValue();
/*      */       }
/*      */     }
/*  572 */     return f;
/*      */   }
/*      */ 
/*      */   double getDouble(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  580 */     double d = 0.0D;
/*      */ 
/*  582 */     if (this.definedColumnType == 0) {
/*  583 */       d = super.getDouble(paramInt);
/*      */     }
/*      */     else {
/*  586 */       NUMBER localNUMBER = getNUMBER(paramInt);
/*  587 */       if (localNUMBER != null) {
/*  588 */         d = localNUMBER.doubleValue();
/*      */       }
/*      */     }
/*  591 */     return d;
/*      */   }
/*      */ 
/*      */   Date getDate(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  601 */     Date localDate = null;
/*      */ 
/*  603 */     if (this.definedColumnType == 0) {
/*  604 */       localDate = super.getDate(paramInt);
/*      */     }
/*      */     else {
/*  607 */       String str = getString(paramInt);
/*  608 */       if (str != null)
/*      */       {
/*  617 */         int[] arrayOfInt = new int[1];
/*      */         try {
/*  619 */           localDate = new Date(DATEStringToCalendar(str, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCDATEFM"), arrayOfInt).getTimeInMillis());
/*      */         }
/*      */         catch (NumberFormatException localNumberFormatException)
/*      */         {
/*  625 */           SQLException localSQLException = DatabaseError.createSqlException(null, 132, null, localNumberFormatException);
/*  626 */           localSQLException.fillInStackTrace();
/*  627 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  633 */     return localDate;
/*      */   }
/*      */ 
/*      */   Timestamp getTimestamp(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  641 */     Timestamp localTimestamp = null;
/*      */ 
/*  643 */     if (this.definedColumnType == 0) {
/*  644 */       localTimestamp = super.getTimestamp(paramInt);
/*      */     }
/*      */     else {
/*  647 */       String str = getString(paramInt);
/*  648 */       if (str != null)
/*      */       {
/*  650 */         int[] arrayOfInt = new int[1];
/*      */         try {
/*  652 */           Calendar localCalendar = DATEStringToCalendar(str, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), arrayOfInt);
/*      */ 
/*  655 */           localTimestamp = new Timestamp(localCalendar.getTimeInMillis());
/*  656 */           localTimestamp.setNanos(arrayOfInt[0]);
/*      */         }
/*      */         catch (NumberFormatException localNumberFormatException)
/*      */         {
/*  660 */           SQLException localSQLException = DatabaseError.createSqlException(null, 132, null, localNumberFormatException);
/*  661 */           localSQLException.fillInStackTrace();
/*  662 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  668 */     return localTimestamp;
/*      */   }
/*      */ 
/*      */   Time getTime(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  676 */     Time localTime = null;
/*      */ 
/*  678 */     if (this.definedColumnType == 0) {
/*  679 */       localTime = super.getTime(paramInt);
/*      */     }
/*      */     else {
/*  682 */       String str = getString(paramInt);
/*  683 */       if (str != null)
/*      */       {
/*  685 */         int[] arrayOfInt = new int[1];
/*      */         try {
/*  687 */           Calendar localCalendar = DATEStringToCalendar(str, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), arrayOfInt);
/*      */ 
/*  690 */           localTime = new Time(localCalendar.getTimeInMillis());
/*      */         }
/*      */         catch (NumberFormatException localNumberFormatException)
/*      */         {
/*  694 */           SQLException localSQLException = DatabaseError.createSqlException(null, 132, null, localNumberFormatException);
/*  695 */           localSQLException.fillInStackTrace();
/*  696 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  702 */     return localTime;
/*      */   }
/*      */ 
/*      */   private final T4CMarshaller getMarshaller()
/*      */   {
/*  710 */     if (this.marshaller == null) {
/*  711 */       this.marshaller = (this.describeType == 8 ? T4CMarshaller.LONG : T4CMarshaller.VARCHAR);
/*      */     }
/*      */ 
/*  715 */     return this.marshaller;
/*      */   }
/*      */ 
/*      */   Object getObject(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  721 */     if (this.definedColumnType == 0) return super.getObject(paramInt);
/*  722 */     if (isUnexpected()) {
/*  723 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 21);
/*  724 */       localSQLException.fillInStackTrace();
/*  725 */       throw localSQLException;
/*      */     }
/*  727 */     if (isNull(paramInt)) return null;
/*      */ 
/*  729 */     switch (this.definedColumnType)
/*      */     {
/*      */     case -16:
/*      */     case -15:
/*      */     case -9:
/*      */     case -1:
/*      */     case 1:
/*      */     case 12:
/*  737 */       return getString(paramInt);
/*      */     case 2:
/*      */     case 3:
/*  741 */       return getBigDecimal(paramInt);
/*      */     case 4:
/*  744 */       return Integer.valueOf(getInt(paramInt));
/*      */     case -6:
/*  747 */       return Byte.valueOf(getByte(paramInt));
/*      */     case 5:
/*  750 */       return Short.valueOf(getShort(paramInt));
/*      */     case -7:
/*      */     case 16:
/*  755 */       return Boolean.valueOf(getBoolean(paramInt));
/*      */     case -5:
/*  758 */       return Long.valueOf(getLong(paramInt));
/*      */     case 7:
/*  761 */       return Float.valueOf(getFloat(paramInt));
/*      */     case 6:
/*      */     case 8:
/*  765 */       return Double.valueOf(getDouble(paramInt));
/*      */     case 91:
/*  768 */       return getDate(paramInt);
/*      */     case 92:
/*  771 */       return getTime(paramInt);
/*      */     case 93:
/*  774 */       return getTimestamp(paramInt);
/*      */     case -101:
/*  777 */       return getTIMESTAMPTZ(paramInt);
/*      */     case -102:
/*  780 */       return getTIMESTAMPLTZ(paramInt);
/*      */     case -4:
/*      */     case -3:
/*      */     case -2:
/*  785 */       return getBytesFromHexChars(paramInt);
/*      */     case -8:
/*  788 */       return getROWID(paramInt);
/*      */     }
/*      */ 
/*  792 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/*  793 */     localSQLException.fillInStackTrace();
/*  794 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   static final NUMBER StringToNUMBER(String paramString)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/*  808 */       return new NUMBER(new BigDecimal(paramString));
/*      */     }
/*      */     catch (NumberFormatException localNumberFormatException)
/*      */     {
/*  814 */       SQLException localSQLException = DatabaseError.createSqlException(null, 132, null, localNumberFormatException);
/*  815 */       localSQLException.fillInStackTrace();
/*  816 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   static final Calendar DATEStringToCalendar(String paramString1, String paramString2, int[] paramArrayOfInt)
/*      */     throws SQLException
/*      */   {
/*  847 */     char[] arrayOfChar = (paramString2 + " ").toCharArray();
/*  848 */     paramString1 = paramString1 + " ";
/*      */ 
/*  851 */     int i = Math.min(paramString1.length(), arrayOfChar.length);
/*      */ 
/*  853 */     int j = -1;
/*  854 */     int k = -1;
/*      */ 
/*  856 */     int m = 0;
/*  857 */     int n = 0;
/*      */ 
/*  859 */     String str1 = 0;
/*  860 */     int i1 = 0;
/*      */ 
/*  862 */     int i2 = 0;
/*  863 */     int i3 = 0;
/*  864 */     int i4 = 0;
/*      */ 
/*  866 */     int i5 = 0;
/*  867 */     int i6 = 0;
/*  868 */     int i7 = 0;
/*  869 */     int i8 = 0;
/*      */ 
/*  871 */     String str2 = null;
/*  872 */     String str3 = null;
/*      */ 
/*  874 */     int i9 = 0;
/*      */ 
/*  877 */     String[] arrayOfString1 = null;
/*  878 */     String[] arrayOfString2 = null;
/*      */ 
/*  896 */     for (int i10 = 0; i10 < i; i10++)
/*      */     {
/*  898 */       switch (arrayOfChar[i10])
/*      */       {
/*      */       case 'R':
/*      */       case 'r':
/*  902 */         if (j != 6)
/*      */         {
/*  904 */           j = 6;
/*  905 */           m = i10; } break;
/*      */       case 'Y':
/*      */       case 'y':
/*  911 */         if (j != 5)
/*      */         {
/*  913 */           j = 5;
/*  914 */           m = i10; } break;
/*      */       case 'D':
/*      */       case 'd':
/*  920 */         if (j != 1)
/*      */         {
/*  922 */           j = 1;
/*  923 */           m = i10; } break;
/*      */       case 'M':
/*      */       case 'm':
/*  929 */         if ((j != 2) || (j != 4) || (j != 3) || (j != 9))
/*      */         {
/*  935 */           m = i10;
/*      */ 
/*  937 */           if ((i10 + 4 < i) && ((arrayOfChar[(i10 + 1)] == 'O') || (arrayOfChar[(i10 + 1)] == 'o')) && ((arrayOfChar[(i10 + 2)] == 'N') || (arrayOfChar[(i10 + 2)] == 'n')) && ((arrayOfChar[(i10 + 3)] == 'T') || (arrayOfChar[(i10 + 3)] == 't')) && ((arrayOfChar[(i10 + 4)] == 'H') || (arrayOfChar[(i10 + 4)] == 'h')))
/*      */           {
/*  943 */             j = 3;
/*  944 */             i10 += 4;
/*  945 */           } else if ((i10 + 2 < i) && ((arrayOfChar[(i10 + 1)] == 'O') || (arrayOfChar[(i10 + 1)] == 'o')) && ((arrayOfChar[(i10 + 2)] == 'N') || (arrayOfChar[(i10 + 2)] == 'n')))
/*      */           {
/*  949 */             j = 4;
/*  950 */             i10 += 2;
/*  951 */           } else if ((i10 + 1 < i) && ((arrayOfChar[(i10 + 1)] == 'M') || (arrayOfChar[(i10 + 1)] == 'm')))
/*      */           {
/*  954 */             j = 2;
/*  955 */             i10++;
/*  956 */           } else if ((i10 + 1 < i) && ((arrayOfChar[(i10 + 1)] == 'I') || (arrayOfChar[(i10 + 1)] == 'i')))
/*      */           {
/*  959 */             j = 9;
/*  960 */             i10++; }  } break;
/*      */       case 'H':
/*      */       case 'h':
/*  969 */         if (j != 7)
/*      */         {
/*  971 */           j = 7;
/*  972 */           m = i10;
/*  973 */         } else if ((i10 + 2 < i) && ((arrayOfChar[(i10 + 1)] == '2') || (arrayOfChar[(i10 + 4)] == '4')))
/*      */         {
/*  976 */           j = 8;
/*  977 */           i10 += 2; } break;
/*      */       case 'S':
/*      */       case 's':
/*  983 */         if ((i10 + 1 < i) && ((arrayOfChar[(i10 + 1)] == 'S') || (arrayOfChar[(i10 + 1)] == 's')))
/*      */         {
/*  986 */           j = 10;
/*  987 */           m = i10;
/*  988 */           i10++; } break;
/*      */       case 'F':
/*      */       case 'f':
/*  995 */         if (j != 11)
/*      */         {
/*  997 */           j = 11;
/*  998 */           m = i10; } break;
/*      */       case 'A':
/*      */       case 'a':
/* 1004 */         if ((i10 + 1 < i) && ((arrayOfChar[(i10 + 1)] == 'M') || (arrayOfChar[(i10 + 1)] == 'm')))
/*      */         {
/* 1007 */           j = 12;
/* 1008 */           m = i10;
/* 1009 */           i10++; } break;
/*      */       case 'T':
/*      */       case 't':
/* 1015 */         if ((i10 + 2 < i) && ((arrayOfChar[(i10 + 1)] == 'Z') || (arrayOfChar[(i10 + 1)] == 'z')) && ((arrayOfChar[(i10 + 2)] == 'R') || (arrayOfChar[(i10 + 2)] == 'r')))
/*      */         {
/* 1019 */           j = 13;
/* 1020 */           m = i10;
/* 1021 */           i10 += 2; } break;
/*      */       case 'B':
/*      */       case 'C':
/*      */       case 'E':
/*      */       case 'G':
/*      */       case 'I':
/*      */       case 'J':
/*      */       case 'K':
/*      */       case 'L':
/*      */       case 'N':
/*      */       case 'O':
/*      */       case 'P':
/*      */       case 'Q':
/*      */       case 'U':
/*      */       case 'V':
/*      */       case 'W':
/*      */       case 'X':
/*      */       case 'Z':
/*      */       case '[':
/*      */       case '\\':
/*      */       case ']':
/*      */       case '^':
/*      */       case '_':
/*      */       case '`':
/*      */       case 'b':
/*      */       case 'c':
/*      */       case 'e':
/*      */       case 'g':
/*      */       case 'i':
/*      */       case 'j':
/*      */       case 'k':
/*      */       case 'l':
/*      */       case 'n':
/*      */       case 'o':
/*      */       case 'p':
/*      */       case 'q':
/*      */       case 'u':
/*      */       case 'v':
/*      */       case 'w':
/*      */       case 'x':
/*      */       default:
/* 1028 */         i9 = 1;
/*      */       }
/*      */ 
/* 1039 */       if ((i9 != 0) && (j != -1))
/*      */       {
/* 1041 */         int i11 = i10 - m;
/* 1042 */         int i12 = m - n;
/* 1043 */         str1 = i1 + i12;
/*      */ 
/* 1045 */         i1 = str1 + i11;
/*      */         Object localObject;
/*      */         String str4;
/*      */         int i15;
/* 1046 */         switch (j)
/*      */         {
/*      */         case 1:
/* 1049 */           i2 = Integer.parseInt(paramString1.substring(str1, i1));
/* 1050 */           break;
/*      */         case 2:
/* 1053 */           i3 = Integer.parseInt(paramString1.substring(str1, i1));
/* 1054 */           break;
/*      */         case 3:
/* 1059 */           int i16 = str1;
/* 1060 */           i1 = str1;
/* 1061 */           for (i16 = str1; (i16 < paramString1.length()) && 
/* 1062 */             (paramString1.charAt(i16) != arrayOfChar[i10]); i16++);
/* 1064 */           i1 = i16;
/*      */ 
/* 1066 */           localObject = null;
/* 1067 */           if (i1 != str1) {
/* 1068 */             localObject = paramString1.substring(str1, i1);
/*      */ 
/* 1072 */             localObject = ((String)localObject).trim();
/*      */ 
/* 1074 */             if (arrayOfString2 == null)
/* 1075 */               arrayOfString2 = new DateFormatSymbols().getMonths();
/* 1076 */             for (i3 = 0; (i3 < arrayOfString2.length) && 
/* 1077 */               (!((String)localObject).equalsIgnoreCase(arrayOfString2[i3])); i3++);
/* 1080 */             if (i3 >= 12)
/*      */             {
/* 1082 */               SQLException localSQLException = DatabaseError.createSqlException(null, 59);
/* 1083 */               localSQLException.fillInStackTrace();
/* 1084 */               throw localSQLException;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/* 1093 */           break;
/*      */         case 4:
/* 1096 */           int i13 = str1;
/* 1097 */           i1 = str1;
/* 1098 */           for (int i14 = str1; (i14 < paramString1.length()) && 
/* 1099 */             (paramString1.charAt(i14) != arrayOfChar[i10]); i14++);
/* 1101 */           i1 = i14;
/*      */ 
/* 1103 */           str4 = null;
/* 1104 */           if (i1 != str1) {
/* 1105 */             str4 = paramString1.substring(str1, i1);
/*      */ 
/* 1109 */             str4 = str4.trim();
/*      */ 
/* 1111 */             if (arrayOfString1 == null)
/* 1112 */               arrayOfString1 = new DateFormatSymbols().getShortMonths();
/* 1113 */             for (i3 = 0; (i3 < arrayOfString1.length) && 
/* 1114 */               (!str4.equalsIgnoreCase(arrayOfString1[i3])); i3++);
/* 1117 */             if (i3 >= 12)
/*      */             {
/* 1119 */               localObject = DatabaseError.createSqlException(null, 59);
/* 1120 */               ((SQLException)localObject).fillInStackTrace();
/* 1121 */               throw ((Throwable)localObject);
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/* 1130 */           break;
/*      */         case 5:
/* 1133 */           i4 = Integer.parseInt(paramString1.substring(str1, i1));
/*      */ 
/* 1137 */           if (i11 == 2)
/* 1138 */             i4 += 2000; break;
/*      */         case 6:
/* 1142 */           i4 = Integer.parseInt(paramString1.substring(str1, i1));
/*      */ 
/* 1146 */           if ((i11 == 2) && (i4 < 50))
/* 1147 */             i4 += 2000;
/*      */           else
/* 1149 */             i4 += 1900;
/* 1150 */           break;
/*      */         case 7:
/*      */         case 8:
/* 1156 */           i1 = str1 + 2;
/* 1157 */           i5 = Integer.parseInt(paramString1.substring(str1, i1));
/* 1158 */           break;
/*      */         case 9:
/* 1161 */           i6 = Integer.parseInt(paramString1.substring(str1, i1));
/* 1162 */           break;
/*      */         case 10:
/* 1165 */           i7 = Integer.parseInt(paramString1.substring(str1, i1));
/* 1166 */           break;
/*      */         case 11:
/* 1175 */           str4 = str1;
/* 1176 */           i1 = str1;
/* 1177 */           for (str4 = str1; (str4 < paramString1.length()) && 
/* 1178 */             ((i15 = paramString1.charAt(str4)) >= '0') && (i15 <= 57); str4++);
/* 1180 */           i1 += str4 - str1;
/*      */ 
/* 1182 */           if (i1 != str1)
/* 1183 */             i8 = Integer.parseInt(paramString1.substring(str1, i1)); break;
/*      */         case 12:
/* 1187 */           if (i1 > 0)
/* 1188 */             str2 = paramString1.substring(str1, i1); break;
/*      */         case 13:
/* 1198 */           int i17 = str1;
/* 1199 */           i1 = str1;
/* 1200 */           for (int i18 = str1; (i18 < paramString1.length()) && (
/* 1201 */             (((i15 = paramString1.charAt(i18)) >= '0') && (i15 <= 57)) || ((i15 >= 97) && (i15 <= 122)) || ((i15 >= 65) && (i15 <= 90))); i18++)
/*      */           {
/* 1206 */             i1 = i18;
/*      */           }
/* 1208 */           if (i1 != str1)
/* 1209 */             str3 = paramString1.substring(str1, i1); break;
/*      */         default:
/* 1214 */           System.out.println("\n\n\n             ***** ERROR(1) ****\n");
/*      */         }
/*      */ 
/* 1218 */         n = i10;
/* 1219 */         j = -1;
/* 1220 */         i9 = 0;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1227 */     GregorianCalendar localGregorianCalendar = new GregorianCalendar(i4, i3, i2, i5, i6, i7);
/* 1228 */     if (str2 != null) {
/* 1229 */       localGregorianCalendar.set(9, str2.equalsIgnoreCase("AM") ? 0 : 1);
/*      */     }
/*      */ 
/* 1234 */     if ((str3 == null) || 
/* 1240 */       (i8 != 0)) {
/* 1241 */       paramArrayOfInt[0] = i8;
/*      */     }
/* 1243 */     return localGregorianCalendar;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CVarcharAccessor
 * JD-Core Version:    0.6.2
 */