/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ class T4CTypeRep
/*     */ {
/*     */   static final byte REPUNV = 1;
/*     */   static final byte REPBUNV = 1;
/*     */   static final byte REPCUNV = 1;
/*     */   static final byte REPCASC = 10;
/*     */   static final byte REPCEBC = 11;
/*     */   static final byte REPIUNV = 1;
/*     */   static final byte REPIT11 = 10;
/*     */   static final byte REPIT12_OLD = 11;
/*     */   static final byte REPIT14_OLD = 12;
/*     */   static final byte REPIU11 = 13;
/*     */   static final byte REPIU12_OLD = 14;
/*     */   static final byte REPIU14_OLD = 15;
/*     */   static final byte REPIT21_OLD = 16;
/*     */   static final byte REPIT41_OLD = 17;
/*     */   static final byte REPIU21_OLD = 18;
/*     */   static final byte REPIU41_OLD = 19;
/*     */   static final byte REPIT32_OLD = 20;
/*     */   static final byte REPIU32_OLD = 21;
/*     */   static final byte REPIT12 = 22;
/*     */   static final byte REPIT14 = 23;
/*     */   static final byte REPIU12 = 24;
/*     */   static final byte REPIU14 = 25;
/*     */   static final byte REPIT21 = 26;
/*     */   static final byte REPIT41 = 27;
/*     */   static final byte REPIU21 = 28;
/*     */   static final byte REPIU41 = 29;
/*     */   static final byte REPIT32 = 30;
/*     */   static final byte REPIU32 = 31;
/*     */   static final byte REPIT18 = 32;
/*     */   static final byte REPIU18 = 33;
/*     */   static final byte REPIT81 = 34;
/*     */   static final byte REPIU81 = 35;
/*     */   static final byte REPAUNV = 1;
/*     */   static final byte REPA4Z = 10;
/*     */   static final byte REPA2Z = 11;
/*     */   static final byte REPA8Z = 12;
/*     */   static final byte REPA16Z = 13;
/*     */   static final byte REPNV51 = 10;
/*     */   static final byte REPDV51 = 10;
/*     */   static final byte REPRUNV = 1;
/*     */   static final byte NATIVE = 0;
/*     */   static final byte UNIVERSAL = 1;
/*     */   static final byte LSB = 2;
/*     */   static final byte MAXREP = 3;
/*     */   static final byte B1 = 0;
/*     */   static final byte B2 = 1;
/*     */   static final byte B4 = 2;
/*     */   static final byte B8 = 3;
/*     */   static final byte PTR = 4;
/*     */   static final byte MAXTYPE = 4;
/*     */   byte[] rep;
/*     */   T4CMAREngine mar;
/* 178 */   final byte NUMREPS = 5;
/*     */   byte conversionFlags;
/*     */   boolean serverConversion;
/* 341 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTypeRep(T4CMAREngine paramT4CMAREngine, boolean paramBoolean)
/*     */   {
/* 197 */     this.conversionFlags = 0;
/* 198 */     this.serverConversion = false;
/* 199 */     this.rep = new byte[5];
/* 200 */     this.mar = paramT4CMAREngine;
/*     */ 
/* 203 */     this.rep[0] = 0;
/* 204 */     this.rep[1] = 1;
/* 205 */     this.rep[2] = 1;
/* 206 */     this.rep[3] = 1;
/* 207 */     this.rep[4] = 1;
/*     */   }
/*     */ 
/*     */   void setRep(byte paramByte1, byte paramByte2)
/*     */     throws SQLException, IOException
/*     */   {
/* 225 */     if ((paramByte1 < 0) || (paramByte1 > 4) || (paramByte2 > 3))
/*     */     {
/* 228 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 407);
/* 229 */       localSQLException.fillInStackTrace();
/* 230 */       throw localSQLException;
/*     */     }
/*     */ 
/* 233 */     this.rep[paramByte1] = paramByte2;
/* 234 */     this.mar.setByteOrder(paramByte2);
/*     */   }
/*     */ 
/*     */   byte getRep(byte paramByte)
/*     */     throws SQLException
/*     */   {
/* 250 */     if ((paramByte < 0) || (paramByte > 4))
/*     */     {
/* 253 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 408);
/* 254 */       localSQLException.fillInStackTrace();
/* 255 */       throw localSQLException;
/*     */     }
/*     */ 
/* 258 */     return this.rep[paramByte];
/*     */   }
/*     */ 
/*     */   void setFlags(byte paramByte)
/*     */   {
/* 271 */     this.conversionFlags = paramByte;
/*     */   }
/*     */ 
/*     */   byte getFlags()
/*     */   {
/* 283 */     return this.conversionFlags;
/*     */   }
/*     */ 
/*     */   boolean isConvNeeded()
/*     */   {
/* 295 */     boolean bool = (this.conversionFlags & 0x2) > 0;
/*     */ 
/* 297 */     return bool;
/*     */   }
/*     */ 
/*     */   void setServerConversion(boolean paramBoolean)
/*     */   {
/* 310 */     this.serverConversion = paramBoolean;
/*     */   }
/*     */ 
/*     */   boolean isServerConversion()
/*     */   {
/* 321 */     return this.serverConversion;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 336 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTypeRep
 * JD-Core Version:    0.6.2
 */