/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import java.text.DateFormatSymbols;
/*     */ import java.util.Properties;
/*     */ import java.util.TimeZone;
/*     */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ 
/*     */ class T4CTimestampAccessor extends TimestampAccessor
/*     */ {
/*     */   T4CMAREngine mare;
/*  36 */   boolean underlyingLongRaw = false;
/*     */ 
/* 603 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTimestampAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  42 */     super(paramOracleStatement, paramInt1, paramShort, paramInt2, paramBoolean);
/*     */ 
/*  44 */     this.mare = paramT4CMAREngine;
/*     */   }
/*     */ 
/*     */   T4CTimestampAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, int paramInt7, int paramInt8, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  53 */     super(paramOracleStatement, paramInt1 == -1 ? paramInt8 : paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort);
/*     */ 
/*  56 */     this.mare = paramT4CMAREngine;
/*     */ 
/*  59 */     if ((paramOracleStatement != null) && (paramOracleStatement.implicitDefineForLobPrefetchDone))
/*     */     {
/*  61 */       this.definedColumnType = 0;
/*  62 */       this.definedColumnSize = 0;
/*     */     }
/*     */     else
/*     */     {
/*  66 */       this.definedColumnType = paramInt7;
/*  67 */       this.definedColumnSize = paramInt8;
/*     */     }
/*     */ 
/*  70 */     if (paramInt1 == -1)
/*  71 */       this.underlyingLongRaw = true;
/*     */   }
/*     */ 
/*     */   public T4CMAREngine getMAREngine() {
/*  75 */     return this.mare;
/*     */   }
/*     */ 
/*     */   public void unmarshalColumnMetadata()
/*     */     throws SQLException, IOException
/*     */   {
/*  84 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*     */     {
/*  87 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processIndicator(int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/*  94 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*     */     {
/* 101 */       this.mare.unmarshalUB2();
/* 102 */       this.mare.unmarshalUB2();
/*     */     }
/* 104 */     else if (this.statement.connection.versionNumber < 9200)
/*     */     {
/* 108 */       this.mare.unmarshalSB2();
/*     */ 
/* 110 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/* 111 */         this.mare.unmarshalSB2();
/*     */     }
/* 113 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/* 114 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getPreviousRowProcessed()
/*     */   {
/* 120 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 121 */     return this.previousRowProcessed;
/*     */   }
/*     */ 
/*     */   boolean unmarshalOneRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 136 */     boolean bool = false;
/* 137 */     if (!isUseless())
/*     */     {
/* 143 */       if (isUnexpected())
/*     */       {
/* 146 */         long l = this.rowData.getPosition();
/* 147 */         unmarshalColumnMetadata();
/* 148 */         unmarshalBytes();
/* 149 */         this.rowData.setPosition(l);
/* 150 */         setNull(this.lastRowProcessed, true);
/*     */       }
/* 152 */       else if (isNullByDescribe())
/*     */       {
/* 155 */         setNull(this.lastRowProcessed, true);
/* 156 */         unmarshalColumnMetadata();
/* 157 */         if (this.statement.connection.versionNumber < 9200) processIndicator(0);
/*     */       }
/*     */       else
/*     */       {
/* 161 */         unmarshalColumnMetadata();
/* 162 */         bool = unmarshalBytes();
/*     */       }
/*     */     }
/* 164 */     this.previousRowProcessed = this.lastRowProcessed;
/* 165 */     this.lastRowProcessed += 1;
/* 166 */     return bool;
/*     */   }
/*     */ 
/*     */   boolean unmarshalBytes()
/*     */     throws SQLException, IOException
/*     */   {
/* 178 */     setOffset(this.lastRowProcessed);
/*     */     int i;
/* 179 */     if (this.statement.maxFieldSize > 0)
/* 180 */       i = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare, this.statement.maxFieldSize);
/*     */     else
/* 182 */       i = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
/* 183 */     processIndicator(i);
/* 184 */     setLength(this.lastRowProcessed, i);
/* 185 */     setNull(this.lastRowProcessed, i == 0);
/* 186 */     return false;
/*     */   }
/*     */ 
/*     */   void copyRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 195 */     if (this.isNullByDescribe) {
/* 196 */       setNull(this.lastRowProcessed, true);
/*     */     }
/* 198 */     else if (this.lastRowProcessed == 0)
/*     */     {
/* 203 */       if (this.previousRowProcessed == -1)
/* 204 */         this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 205 */       long l = getOffset(this.previousRowProcessed);
/* 206 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 207 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 208 */       if (!isNull(this.previousRowProcessed)) {
/* 209 */         setOffset(this.lastRowProcessed);
/* 210 */         ((DynamicByteArray)this.rowData).copyLeft(l, getLength(this.previousRowProcessed));
/* 211 */         setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 216 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 217 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 218 */       setOffset(this.lastRowProcessed, getOffset(this.previousRowProcessed));
/* 219 */       setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */     }
/* 221 */     this.previousRowProcessed = this.lastRowProcessed;
/* 222 */     this.lastRowProcessed += 1;
/*     */   }
/*     */ 
/*     */   String toText(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, boolean paramBoolean, String paramString)
/*     */     throws SQLException
/*     */   {
/* 247 */     if ((this.definedColumnType == 0) || (this.definedColumnType == 93))
/*     */     {
/* 250 */       return super.toText(paramInt1, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramInt7, paramBoolean, paramString);
/*     */     }
/*     */ 
/* 258 */     String str = (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM");
/* 259 */     return nlsFormatToText(paramInt1, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramInt7, paramBoolean, paramString, str);
/*     */   }
/*     */ 
/*     */   private static final String nlsFormatToText(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, boolean paramBoolean, String paramString1, String paramString2)
/*     */     throws SQLException
/*     */   {
/* 286 */     char[] arrayOfChar = new StringBuilder().append(paramString2).append("      ").toString().toCharArray();
/* 287 */     int i = paramString2.length();
/*     */ 
/* 289 */     StringBuffer localStringBuffer = new StringBuffer(i + 25);
/* 290 */     String[] arrayOfString1 = null;
/* 291 */     String[] arrayOfString2 = null;
/* 292 */     TimeZone localTimeZone = null;
/*     */ 
/* 295 */     for (int j = 0; j < i; j++)
/*     */     {
/* 297 */       switch (arrayOfChar[j])
/*     */       {
/*     */       case 'R':
/*     */       case 'r':
/* 301 */         if ((arrayOfChar[(j + 1)] == 'R') || (arrayOfChar[(j + 1)] == 'r'))
/*     */         {
/* 303 */           if (((arrayOfChar[(j + 2)] == 'R') || (arrayOfChar[(j + 2)] == 'r')) && ((arrayOfChar[(j + 3)] == 'R') || (arrayOfChar[(j + 3)] == 'r')))
/*     */           {
/* 306 */             if (paramInt1 < 1000)
/* 307 */               localStringBuffer.append(new StringBuilder().append("0").append(paramInt1).toString());
/* 308 */             else if (paramInt1 < 100)
/* 309 */               localStringBuffer.append(new StringBuilder().append("00").append(paramInt1).toString());
/* 310 */             else if (paramInt1 < 10)
/* 311 */               localStringBuffer.append(new StringBuilder().append("000").append(paramInt1).toString());
/*     */             else {
/* 313 */               localStringBuffer.append(paramInt1);
/*     */             }
/* 315 */             j += 3;
/*     */           }
/*     */           else
/*     */           {
/* 319 */             if (paramInt1 >= 100) {
/* 320 */               paramInt1 %= 100;
/*     */             }
/* 322 */             if (paramInt1 < 10)
/* 323 */               localStringBuffer.append(new StringBuilder().append("0").append(paramInt1).toString());
/*     */             else {
/* 325 */               localStringBuffer.append(paramInt1);
/*     */             }
/* 327 */             j++; }  } break;
/*     */       case 'Y':
/*     */       case 'y':
/* 334 */         if ((arrayOfChar[(j + 1)] == 'Y') || (arrayOfChar[(j + 1)] == 'y'))
/*     */         {
/* 336 */           if (((arrayOfChar[(j + 2)] == 'Y') || (arrayOfChar[(j + 2)] == 'y')) && ((arrayOfChar[(j + 3)] == 'Y') || (arrayOfChar[(j + 3)] == 'y')))
/*     */           {
/* 339 */             if (paramInt1 < 1000)
/* 340 */               localStringBuffer.append(new StringBuilder().append("0").append(paramInt1).toString());
/* 341 */             else if (paramInt1 < 100)
/* 342 */               localStringBuffer.append(new StringBuilder().append("00").append(paramInt1).toString());
/* 343 */             else if (paramInt1 < 10)
/* 344 */               localStringBuffer.append(new StringBuilder().append("000").append(paramInt1).toString());
/*     */             else {
/* 346 */               localStringBuffer.append(paramInt1);
/*     */             }
/* 348 */             j += 3;
/*     */           }
/*     */           else
/*     */           {
/* 352 */             if (paramInt1 >= 100) {
/* 353 */               paramInt1 %= 100;
/*     */             }
/* 355 */             if (paramInt1 < 10)
/* 356 */               localStringBuffer.append(new StringBuilder().append("0").append(paramInt1).toString());
/*     */             else {
/* 358 */               localStringBuffer.append(paramInt1);
/*     */             }
/* 360 */             j++; }  } break;
/*     */       case 'D':
/*     */       case 'd':
/* 367 */         if ((arrayOfChar[(j + 1)] == 'D') || (arrayOfChar[(j + 1)] == 'd'))
/*     */         {
/* 369 */           localStringBuffer.append(new StringBuilder().append(paramInt3 < 10 ? "0" : "").append(paramInt3).toString());
/* 370 */           j++; } break;
/*     */       case 'M':
/*     */       case 'm':
/* 376 */         if ((arrayOfChar[(j + 1)] == 'M') || (arrayOfChar[(j + 1)] == 'm'))
/*     */         {
/* 378 */           localStringBuffer.append(new StringBuilder().append(paramInt2 < 10 ? "0" : "").append(paramInt2).toString());
/* 379 */           j++;
/*     */         }
/* 381 */         else if ((arrayOfChar[(j + 1)] == 'I') || (arrayOfChar[(j + 1)] == 'i'))
/*     */         {
/* 383 */           localStringBuffer.append(new StringBuilder().append(paramInt5 < 10 ? "0" : "").append(paramInt5).toString());
/* 384 */           j++;
/*     */         }
/* 386 */         else if (((arrayOfChar[(j + 1)] == 'O') || (arrayOfChar[(j + 1)] == 'o')) && ((arrayOfChar[(j + 2)] == 'N') || (arrayOfChar[(j + 2)] == 'n')))
/*     */         {
/* 389 */           if (((arrayOfChar[(j + 3)] == 'T') || (arrayOfChar[(j + 3)] == 't')) && ((arrayOfChar[(j + 4)] == 'H') || (arrayOfChar[(j + 4)] == 'h')))
/*     */           {
/* 393 */             if (arrayOfString2 == null) {
/* 394 */               arrayOfString2 = new DateFormatSymbols().getMonths();
/*     */             }
/*     */ 
/* 401 */             if (arrayOfChar[j] == 'm')
/*     */             {
/* 404 */               localStringBuffer.append(arrayOfString2[(paramInt2 - 1)].toLowerCase());
/*     */             }
/* 406 */             else if (arrayOfChar[(j + 1)] == 'O')
/*     */             {
/* 409 */               localStringBuffer.append(arrayOfString2[(paramInt2 - 1)].toUpperCase());
/*     */             }
/*     */             else
/*     */             {
/* 414 */               localStringBuffer.append(arrayOfString2[(paramInt2 - 1)]);
/*     */             }
/* 416 */             j += 4;
/*     */           }
/*     */           else
/*     */           {
/* 421 */             if (arrayOfString1 == null) {
/* 422 */               arrayOfString1 = new DateFormatSymbols().getShortMonths();
/*     */             }
/*     */ 
/* 429 */             if (arrayOfChar[j] == 'm')
/*     */             {
/* 432 */               localStringBuffer.append(arrayOfString1[(paramInt2 - 1)].toLowerCase());
/*     */             }
/* 434 */             else if (arrayOfChar[(j + 1)] == 'O')
/*     */             {
/* 437 */               localStringBuffer.append(arrayOfString1[(paramInt2 - 1)].toUpperCase());
/*     */             }
/*     */             else
/*     */             {
/* 442 */               localStringBuffer.append(arrayOfString1[(paramInt2 - 1)]);
/*     */             }
/* 444 */             j += 2; }  } break;
/*     */       case 'H':
/*     */       case 'h':
/* 451 */         if ((arrayOfChar[(j + 1)] == 'H') || (arrayOfChar[(j + 1)] == 'h'))
/*     */         {
/* 453 */           if ((arrayOfChar[(j + 2)] == '2') || (arrayOfChar[(j + 3)] == '4'))
/*     */           {
/* 455 */             localStringBuffer.append(new StringBuilder().append(paramInt4 < 10 ? "0" : "").append(paramInt4).toString());
/* 456 */             j += 3;
/*     */           }
/*     */           else {
/* 459 */             if (paramInt4 > 12)
/* 460 */               paramInt4 -= 12;
/* 461 */             localStringBuffer.append(new StringBuilder().append(paramInt4 < 10 ? "0" : "").append(paramInt4).toString());
/* 462 */             j++; }  } break;
/*     */       case 'S':
/*     */       case 's':
/* 469 */         if ((arrayOfChar[(j + 1)] == 'S') || (arrayOfChar[(j + 1)] == 's'))
/*     */         {
/* 471 */           localStringBuffer.append(new StringBuilder().append(paramInt6 < 10 ? "0" : "").append(paramInt6).toString());
/* 472 */           j++;
/* 473 */           if (((arrayOfChar[(j + 1)] == 'X') || (arrayOfChar[(j + 1)] == 'x')) && ((arrayOfChar[(j + 2)] == 'F') || (arrayOfChar[(j + 2)] == 'f')) && ((arrayOfChar[(j + 3)] == 'F') || (arrayOfChar[(j + 3)] == 'f')))
/*     */           {
/* 477 */             localStringBuffer.append(".");
/* 478 */             j++; }  } break;
/*     */       case 'F':
/*     */       case 'f':
/* 486 */         if ((arrayOfChar[(j + 1)] == 'F') || (arrayOfChar[(j + 1)] == 'f'))
/*     */         {
/* 488 */           if (paramInt7 >= 0)
/*     */           {
/* 490 */             localStringBuffer.append(paramInt7);
/*     */           }
/*     */           else
/*     */           {
/* 494 */             localStringBuffer.append(0);
/*     */           }
/* 496 */           j++; } break;
/*     */       case 'T':
/*     */       case 't':
/* 502 */         if ((arrayOfChar[(j + 1)] == 'Z') || (arrayOfChar[(j + 1)] == 'z'))
/*     */         {
/* 504 */           if ((arrayOfChar[(j + 2)] == 'R') || (arrayOfChar[(j + 2)] == 'r'))
/*     */           {
/* 506 */             if ((paramString1.length() > 3) && (paramString1.startsWith("GMT")))
/*     */             {
/* 508 */               localStringBuffer.append(paramString1.substring(3));
/*     */             }
/*     */             else
/*     */             {
/* 513 */               localStringBuffer.append(paramString1.toUpperCase());
/*     */             }
/* 515 */             j += 2;
/*     */           }
/*     */           else
/*     */           {
/*     */             long l;
/* 516 */             if ((arrayOfChar[(j + 2)] == 'H') || (arrayOfChar[(j + 2)] == 'h'))
/*     */             {
/* 518 */               if (localTimeZone == null)
/* 519 */                 localTimeZone = TimeZone.getTimeZone(paramString1);
/* 520 */               l = localTimeZone.getRawOffset() / 3600000;
/* 521 */               localStringBuffer.append(l);
/* 522 */               j += 2;
/* 523 */             } else if ((arrayOfChar[(j + 2)] == 'M') || (arrayOfChar[(j + 2)] == 'm'))
/*     */             {
/* 525 */               if (localTimeZone == null)
/* 526 */                 localTimeZone = TimeZone.getTimeZone(paramString1);
/* 527 */               l = Math.abs(localTimeZone.getRawOffset()) % 3600000 / 60000;
/* 528 */               localStringBuffer.append(new StringBuilder().append(l < 10L ? "0" : "").append(l).toString());
/* 529 */               j += 2; }  } 
/* 530 */         }break;
/*     */       case 'A':
/*     */       case 'P':
/*     */       case 'a':
/*     */       case 'p':
/* 538 */         if ((arrayOfChar[(j + 1)] == 'M') || (arrayOfChar[(j + 1)] == 'm'))
/*     */         {
/* 540 */           localStringBuffer.append(paramBoolean ? "AM" : "PM");
/* 541 */           j++; } break;
/*     */       case 'B':
/*     */       case 'C':
/*     */       case 'E':
/*     */       case 'G':
/*     */       case 'I':
/*     */       case 'J':
/*     */       case 'K':
/*     */       case 'L':
/*     */       case 'N':
/*     */       case 'O':
/*     */       case 'Q':
/*     */       case 'U':
/*     */       case 'V':
/*     */       case 'W':
/*     */       case 'X':
/*     */       case 'Z':
/*     */       case '[':
/*     */       case '\\':
/*     */       case ']':
/*     */       case '^':
/*     */       case '_':
/*     */       case '`':
/*     */       case 'b':
/*     */       case 'c':
/*     */       case 'e':
/*     */       case 'g':
/*     */       case 'i':
/*     */       case 'j':
/*     */       case 'k':
/*     */       case 'l':
/*     */       case 'n':
/*     */       case 'o':
/*     */       case 'q':
/*     */       case 'u':
/*     */       case 'v':
/*     */       case 'w':
/*     */       case 'x':
/*     */       default:
/* 546 */         localStringBuffer.append(arrayOfChar[j]);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 552 */     return localStringBuffer.substring(0, localStringBuffer.length());
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 562 */     if (this.definedColumnType == 0) return super.getObject(paramInt);
/* 563 */     if (isUnexpected()) {
/* 564 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 21);
/* 565 */       localSQLException.fillInStackTrace();
/* 566 */       throw localSQLException;
/*     */     }
/* 568 */     if (isNull(paramInt)) return null;
/*     */ 
/* 570 */     switch (this.definedColumnType)
/*     */     {
/*     */     case -1:
/*     */     case 1:
/*     */     case 12:
/* 575 */       return getString(paramInt);
/*     */     case 93:
/* 578 */       return getTimestamp(paramInt);
/*     */     case 91:
/* 581 */       return getDate(paramInt);
/*     */     case 92:
/* 584 */       return getTime(paramInt);
/*     */     case -4:
/*     */     case -3:
/*     */     case -2:
/* 589 */       return getBytes(paramInt);
/*     */     }
/*     */ 
/* 593 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 594 */     localSQLException.fillInStackTrace();
/* 595 */     throw localSQLException;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTimestampAccessor
 * JD-Core Version:    0.6.2
 */