/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.internal.OracleConnection.XSOperationCode;
/*     */ import oracle.jdbc.internal.XSNamespace;
/*     */ 
/*     */ class T4CTTIxsnsop extends T4CTTIfun
/*     */ {
/*     */   private OracleConnection.XSOperationCode operationCode;
/*     */   private byte[] sessionId;
/*     */   private XSNamespace[] namespaces;
/*     */   private XSNamespace[] outNamespaces;
/* 181 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIxsnsop(T4CConnection paramT4CConnection)
/*     */   {
/*  64 */     super(paramT4CConnection, (byte)3);
/*     */ 
/*  66 */     setFunCode((short)172);
/*     */   }
/*     */ 
/*     */   void doOXSNS(OracleConnection.XSOperationCode paramXSOperationCode, byte[] paramArrayOfByte, XSNamespace[] paramArrayOfXSNamespace, boolean paramBoolean)
/*     */     throws IOException, SQLException
/*     */   {
/*  84 */     if (paramBoolean)
/*  85 */       setTTCCode((byte)3);
/*     */     else
/*  87 */       setTTCCode((byte)17);
/*  88 */     this.operationCode = paramXSOperationCode;
/*  89 */     this.sessionId = paramArrayOfByte;
/*  90 */     this.namespaces = paramArrayOfXSNamespace;
/*     */ 
/*  92 */     if (this.namespaces != null) {
/*  93 */       for (int i = 0; i < this.namespaces.length; i++)
/*  94 */         ((XSNamespaceI)this.namespaces[i]).doCharConversion(this.meg.conv);
/*     */     }
/*  96 */     if (paramBoolean)
/*  97 */       doRPC();
/*     */     else
/*  99 */       doPigRPC();
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 107 */     this.meg.marshalUB4(this.operationCode.getCode());
/* 108 */     int i = 0;
/* 109 */     if ((this.sessionId != null) && (this.sessionId.length > 0))
/*     */     {
/* 111 */       i = 1;
/* 112 */       this.meg.marshalPTR();
/* 113 */       this.meg.marshalUB4(this.sessionId.length);
/*     */     }
/*     */     else
/*     */     {
/* 117 */       this.meg.marshalNULLPTR();
/* 118 */       this.meg.marshalUB4(0L);
/*     */     }
/*     */ 
/* 121 */     int j = 0;
/* 122 */     this.meg.marshalPTR();
/* 123 */     if ((this.namespaces != null) && (this.namespaces.length > 0))
/*     */     {
/* 125 */       j = 1;
/* 126 */       this.meg.marshalUB4(this.namespaces.length);
/*     */     }
/*     */     else
/*     */     {
/* 130 */       this.meg.marshalUB4(0L);
/*     */     }
/* 132 */     this.meg.marshalPTR();
/*     */ 
/* 134 */     if (i != 0)
/* 135 */       this.meg.marshalB1Array(this.sessionId);
/* 136 */     if (j != 0)
/* 137 */       for (int k = 0; k < this.namespaces.length; k++)
/* 138 */         ((XSNamespaceI)this.namespaces[k]).marshal(this.meg);
/*     */   }
/*     */ 
/*     */   void readRPA()
/*     */     throws SQLException, IOException
/*     */   {
/* 147 */     this.outNamespaces = null;
/* 148 */     int i = (int)this.meg.unmarshalUB4();
/* 149 */     if (i > 0)
/*     */     {
/* 151 */       this.outNamespaces = new XSNamespace[i];
/* 152 */       for (int j = 0; j < i; j++)
/* 153 */         this.outNamespaces[j] = XSNamespaceI.unmarshal(this.meg);
/*     */     }
/*     */   }
/*     */ 
/*     */   XSNamespace[] getNamespaces()
/*     */     throws SQLException
/*     */   {
/* 161 */     return this.outNamespaces;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 176 */     return this.connection;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIxsnsop
 * JD-Core Version:    0.6.2
 */