/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.PrintWriter;
/*      */ import java.io.StringWriter;
/*      */ import java.sql.SQLException;
/*      */ import java.util.BitSet;
/*      */ import java.util.Vector;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*      */ import oracle.jdbc.oracore.OracleTypeADT;
/*      */ 
/*      */ class T4CTTIrxd extends T4CTTIMsg
/*      */ {
/*   46 */   static final byte[] NO_BYTES = new byte[0];
/*      */   byte[] buffer;
/*      */   byte[] bufferCHAR;
/*   56 */   BitSet bvcColSent = null;
/*   57 */   int nbOfColumns = 0;
/*   58 */   boolean bvcFound = false;
/*      */   static final byte TTICMD_UNAUTHORIZED = 1;
/* 1029 */   static int call_count = 0;
/*      */ 
/* 1070 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   T4CTTIrxd(T4CConnection paramT4CConnection)
/*      */   {
/*   72 */     super(paramT4CConnection, (byte)7);
/*      */   }
/*      */ 
/*      */   void init()
/*      */   {
/*      */   }
/*      */ 
/*      */   void setNumberOfColumns(int paramInt)
/*      */   {
/*   86 */     this.nbOfColumns = paramInt;
/*   87 */     this.bvcFound = false;
/*      */ 
/*   89 */     if ((this.bvcColSent == null) || (this.bvcColSent.length() < this.nbOfColumns))
/*      */     {
/*   91 */       this.bvcColSent = new BitSet(this.nbOfColumns);
/*      */     }
/*      */     else
/*      */     {
/*   95 */       this.bvcColSent.clear();
/*      */     }
/*      */   }
/*      */ 
/*      */   void unmarshalBVC(int paramInt)
/*      */     throws SQLException, IOException
/*      */   {
/*  103 */     int i = 0;
/*      */ 
/*  106 */     for (int j = 0; j < this.bvcColSent.length(); j++) {
/*  107 */       this.bvcColSent.clear(j);
/*      */     }
/*      */ 
/*  110 */     j = this.nbOfColumns / 8 + (this.nbOfColumns % 8 != 0 ? 1 : 0);
/*      */ 
/*  112 */     for (int k = 0; k < j; k++)
/*      */     {
/*  114 */       int m = (byte)(this.meg.unmarshalUB1() & 0xFF);
/*      */ 
/*  119 */       for (int n = 0; n < 8; n++)
/*      */       {
/*  121 */         if ((m & 1 << n) != 0)
/*      */         {
/*  123 */           this.bvcColSent.set(k * 8 + n);
/*      */ 
/*  125 */           i++;
/*      */         }
/*      */         else
/*      */         {
/*  129 */           this.bvcColSent.clear(k * 8 + n);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  134 */     if (i != paramInt)
/*      */     {
/*  137 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), -1, "INTERNAL ERROR: oracle.jdbc.driver.T4CTTIrxd.unmarshalBVC: bits missing in vector");
/*      */ 
/*  139 */       localSQLException.fillInStackTrace();
/*  140 */       throw localSQLException;
/*      */     }
/*      */ 
/*  144 */     this.bvcFound = true;
/*      */   }
/*      */ 
/*      */   void readBitVector(byte[] paramArrayOfByte)
/*      */     throws SQLException, IOException
/*      */   {
/*  158 */     for (int i = 0; i < this.bvcColSent.length(); i++) {
/*  159 */       this.bvcColSent.clear(i);
/*      */     }
/*  161 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/*  162 */       this.bvcFound = false;
/*      */     }
/*      */     else {
/*  165 */       for (i = 0; i < paramArrayOfByte.length; i++) {
/*  166 */         int j = paramArrayOfByte[i];
/*  167 */         for (int k = 0; k < 8; k++) {
/*  168 */           if ((j & 1 << k) != 0)
/*  169 */             this.bvcColSent.set(i * 8 + k);
/*      */         }
/*      */       }
/*  172 */       this.bvcFound = true;
/*      */     }
/*      */   }
/*      */ 
/*      */   Vector<IOException> marshal(byte[] paramArrayOfByte1, char[] paramArrayOfChar1, short[] paramArrayOfShort1, int paramInt1, byte[] paramArrayOfByte2, DBConversion paramDBConversion, InputStream[] paramArrayOfInputStream, byte[][] paramArrayOfByte, OracleTypeADT[] paramArrayOfOracleTypeADT, byte[] paramArrayOfByte3, char[] paramArrayOfChar2, short[] paramArrayOfShort2, byte[] paramArrayOfByte4, int paramInt2, int[] paramArrayOfInt1, boolean paramBoolean1, int[] paramArrayOfInt2, int[] paramArrayOfInt3, int[][] paramArrayOfInt, boolean paramBoolean2)
/*      */     throws IOException
/*      */   {
/*  200 */     Vector localVector = null;
/*      */     try
/*      */     {
/*  205 */       marshalTTCcode();
/*      */ 
/*  208 */       int i = paramArrayOfShort1[(paramInt1 + 0)] & 0xFFFF;
/*      */ 
/*  230 */       int i10 = 0;
/*  231 */       int i11 = paramArrayOfInt3[0];
/*  232 */       Object localObject1 = paramArrayOfInt[0];
/*      */ 
/*  234 */       int i12 = 0;
/*      */       int i13;
/*      */       int i14;
/*      */       int i15;
/*      */       int j;
/*      */       int i7;
/*      */       int k;
/*      */       int i9;
/*      */       int m;
/*      */       int i8;
/*      */       int i4;
/*      */       int i6;
/*      */       int i5;
/*      */       int i1;
/*      */       int i3;
/*      */       int i18;
/*      */       int i20;
/*  238 */       if (paramBoolean2)
/*      */       {
/*  240 */         i13 = 1;
/*  241 */         if ((!$assertionsDisabled) && (i11 <= 0)) throw new AssertionError("No postoned columns in RXD");
/*      */       }
/*      */       else
/*      */       {
/*  245 */         for (i14 = 0; i14 < i; i14++)
/*      */         {
/*  247 */           if ((i10 < i11) && (localObject1[i10] == i14))
/*      */           {
/*  250 */             i10++;
/*      */           }
/*      */           else
/*      */           {
/*  254 */             i15 = 0;
/*      */ 
/*  259 */             j = paramInt1 + 5 + 10 * i14;
/*      */ 
/*  264 */             i7 = paramArrayOfShort1[(j + 0)] & 0xFFFF;
/*      */ 
/*  269 */             if ((paramArrayOfByte4 != null) && ((paramArrayOfByte4[i14] & 0x20) == 0))
/*      */             {
/*  273 */               if (i7 == 998) {
/*  274 */                 i12++;
/*      */               }
/*      */             }
/*      */             else
/*      */             {
/*  279 */               k = ((paramArrayOfShort1[(j + 7)] & 0xFFFF) << 16) + (paramArrayOfShort1[(j + 8)] & 0xFFFF) + paramInt2;
/*      */ 
/*  283 */               i9 = ((paramArrayOfShort1[(j + 5)] & 0xFFFF) << 16) + (paramArrayOfShort1[(j + 6)] & 0xFFFF) + paramInt2;
/*      */ 
/*  288 */               m = paramArrayOfShort1[k] & 0xFFFF;
/*      */ 
/*  290 */               i8 = paramArrayOfShort1[i9];
/*      */ 
/*  292 */               if (i7 == 116)
/*      */               {
/*  294 */                 this.meg.marshalUB1((short)1);
/*  295 */                 this.meg.marshalUB1((short)0);
/*      */               }
/*      */               else
/*      */               {
/*  299 */                 if (i7 == 994)
/*      */                 {
/*  301 */                   i8 = -1;
/*  302 */                   int i16 = paramArrayOfInt2[(3 + i14 * 4 + 0)];
/*      */ 
/*  306 */                   if (i16 == 109)
/*  307 */                     i15 = 1;
/*      */                 }
/*  309 */                 else if ((i7 == 8) || (i7 == 24) || ((!paramBoolean1) && (paramArrayOfInt1 != null) && (paramArrayOfInt1.length > i14) && (paramArrayOfInt1[i14] > this.connection.maxNonStreamBindByteSize)))
/*      */                 {
/*  327 */                   if (i11 >= localObject1.length)
/*      */                   {
/*  329 */                     int[] arrayOfInt = new int[localObject1.length << 1];
/*      */ 
/*  332 */                     System.arraycopy(localObject1, 0, arrayOfInt, 0, localObject1.length);
/*      */ 
/*  336 */                     localObject1 = arrayOfInt;
/*      */                   }
/*      */ 
/*  339 */                   localObject1[(i11++)] = i14;
/*      */ 
/*  343 */                   continue;
/*      */                 }
/*      */ 
/*  347 */                 if (i8 == -1)
/*      */                 {
/*  349 */                   if ((i7 == 109) || (i15 != 0))
/*      */                   {
/*  352 */                     this.meg.marshalDALC(NO_BYTES);
/*  353 */                     this.meg.marshalDALC(NO_BYTES);
/*  354 */                     this.meg.marshalDALC(NO_BYTES);
/*  355 */                     this.meg.marshalUB2(0);
/*  356 */                     this.meg.marshalUB4(0L);
/*  357 */                     this.meg.marshalUB2(1);
/*      */ 
/*  359 */                     continue;
/*      */                   }
/*  361 */                   if (i7 == 998)
/*      */                   {
/*  363 */                     i12++;
/*  364 */                     this.meg.marshalUB4(0L);
/*  365 */                     continue;
/*      */                   }
/*  367 */                   if ((i7 == 112) || (i7 == 113) || (i7 == 114))
/*      */                   {
/*  369 */                     this.meg.marshalUB4(0L);
/*  370 */                     continue;
/*      */                   }
/*  372 */                   if ((i7 != 8) && (i7 != 24))
/*      */                   {
/*  381 */                     this.meg.marshalUB1((short)0);
/*      */ 
/*  383 */                     continue;
/*      */                   }
/*      */                 }
/*      */                 int i19;
/*      */                 int i23;
/*      */                 int i24;
/*  387 */                 if (i7 == 998)
/*      */                 {
/*  390 */                   int i17 = (paramArrayOfShort2[(6 + i12 * 8 + 4)] & 0xFFFF) << 16 & 0xFFFF000 | paramArrayOfShort2[(6 + i12 * 8 + 5)] & 0xFFFF;
/*      */ 
/*  393 */                   i19 = (paramArrayOfShort2[(6 + i12 * 8 + 6)] & 0xFFFF) << 16 & 0xFFFF000 | paramArrayOfShort2[(6 + i12 * 8 + 7)] & 0xFFFF;
/*      */ 
/*  396 */                   int i21 = paramArrayOfShort2[(6 + i12 * 8)] & 0xFFFF;
/*  397 */                   int i22 = paramArrayOfShort2[(6 + i12 * 8 + 1)] & 0xFFFF;
/*      */ 
/*  399 */                   this.meg.marshalUB4(i17);
/*      */ 
/*  401 */                   for (i23 = 0; i23 < i17; i23++)
/*      */                   {
/*  403 */                     i24 = i19 + i23 * i22;
/*      */ 
/*  405 */                     if (i21 == 9)
/*      */                     {
/*  407 */                       i4 = paramArrayOfChar2[i24] / '\002';
/*  408 */                       i6 = 0;
/*  409 */                       i6 = paramDBConversion.javaCharsToCHARBytes(paramArrayOfChar2, i24 + 1, paramArrayOfByte2, 0, i4);
/*      */ 
/*  415 */                       this.meg.marshalCLR(paramArrayOfByte2, i6);
/*      */                     }
/*      */                     else
/*      */                     {
/*  419 */                       m = paramArrayOfByte3[i24];
/*      */ 
/*  421 */                       if (m < 1)
/*  422 */                         this.meg.marshalUB1((short)0);
/*      */                       else {
/*  424 */                         this.meg.marshalCLR(paramArrayOfByte3, i24 + 1, m);
/*      */                       }
/*      */                     }
/*      */                   }
/*  428 */                   i12++;
/*      */                 }
/*      */                 else
/*      */                 {
/*  437 */                   int n = paramArrayOfShort1[(j + 1)] & 0xFFFF;
/*      */ 
/*  441 */                   if (n != 0)
/*      */                   {
/*  447 */                     int i2 = ((paramArrayOfShort1[(j + 3)] & 0xFFFF) << 16) + (paramArrayOfShort1[(j + 4)] & 0xFFFF) + n * paramInt2;
/*      */ 
/*  454 */                     if (i7 == 6)
/*      */                     {
/*  456 */                       i2++;
/*  457 */                       m--;
/*      */                     }
/*  459 */                     else if (i7 == 9)
/*      */                     {
/*  461 */                       i2 += 2;
/*      */ 
/*  463 */                       m -= 2;
/*      */                     }
/*  465 */                     else if ((i7 == 114) || (i7 == 113) || (i7 == 112))
/*      */                     {
/*  468 */                       this.meg.marshalUB4(m);
/*      */                     }
/*      */                     Object localObject2;
/*  472 */                     if ((i7 == 109) || (i7 == 111))
/*      */                     {
/*  474 */                       if (paramArrayOfByte == null)
/*      */                       {
/*  477 */                         localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), -1, "INTERNAL ERROR: oracle.jdbc.driver.T4CTTIrxd.marshal: parameterDatum is null");
/*      */ 
/*  479 */                         ((SQLException)localObject2).fillInStackTrace();
/*  480 */                         throw ((Throwable)localObject2);
/*      */                       }
/*      */ 
/*  484 */                       localObject2 = paramArrayOfByte[i14];
/*      */ 
/*  486 */                       m = localObject2 == null ? 0 : localObject2.length;
/*      */ 
/*  488 */                       if (i7 == 109)
/*      */                       {
/*  490 */                         this.meg.marshalDALC(NO_BYTES);
/*  491 */                         this.meg.marshalDALC(NO_BYTES);
/*  492 */                         this.meg.marshalDALC(NO_BYTES);
/*  493 */                         this.meg.marshalUB2(0);
/*      */ 
/*  495 */                         this.meg.marshalUB4(m);
/*  496 */                         this.meg.marshalUB2(1);
/*      */                       }
/*      */ 
/*  499 */                       if (m > 0)
/*  500 */                         this.meg.marshalCLR((byte[])localObject2, 0, m);
/*      */                     }
/*  502 */                     else if (i7 == 104)
/*      */                     {
/*  506 */                       i2 += 2;
/*      */ 
/*  508 */                       localObject2 = T4CRowidAccessor.stringToRowid(paramArrayOfByte1, i2, 18);
/*      */ 
/*  510 */                       i19 = 14;
/*  511 */                       long l1 = localObject2[0];
/*  512 */                       i23 = (int)localObject2[1];
/*  513 */                       i24 = 0;
/*  514 */                       long l2 = localObject2[2];
/*  515 */                       int i25 = (int)localObject2[3];
/*      */ 
/*  518 */                       if ((l1 == 0L) && (i23 == 0) && (l2 == 0L) && (i25 == 0))
/*      */                       {
/*  524 */                         this.meg.marshalUB1((short)0);
/*      */                       }
/*      */                       else
/*      */                       {
/*  528 */                         this.meg.marshalUB1(i19);
/*  529 */                         this.meg.marshalUB4(l1);
/*  530 */                         this.meg.marshalUB2(i23);
/*  531 */                         this.meg.marshalUB1(i24);
/*  532 */                         this.meg.marshalUB4(l2);
/*  533 */                         this.meg.marshalUB2(i25);
/*      */                       }
/*      */                     }
/*  536 */                     else if (i7 == 208)
/*      */                     {
/*  540 */                       i2 += 2;
/*  541 */                       m -= 2;
/*  542 */                       this.meg.marshalUB4(m);
/*  543 */                       this.meg.marshalCLR(paramArrayOfByte1, i2, m);
/*      */                     }
/*  547 */                     else if (m < 1) {
/*  548 */                       this.meg.marshalUB1((short)0);
/*      */                     } else {
/*  550 */                       this.meg.marshalCLR(paramArrayOfByte1, i2, m);
/*      */                     }
/*      */ 
/*      */                   }
/*      */                   else
/*      */                   {
/*  560 */                     i5 = paramArrayOfShort1[(j + 9)] & 0xFFFF;
/*      */ 
/*  567 */                     i1 = paramArrayOfShort1[(j + 2)] & 0xFFFF;
/*      */ 
/*  570 */                     i3 = ((paramArrayOfShort1[(j + 3)] & 0xFFFF) << 16) + (paramArrayOfShort1[(j + 4)] & 0xFFFF) + i1 * paramInt2 + 1;
/*      */ 
/*  575 */                     if (i7 == 996)
/*      */                     {
/*  584 */                       i18 = paramArrayOfChar1[(i3 - 1)];
/*      */ 
/*  586 */                       if ((this.bufferCHAR == null) || (this.bufferCHAR.length < i18)) {
/*  587 */                         this.bufferCHAR = new byte[i18];
/*      */                       }
/*  589 */                       for (i20 = 0; i20 < i18; i20++)
/*      */                       {
/*  591 */                         this.bufferCHAR[i20] = ((byte)((paramArrayOfChar1[(i3 + i20 / 2)] & 0xFF00) >> '\b' & 0xFF));
/*      */ 
/*  595 */                         if (i20 < i18 - 1)
/*      */                         {
/*  597 */                           this.bufferCHAR[(i20 + 1)] = ((byte)(paramArrayOfChar1[(i3 + i20 / 2)] & 0xFF & 0xFF));
/*      */ 
/*  600 */                           i20++;
/*      */                         }
/*      */                       }
/*      */ 
/*  604 */                       this.meg.marshalCLR(this.bufferCHAR, i18);
/*      */ 
/*  606 */                       if (this.bufferCHAR.length > 4000) {
/*  607 */                         this.bufferCHAR = null;
/*      */                       }
/*      */ 
/*      */                     }
/*      */                     else
/*      */                     {
/*  618 */                       if (i7 == 96)
/*      */                       {
/*  622 */                         i4 = m / 2;
/*  623 */                         i3--;
/*      */                       }
/*      */                       else
/*      */                       {
/*  627 */                         i4 = (m - 2) / 2;
/*      */                       }
/*      */ 
/*  631 */                       i6 = 0;
/*      */ 
/*  636 */                       if (i5 == 2)
/*      */                       {
/*  638 */                         i6 = paramDBConversion.javaCharsToNCHARBytes(paramArrayOfChar1, i3, paramArrayOfByte2, 0, i4);
/*      */                       }
/*      */                       else
/*      */                       {
/*  643 */                         i6 = paramDBConversion.javaCharsToCHARBytes(paramArrayOfChar1, i3, paramArrayOfByte2, 0, i4);
/*      */                       }
/*      */ 
/*  649 */                       this.meg.marshalCLR(paramArrayOfByte2, i6);
/*      */                     }
/*      */                   }
/*      */                 }
/*      */               }
/*      */             }
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  659 */         i13 = i11;
/*      */       }
/*      */ 
/*  662 */       if (i11 > 0)
/*      */       {
/*  664 */         for (i14 = 0; i14 < i13; i14++)
/*      */         {
/*  666 */           i15 = localObject1[i14];
/*      */ 
/*  668 */           j = paramInt1 + 5 + 10 * i15;
/*      */ 
/*  672 */           i7 = paramArrayOfShort1[(j + 0)] & 0xFFFF;
/*      */ 
/*  676 */           k = ((paramArrayOfShort1[(j + 7)] & 0xFFFF) << 16) + (paramArrayOfShort1[(j + 8)] & 0xFFFF) + paramInt2;
/*      */ 
/*  680 */           i9 = ((paramArrayOfShort1[(j + 5)] & 0xFFFF) << 16) + (paramArrayOfShort1[(j + 6)] & 0xFFFF) + paramInt2;
/*      */ 
/*  684 */           i8 = paramArrayOfShort1[i9];
/*  685 */           m = paramArrayOfShort1[k] & 0xFFFF;
/*      */ 
/*  687 */           i1 = paramArrayOfShort1[(j + 2)] & 0xFFFF;
/*      */ 
/*  690 */           i3 = ((paramArrayOfShort1[(j + 3)] & 0xFFFF) << 16) + (paramArrayOfShort1[(j + 4)] & 0xFFFF) + i1 * paramInt2 + 1;
/*      */ 
/*  695 */           if (i8 == -1)
/*      */           {
/*  697 */             this.meg.marshalUB1((short)0);
/*      */           }
/*  701 */           else if (i7 == 996)
/*      */           {
/*  710 */             i18 = paramArrayOfChar1[(i3 - 1)];
/*      */ 
/*  712 */             if ((this.bufferCHAR == null) || (this.bufferCHAR.length < i18)) {
/*  713 */               this.bufferCHAR = new byte[i18];
/*      */             }
/*  715 */             for (i20 = 0; i20 < i18; i20++)
/*      */             {
/*  717 */               this.bufferCHAR[i20] = ((byte)((paramArrayOfChar1[(i3 + i20 / 2)] & 0xFF00) >> '\b' & 0xFF));
/*      */ 
/*  721 */               if (i20 < i18 - 1)
/*      */               {
/*  723 */                 this.bufferCHAR[(i20 + 1)] = ((byte)(paramArrayOfChar1[(i3 + i20 / 2)] & 0xFF & 0xFF));
/*      */ 
/*  725 */                 i20++;
/*      */               }
/*      */             }
/*      */ 
/*  729 */             this.meg.marshalCLR(this.bufferCHAR, i18);
/*      */ 
/*  731 */             if (this.bufferCHAR.length > 4000)
/*  732 */               this.bufferCHAR = null;
/*      */           }
/*  734 */           else if ((i7 != 8) && (i7 != 24))
/*      */           {
/*  741 */             if (i7 == 96)
/*      */             {
/*  745 */               i4 = m / 2;
/*  746 */               i3--;
/*      */             }
/*      */             else
/*      */             {
/*  750 */               i4 = (m - 2) / 2;
/*      */             }
/*      */ 
/*  753 */             i5 = paramArrayOfShort1[(j + 9)] & 0xFFFF;
/*      */ 
/*  758 */             i6 = 0;
/*      */ 
/*  763 */             if (i5 == 2)
/*      */             {
/*  765 */               i6 = paramDBConversion.javaCharsToNCHARBytes(paramArrayOfChar1, i3, paramArrayOfByte2, 0, i4);
/*      */             }
/*      */             else
/*      */             {
/*  770 */               i6 = paramDBConversion.javaCharsToCHARBytes(paramArrayOfChar1, i3, paramArrayOfByte2, 0, i4);
/*      */             }
/*      */ 
/*  776 */             this.meg.marshalCLR(paramArrayOfByte2, i6);
/*      */           }
/*      */           else
/*      */           {
/*  781 */             i18 = i15;
/*      */ 
/*  784 */             if (paramArrayOfInputStream != null)
/*      */             {
/*  786 */               InputStream localInputStream = paramArrayOfInputStream[i18];
/*      */ 
/*  788 */               if (localInputStream != null)
/*      */               {
/*      */                 try
/*      */                 {
/*  796 */                   this.meg.marshalCLR(localInputStream, 0);
/*      */                 } catch (IOException localIOException2) {
/*  798 */                   if (localVector == null) {
/*  799 */                     localVector = new Vector();
/*      */                   }
/*  801 */                   localVector.add(localIOException2);
/*      */                 }
/*      */ 
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  821 */       paramArrayOfInt3[0] = i11;
/*  822 */       paramArrayOfInt[0] = localObject1;
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*  826 */       IOException localIOException1 = new IOException();
/*  827 */       localIOException1.initCause(localSQLException);
/*  828 */       throw localIOException1;
/*      */     }
/*      */ 
/*  831 */     return localVector;
/*      */   }
/*      */ 
/*      */   boolean unmarshal(Accessor[] paramArrayOfAccessor, int paramInt)
/*      */     throws SQLException, IOException
/*      */   {
/*  842 */     return unmarshal(paramArrayOfAccessor, 0, paramInt);
/*      */   }
/*      */ 
/*      */   void copyRowsAsNeeded(Accessor[] paramArrayOfAccessor, int paramInt)
/*      */     throws SQLException, IOException
/*      */   {
/*  878 */     int[] arrayOfInt = new int[this.nbOfColumns];
/*  879 */     int i = 0;
/*  880 */     int j = Math.min(paramInt, paramArrayOfAccessor.length);
/*  881 */     for (int k = 0; k < j; k++) {
/*  882 */       Accessor localAccessor1 = paramArrayOfAccessor[k];
/*  883 */       if ((!localAccessor1.isUseLess) && (!this.bvcColSent.get(localAccessor1.physicalColumnIndex))) {
/*  884 */         arrayOfInt[(i++)] = k;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  891 */     long l1 = -1L;
/*  892 */     while (i > 0)
/*      */     {
/*  897 */       int m = 0;
/*  898 */       Accessor localAccessor2 = paramArrayOfAccessor[arrayOfInt[m]];
/*  899 */       long l2 = localAccessor2.getOffset(localAccessor2.getPreviousRowProcessed());
/*      */ 
/*  902 */       for (int n = 1; n < i; n++) {
/*  903 */         int i1 = arrayOfInt[n];
/*  904 */         localAccessor2 = paramArrayOfAccessor[arrayOfInt[n]];
/*  905 */         long l3 = localAccessor2.getOffset(localAccessor2.getPreviousRowProcessed());
/*  906 */         if (l3 < l2) {
/*  907 */           l2 = l3;
/*  908 */           m = n;
/*  909 */           if (l3 == -1L) {
/*      */             break;
/*      */           }
/*      */         }
/*      */       }
/*  914 */       n = arrayOfInt[m];
/*  915 */       localAccessor2 = paramArrayOfAccessor[n];
/*      */ 
/*  917 */       assert ((localAccessor2.isNull(localAccessor2.getPreviousRowProcessed())) || (l1 < l2)) : ("lastOffset: " + l1 + "\tleastOffset: " + l2 + "\tindexOfLeastOffet: " + m);
/*      */ 
/*  920 */       l1 = l2;
/*      */       try {
/*  922 */         localAccessor2.copyRow();
/*      */       }
/*      */       catch (AssertionError localAssertionError1) {
/*  925 */         String str = dumpIndicesOfColumnsToBeCopied(i, arrayOfInt, paramArrayOfAccessor);
/*      */ 
/*  928 */         AssertionError localAssertionError2 = new AssertionError(str + "\nlastOffset: " + l1 + "\tleastOffset: " + l2 + "\tindexOfLeastOffet: " + m);
/*      */ 
/*  932 */         localAssertionError2.initCause(localAssertionError1);
/*  933 */         throw localAssertionError2;
/*      */       }
/*      */ 
/*  938 */       arrayOfInt[m] = arrayOfInt[(--i)];
/*      */     }
/*      */   }
/*      */ 
/*      */   boolean unmarshal(Accessor[] paramArrayOfAccessor, int paramInt1, int paramInt2)
/*      */     throws SQLException, IOException
/*      */   {
/*  953 */     for (int i = paramInt1; (i < paramInt2) && (i < paramArrayOfAccessor.length); i++)
/*      */     {
/*  955 */       if (paramArrayOfAccessor[i] != null)
/*      */       {
/*  972 */         if (paramArrayOfAccessor[i].physicalColumnIndex < 0)
/*      */         {
/*  976 */           int j = 0;
/*      */ 
/*  978 */           for (int k = 0; (k < paramInt2) && (k < paramArrayOfAccessor.length); k++)
/*      */           {
/*  980 */             if (paramArrayOfAccessor[k] != null)
/*      */             {
/*  982 */               paramArrayOfAccessor[k].physicalColumnIndex = j;
/*      */ 
/*  984 */               if (!paramArrayOfAccessor[k].isUseLess)
/*  985 */                 j++;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*  991 */     if ((this.bvcFound) && (paramInt1 == 0))
/*      */     {
/*  994 */       copyRowsAsNeeded(paramArrayOfAccessor, paramInt2);
/*      */     }
/*  996 */     for (i = paramInt1; (i < paramInt2) && (i < paramArrayOfAccessor.length); i++)
/*      */     {
/*  998 */       if (paramArrayOfAccessor[i] != null)
/*      */       {
/* 1008 */         if ((!this.bvcFound) || (paramArrayOfAccessor[i].isUseLess) || (this.bvcColSent.get(paramArrayOfAccessor[i].physicalColumnIndex)))
/*      */         {
/* 1012 */           if ((paramArrayOfAccessor[i].statement.statementType == 2) || (paramArrayOfAccessor[i].statement.sqlKind.isPlsqlOrCall()))
/*      */           {
/* 1016 */             paramArrayOfAccessor[i].setCapacity(1);
/*      */           }
/*      */ 
/* 1019 */           if (paramArrayOfAccessor[i].unmarshalOneRow())
/* 1020 */             return true;
/*      */         }
/*      */       }
/*      */     }
/* 1024 */     this.bvcFound = false;
/* 1025 */     return false;
/*      */   }
/*      */ 
/*      */   String dumpIndicesOfColumnsToBeCopied(int paramInt, int[] paramArrayOfInt, Accessor[] paramArrayOfAccessor)
/*      */     throws SQLException
/*      */   {
/* 1034 */     StringWriter localStringWriter = new StringWriter();
/* 1035 */     PrintWriter localPrintWriter = new PrintWriter(localStringWriter);
/* 1036 */     localPrintWriter.println("dump indicesOfColumnsToBeCopied call_count: " + call_count++ + " numColumnsToBeCopied: " + paramInt);
/* 1037 */     for (int i = 0; i < paramInt; i++)
/*      */     {
/* 1039 */       long l = paramArrayOfAccessor[paramArrayOfInt[i]].getOffset(0);
/* 1040 */       localPrintWriter.println("copy order: " + i + " index: " + paramArrayOfInt[i] + " offset: " + l);
/*      */     }
/* 1042 */     localPrintWriter.println();
/* 1043 */     return localStringWriter.toString();
/*      */   }
/*      */ 
/*      */   boolean unmarshal(Accessor[] paramArrayOfAccessor, int paramInt1, int paramInt2, int paramInt3)
/*      */     throws SQLException, IOException
/*      */   {
/* 1050 */     return false;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1065 */     return null;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIrxd
 * JD-Core Version:    0.6.2
 */