/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.KeywordValueLong;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ final class T4CTTIoxssro extends T4CTTIfun
/*     */ {
/*     */   private int functionId;
/*  67 */   private byte[] sessionId = null;
/*  68 */   private KeywordValueLong[] inKV = null;
/*     */   private int inFlags;
/*  71 */   private KeywordValueLong[] outKV = null;
/*  72 */   private int outFlags = -1;
/*     */ 
/* 175 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIoxssro(T4CConnection paramT4CConnection)
/*     */   {
/*  61 */     super(paramT4CConnection, (byte)3);
/*     */ 
/*  63 */     setFunCode((short)156);
/*     */   }
/*     */ 
/*     */   void doOXSSRO(int paramInt1, byte[] paramArrayOfByte, KeywordValueLong[] paramArrayOfKeywordValueLong, int paramInt2)
/*     */     throws IOException, SQLException
/*     */   {
/*  81 */     this.functionId = paramInt1;
/*  82 */     this.sessionId = paramArrayOfByte;
/*  83 */     this.inKV = paramArrayOfKeywordValueLong;
/*  84 */     this.inFlags = paramInt2;
/*  85 */     this.outKV = null;
/*  86 */     this.outFlags = -1;
/*     */ 
/*  88 */     if (this.inKV != null)
/*  89 */       for (int i = 0; i < this.inKV.length; i++)
/*  90 */         ((KeywordValueLongI)this.inKV[i]).doCharConversion(this.meg.conv);
/*  91 */     doRPC();
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/*  97 */     this.meg.marshalUB4(this.functionId);
/*  98 */     int i = 0;
/*  99 */     if ((this.sessionId != null) && (this.sessionId.length > 0))
/*     */     {
/* 101 */       i = 1;
/* 102 */       this.meg.marshalPTR();
/* 103 */       this.meg.marshalUB4(this.sessionId.length);
/*     */     }
/*     */     else
/*     */     {
/* 107 */       this.meg.marshalNULLPTR();
/* 108 */       this.meg.marshalUB4(0L);
/*     */     }
/* 110 */     int j = 0;
/* 111 */     if ((this.inKV != null) && (this.inKV.length > 0))
/*     */     {
/* 113 */       j = 1;
/* 114 */       this.meg.marshalPTR();
/* 115 */       this.meg.marshalUB4(this.inKV.length);
/*     */     }
/*     */     else
/*     */     {
/* 119 */       this.meg.marshalNULLPTR();
/* 120 */       this.meg.marshalUB4(0L);
/*     */     }
/* 122 */     this.meg.marshalUB4(this.inFlags);
/* 123 */     this.meg.marshalPTR();
/* 124 */     this.meg.marshalPTR();
/* 125 */     this.meg.marshalPTR();
/*     */ 
/* 127 */     if (i != 0)
/* 128 */       this.meg.marshalB1Array(this.sessionId);
/* 129 */     if (j != 0)
/* 130 */       for (int k = 0; k < this.inKV.length; k++)
/* 131 */         ((KeywordValueLongI)this.inKV[k]).marshal(this.meg);
/*     */   }
/*     */ 
/*     */   KeywordValueLong[] getOutKV()
/*     */   {
/* 139 */     return this.outKV;
/*     */   }
/*     */ 
/*     */   int getOutFlags()
/*     */   {
/* 145 */     return this.outFlags;
/*     */   }
/*     */ 
/*     */   void readRPA()
/*     */     throws SQLException, IOException
/*     */   {
/* 151 */     int i = (int)this.meg.unmarshalUB4();
/* 152 */     this.outKV = new KeywordValueLong[i];
/* 153 */     for (int j = 0; j < i; j++)
/* 154 */       this.outKV[j] = KeywordValueLongI.unmarshal(this.meg);
/* 155 */     this.outFlags = ((int)this.meg.unmarshalUB4());
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 170 */     return this.connection;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIoxssro
 * JD-Core Version:    0.6.2
 */