/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleConnection.XSSessionSetOperationCode;
/*     */ import oracle.jdbc.internal.XSSecureId;
/*     */ 
/*     */ final class T4CTTIoxsset extends T4CTTIfun
/*     */ {
/*     */   OracleConnection.XSSessionSetOperationCode opCode;
/*     */   byte[] sessionId;
/*     */   XSSecureId sidp;
/*     */   XSSessionParametersI sessParam;
/* 163 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIoxsset(T4CConnection paramT4CConnection)
/*     */   {
/*  77 */     super(paramT4CConnection, (byte)3);
/*  78 */     setFunCode((short)183);
/*     */   }
/*     */ 
/*     */   void doOXSSET(OracleConnection.XSSessionSetOperationCode paramXSSessionSetOperationCode, byte[] paramArrayOfByte, XSSecureId paramXSSecureId, XSSessionParametersI paramXSSessionParametersI)
/*     */     throws IOException, SQLException
/*     */   {
/*  91 */     this.opCode = paramXSSessionSetOperationCode;
/*  92 */     this.sessionId = paramArrayOfByte;
/*  93 */     this.sidp = paramXSSecureId;
/*  94 */     this.sessParam = paramXSSessionParametersI;
/*  95 */     if (paramXSSessionParametersI != null) {
/*  96 */       paramXSSessionParametersI.doCharConversion(this.meg.conv);
/*     */     }
/*  98 */     doRPC();
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 105 */     this.meg.marshalUB4(this.opCode.getCode());
/* 106 */     int i = 0;
/* 107 */     if ((this.sessionId != null) && (this.sessionId.length > 0)) {
/* 108 */       i = 1;
/* 109 */       this.meg.marshalPTR();
/* 110 */       this.meg.marshalUB4(this.sessionId.length);
/*     */     } else {
/* 112 */       this.meg.marshalNULLPTR();
/* 113 */       this.meg.marshalUB4(0L);
/*     */     }
/* 115 */     if (this.sidp != null)
/* 116 */       this.meg.marshalPTR();
/*     */     else {
/* 118 */       this.meg.marshalNULLPTR();
/*     */     }
/* 120 */     if ((this.sessParam != null) && (this.sessParam.binaryParam != null) && (this.sessParam.binaryParam.length > 0)) {
/* 121 */       this.meg.marshalPTR();
/* 122 */       this.meg.marshalUB4(this.sessParam.binaryParam.length);
/*     */     } else {
/* 124 */       this.meg.marshalNULLPTR();
/* 125 */       this.meg.marshalUB4(0L);
/*     */     }
/* 127 */     if (this.sessParam != null)
/* 128 */       this.meg.marshalUB4(this.sessParam.intParam);
/*     */     else
/* 130 */       this.meg.marshalUB4(0L);
/* 131 */     if ((this.sessParam != null) && (this.sessParam.textParamBytes != null) && (this.sessParam.textParamBytes.length > 0))
/*     */     {
/* 133 */       this.meg.marshalPTR();
/* 134 */       this.meg.marshalUB4(this.sessParam.textParamBytes.length);
/*     */     } else {
/* 136 */       this.meg.marshalNULLPTR();
/* 137 */       this.meg.marshalUB4(0L);
/*     */     }
/*     */ 
/* 140 */     if (i != 0) {
/* 141 */       this.meg.marshalB1Array(this.sessionId);
/*     */     }
/* 143 */     if (this.sidp != null) {
/* 144 */       ((XSSecureIdI)this.sidp).marshal(this.meg);
/*     */     }
/* 146 */     if ((this.sessParam != null) && (this.sessParam.binaryParam != null) && (this.sessParam.binaryParam.length > 0)) {
/* 147 */       this.meg.marshalB1Array(this.sessParam.binaryParam);
/*     */     }
/* 149 */     if ((this.sessParam != null) && (this.sessParam.textParamBytes != null) && (this.sessParam.textParamBytes.length > 0))
/* 150 */       for (int j = 0; j < this.sessParam.textParamBytes.length; j++)
/* 151 */         if (this.sessParam.textParamBytes[j] == null) {
/* 152 */           this.meg.marshalUB4(0L);
/*     */         } else {
/* 154 */           this.meg.marshalUB4(this.sessParam.textParamBytes[j].length);
/*     */ 
/* 156 */           this.meg.marshalCLR(this.sessParam.textParamBytes[j], this.sessParam.textParamBytes[j].length);
/*     */         }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIoxsset
 * JD-Core Version:    0.6.2
 */