/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.KeywordValueLong;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ final class T4CTTIoxsscs extends T4CTTIfun
/*     */ {
/*  56 */   private String userName = null;
/*  57 */   private KeywordValueLong[] inKV = null;
/*     */   private int inFlags;
/*  59 */   private byte[] userNameArr = null;
/*     */ 
/*  61 */   private byte[] sessionId = null;
/*  62 */   private KeywordValueLong[] outKV = null;
/*  63 */   private int outFlags = -1;
/*     */ 
/* 187 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIoxsscs(T4CConnection paramT4CConnection)
/*     */   {
/*  67 */     super(paramT4CConnection, (byte)3);
/*     */ 
/*  69 */     setFunCode((short)155);
/*     */   }
/*     */ 
/*     */   void doOXSSCS(String paramString, KeywordValueLong[] paramArrayOfKeywordValueLong, int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/*  80 */     this.userName = paramString;
/*  81 */     this.inKV = paramArrayOfKeywordValueLong;
/*  82 */     this.inFlags = paramInt;
/*  83 */     if ((this.userName != null) && (this.userName.length() > 0))
/*  84 */       this.userNameArr = this.meg.conv.StringToCharBytes(this.userName);
/*     */     else {
/*  86 */       this.userNameArr = null;
/*     */     }
/*     */ 
/*  89 */     this.sessionId = null;
/*  90 */     this.outKV = null;
/*  91 */     this.outFlags = -1;
/*     */ 
/*  93 */     if (this.inKV != null)
/*  94 */       for (int i = 0; i < this.inKV.length; i++)
/*  95 */         ((KeywordValueLongI)this.inKV[i]).doCharConversion(this.meg.conv);
/*  96 */     doRPC();
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 102 */     this.meg.marshalPTR();
/* 103 */     this.meg.marshalPTR();
/* 104 */     if (this.userNameArr != null)
/*     */     {
/* 106 */       this.meg.marshalPTR();
/* 107 */       this.meg.marshalSB4(this.userNameArr.length);
/*     */     }
/*     */     else
/*     */     {
/* 111 */       this.meg.marshalNULLPTR();
/* 112 */       this.meg.marshalSB4(0);
/*     */     }
/* 114 */     int i = 0;
/* 115 */     if ((this.inKV != null) && (this.inKV.length > 0))
/*     */     {
/* 117 */       i = 1;
/* 118 */       this.meg.marshalPTR();
/* 119 */       this.meg.marshalSB4(this.inKV.length);
/*     */     }
/*     */     else
/*     */     {
/* 123 */       this.meg.marshalNULLPTR();
/* 124 */       this.meg.marshalSB4(0);
/*     */     }
/* 126 */     this.meg.marshalUB4(this.inFlags);
/* 127 */     this.meg.marshalPTR();
/* 128 */     this.meg.marshalPTR();
/* 129 */     this.meg.marshalPTR();
/*     */ 
/* 131 */     if (this.userNameArr != null)
/* 132 */       this.meg.marshalCHR(this.userNameArr);
/* 133 */     if (i != 0)
/* 134 */       for (int j = 0; j < this.inKV.length; j++)
/* 135 */         ((KeywordValueLongI)this.inKV[j]).marshal(this.meg);
/*     */   }
/*     */ 
/*     */   byte[] getSessionId()
/*     */   {
/* 143 */     return this.sessionId;
/*     */   }
/*     */ 
/*     */   KeywordValueLong[] getOutKV()
/*     */   {
/* 149 */     return this.outKV;
/*     */   }
/*     */ 
/*     */   int getOutFlags()
/*     */   {
/* 155 */     return this.outFlags;
/*     */   }
/*     */ 
/*     */   void readRPA()
/*     */     throws SQLException, IOException
/*     */   {
/* 161 */     int i = (int)this.meg.unmarshalUB4();
/* 162 */     this.sessionId = this.meg.unmarshalNBytes(i);
/* 163 */     int j = (int)this.meg.unmarshalUB4();
/* 164 */     this.outKV = new KeywordValueLong[j];
/* 165 */     for (int k = 0; k < j; k++)
/* 166 */       this.outKV[k] = KeywordValueLongI.unmarshal(this.meg);
/* 167 */     this.outFlags = ((int)this.meg.unmarshalUB4());
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 182 */     return this.connection;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIoxsscs
 * JD-Core Version:    0.6.2
 */