/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleConnection.XSOperationCode;
/*     */ import oracle.jdbc.internal.XSNamespace;
/*     */ import oracle.jdbc.internal.XSSecureId;
/*     */ 
/*     */ class T4CTTIoxsns extends T4CTTIfun
/*     */ {
/*     */   private OracleConnection.XSOperationCode operationCode;
/*     */   private byte[] sessionId;
/*     */   private XSNamespace[] namespaces;
/*     */   private XSSecureId secureId;
/*     */   private XSNamespace[] outNamespaces;
/* 185 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIoxsns(T4CConnection paramT4CConnection)
/*     */   {
/*  83 */     super(paramT4CConnection, (byte)3);
/*  84 */     setFunCode((short)178);
/*     */   }
/*     */ 
/*     */   void doOXSNS(OracleConnection.XSOperationCode paramXSOperationCode, byte[] paramArrayOfByte, XSNamespace[] paramArrayOfXSNamespace, XSSecureId paramXSSecureId, boolean paramBoolean)
/*     */     throws IOException, SQLException
/*     */   {
/* 103 */     if (paramBoolean)
/* 104 */       setTTCCode((byte)3);
/*     */     else
/* 106 */       setTTCCode((byte)17);
/* 107 */     this.operationCode = paramXSOperationCode;
/* 108 */     this.sessionId = paramArrayOfByte;
/* 109 */     this.namespaces = paramArrayOfXSNamespace;
/* 110 */     this.secureId = paramXSSecureId;
/*     */ 
/* 112 */     if (this.namespaces != null) {
/* 113 */       for (int i = 0; i < this.namespaces.length; i++)
/* 114 */         ((XSNamespaceI)this.namespaces[i]).doCharConversion(this.meg.conv);
/*     */     }
/* 116 */     if (paramBoolean)
/* 117 */       doRPC();
/*     */     else
/* 119 */       doPigRPC();
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 127 */     this.meg.marshalUB4(this.operationCode.getCode());
/* 128 */     int i = 0;
/* 129 */     if ((this.sessionId != null) && (this.sessionId.length > 0)) {
/* 130 */       i = 1;
/* 131 */       this.meg.marshalPTR();
/* 132 */       this.meg.marshalUB4(this.sessionId.length);
/*     */     } else {
/* 134 */       this.meg.marshalNULLPTR();
/* 135 */       this.meg.marshalUB4(0L);
/*     */     }
/*     */ 
/* 138 */     int j = 0;
/* 139 */     this.meg.marshalPTR();
/* 140 */     if ((this.namespaces != null) && (this.namespaces.length > 0)) {
/* 141 */       j = 1;
/* 142 */       this.meg.marshalUB4(this.namespaces.length);
/*     */     } else {
/* 144 */       this.meg.marshalUB4(0L);
/*     */     }
/* 146 */     this.meg.marshalPTR();
/*     */ 
/* 148 */     if (this.secureId == null)
/* 149 */       this.meg.marshalNULLPTR();
/*     */     else {
/* 151 */       this.meg.marshalPTR();
/*     */     }
/* 153 */     if (i != 0)
/* 154 */       this.meg.marshalB1Array(this.sessionId);
/* 155 */     if (j != 0)
/* 156 */       for (int k = 0; k < this.namespaces.length; k++)
/* 157 */         ((XSNamespaceI)this.namespaces[k]).marshal(this.meg);
/* 158 */     if (this.secureId != null)
/* 159 */       ((XSSecureIdI)this.secureId).marshal(this.meg);
/*     */   }
/*     */ 
/*     */   void readRPA()
/*     */     throws SQLException, IOException
/*     */   {
/* 167 */     this.outNamespaces = null;
/* 168 */     int i = (int)this.meg.unmarshalUB4();
/* 169 */     if (i > 0) {
/* 170 */       this.outNamespaces = new XSNamespace[i];
/* 171 */       for (int j = 0; j < i; j++)
/* 172 */         this.outNamespaces[j] = XSNamespaceI.unmarshal(this.meg);
/*     */     }
/*     */   }
/*     */ 
/*     */   XSNamespace[] getNamespaces()
/*     */     throws SQLException
/*     */   {
/* 180 */     return this.outNamespaces;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIoxsns
 * JD-Core Version:    0.6.2
 */