/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.KeywordValueLong;
/*     */ import oracle.jdbc.internal.OracleConnection.XSSessionModeFlag;
/*     */ import oracle.jdbc.internal.OracleConnection.XSSessionOperationCode;
/*     */ import oracle.jdbc.internal.XSKeyval;
/*     */ import oracle.jdbc.internal.XSNamespace;
/*     */ import oracle.jdbc.internal.XSPrincipal;
/*     */ import oracle.jdbc.internal.XSSecureId;
/*     */ 
/*     */ final class T4CTTIoxscre extends T4CTTIfun
/*     */ {
/*     */   private OracleConnection.XSSessionOperationCode opcode;
/*     */   private XSSecureId sidp;
/*     */   private byte[] cookie;
/*     */   private XSPrincipal username;
/*     */   private byte[] tenantBytes;
/*     */   private XSNamespace[] namespaces;
/*     */   private OracleConnection.XSSessionModeFlag mode;
/*     */   private XSKeyval kv;
/*  81 */   private byte[] sessionId = null;
/*     */ 
/* 227 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIoxscre(T4CConnection paramT4CConnection)
/*     */   {
/*  85 */     super(paramT4CConnection, (byte)3);
/*  86 */     setFunCode((short)179);
/*     */   }
/*     */ 
/*     */   void doOXSCRE(OracleConnection.XSSessionOperationCode paramXSSessionOperationCode, XSSecureId paramXSSecureId, byte[] paramArrayOfByte, XSPrincipal paramXSPrincipal, String paramString, XSNamespace[] paramArrayOfXSNamespace, OracleConnection.XSSessionModeFlag paramXSSessionModeFlag, XSKeyval paramXSKeyval)
/*     */     throws IOException, SQLException
/*     */   {
/* 101 */     this.opcode = paramXSSessionOperationCode;
/* 102 */     this.sidp = paramXSSecureId;
/* 103 */     this.cookie = paramArrayOfByte;
/* 104 */     this.username = paramXSPrincipal;
/* 105 */     if (paramXSPrincipal != null)
/* 106 */       ((XSPrincipalI)paramXSPrincipal).doCharConversion(this.meg.conv);
/* 107 */     if ((paramString != null) && (paramString.length() > 0))
/* 108 */       this.tenantBytes = this.meg.conv.StringToCharBytes(paramString);
/*     */     else
/* 110 */       this.tenantBytes = null;
/* 111 */     this.namespaces = paramArrayOfXSNamespace;
/* 112 */     if (paramArrayOfXSNamespace != null)
/* 113 */       for (int i = 0; i < paramArrayOfXSNamespace.length; i++)
/* 114 */         ((XSNamespaceI)paramArrayOfXSNamespace[i]).doCharConversion(this.meg.conv);
/* 115 */     this.mode = paramXSSessionModeFlag;
/* 116 */     this.kv = paramXSKeyval;
/*     */ 
/* 118 */     if (paramXSKeyval != null) {
/* 119 */       KeywordValueLong[] arrayOfKeywordValueLong = paramXSKeyval.getKeyval();
/* 120 */       if (arrayOfKeywordValueLong != null) {
/* 121 */         for (int j = 0; j < arrayOfKeywordValueLong.length; j++) {
/* 122 */           ((KeywordValueLongI)arrayOfKeywordValueLong[j]).doCharConversion(this.meg.conv);
/*     */         }
/*     */       }
/*     */     }
/* 126 */     doRPC();
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 133 */     this.meg.marshalUB4(this.opcode.getCode());
/* 134 */     this.meg.marshalPTR();
/* 135 */     this.meg.marshalPTR();
/* 136 */     int i = 0;
/* 137 */     if (this.sidp != null) {
/* 138 */       i = 1;
/* 139 */       this.meg.marshalPTR();
/*     */     } else {
/* 141 */       this.meg.marshalNULLPTR();
/*     */     }
/*     */ 
/* 144 */     int j = 0;
/* 145 */     if ((this.cookie != null) && (this.cookie.length > 0)) {
/* 146 */       j = 1;
/* 147 */       this.meg.marshalPTR();
/* 148 */       this.meg.marshalUB4(this.cookie.length);
/*     */     } else {
/* 150 */       this.meg.marshalNULLPTR();
/* 151 */       this.meg.marshalUB4(0L);
/*     */     }
/*     */ 
/* 154 */     int k = 0;
/* 155 */     if (this.username != null) {
/* 156 */       k = 1;
/* 157 */       this.meg.marshalPTR();
/*     */     } else {
/* 159 */       this.meg.marshalNULLPTR();
/*     */     }
/* 161 */     int m = 0;
/* 162 */     if (this.tenantBytes != null) {
/* 163 */       m = 1;
/* 164 */       this.meg.marshalPTR();
/* 165 */       this.meg.marshalUB4(this.tenantBytes.length);
/*     */     }
/*     */     else {
/* 168 */       this.meg.marshalNULLPTR();
/* 169 */       this.meg.marshalUB4(0L);
/*     */     }
/*     */ 
/* 172 */     int n = 0;
/* 173 */     this.meg.marshalPTR();
/* 174 */     if ((this.namespaces != null) && (this.namespaces.length > 0)) {
/* 175 */       n = 1;
/* 176 */       this.meg.marshalUB4(this.namespaces.length);
/*     */     }
/*     */     else {
/* 179 */       this.meg.marshalUB4(0L);
/*     */     }
/* 181 */     this.meg.marshalUB4(this.mode.getCode());
/*     */ 
/* 183 */     int i1 = 0;
/* 184 */     if (this.kv != null) {
/* 185 */       i1 = 1;
/* 186 */       this.meg.marshalPTR();
/*     */     }
/*     */     else {
/* 189 */       this.meg.marshalNULLPTR();
/*     */     }
/*     */ 
/* 192 */     if (i != 0)
/* 193 */       ((XSSecureIdI)this.sidp).marshal(this.meg);
/* 194 */     if (j != 0)
/* 195 */       this.meg.marshalB1Array(this.cookie);
/* 196 */     if (k != 0)
/* 197 */       ((XSPrincipalI)this.username).marshal(this.meg);
/* 198 */     if (m != 0)
/* 199 */       this.meg.marshalCHR(this.tenantBytes);
/* 200 */     if (n != 0)
/*     */     {
/* 202 */       for (int i2 = 0; i2 < this.namespaces.length; i2++)
/* 203 */         ((XSNamespaceI)this.namespaces[i2]).marshal(this.meg);
/*     */     }
/* 205 */     if (i1 != 0)
/* 206 */       ((XSKeyvalI)this.kv).marshal(this.meg);
/*     */   }
/*     */ 
/*     */   byte[] getSessionId()
/*     */   {
/* 214 */     return this.sessionId;
/*     */   }
/*     */ 
/*     */   void readRPA()
/*     */     throws SQLException, IOException
/*     */   {
/* 220 */     int i = (int)this.meg.unmarshalUB4();
/* 221 */     this.sessionId = null;
/* 222 */     if (i > 0)
/* 223 */       this.sessionId = this.meg.unmarshalNBytes(i);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIoxscre
 * JD-Core Version:    0.6.2
 */