/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.KeywordValueLong;
/*     */ import oracle.jdbc.internal.XSKeyval;
/*     */ import oracle.jdbc.internal.XSNamespace;
/*     */ import oracle.jdbc.internal.XSPrincipal;
/*     */ import oracle.jdbc.internal.XSSecureId;
/*     */ import oracle.sql.TIMESTAMPTZ;
/*     */ 
/*     */ final class T4CTTIoxsatt extends T4CTTIfun
/*     */ {
/*     */   private int opcode;
/*     */   private byte[] sessionId;
/*     */   private XSSecureId sidp;
/*     */   private byte[] cookie;
/*     */   private XSPrincipal username;
/*     */   private byte[][] disabledRolesBytes;
/*     */   private byte[][] enabledRolesBytes;
/*     */   private byte[][] externalRolesBytes;
/*     */   private XSNamespace[] namespaces;
/*     */   private XSNamespace[] cacheNamespace;
/*     */   private XSNamespace[] deleteNamespace;
/*     */   private TIMESTAMPTZ midTierTimestamp;
/*     */   private TIMESTAMPTZ authtime;
/*     */   private int roleVersion;
/*     */   private long inputFlag;
/*     */   private XSKeyval kv;
/*     */   private int[] roleVersionOutput;
/* 399 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIoxsatt(T4CConnection paramT4CConnection)
/*     */   {
/* 117 */     super(paramT4CConnection, (byte)3);
/* 118 */     setFunCode((short)180);
/*     */   }
/*     */ 
/*     */   void doOXSATT(int paramInt1, byte[] paramArrayOfByte1, XSSecureId paramXSSecureId, byte[] paramArrayOfByte2, XSPrincipal paramXSPrincipal, String[] paramArrayOfString1, String[] paramArrayOfString2, String[] paramArrayOfString3, XSNamespace[] paramArrayOfXSNamespace1, XSNamespace[] paramArrayOfXSNamespace2, XSNamespace[] paramArrayOfXSNamespace3, TIMESTAMPTZ paramTIMESTAMPTZ1, TIMESTAMPTZ paramTIMESTAMPTZ2, int paramInt2, long paramLong, XSKeyval paramXSKeyval, int[] paramArrayOfInt)
/*     */     throws IOException, SQLException
/*     */   {
/* 142 */     this.opcode = paramInt1;
/* 143 */     this.sessionId = paramArrayOfByte1;
/* 144 */     this.sidp = paramXSSecureId;
/* 145 */     this.cookie = paramArrayOfByte2;
/* 146 */     this.username = paramXSPrincipal;
/* 147 */     if (paramXSPrincipal != null)
/* 148 */       ((XSPrincipalI)paramXSPrincipal).doCharConversion(this.meg.conv);
/*     */     int i;
/* 150 */     if ((paramArrayOfString1 != null) && (paramArrayOfString1.length > 0)) {
/* 151 */       this.disabledRolesBytes = new byte[paramArrayOfString1.length][];
/* 152 */       for (i = 0; i < paramArrayOfString1.length; i++) {
/* 153 */         if ((paramArrayOfString1[i] != null) && (paramArrayOfString1[i].length() > 0))
/* 154 */           this.disabledRolesBytes[i] = this.meg.conv.StringToCharBytes(paramArrayOfString1[i]);
/*     */         else
/* 156 */           this.disabledRolesBytes[i] = null;
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 161 */       this.disabledRolesBytes = ((byte[][])null);
/*     */     }
/*     */ 
/* 164 */     if ((paramArrayOfString2 != null) && (paramArrayOfString2.length > 0)) {
/* 165 */       this.enabledRolesBytes = new byte[paramArrayOfString2.length][];
/* 166 */       for (i = 0; i < paramArrayOfString2.length; i++)
/* 167 */         if ((paramArrayOfString2[i] != null) && (paramArrayOfString2[i].length() > 0))
/* 168 */           this.enabledRolesBytes[i] = this.meg.conv.StringToCharBytes(paramArrayOfString2[i]);
/*     */         else
/* 170 */           this.enabledRolesBytes[i] = null;
/*     */     }
/*     */     else
/*     */     {
/* 174 */       this.enabledRolesBytes = ((byte[][])null);
/*     */     }
/*     */ 
/* 177 */     if ((paramArrayOfString3 != null) && (paramArrayOfString3.length > 0)) {
/* 178 */       this.externalRolesBytes = new byte[paramArrayOfString3.length][];
/* 179 */       for (i = 0; i < paramArrayOfString3.length; i++)
/* 180 */         if ((paramArrayOfString3[i] != null) && (paramArrayOfString3[i].length() > 0))
/* 181 */           this.externalRolesBytes[i] = this.meg.conv.StringToCharBytes(paramArrayOfString3[i]);
/*     */         else
/* 183 */           this.externalRolesBytes[i] = null;
/*     */     }
/*     */     else
/*     */     {
/* 187 */       this.externalRolesBytes = ((byte[][])null);
/*     */     }
/*     */ 
/* 190 */     this.namespaces = paramArrayOfXSNamespace1;
/* 191 */     if (paramArrayOfXSNamespace1 != null)
/* 192 */       for (i = 0; i < paramArrayOfXSNamespace1.length; i++)
/* 193 */         ((XSNamespaceI)paramArrayOfXSNamespace1[i]).doCharConversion(this.meg.conv);
/* 194 */     this.cacheNamespace = paramArrayOfXSNamespace2;
/* 195 */     if (paramArrayOfXSNamespace2 != null)
/* 196 */       for (i = 0; i < paramArrayOfXSNamespace2.length; i++)
/* 197 */         ((XSNamespaceI)paramArrayOfXSNamespace2[i]).doCharConversion(this.meg.conv);
/* 198 */     this.deleteNamespace = paramArrayOfXSNamespace3;
/* 199 */     if (paramArrayOfXSNamespace3 != null) {
/* 200 */       for (i = 0; i < paramArrayOfXSNamespace3.length; i++) {
/* 201 */         ((XSNamespaceI)paramArrayOfXSNamespace3[i]).doCharConversion(this.meg.conv);
/*     */       }
/*     */     }
/* 204 */     this.midTierTimestamp = paramTIMESTAMPTZ1;
/* 205 */     this.authtime = paramTIMESTAMPTZ2;
/* 206 */     this.roleVersion = paramInt2;
/* 207 */     this.inputFlag = paramLong;
/* 208 */     this.kv = paramXSKeyval;
/* 209 */     if (paramXSKeyval != null) {
/* 210 */       KeywordValueLong[] arrayOfKeywordValueLong = paramXSKeyval.getKeyval();
/* 211 */       if (arrayOfKeywordValueLong != null) {
/* 212 */         for (int j = 0; j < arrayOfKeywordValueLong.length; j++)
/* 213 */           ((KeywordValueLongI)arrayOfKeywordValueLong[j]).doCharConversion(this.meg.conv);
/*     */       }
/*     */     }
/* 216 */     this.roleVersionOutput = paramArrayOfInt;
/*     */ 
/* 218 */     doRPC();
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 225 */     this.meg.marshalUB4(this.opcode);
/*     */ 
/* 227 */     int i = 0;
/* 228 */     if ((this.sessionId != null) && (this.sessionId.length > 0)) {
/* 229 */       i = 1;
/* 230 */       this.meg.marshalPTR();
/* 231 */       this.meg.marshalUB4(this.sessionId.length);
/*     */     } else {
/* 233 */       this.meg.marshalNULLPTR();
/* 234 */       this.meg.marshalUB4(0L);
/*     */     }
/* 236 */     int j = 0;
/* 237 */     if (this.sidp != null) {
/* 238 */       j = 1;
/* 239 */       this.meg.marshalPTR();
/*     */     } else {
/* 241 */       this.meg.marshalNULLPTR();
/*     */     }
/* 243 */     int k = 0;
/* 244 */     if ((this.cookie != null) && (this.cookie.length > 0)) {
/* 245 */       k = 1;
/* 246 */       this.meg.marshalPTR();
/* 247 */       this.meg.marshalUB4(this.cookie.length);
/*     */     } else {
/* 249 */       this.meg.marshalNULLPTR();
/* 250 */       this.meg.marshalUB4(0L);
/*     */     }
/* 252 */     int m = 0;
/* 253 */     if (this.username == null) {
/* 254 */       this.meg.marshalNULLPTR();
/*     */     } else {
/* 256 */       m = 1;
/* 257 */       this.meg.marshalPTR();
/*     */     }
/* 259 */     if ((this.disabledRolesBytes != null) && (this.disabledRolesBytes.length > 0)) {
/* 260 */       this.meg.marshalPTR();
/* 261 */       this.meg.marshalUB4(this.disabledRolesBytes.length);
/*     */     } else {
/* 263 */       this.meg.marshalNULLPTR();
/* 264 */       this.meg.marshalUB4(0L);
/*     */     }
/* 266 */     if ((this.enabledRolesBytes != null) && (this.enabledRolesBytes.length > 0)) {
/* 267 */       this.meg.marshalPTR();
/* 268 */       this.meg.marshalUB4(this.enabledRolesBytes.length);
/*     */     } else {
/* 270 */       this.meg.marshalNULLPTR();
/* 271 */       this.meg.marshalUB4(0L);
/*     */     }
/* 273 */     if ((this.externalRolesBytes != null) && (this.externalRolesBytes.length > 0)) {
/* 274 */       this.meg.marshalPTR();
/* 275 */       this.meg.marshalUB4(this.externalRolesBytes.length);
/*     */     } else {
/* 277 */       this.meg.marshalNULLPTR();
/* 278 */       this.meg.marshalUB4(0L);
/*     */     }
/* 280 */     int n = 0;
/* 281 */     this.meg.marshalPTR();
/* 282 */     if ((this.namespaces != null) && (this.namespaces.length > 0)) {
/* 283 */       n = 1;
/* 284 */       this.meg.marshalUB4(this.namespaces.length);
/*     */     } else {
/* 286 */       this.meg.marshalUB4(0L);
/*     */     }
/* 288 */     int i1 = 0;
/* 289 */     this.meg.marshalPTR();
/* 290 */     if ((this.cacheNamespace != null) && (this.cacheNamespace.length > 0)) {
/* 291 */       i1 = 1;
/* 292 */       this.meg.marshalUB4(this.cacheNamespace.length);
/*     */     } else {
/* 294 */       this.meg.marshalUB4(0L);
/*     */     }
/* 296 */     int i2 = 0;
/* 297 */     this.meg.marshalPTR();
/* 298 */     if ((this.deleteNamespace != null) && (this.deleteNamespace.length > 0)) {
/* 299 */       i2 = 1;
/* 300 */       this.meg.marshalUB4(this.deleteNamespace.length);
/*     */     } else {
/* 302 */       this.meg.marshalUB4(0L);
/*     */     }
/* 304 */     if (this.midTierTimestamp != null)
/* 305 */       this.meg.marshalPTR();
/*     */     else {
/* 307 */       this.meg.marshalNULLPTR();
/*     */     }
/* 309 */     if (this.authtime != null)
/* 310 */       this.meg.marshalPTR();
/*     */     else
/* 312 */       this.meg.marshalNULLPTR();
/* 313 */     this.meg.marshalPTR();
/* 314 */     this.meg.marshalUB4(this.inputFlag);
/* 315 */     int i3 = 0;
/* 316 */     if (this.kv != null) {
/* 317 */       i3 = 1;
/* 318 */       this.meg.marshalPTR();
/*     */     }
/*     */     else {
/* 321 */       this.meg.marshalNULLPTR();
/*     */     }
/* 323 */     if (i != 0)
/* 324 */       this.meg.marshalB1Array(this.sessionId);
/* 325 */     if (j != 0)
/* 326 */       ((XSSecureIdI)this.sidp).marshal(this.meg);
/* 327 */     if (k != 0)
/* 328 */       this.meg.marshalB1Array(this.cookie);
/* 329 */     if (m != 0)
/* 330 */       ((XSPrincipalI)this.username).marshal(this.meg);
/*     */     int i4;
/* 331 */     if ((this.disabledRolesBytes != null) && (this.disabledRolesBytes.length > 0)) {
/* 332 */       for (i4 = 0; i4 < this.disabledRolesBytes.length; i4++) {
/* 333 */         if (this.disabledRolesBytes[i4] == null) {
/* 334 */           this.meg.marshalUB4(0L);
/*     */         } else {
/* 336 */           this.meg.marshalUB4(this.disabledRolesBytes[i4].length);
/* 337 */           this.meg.marshalCLR(this.disabledRolesBytes[i4], this.disabledRolesBytes[i4].length);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 342 */     if ((this.enabledRolesBytes != null) && (this.enabledRolesBytes.length > 0)) {
/* 343 */       for (i4 = 0; i4 < this.enabledRolesBytes.length; i4++) {
/* 344 */         if (this.enabledRolesBytes[i4] == null) {
/* 345 */           this.meg.marshalUB4(0L);
/*     */         } else {
/* 347 */           this.meg.marshalUB4(this.enabledRolesBytes[i4].length);
/*     */ 
/* 349 */           this.meg.marshalCLR(this.enabledRolesBytes[i4], this.enabledRolesBytes[i4].length);
/*     */         }
/*     */       }
/*     */     }
/* 353 */     if ((this.externalRolesBytes != null) && (this.externalRolesBytes.length > 0)) {
/* 354 */       for (i4 = 0; i4 < this.externalRolesBytes.length; i4++) {
/* 355 */         if (this.externalRolesBytes[i4] == null) {
/* 356 */           this.meg.marshalUB4(0L);
/*     */         } else {
/* 358 */           this.meg.marshalUB4(this.externalRolesBytes[i4].length);
/*     */ 
/* 360 */           this.meg.marshalCLR(this.externalRolesBytes[i4], this.externalRolesBytes[i4].length);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 365 */     if (n != 0) {
/* 366 */       for (i4 = 0; i4 < this.namespaces.length; i4++)
/* 367 */         ((XSNamespaceI)this.namespaces[i4]).marshal(this.meg);
/*     */     }
/* 369 */     if (i1 != 0) {
/* 370 */       for (i4 = 0; i4 < this.cacheNamespace.length; i4++)
/* 371 */         ((XSNamespaceI)this.cacheNamespace[i4]).marshal(this.meg);
/*     */     }
/* 373 */     if (i2 != 0) {
/* 374 */       for (i4 = 0; i4 < this.deleteNamespace.length; i4++) {
/* 375 */         ((XSNamespaceI)this.deleteNamespace[i4]).marshal(this.meg);
/*     */       }
/*     */     }
/* 378 */     if (this.midTierTimestamp != null)
/* 379 */       this.meg.marshalB1Array(this.midTierTimestamp.getBytes());
/* 380 */     if (this.authtime != null)
/* 381 */       this.meg.marshalB1Array(this.authtime.getBytes());
/* 382 */     this.meg.marshalUB4(this.roleVersion);
/* 383 */     if (i3 != 0)
/* 384 */       ((XSKeyvalI)this.kv).marshal(this.meg);
/*     */   }
/*     */ 
/*     */   void readRPA()
/*     */     throws SQLException, IOException
/*     */   {
/* 391 */     int i = (int)this.meg.unmarshalUB4();
/* 392 */     if ((this.roleVersionOutput != null) && (this.roleVersionOutput.length == 1))
/* 393 */       this.roleVersionOutput[0] = i;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIoxsatt
 * JD-Core Version:    0.6.2
 */