/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ final class T4CTTIoscid extends T4CTTIfun
/*     */ {
/*     */   static final int KPDUSR_CID_RESET = 1;
/*     */   static final int KPDUSR_PROXY_RESET = 2;
/*     */   static final int KPDUSR_PROXY_TKTSENT = 4;
/*     */   static final int KPDUSR_MODULE_RESET = 8;
/*     */   static final int KPDUSR_ACTION_RESET = 16;
/*     */   static final int KPDUSR_EXECID_RESET = 32;
/*     */   static final int KPDUSR_EXECSQ_RESET = 64;
/*     */   static final int KPDUSR_COLLCT_RESET = 128;
/*     */   static final int KPDUSR_CLINFO_RESET = 256;
/*     */   static final int KPDUSR_DBOP_RESET = 512;
/* 126 */   private byte[] cidcid = null;
/* 127 */   private byte[] cidmod = null;
/* 128 */   private byte[] cidact = null;
/* 129 */   private byte[] cideci = null;
/* 130 */   private byte[] ciddbop = null;
/*     */ 
/* 132 */   private boolean[] endToEndHasChanged = null;
/* 133 */   private String[] endToEndValues = null;
/*     */   private int endToEndECIDSequenceNumber;
/* 316 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIoscid(T4CConnection paramT4CConnection)
/*     */   {
/* 122 */     super(paramT4CConnection, (byte)17);
/* 123 */     setFunCode((short)135);
/*     */   }
/*     */ 
/*     */   void doOSCID(boolean[] paramArrayOfBoolean, String[] paramArrayOfString, int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/* 140 */     this.endToEndHasChanged = paramArrayOfBoolean;
/* 141 */     this.endToEndValues = paramArrayOfString;
/* 142 */     this.endToEndECIDSequenceNumber = paramInt;
/*     */ 
/* 144 */     if (this.endToEndValues[1] != null) {
/* 145 */       this.cidcid = this.meg.conv.StringToCharBytes(this.endToEndValues[1]);
/*     */     }
/*     */     else {
/* 148 */       this.cidcid = null;
/*     */     }
/* 150 */     if (this.endToEndValues[3] != null) {
/* 151 */       this.cidmod = this.meg.conv.StringToCharBytes(this.endToEndValues[3]);
/*     */     }
/*     */     else {
/* 154 */       this.cidmod = null;
/*     */     }
/* 156 */     if (this.endToEndValues[0] != null) {
/* 157 */       this.cidact = this.meg.conv.StringToCharBytes(this.endToEndValues[0]);
/*     */     }
/*     */     else {
/* 160 */       this.cidact = null;
/*     */     }
/* 162 */     if (this.endToEndValues[2] != null) {
/* 163 */       this.cideci = this.meg.conv.StringToCharBytes(this.endToEndValues[2]);
/*     */     }
/*     */     else
/* 166 */       this.cideci = null;
/* 167 */     if (this.endToEndValues[4] != null) {
/* 168 */       this.ciddbop = this.meg.conv.StringToCharBytes(this.endToEndValues[4]);
/*     */     }
/*     */     else
/* 171 */       this.ciddbop = null;
/* 172 */     doPigRPC();
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 180 */     int i = 64;
/*     */ 
/* 182 */     if (this.endToEndHasChanged[0] != 0) {
/* 183 */       i |= 16;
/*     */     }
/* 185 */     if (this.endToEndHasChanged[1] != 0) {
/* 186 */       i |= 1;
/*     */     }
/* 188 */     if (this.endToEndHasChanged[2] != 0) {
/* 189 */       i |= 32;
/*     */     }
/* 191 */     if (this.endToEndHasChanged[3] != 0) {
/* 192 */       i |= 8;
/*     */     }
/* 194 */     if (this.endToEndHasChanged[4] != 0) {
/* 195 */       i |= 512;
/*     */     }
/*     */ 
/* 199 */     this.meg.marshalNULLPTR();
/* 200 */     this.meg.marshalNULLPTR();
/* 201 */     this.meg.marshalUB4(i);
/*     */ 
/* 203 */     int j = 0; int k = 0;
/* 204 */     int m = 0; int n = 0; int i1 = 0;
/*     */ 
/* 206 */     if (this.endToEndHasChanged[1] != 0)
/*     */     {
/* 208 */       this.meg.marshalPTR();
/*     */ 
/* 210 */       if (this.cidcid != null)
/* 211 */         this.meg.marshalUB4(this.cidcid.length);
/*     */       else
/* 213 */         this.meg.marshalUB4(0L);
/* 214 */       j = 1;
/*     */     }
/*     */     else
/*     */     {
/* 218 */       this.meg.marshalNULLPTR();
/* 219 */       this.meg.marshalUB4(0L);
/*     */     }
/*     */ 
/* 223 */     if (this.endToEndHasChanged[3] != 0)
/*     */     {
/* 225 */       this.meg.marshalPTR();
/*     */ 
/* 227 */       if (this.cidmod != null)
/* 228 */         this.meg.marshalUB4(this.cidmod.length);
/*     */       else
/* 230 */         this.meg.marshalUB4(0L);
/* 231 */       k = 1;
/*     */     }
/*     */     else
/*     */     {
/* 235 */       this.meg.marshalNULLPTR();
/* 236 */       this.meg.marshalUB4(0L);
/*     */     }
/*     */ 
/* 239 */     if (this.endToEndHasChanged[0] != 0)
/*     */     {
/* 241 */       this.meg.marshalPTR();
/* 242 */       if (this.cidact != null)
/* 243 */         this.meg.marshalUB4(this.cidact.length);
/*     */       else
/* 245 */         this.meg.marshalUB4(0L);
/* 246 */       m = 1;
/*     */     }
/*     */     else
/*     */     {
/* 250 */       this.meg.marshalNULLPTR();
/* 251 */       this.meg.marshalUB4(0L);
/*     */     }
/*     */ 
/* 254 */     if (this.endToEndHasChanged[2] != 0)
/*     */     {
/* 256 */       this.meg.marshalPTR();
/*     */ 
/* 258 */       if (this.cideci != null)
/* 259 */         this.meg.marshalUB4(this.cideci.length);
/*     */       else
/* 261 */         this.meg.marshalUB4(0L);
/* 262 */       n = 1;
/*     */     }
/*     */     else
/*     */     {
/* 266 */       this.meg.marshalNULLPTR();
/* 267 */       this.meg.marshalUB4(0L);
/*     */     }
/*     */ 
/* 270 */     this.meg.marshalUB2(0);
/* 271 */     this.meg.marshalUB2(this.endToEndECIDSequenceNumber);
/* 272 */     this.meg.marshalNULLPTR();
/* 273 */     this.meg.marshalUB4(0L);
/* 274 */     this.meg.marshalNULLPTR();
/* 275 */     this.meg.marshalUB4(0L);
/* 276 */     this.meg.marshalNULLPTR();
/* 277 */     this.meg.marshalUB4(0L);
/* 278 */     if (this.connection.getTTCVersion() >= 7) {
/* 279 */       if (this.endToEndHasChanged[4] != 0)
/*     */       {
/* 281 */         this.meg.marshalPTR();
/*     */ 
/* 283 */         if (this.ciddbop != null)
/* 284 */           this.meg.marshalUB4(this.ciddbop.length);
/*     */         else
/* 286 */           this.meg.marshalUB4(0L);
/* 287 */         i1 = 1;
/*     */       }
/*     */       else
/*     */       {
/* 291 */         this.meg.marshalNULLPTR();
/* 292 */         this.meg.marshalUB4(0L);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 298 */     if ((j != 0) && (this.cidcid != null)) {
/* 299 */       this.meg.marshalCHR(this.cidcid);
/*     */     }
/* 301 */     if ((k != 0) && (this.cidmod != null)) {
/* 302 */       this.meg.marshalCHR(this.cidmod);
/*     */     }
/* 304 */     if ((m != 0) && (this.cidact != null)) {
/* 305 */       this.meg.marshalCHR(this.cidact);
/*     */     }
/* 307 */     if ((n != 0) && (this.cideci != null)) {
/* 308 */       this.meg.marshalCHR(this.cideci);
/*     */     }
/* 310 */     if ((i1 != 0) && (this.ciddbop != null))
/* 311 */       this.meg.marshalCHR(this.ciddbop);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIoscid
 * JD-Core Version:    0.6.2
 */