/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import java.util.ArrayList;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.TIMESTAMPTZ;
/*     */ 
/*     */ final class T4CTTIokpn extends T4CTTIfun
/*     */ {
/*     */   static final int REGISTER_KPNDEF = 1;
/*     */   static final int UNREGISTER_KPNDEF = 2;
/*     */   static final int POST_KPNDEF = 3;
/*     */   static final int EXISTINGCLIENT_KPNDEF = 0;
/*     */   static final int NEWCLIENT_KPNDEF = 1;
/*     */   static final int CLIENTCON_KPNDEF = 4;
/*     */   static final int KPUN_PRS_RAW = 1;
/*     */   static final int KPUN_VER_10200 = 2;
/*     */   static final int KPUN_VER_11100 = 3;
/*     */   static final int KPUN_VER_11200 = 4;
/*     */   static final int OCI_SUBSCR_NAMESPACE_ANONYMOUS = 0;
/*     */   static final int OCI_SUBSCR_NAMESPACE_AQ = 1;
/*     */   static final int OCI_SUBSCR_NAMESPACE_DBCHANGE = 2;
/*     */   static final int OCI_SUBSCR_NAMESPACE_MAX = 3;
/*     */   static final int KPD_CHNF_OPFILTER = 1;
/*     */   static final int KPD_CHNF_INSERT = 2;
/*     */   static final int KPD_CHNF_UPDATE = 4;
/*     */   static final int KPD_CHNF_DELETE = 8;
/*     */   static final int KPD_CHNF_ROWID = 16;
/*     */   static final int KPD_CQ_QUERYNF = 32;
/*     */   static final int KPD_CQ_BEST_EFFORT = 64;
/*     */   static final int KPD_CQ_CLQRYCACHE = 128;
/*     */   static final int KPD_CHNF_INVALID_REGID = 0;
/*     */   static final int KPD_NTFN_CONNID_LEN = 29;
/*     */   static final int KKCN_CTX_RAW = 0;
/*     */   static final int SUBSCR_QOS_RELIABLE = 1;
/*     */   static final int SUBSCR_QOS_PAYLOAD = 2;
/*     */   static final int SUBSCR_QOS_REPLICATE = 4;
/*     */   static final int SUBSCR_QOS_SECURE = 8;
/*     */   static final int SUBSCR_QOS_PURGE_ON_NTFN = 16;
/*     */   static final int SUBSCR_QOS_MULTICBK = 32;
/*     */   static final int SUBSCR_QOS_ASYNC_DEQ = 512;
/*     */   static final int SUBSCR_QOS_TX_ACK = 2048;
/*     */   static final int SUBSCR_QOS_AUTO_ACK = 1024;
/*     */   static final byte SUBSCR_NTFN_GROUPING_CLASS_NONE = 0;
/*     */   static final byte SUBSCR_NTFN_GROUPING_CLASS_TIME = 1;
/*     */   static final byte SUBSCR_NTFN_GROUPING_TYPE_SUMMARY = 1;
/*     */   static final byte SUBSCR_NTFN_GROUPING_TYPE_LAST = 2;
/*     */   private int opcode;
/*     */   private int mode;
/*     */   private int nbOfRegistrationInfo;
/*     */   private String user;
/*     */   private String location;
/* 269 */   private String jmsClientId = null;
/* 270 */   private String[] databaseInstances = null;
/*     */   private int[] namespace;
/*     */   private int[] kpdnrgrpval;
/*     */   private int[] kpdnrgrprepcnt;
/*     */   private int[] payloadType;
/*     */   private int[] qosFlags;
/*     */   private int[] timeout;
/*     */   private int[] dbchangeOpFilter;
/* 271 */   private int[] dbchangeTxnLag = null;
/*     */ 
/* 274 */   private byte[] kpncid = null;
/* 275 */   private byte[][] registeredAgentName = (byte[][])null;
/* 276 */   private byte[][] kpdnrcx = (byte[][])null;
/*     */   private byte[] kpdnrgrpcla;
/* 277 */   private byte[] kpdnrgrptyp = null;
/* 278 */   private TIMESTAMPTZ[] kpdnrgrpstatim = null;
/* 279 */   private long[] dbchangeRegistrationId = null;
/* 280 */   private byte[] userArr = null;
/* 281 */   private byte[] locationArr = null;
/* 282 */   private byte[] subscriberName = null;
/*     */ 
/* 284 */   private long regid = 0L;
/* 285 */   private long[] registrationId = null;
/*     */ 
/* 287 */   ArrayList<String> listenerAddresses = new ArrayList();
/* 288 */   T4CTTIkpdnrri kpninst = null;
/* 289 */   T4CTTIkpdnrgnc kpngcret = null;
/*     */ 
/* 718 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIokpn(T4CConnection paramT4CConnection)
/*     */   {
/* 261 */     super(paramT4CConnection, (byte)3);
/*     */ 
/* 263 */     setFunCode((short)125);
/*     */   }
/*     */ 
/*     */   void doOKPN(int paramInt1, int paramInt2, String paramString1, String paramString2, int paramInt3, int[] paramArrayOfInt1, String[] paramArrayOfString, byte[][] paramArrayOfByte, int[] paramArrayOfInt2, int[] paramArrayOfInt3, int[] paramArrayOfInt4, int[] paramArrayOfInt5, int[] paramArrayOfInt6, long[] paramArrayOfLong1, byte[] paramArrayOfByte1, int[] paramArrayOfInt7, byte[] paramArrayOfByte2, TIMESTAMPTZ[] paramArrayOfTIMESTAMPTZ, int[] paramArrayOfInt8, long[] paramArrayOfLong2)
/*     */     throws IOException, SQLException
/*     */   {
/* 317 */     this.opcode = paramInt1;
/* 318 */     this.mode = paramInt2;
/* 319 */     this.user = paramString1;
/* 320 */     this.location = paramString2;
/* 321 */     this.nbOfRegistrationInfo = paramInt3;
/* 322 */     this.namespace = paramArrayOfInt1;
/* 323 */     this.kpdnrcx = paramArrayOfByte;
/* 324 */     this.payloadType = paramArrayOfInt2;
/* 325 */     this.qosFlags = paramArrayOfInt3;
/* 326 */     this.timeout = paramArrayOfInt4;
/* 327 */     this.dbchangeOpFilter = paramArrayOfInt5;
/* 328 */     if (this.dbchangeOpFilter == null)
/*     */     {
/* 330 */       this.dbchangeOpFilter = new int[this.nbOfRegistrationInfo];
/*     */     }
/* 332 */     this.dbchangeTxnLag = paramArrayOfInt6;
/* 333 */     if (this.dbchangeTxnLag == null)
/*     */     {
/* 335 */       this.dbchangeTxnLag = new int[this.nbOfRegistrationInfo];
/*     */     }
/* 337 */     this.dbchangeRegistrationId = paramArrayOfLong1;
/* 338 */     if (this.dbchangeRegistrationId == null)
/*     */     {
/* 340 */       this.dbchangeRegistrationId = new long[this.nbOfRegistrationInfo];
/*     */     }
/* 342 */     this.kpdnrgrpcla = paramArrayOfByte1;
/* 343 */     if (this.kpdnrgrpcla == null)
/*     */     {
/* 345 */       this.kpdnrgrpcla = new byte[this.nbOfRegistrationInfo];
/*     */     }
/* 347 */     this.kpdnrgrpval = paramArrayOfInt7;
/* 348 */     if (this.kpdnrgrpval == null)
/*     */     {
/* 350 */       this.kpdnrgrpval = new int[this.nbOfRegistrationInfo];
/*     */     }
/* 352 */     this.kpdnrgrptyp = paramArrayOfByte2;
/* 353 */     if (this.kpdnrgrptyp == null)
/*     */     {
/* 355 */       this.kpdnrgrptyp = new byte[this.nbOfRegistrationInfo];
/*     */     }
/* 357 */     this.kpdnrgrpstatim = paramArrayOfTIMESTAMPTZ;
/* 358 */     if (this.kpdnrgrpstatim == null)
/*     */     {
/* 360 */       this.kpdnrgrpstatim = new TIMESTAMPTZ[this.nbOfRegistrationInfo];
/*     */     }
/* 362 */     this.kpdnrgrprepcnt = paramArrayOfInt8;
/* 363 */     if (this.kpdnrgrprepcnt == null)
/*     */     {
/* 365 */       this.kpdnrgrprepcnt = new int[this.nbOfRegistrationInfo];
/*     */     }
/* 367 */     this.registrationId = paramArrayOfLong2;
/* 368 */     if (this.registrationId == null)
/*     */     {
/* 370 */       this.registrationId = new long[this.nbOfRegistrationInfo];
/*     */     }
/* 372 */     this.registeredAgentName = new byte[this.nbOfRegistrationInfo][];
/* 373 */     for (int i = 0; i < this.nbOfRegistrationInfo; i++) {
/* 374 */       if (paramArrayOfString[i] != null)
/* 375 */         this.registeredAgentName[i] = this.meg.conv.StringToCharBytes(paramArrayOfString[i]);
/*     */     }
/* 377 */     if (this.user != null)
/* 378 */       this.userArr = this.meg.conv.StringToCharBytes(this.user);
/*     */     else {
/* 380 */       this.userArr = null;
/*     */     }
/* 382 */     if (this.location != null)
/* 383 */       this.locationArr = this.meg.conv.StringToCharBytes(this.location);
/*     */     else {
/* 385 */       this.locationArr = null;
/*     */     }
/*     */ 
/* 388 */     this.regid = 0L;
/*     */ 
/* 390 */     doRPC();
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 398 */     int i = 1;
/* 399 */     int j = 2;
/*     */ 
/* 402 */     this.meg.marshalUB1((short)(byte)this.opcode);
/*     */ 
/* 404 */     this.meg.marshalUB4(this.mode);
/*     */ 
/* 406 */     if (this.userArr != null)
/*     */     {
/* 408 */       this.meg.marshalPTR();
/* 409 */       this.meg.marshalUB4(this.userArr.length);
/*     */     }
/*     */     else
/*     */     {
/* 413 */       this.meg.marshalNULLPTR();
/* 414 */       this.meg.marshalUB4(0L);
/*     */     }
/*     */ 
/* 418 */     if (this.locationArr != null)
/*     */     {
/* 420 */       this.meg.marshalPTR();
/* 421 */       this.meg.marshalUB4(this.locationArr.length);
/*     */     }
/*     */     else
/*     */     {
/* 425 */       this.meg.marshalNULLPTR();
/* 426 */       this.meg.marshalUB4(0L);
/*     */     }
/*     */ 
/* 430 */     this.meg.marshalPTR();
/* 431 */     this.meg.marshalUB4(this.nbOfRegistrationInfo);
/*     */ 
/* 433 */     this.meg.marshalUB2(i);
/*     */ 
/* 435 */     this.meg.marshalUB2(j);
/* 436 */     if (this.connection.getTTCVersion() >= 4)
/*     */     {
/* 439 */       this.meg.marshalNULLPTR();
/*     */ 
/* 441 */       this.meg.marshalPTR();
/*     */ 
/* 443 */       if (this.connection.getTTCVersion() >= 5)
/*     */       {
/* 446 */         this.meg.marshalNULLPTR();
/*     */ 
/* 448 */         this.meg.marshalPTR();
/* 449 */         if (this.connection.getTTCVersion() >= 7)
/*     */         {
/* 451 */           this.meg.marshalPTR();
/*     */ 
/* 453 */           this.meg.marshalPTR();
/*     */ 
/* 455 */           this.meg.marshalPTR();
/*     */ 
/* 457 */           this.meg.marshalPTR();
/*     */ 
/* 459 */           this.meg.marshalPTR();
/*     */ 
/* 461 */           this.meg.marshalSWORD(29);
/*     */ 
/* 463 */           this.meg.marshalPTR();
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 470 */     if (this.userArr != null)
/* 471 */       this.meg.marshalCHR(this.userArr);
/* 472 */     if (this.locationArr != null) {
/* 473 */       this.meg.marshalCHR(this.locationArr);
/*     */     }
/*     */ 
/* 480 */     assert ((this.namespace != null) && (this.registeredAgentName != null) && (this.payloadType != null) && (this.qosFlags != null) && (this.timeout != null)) : (" namespace : " + this.namespace + ", registeredAgentName : " + this.registeredAgentName + ", payloadType : " + this.payloadType + ", qosFlags : " + this.qosFlags + ", timeout : " + this.timeout);
/*     */ 
/* 499 */     assert ((this.namespace.length == this.nbOfRegistrationInfo) && (this.registeredAgentName.length == this.nbOfRegistrationInfo) && (this.payloadType.length == this.nbOfRegistrationInfo) && (this.qosFlags.length == this.nbOfRegistrationInfo) && (this.timeout.length == this.nbOfRegistrationInfo) && (this.kpdnrcx.length == this.nbOfRegistrationInfo) && (this.dbchangeOpFilter.length == this.nbOfRegistrationInfo) && (this.dbchangeTxnLag.length == this.nbOfRegistrationInfo) && (this.kpdnrgrpcla.length == this.nbOfRegistrationInfo) && (this.kpdnrgrpval.length == this.nbOfRegistrationInfo) && (this.kpdnrgrptyp.length == this.nbOfRegistrationInfo) && (this.kpdnrgrpstatim.length == this.nbOfRegistrationInfo) && (this.kpdnrgrprepcnt.length == this.nbOfRegistrationInfo) && (this.registrationId.length == this.nbOfRegistrationInfo)) : (" namespace.length = " + this.namespace.length + ", registeredAgentName.length = " + this.registeredAgentName.length + ", qosFlags.length = " + this.qosFlags.length + ", timeout.length = " + this.timeout.length + ", kpdnrcx.length = " + this.kpdnrcx.length + ", dbchangeOpFilter.length = " + this.dbchangeOpFilter.length + ", dbchangeTxnLag.length = " + this.dbchangeTxnLag.length + ", kpdnrgrpcla.length = " + this.kpdnrgrpcla.length + ", kpdnrgrpval.length = " + this.kpdnrgrpval.length + ", kpdnrgrptyp.length = " + this.kpdnrgrptyp.length + ", kpdnrgrpstatim.length = " + this.kpdnrgrpstatim.length + ", kpdnrgrprepcnt.length = " + this.kpdnrgrprepcnt.length + ", registrationId.length = " + this.registrationId.length);
/*     */ 
/* 512 */     for (int k = 0; k < this.nbOfRegistrationInfo; k++)
/*     */     {
/* 514 */       this.meg.marshalUB4(this.namespace[k]);
/*     */ 
/* 516 */       byte[] arrayOfByte1 = this.registeredAgentName[k];
/* 517 */       if ((arrayOfByte1 != null) && (arrayOfByte1.length > 0)) {
/* 518 */         this.meg.marshalUB4(arrayOfByte1.length);
/* 519 */         this.meg.marshalCLR(arrayOfByte1, 0, arrayOfByte1.length);
/*     */       }
/*     */       else {
/* 522 */         this.meg.marshalUB4(0L);
/*     */       }
/* 524 */       if (this.kpdnrcx == null) {
/* 525 */         this.meg.marshalUB4(0L);
/*     */       }
/* 527 */       else if ((this.kpdnrcx[k] != null) && (this.kpdnrcx[k].length > 0)) {
/* 528 */         this.meg.marshalUB4(this.kpdnrcx[k].length);
/* 529 */         this.meg.marshalCLR(this.kpdnrcx[k], 0, this.kpdnrcx[k].length);
/*     */       }
/*     */       else {
/* 532 */         this.meg.marshalUB4(0L);
/*     */       }
/* 534 */       this.meg.marshalUB4(this.payloadType[k]);
/* 535 */       if (this.connection.getTTCVersion() >= 4)
/*     */       {
/* 537 */         this.meg.marshalUB4(this.qosFlags[k]);
/* 538 */         byte[] arrayOfByte2 = new byte[0];
/* 539 */         this.meg.marshalUB4(arrayOfByte2.length);
/* 540 */         if (arrayOfByte2.length > 0) {
/* 541 */           this.meg.marshalCLR(arrayOfByte2, arrayOfByte2.length);
/*     */         }
/* 543 */         this.meg.marshalUB4(this.timeout[k]);
/*     */ 
/* 545 */         int m = 0;
/* 546 */         this.meg.marshalUB4(m);
/*     */ 
/* 548 */         this.meg.marshalUB4(this.dbchangeOpFilter[k]);
/*     */ 
/* 550 */         this.meg.marshalUB4(this.dbchangeTxnLag[k]);
/* 551 */         this.meg.marshalUB4((int)this.dbchangeRegistrationId[k]);
/*     */ 
/* 553 */         if (this.connection.getTTCVersion() >= 5) {
/* 554 */           this.meg.marshalUB1((short)this.kpdnrgrpcla[k]);
/* 555 */           this.meg.marshalUB4(this.kpdnrgrpval[k]);
/* 556 */           this.meg.marshalUB1((short)this.kpdnrgrptyp[k]);
/* 557 */           if (this.kpdnrgrpstatim[k] == null)
/* 558 */             this.meg.marshalDALC(null);
/*     */           else
/* 560 */             this.meg.marshalDALC(this.kpdnrgrpstatim[k].shareBytes());
/* 561 */           this.meg.marshalSB4(this.kpdnrgrprepcnt[k]);
/*     */ 
/* 564 */           this.meg.marshalSB8(this.registrationId[k]);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   long getRegistrationId()
/*     */   {
/* 574 */     return this.regid;
/*     */   }
/*     */ 
/*     */   void readRPA()
/*     */     throws IOException, SQLException
/*     */   {
/* 583 */     int i = (int)this.meg.unmarshalUB4();
/* 584 */     for (int j = 0; j < i; j++)
/* 585 */       this.meg.unmarshalUB4();
/* 586 */     int[] arrayOfInt = new int[i];
/* 587 */     for (int k = 0; k < i; k++)
/* 588 */       arrayOfInt[k] = ((int)this.meg.unmarshalUB4());
/* 589 */     this.regid = arrayOfInt[0];
/* 590 */     if (this.connection.getTTCVersion() >= 5) {
/* 591 */       k = (int)this.meg.unmarshalUB4();
/* 592 */       this.registrationId = new long[k];
/*     */       int n;
/* 593 */       for (int m = 0; m < k; m++)
/*     */       {
/* 596 */         this.registrationId[m] = this.meg.unmarshalSB8();
/*     */ 
/* 602 */         if (this.connection.getTTCVersion() >= 7) {
/* 603 */           n = (int)this.meg.unmarshalUB4();
/* 604 */           if (n > 0) {
/* 605 */             this.subscriberName = new byte[n];
/* 606 */             this.meg.unmarshalBuffer(this.subscriberName, 0, n);
/*     */           }
/*     */         }
/*     */       }
/* 610 */       this.regid = this.registrationId[0];
/* 611 */       if (this.connection.getTTCVersion() >= 7)
/*     */       {
/* 613 */         m = (int)this.meg.unmarshalUB4();
/* 614 */         this.databaseInstances = new String[m];
/* 615 */         for (n = 0; n < m; n++)
/*     */         {
/* 618 */           this.kpninst = new T4CTTIkpdnrri(this.connection);
/* 619 */           this.kpninst.receive();
/* 620 */           byte[] arrayOfByte1 = this.kpninst.getKpdnrrinm();
/* 621 */           if (arrayOfByte1 != null) {
/* 622 */             this.databaseInstances[n] = this.meg.conv.CharBytesToString(arrayOfByte1, arrayOfByte1.length);
/*     */           }
/*     */         }
/* 625 */         n = (int)this.meg.unmarshalUB4();
/*     */ 
/* 627 */         this.listenerAddresses = new ArrayList();
/* 628 */         for (int i1 = 0; i1 < n; i1++) {
/* 629 */           this.kpngcret = new T4CTTIkpdnrgnc(this.connection);
/* 630 */           this.kpngcret.receive();
/*     */ 
/* 632 */           byte[] arrayOfByte2 = this.kpngcret.getKpdnrgnclsc();
/* 633 */           if (arrayOfByte2 != null)
/*     */           {
/* 637 */             String str = this.meg.conv.CharBytesToString(arrayOfByte2, arrayOfByte2.length);
/* 638 */             this.listenerAddresses.add(str);
/*     */           }
/*     */         }
/* 641 */         i1 = this.meg.unmarshalUB2();
/* 642 */         if (i1 > 0) {
/* 643 */           this.kpncid = new byte[i1];
/* 644 */           this.kpncid = this.meg.unmarshalCHR(i1);
/* 645 */           if (this.kpncid != null)
/* 646 */             this.jmsClientId = this.meg.conv.CharBytesToString(this.kpncid, this.kpncid.length);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 665 */     return this.connection;
/*     */   }
/*     */ 
/*     */   ArrayList<String> getListenerAddresses()
/*     */   {
/* 677 */     return this.listenerAddresses;
/*     */   }
/*     */ 
/*     */   String getListenerAddress()
/*     */     throws SQLException
/*     */   {
/* 684 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 685 */     localSQLException.fillInStackTrace();
/* 686 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   long[] getRegistrationIdArray()
/*     */   {
/* 696 */     return this.registrationId;
/*     */   }
/*     */ 
/*     */   String getJMSClientId()
/*     */   {
/* 705 */     return this.jmsClientId;
/*     */   }
/*     */ 
/*     */   String[] getDatabaseInstances()
/*     */   {
/* 714 */     return this.databaseInstances;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIokpn
 * JD-Core Version:    0.6.2
 */