/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ final class T4CTTIokeyval extends T4CTTIfun
/*     */ {
/*     */   static final byte KVASET_KPDUSR = 1;
/*     */   static final byte KVACLA_KPDUSR = 2;
/*     */   private byte[] namespaceByteArr;
/*     */   private char[] charArr;
/*     */   private byte[][] attrArr;
/*     */   private int[] attrArrSize;
/*     */   private byte[][] valueArr;
/*     */   private int[] valueArrSize;
/*     */   private byte[] kvalflg;
/*     */   private int nbNamespaceBytes;
/*     */   private int nbKeyVal;
/*     */   private boolean clear;
/* 169 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIokeyval(T4CConnection paramT4CConnection)
/*     */   {
/*  57 */     super(paramT4CConnection, (byte)17);
/*     */ 
/*  59 */     setFunCode((short)154);
/*     */ 
/*  61 */     this.namespaceByteArr = new byte[100];
/*  62 */     this.charArr = new char[100];
/*     */ 
/*  64 */     this.attrArr = new byte[10][];
/*  65 */     this.attrArrSize = new int[10];
/*  66 */     this.valueArr = new byte[10][];
/*  67 */     this.valueArrSize = new int[10];
/*     */ 
/*  69 */     this.kvalflg = new byte[10];
/*     */   }
/*     */ 
/*     */   void doOKEYVAL(Namespace paramNamespace)
/*     */     throws IOException, SQLException
/*     */   {
/*  75 */     String str1 = paramNamespace.name;
/*  76 */     String[] arrayOfString1 = paramNamespace.keys;
/*  77 */     String[] arrayOfString2 = paramNamespace.values;
/*  78 */     this.clear = paramNamespace.clear;
/*  79 */     this.nbKeyVal = paramNamespace.nbPairs;
/*     */ 
/*  82 */     int i = str1.length() * this.meg.conv.cMaxCharSize;
/*  83 */     if (i > this.namespaceByteArr.length)
/*  84 */       this.namespaceByteArr = new byte[i];
/*  85 */     if (str1.length() > this.charArr.length)
/*  86 */       this.charArr = new char[str1.length()];
/*  87 */     str1.getChars(0, str1.length(), this.charArr, 0);
/*  88 */     this.nbNamespaceBytes = this.meg.conv.javaCharsToCHARBytes(this.charArr, 0, this.namespaceByteArr, 0, str1.length());
/*     */ 
/*  95 */     if (this.nbKeyVal > 0)
/*     */     {
/*  97 */       if (this.nbKeyVal > this.attrArr.length)
/*     */       {
/*  99 */         this.attrArr = new byte[this.nbKeyVal][];
/* 100 */         this.attrArrSize = new int[this.nbKeyVal];
/* 101 */         this.valueArr = new byte[this.nbKeyVal][];
/* 102 */         this.valueArrSize = new int[this.nbKeyVal];
/* 103 */         this.kvalflg = new byte[this.nbKeyVal];
/*     */       }
/*     */ 
/* 106 */       for (int j = 0; j < this.nbKeyVal; j++)
/*     */       {
/* 108 */         String str2 = arrayOfString1[j];
/* 109 */         String str3 = arrayOfString2[j];
/*     */ 
/* 111 */         int k = str2.length() * this.meg.conv.cMaxCharSize;
/* 112 */         if ((this.attrArr[j] == null) || (this.attrArr[j].length < k)) {
/* 113 */           this.attrArr[j] = new byte[k];
/*     */         }
/* 115 */         int m = str3.length() * this.meg.conv.cMaxCharSize;
/* 116 */         if ((this.valueArr[j] == null) || (this.valueArr[j].length < m)) {
/* 117 */           this.valueArr[j] = new byte[m];
/*     */         }
/* 119 */         if (str2.length() > this.charArr.length)
/* 120 */           this.charArr = new char[str2.length()];
/* 121 */         str2.getChars(0, str2.length(), this.charArr, 0);
/* 122 */         this.attrArrSize[j] = this.meg.conv.javaCharsToCHARBytes(this.charArr, 0, this.attrArr[j], 0, str2.length());
/*     */ 
/* 127 */         if (str3.length() > this.charArr.length)
/* 128 */           this.charArr = new char[str3.length()];
/* 129 */         str3.getChars(0, str3.length(), this.charArr, 0);
/* 130 */         this.valueArrSize[j] = this.meg.conv.javaCharsToCHARBytes(this.charArr, 0, this.valueArr[j], 0, str3.length());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 136 */     doPigRPC();
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 145 */     this.meg.marshalPTR();
/* 146 */     this.meg.marshalUB4(this.nbNamespaceBytes);
/* 147 */     if (this.nbKeyVal > 0)
/* 148 */       this.meg.marshalPTR();
/*     */     else
/* 150 */       this.meg.marshalNULLPTR();
/* 151 */     this.meg.marshalUB4(this.nbKeyVal);
/* 152 */     int i = 0;
/* 153 */     if (this.nbKeyVal > 0)
/* 154 */       i = 1;
/* 155 */     if (this.clear)
/* 156 */       i |= 2;
/* 157 */     this.meg.marshalUB2(i);
/* 158 */     this.meg.marshalNULLPTR();
/*     */ 
/* 162 */     this.meg.marshalCHR(this.namespaceByteArr, 0, this.nbNamespaceBytes);
/* 163 */     if (this.nbKeyVal > 0)
/* 164 */       this.meg.marshalKEYVAL(this.attrArr, this.attrArrSize, this.valueArr, this.valueArrSize, this.kvalflg, this.nbKeyVal);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIokeyval
 * JD-Core Version:    0.6.2
 */