/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ class T4CTTIoer extends T4CTTIMsg
/*     */ {
/* 162 */   final int MAXERRBUF = 512;
/*     */   long curRowNumber;
/*     */   int retCode;
/*     */   int arrayElemWError;
/*     */   int arrayElemErrno;
/*     */   int currCursorID;
/*     */   short errorPosition;
/*     */   short sqlType;
/*     */   byte oerFatal;
/*     */   short flags;
/*     */   short userCursorOpt;
/*     */   short upiParam;
/*     */   short warningFlag;
/*     */   int osError;
/*     */   short stmtNumber;
/*     */   short callNumber;
/*     */   int pad1;
/*     */   long successIters;
/*     */   int partitionId;
/*     */   int tableId;
/*     */   int slotNumber;
/*     */   long rba;
/*     */   long blockNumber;
/* 188 */   int warnLength = 0;
/* 189 */   int warnFlag = 0;
/*     */ 
/* 193 */   int[] errorLength = new int[1];
/*     */   byte[] errorMsg;
/*     */   static final int OERFNCF = 32;
/*     */   static final int ORA1403 = 1403;
/* 570 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIoer(T4CConnection paramT4CConnection)
/*     */   {
/* 209 */     super(paramT4CConnection, (byte)4);
/*     */   }
/*     */ 
/*     */   void init()
/*     */   {
/* 217 */     this.retCode = 0;
/* 218 */     this.errorMsg = null;
/*     */   }
/*     */ 
/*     */   int unmarshal()
/*     */     throws IOException, SQLException
/*     */   {
/* 233 */     if (this.connection.getTTCVersion() >= 3)
/*     */     {
/* 235 */       short s = (short)this.meg.unmarshalUB2();
/*     */ 
/* 237 */       this.connection.endToEndECIDSequenceNumber = s;
/*     */     }
/*     */ 
/* 240 */     this.curRowNumber = this.meg.unmarshalUB4();
/* 241 */     this.retCode = this.meg.unmarshalUB2();
/* 242 */     this.arrayElemWError = this.meg.unmarshalUB2();
/* 243 */     this.arrayElemErrno = this.meg.unmarshalUB2();
/* 244 */     this.currCursorID = this.meg.unmarshalUB2();
/* 245 */     this.errorPosition = this.meg.unmarshalSB2();
/* 246 */     this.sqlType = this.meg.unmarshalUB1();
/* 247 */     this.oerFatal = this.meg.unmarshalSB1();
/* 248 */     this.flags = ((short)this.meg.unmarshalSB1());
/*     */ 
/* 252 */     this.userCursorOpt = ((short)this.meg.unmarshalSB1());
/* 253 */     this.upiParam = this.meg.unmarshalUB1();
/* 254 */     this.warningFlag = this.meg.unmarshalUB1();
/*     */ 
/* 257 */     this.rba = this.meg.unmarshalUB4();
/* 258 */     this.partitionId = this.meg.unmarshalUB2();
/* 259 */     this.tableId = this.meg.unmarshalUB1();
/* 260 */     this.blockNumber = this.meg.unmarshalUB4();
/* 261 */     this.slotNumber = this.meg.unmarshalUB2();
/*     */ 
/* 263 */     this.osError = this.meg.unmarshalSWORD();
/* 264 */     this.stmtNumber = this.meg.unmarshalUB1();
/* 265 */     this.callNumber = this.meg.unmarshalUB1();
/* 266 */     this.pad1 = this.meg.unmarshalUB2();
/* 267 */     this.successIters = this.meg.unmarshalUB4();
/*     */ 
/* 278 */     byte[] arrayOfByte = this.meg.unmarshalDALC();
/*     */ 
/* 293 */     int i = this.meg.unmarshalUB2();
/* 294 */     for (int j = 0; j < i; j++)
/* 295 */       this.meg.unmarshalUB2();
/* 296 */     j = (int)this.meg.unmarshalUB4();
/* 297 */     for (int k = 0; k < j; k++)
/* 298 */       this.meg.unmarshalUB4();
/* 299 */     k = this.meg.unmarshalUB2();
/*     */ 
/* 302 */     if (this.retCode != 0)
/*     */     {
/* 304 */       this.errorMsg = this.meg.unmarshalCLRforREFS();
/* 305 */       this.errorLength[0] = this.errorMsg.length;
/*     */     }
/*     */ 
/* 309 */     return this.currCursorID;
/*     */   }
/*     */ 
/*     */   void unmarshalWarning()
/*     */     throws IOException, SQLException
/*     */   {
/* 317 */     this.retCode = this.meg.unmarshalUB2();
/* 318 */     this.warnLength = this.meg.unmarshalUB2();
/* 319 */     this.warnFlag = this.meg.unmarshalUB2();
/*     */ 
/* 322 */     if ((this.retCode != 0) && (this.warnLength > 0))
/*     */     {
/* 324 */       this.errorMsg = this.meg.unmarshalCHR(this.warnLength);
/* 325 */       this.errorLength[0] = this.warnLength;
/*     */     }
/*     */   }
/*     */ 
/*     */   void print()
/*     */     throws SQLException
/*     */   {
/* 369 */     if (this.retCode == 0)
/*     */     {
/* 374 */       if (this.warnFlag == 0);
/*     */     }
/*     */   }
/*     */ 
/*     */   void processError()
/*     */     throws SQLException
/*     */   {
/* 385 */     processError(true);
/*     */   }
/*     */ 
/*     */   void processError(boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 392 */     processError(paramBoolean, null);
/*     */   }
/*     */ 
/*     */   void processError(OracleStatement paramOracleStatement)
/*     */     throws SQLException
/*     */   {
/* 399 */     processError(true, paramOracleStatement);
/*     */   }
/*     */ 
/*     */   void processError(boolean paramBoolean, OracleStatement paramOracleStatement)
/*     */     throws SQLException
/*     */   {
/* 413 */     if (paramOracleStatement != null) {
/* 414 */       paramOracleStatement.numberOfExecutedElementsInBatch = ((int)this.successIters);
/*     */     }
/* 416 */     if (this.retCode != 0)
/*     */     {
/* 421 */       switch (this.retCode)
/*     */       {
/*     */       case 28:
/*     */       case 600:
/*     */       case 1012:
/*     */       case 1041:
/*     */       case 3113:
/*     */       case 3114:
/* 436 */         this.connection.internalClose();
/* 437 */         break;
/*     */       case 902:
/* 441 */         this.connection.removeAllDescriptor();
/*     */       }
/*     */ 
/* 445 */       if (paramBoolean)
/*     */       {
/* 449 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true), this.retCode);
/* 450 */         localSQLException1.fillInStackTrace();
/* 451 */         throw localSQLException1;
/*     */       }
/*     */ 
/* 454 */       return;
/*     */     }
/*     */ 
/* 460 */     if (!paramBoolean) {
/* 461 */       return;
/*     */     }
/*     */ 
/* 470 */     if ((this.warningFlag & 0x1) == 1)
/*     */     {
/* 472 */       int i = this.warningFlag & 0xFFFFFFFE;
/*     */ 
/* 475 */       if (((i & 0x20) == 32) || ((i & 0x4) == 4))
/*     */       {
/* 477 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 110);
/* 478 */         localSQLException2.fillInStackTrace();
/* 479 */         throw localSQLException2;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 484 */     if ((this.connection != null) && (this.connection.plsqlCompilerWarnings))
/*     */     {
/* 486 */       if ((this.flags & 0x4) == 4)
/* 487 */         paramOracleStatement.foundPlsqlCompilerWarning();
/*     */     }
/*     */   }
/*     */ 
/*     */   void processWarning()
/*     */     throws SQLException
/*     */   {
/* 503 */     if (this.retCode != 0)
/*     */     {
/* 507 */       throw DatabaseError.newSqlWarning(this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true), this.retCode);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getCurRowNumber()
/*     */     throws SQLException
/*     */   {
/* 520 */     return (int)this.curRowNumber;
/*     */   }
/*     */ 
/*     */   int getRetCode()
/*     */   {
/* 531 */     return this.retCode;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 546 */     return this.connection;
/*     */   }
/*     */ 
/*     */   long updateChecksum(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 553 */     paramLong = CRC64.updateChecksum(paramLong, this.retCode);
/* 554 */     paramLong = CRC64.updateChecksum(paramLong, this.curRowNumber);
/* 555 */     paramLong = CRC64.updateChecksum(paramLong, this.errorPosition);
/* 556 */     paramLong = CRC64.updateChecksum(paramLong, this.sqlType);
/* 557 */     paramLong = CRC64.updateChecksum(paramLong, this.oerFatal);
/* 558 */     paramLong = CRC64.updateChecksum(paramLong, this.flags);
/* 559 */     paramLong = CRC64.updateChecksum(paramLong, this.userCursorOpt);
/* 560 */     paramLong = CRC64.updateChecksum(paramLong, this.upiParam);
/* 561 */     paramLong = CRC64.updateChecksum(paramLong, this.warningFlag);
/* 562 */     paramLong = CRC64.updateChecksum(paramLong, this.osError);
/* 563 */     paramLong = CRC64.updateChecksum(paramLong, this.successIters);
/* 564 */     paramLong = CRC64.updateChecksum(paramLong, this.errorMsg, 0, this.errorMsg.length);
/* 565 */     return paramLong;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIoer
 * JD-Core Version:    0.6.2
 */