/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.UnsupportedEncodingException;
/*      */ import java.net.InetAddress;
/*      */ import java.security.NoSuchAlgorithmException;
/*      */ import java.security.spec.InvalidKeySpecException;
/*      */ import java.sql.DatabaseMetaData;
/*      */ import java.sql.SQLException;
/*      */ import java.util.Properties;
/*      */ import java.util.TimeZone;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.util.RepConversion;
/*      */ import oracle.net.ano.AuthenticationService;
/*      */ import oracle.net.ns.Communication;
/*      */ import oracle.net.ns.SessionAtts;
/*      */ import oracle.net.nt.TcpsNTAdapter;
/*      */ import oracle.security.o3logon.O3LoginClientHelper;
/*      */ import oracle.security.o5logon.O5Logon;
/*      */ import oracle.sql.ZONEIDMAP;
/*      */ import oracle.sql.converter.CharacterSetMetaData;
/*      */ 
/*      */ final class T4CTTIoauthenticate extends T4CTTIfun
/*      */ {
/*      */   byte[] terminal;
/*      */   byte[] enableTempLobRefCnt;
/*      */   byte[] machine;
/*      */   byte[] sysUserName;
/*      */   byte[] processID;
/*      */   byte[] programName;
/*      */   byte[] encryptedSK;
/*      */   byte[] internalName;
/*      */   byte[] externalName;
/*      */   byte[] alterSession;
/*      */   byte[] aclValue;
/*      */   byte[] clientname;
/*   90 */   byte[] editionName = null;
/*      */   byte[] driverName;
/*      */   String ressourceManagerId;
/*      */   boolean bUseO5Logon;
/*      */   int verifierType;
/*      */   static final int ZTVT_ORCL_7 = 2361;
/*      */   static final int ZTVT_SSH1 = 6949;
/*      */   static final int ZTVT_NTV = 7809;
/*      */   static final int ZTVT_SMD5 = 59694;
/*      */   static final int ZTVT_MD5 = 40674;
/*      */   static final int ZTVT_SH1 = 45394;
/*      */   static final int ZTVT_SHA512 = 18453;
/*      */   byte[] salt;
/*      */   byte[] encryptedKB;
/*  110 */   boolean isSessionTZ = true;
/*      */   static final int SERVER_VERSION_81 = 8100;
/*      */   static final int KPZ_LOGON = 1;
/*      */   static final int KPZ_CPW = 2;
/*      */   static final int KPZ_SRVAUTH = 4;
/*      */   static final int KPZ_ENCRYPTED_PASSWD = 256;
/*      */   static final int KPZ_LOGON_MIGRATE = 16;
/*      */   static final int KPZ_LOGON_SYSDBA = 32;
/*      */   static final int KPZ_LOGON_SYSOPER = 64;
/*      */   static final int KPZ_LOGON_PRELIMAUTH = 128;
/*      */   static final int KPZ_PASSWD_ENCRYPTED = 256;
/*      */   static final int KPZ_LOGON_DBCONC = 512;
/*      */   static final int KPZ_PROXY_AUTH = 1024;
/*      */   static final int KPZ_SESSION_CACHE = 2048;
/*      */   static final int KPZ_PASSWD_IS_VFR = 4096;
/*      */   static final int KPZ_LOGON_SYSASM = 4194304;
/*      */   static final int KPZ_SESSION_QCACHE = 8388608;
/*      */   static final int KPZ_LOGON_SYSBKP = 16777216;
/*      */   static final int KPZ_LOGON_SYSDGD = 33554432;
/*      */   static final int KPZ_LOGON_SYSKMT = 67108864;
/*      */   static final String AUTH_TERMINAL = "AUTH_TERMINAL";
/*      */   static final String AUTH_PROGRAM_NM = "AUTH_PROGRAM_NM";
/*      */   static final String AUTH_MACHINE = "AUTH_MACHINE";
/*      */   static final String AUTH_PID = "AUTH_PID";
/*      */   static final String AUTH_SID = "AUTH_SID";
/*      */   static final String AUTH_SESSKEY = "AUTH_SESSKEY";
/*      */   static final String AUTH_VFR_DATA = "AUTH_VFR_DATA";
/*      */   static final String AUTH_PASSWORD = "AUTH_PASSWORD";
/*      */   static final String AUTH_INTERNALNAME = "AUTH_INTERNALNAME_";
/*      */   static final String AUTH_EXTERNALNAME = "AUTH_EXTERNALNAME_";
/*      */   static final String AUTH_ACL = "AUTH_ACL";
/*      */   static final String AUTH_ALTER_SESSION = "AUTH_ALTER_SESSION";
/*      */   static final String AUTH_INITIAL_CLIENT_ROLE = "INITIAL_CLIENT_ROLE";
/*      */   static final String AUTH_VERSION_SQL = "AUTH_VERSION_SQL";
/*      */   static final String AUTH_VERSION_NO = "AUTH_VERSION_NO";
/*      */   static final String AUTH_XACTION_TRAITS = "AUTH_XACTION_TRAITS";
/*      */   static final String AUTH_VERSION_STATUS = "AUTH_VERSION_STATUS";
/*      */   static final String AUTH_SERIAL_NUM = "AUTH_SERIAL_NUM";
/*      */   static final String AUTH_SESSION_ID = "AUTH_SESSION_ID";
/*      */   static final String AUTH_CLIENT_CERTIFICATE = "AUTH_CLIENT_CERTIFICATE";
/*      */   static final String AUTH_PROXY_CLIENT_NAME = "PROXY_CLIENT_NAME";
/*      */   static final String AUTH_CLIENT_DN = "AUTH_CLIENT_DISTINGUISHED_NAME";
/*      */   static final String AUTH_INSTANCENAME = "AUTH_INSTANCENAME";
/*      */   static final String AUTH_DBNAME = "AUTH_DBNAME";
/*      */   static final String AUTH_INSTANCE_NO = "AUTH_INSTANCE_NO";
/*      */   static final String AUTH_DB_ID = "AUTH_DB_ID";
/*      */   static final String AUTH_SC_SERVER_HOST = "AUTH_SC_SERVER_HOST";
/*      */   static final String AUTH_SC_INSTANCE_NAME = "AUTH_SC_INSTANCE_NAME";
/*      */   static final String AUTH_SC_INSTANCE_ID = "AUTH_SC_INSTANCE_ID";
/*      */   static final String AUTH_SC_INSTANCE_START_TIME = "AUTH_SC_INSTANCE_START_TIME";
/*      */   static final String AUTH_SC_DBUNIQUE_NAME = "AUTH_SC_DBUNIQUE_NAME";
/*      */   static final String AUTH_SC_SERVICE_NAME = "AUTH_SC_SERVICE_NAME";
/*      */   static final String AUTH_SC_SVC_FLAGS = "AUTH_SC_SVC_FLAGS";
/*      */   static final String AUTH_SC_DB_DOMAIN = "AUTH_SC_DB_DOMAIN";
/*      */   static final String AUTH_SESSION_CLIENT_CSET = "SESSION_CLIENT_CHARSET";
/*      */   static final String AUTH_SESSION_CLIENT_LTYPE = "SESSION_CLIENT_LIB_TYPE";
/*      */   static final String AUTH_SESSION_CLIENT_DRVNM = "SESSION_CLIENT_DRIVER_NAME";
/*      */   static final String AUTH_SESSION_CLIENT_VSN = "SESSION_CLIENT_VERSION";
/*      */   static final String AUTH_NLS_LXLAN = "AUTH_NLS_LXLAN";
/*      */   static final String AUTH_NLS_LXCTERRITORY = "AUTH_NLS_LXCTERRITORY";
/*      */   static final String AUTH_NLS_LXCCURRENCY = "AUTH_NLS_LXCCURRENCY";
/*      */   static final String AUTH_NLS_LXCISOCURR = "AUTH_NLS_LXCISOCURR";
/*      */   static final String AUTH_NLS_LXCNUMERICS = "AUTH_NLS_LXCNUMERICS";
/*      */   static final String AUTH_NLS_LXCDATEFM = "AUTH_NLS_LXCDATEFM";
/*      */   static final String AUTH_NLS_LXCDATELANG = "AUTH_NLS_LXCDATELANG";
/*      */   static final String AUTH_NLS_LXCSORT = "AUTH_NLS_LXCSORT";
/*      */   static final String AUTH_NLS_LXCCALENDAR = "AUTH_NLS_LXCCALENDAR";
/*      */   static final String AUTH_NLS_LXCUNIONCUR = "AUTH_NLS_LXCUNIONCUR";
/*      */   static final String AUTH_NLS_LXCTIMEFM = "AUTH_NLS_LXCTIMEFM";
/*      */   static final String AUTH_NLS_LXCSTMPFM = "AUTH_NLS_LXCSTMPFM";
/*      */   static final String AUTH_NLS_LXCTTZNFM = "AUTH_NLS_LXCTTZNFM";
/*      */   static final String AUTH_NLS_LXCSTZNFM = "AUTH_NLS_LXCSTZNFM";
/*      */   static final String SESSION_CLIENT_LOBATTR = "SESSION_CLIENT_LOBATTR";
/*      */   static final String AUTH_KPPL_CONN_CLASS = "AUTH_KPPL_CONN_CLASS";
/*      */   static final String AUTH_KPPL_PURITY = "AUTH_KPPL_PURITY";
/*      */   static final String AUTH_KPPL_TAG = "AUTH_KPPL_TAG";
/*      */   static final String AUTH_KPPL_WAIT = "AUTH_KPPL_WAIT";
/*      */   static final String KPPL_PURITY_DEFAULT = "0";
/*      */   static final String KPPL_PURITY_NEW = "1";
/*      */   static final String KPPL_PURITY_SELF = "2";
/*      */   static final String AUTH_CONNECT_STRING = "AUTH_CONNECT_STRING";
/*      */   static final String DRIVER_NAME_DEFAULT = "jdbcthin";
/*      */   static final int KPU_LIB_UNKN = 0;
/*      */   static final int KPU_LIB_DEF = 1;
/*      */   static final int KPU_LIB_EI = 2;
/*      */   static final int KPU_LIB_XE = 3;
/*      */   static final int KPU_LIB_ICUS = 4;
/*      */   static final int KPU_LIB_OCI = 5;
/*      */   static final int KPU_LIB_THIN = 10;
/*      */   static final String AUTH_ORA_EDITION = "AUTH_ORA_EDITION";
/*      */   static final String AUTH_COPYRIGHT = "AUTH_COPYRIGHT";
/*      */   static final String COPYRIGHT_STR = "\"Oracle\nEverybody follows\nSpeedy bits exchange\nStars await to glow\"\nThe preceding key is copyrighted by Oracle Corporation.\nDuplication of this key is not allowed without permission\nfrom Oracle Corporation. Copyright 2003 Oracle Corporation.";
/*      */   static final String SESSION_TIME_ZONE = "SESSION_TIME_ZONE";
/*      */   static final String SESSION_NLS_LXCCHARSET = "SESSION_NLS_LXCCHARSET";
/*      */   static final String SESSION_NLS_LXCNLSLENSEM = "SESSION_NLS_LXCNLSLENSEM";
/*      */   static final String SESSION_NLS_LXCNCHAREXCP = "SESSION_NLS_LXCNCHAREXCP";
/*      */   static final String SESSION_NLS_LXCNCHARIMP = "SESSION_NLS_LXCNCHARIMP";
/*      */   public static final int AUTH_FLAG_O5LOGON = 0;
/*      */   public static final int AUTH_FLAG_NONO5LOGON = 1;
/*  246 */   String sessionTimeZone = null;
/*  247 */   byte[] serverCompileTimeCapabilities = null;
/*      */ 
/*  267 */   private T4CKvaldfList keyValList = null;
/*  268 */   private byte[] user = null;
/*      */   private long logonMode;
/*  272 */   private byte[][] outKeys = (byte[][])null;
/*  273 */   private byte[][] outValues = (byte[][])null;
/*  274 */   private int[] outFlags = new int[0];
/*  275 */   private int outNbPairs = 0;
/*      */ 
/*  610 */   O5Logon o5logonHelper = new O5Logon();
/*      */ 
/* 1190 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   T4CTTIoauthenticate(T4CConnection paramT4CConnection, String paramString, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  253 */     super(paramT4CConnection, (byte)3);
/*      */ 
/*  255 */     this.ressourceManagerId = paramString;
/*  256 */     this.serverCompileTimeCapabilities = paramArrayOfByte;
/*  257 */     setSessionFields(paramT4CConnection);
/*      */ 
/*  261 */     this.isSessionTZ = true;
/*      */ 
/*  263 */     this.bUseO5Logon = false;
/*      */   }
/*      */ 
/*      */   void marshal()
/*      */     throws IOException
/*      */   {
/*  281 */     if ((this.user != null) && (this.user.length > 0))
/*      */     {
/*  283 */       this.meg.marshalPTR();
/*  284 */       this.meg.marshalSB4(this.user.length);
/*      */     }
/*      */     else
/*      */     {
/*  288 */       this.meg.marshalNULLPTR();
/*  289 */       this.meg.marshalSB4(0);
/*      */     }
/*  291 */     this.meg.marshalUB4(this.logonMode);
/*  292 */     this.meg.marshalPTR();
/*      */ 
/*  294 */     this.meg.marshalUB4(this.keyValList.size());
/*  295 */     this.meg.marshalPTR();
/*  296 */     this.meg.marshalPTR();
/*      */ 
/*  299 */     if ((this.user != null) && (this.user.length > 0))
/*  300 */       this.meg.marshalCHR(this.user);
/*  301 */     this.meg.marshalKEYVAL(this.keyValList.getKeys(), this.keyValList.getValues(), this.keyValList.getFlags(), this.keyValList.size());
/*      */   }
/*      */ 
/*      */   private void doOAUTH(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long paramLong, String paramString, boolean paramBoolean, byte[] paramArrayOfByte3, byte[] paramArrayOfByte4, byte[][] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws IOException, SQLException
/*      */   {
/*  317 */     setFunCode((short)115);
/*      */ 
/*  319 */     this.user = paramArrayOfByte1;
/*      */ 
/*  322 */     this.logonMode = (paramLong | 1L);
/*      */ 
/*  325 */     if (paramBoolean) {
/*  326 */       this.logonMode |= 1024L;
/*      */     }
/*  328 */     if ((paramArrayOfByte1 != null) && (paramArrayOfByte1.length != 0) && (paramArrayOfByte2 != null) && (paramString != "RADIUS"))
/*      */     {
/*  332 */       this.logonMode |= 256L;
/*      */     }
/*  334 */     this.keyValList = new T4CKvaldfList(this.meg.conv);
/*      */ 
/*  336 */     if (paramArrayOfByte2 != null) {
/*  337 */       this.keyValList.add("AUTH_PASSWORD", paramArrayOfByte2);
/*      */     }
/*  339 */     if (paramArrayOfByte != null) {
/*  340 */       for (int i = 0; i < paramArrayOfByte.length; i++)
/*  341 */         this.keyValList.add("INITIAL_CLIENT_ROLE", paramArrayOfByte[i]);
/*      */     }
/*  343 */     if (paramArrayOfByte3 != null) {
/*  344 */       this.keyValList.add("AUTH_CLIENT_DISTINGUISHED_NAME", paramArrayOfByte3);
/*      */     }
/*  346 */     if (paramArrayOfByte4 != null) {
/*  347 */       this.keyValList.add("AUTH_CLIENT_CERTIFICATE", paramArrayOfByte4);
/*      */     }
/*  349 */     this.keyValList.add("AUTH_TERMINAL", this.terminal);
/*      */ 
/*  351 */     if ((this.bUseO5Logon) && (this.encryptedKB != null)) {
/*  352 */       this.keyValList.add("AUTH_SESSKEY", this.encryptedKB, (byte)1);
/*      */     }
/*  354 */     if (this.programName != null) {
/*  355 */       this.keyValList.add("AUTH_PROGRAM_NM", this.programName);
/*      */     }
/*  357 */     if (this.clientname != null) {
/*  358 */       this.keyValList.add("PROXY_CLIENT_NAME", this.clientname);
/*      */     }
/*  360 */     this.keyValList.add("AUTH_MACHINE", this.machine);
/*  361 */     this.keyValList.add("AUTH_PID", this.processID);
/*      */ 
/*  363 */     if (!this.ressourceManagerId.equals("0000"))
/*      */     {
/*  365 */       byte[] arrayOfByte = this.meg.conv.StringToCharBytes("AUTH_INTERNALNAME_");
/*      */ 
/*  368 */       arrayOfByte[(arrayOfByte.length - 1)] = 0;
/*  369 */       this.keyValList.add(arrayOfByte, this.internalName);
/*      */ 
/*  371 */       arrayOfByte = this.meg.conv.StringToCharBytes("AUTH_EXTERNALNAME_");
/*  372 */       arrayOfByte[(arrayOfByte.length - 1)] = 0;
/*  373 */       this.keyValList.add(arrayOfByte, this.externalName);
/*      */     }
/*      */ 
/*  376 */     this.keyValList.add("AUTH_ACL", this.aclValue);
/*      */ 
/*  378 */     this.keyValList.add("AUTH_ALTER_SESSION", this.alterSession, (byte)1);
/*      */ 
/*  380 */     if (this.editionName != null) {
/*  381 */       this.keyValList.add("AUTH_ORA_EDITION", this.editionName);
/*      */     }
/*      */ 
/*  385 */     this.keyValList.add("SESSION_CLIENT_LOBATTR", this.enableTempLobRefCnt);
/*      */ 
/*  387 */     this.keyValList.add("SESSION_CLIENT_DRIVER_NAME", this.driverName);
/*  388 */     this.keyValList.add("SESSION_CLIENT_VERSION", this.meg.conv.StringToCharBytes(Integer.toString(versionStringToInt(this.connection.getMetaData().getDriverVersion()), 10)));
/*      */ 
/*  390 */     if (paramInt1 != -1) {
/*  391 */       this.keyValList.add("AUTH_SESSION_ID", this.meg.conv.StringToCharBytes(Integer.toString(paramInt1)));
/*      */     }
/*  393 */     if (paramInt2 != -1) {
/*  394 */       this.keyValList.add("AUTH_SERIAL_NUM", this.meg.conv.StringToCharBytes(Integer.toString(paramInt2)));
/*      */     }
/*  396 */     if (this.connection.drcpEnabled) {
/*  397 */       this.keyValList.add("AUTH_KPPL_CONN_CLASS", this.meg.conv.StringToCharBytes(this.connection.drcpConnectionClass));
/*  398 */       this.keyValList.add("AUTH_KPPL_PURITY", this.meg.conv.StringToCharBytes("2"));
/*  399 */       if (this.connection.drcpTagName != null) {
/*  400 */         this.keyValList.add("AUTH_KPPL_TAG", this.meg.conv.StringToCharBytes(this.connection.drcpTagName));
/*      */       }
/*      */     }
/*  403 */     this.keyValList.add("AUTH_CONNECT_STRING", this.meg.conv.StringToCharBytes(this.connection.net.getConnectionString()));
/*      */ 
/*  405 */     this.keyValList.add("AUTH_COPYRIGHT", this.meg.conv.StringToCharBytes("\"Oracle\nEverybody follows\nSpeedy bits exchange\nStars await to glow\"\nThe preceding key is copyrighted by Oracle Corporation.\nDuplication of this key is not allowed without permission\nfrom Oracle Corporation. Copyright 2003 Oracle Corporation."));
/*      */ 
/*  407 */     this.outNbPairs = 0;
/*  408 */     this.outKeys = ((byte[][])null);
/*  409 */     this.outValues = ((byte[][])null);
/*  410 */     this.outFlags = new int[0];
/*      */ 
/*  412 */     doRPC();
/*      */   }
/*      */ 
/*      */   void doOSESSKEY(String paramString, long paramLong)
/*      */     throws IOException, SQLException
/*      */   {
/*  420 */     setFunCode((short)118);
/*  421 */     this.user = this.meg.conv.StringToCharBytes(paramString);
/*  422 */     this.logonMode = (paramLong | 1L);
/*      */ 
/*  424 */     this.keyValList = new T4CKvaldfList(this.meg.conv);
/*  425 */     this.keyValList.add("AUTH_TERMINAL", this.terminal);
/*  426 */     if (this.programName != null)
/*  427 */       this.keyValList.add("AUTH_PROGRAM_NM", this.programName);
/*  428 */     this.keyValList.add("AUTH_MACHINE", this.machine);
/*  429 */     this.keyValList.add("AUTH_PID", this.processID);
/*  430 */     this.keyValList.add("AUTH_SID", this.sysUserName);
/*  431 */     this.outNbPairs = 0;
/*  432 */     this.outKeys = ((byte[][])null);
/*  433 */     this.outValues = ((byte[][])null);
/*  434 */     this.outFlags = new int[0];
/*  435 */     doRPC();
/*      */   }
/*      */ 
/*      */   void readRPA()
/*      */     throws IOException, SQLException
/*      */   {
/*  447 */     this.outNbPairs = this.meg.unmarshalUB2();
/*      */ 
/*  449 */     this.outKeys = new byte[this.outNbPairs][];
/*  450 */     this.outValues = new byte[this.outNbPairs][];
/*      */ 
/*  453 */     this.outFlags = this.meg.unmarshalKEYVAL(this.outKeys, this.outValues, this.outNbPairs);
/*      */   }
/*      */ 
/*      */   void processError()
/*      */     throws SQLException
/*      */   {
/*  460 */     if (getFunCode() == 118)
/*      */     {
/*  462 */       if ((this.oer.getRetCode() != 28035) || (this.connection.net.getAuthenticationAdaptorName() != "RADIUS"))
/*      */       {
/*  472 */         this.oer.processError();
/*      */       }
/*      */     }
/*      */     else
/*  476 */       super.processError();
/*      */   }
/*      */ 
/*      */   protected void processRPA()
/*      */     throws SQLException
/*      */   {
/*      */     Object localObject;
/*      */     String str3;
/*  483 */     if (getFunCode() == 115)
/*      */     {
/*  489 */       localObject = new Properties();
/*      */ 
/*  491 */       for (int j = 0; j < this.outNbPairs; j++)
/*      */       {
/*  493 */         String str2 = this.meg.conv.CharBytesToString(this.outKeys[j], this.outKeys[j].length).trim();
/*  494 */         str3 = "";
/*  495 */         if (this.outValues[j] != null) {
/*  496 */           str3 = this.meg.conv.CharBytesToString(this.outValues[j], this.outValues[j].length).trim();
/*      */         }
/*  498 */         ((Properties)localObject).setProperty(str2, str3);
/*      */       }
/*      */ 
/*  501 */       String str1 = ((Properties)localObject).getProperty("AUTH_VERSION_NO");
/*      */ 
/*  504 */       if (str1 != null)
/*      */       {
/*      */         try
/*      */         {
/*  508 */           int m = new Integer(str1).intValue();
/*      */         }
/*      */         catch (NumberFormatException localNumberFormatException)
/*      */         {
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  516 */       ((Properties)localObject).setProperty("SERVER_HOST", ((Properties)localObject).getProperty("AUTH_SC_SERVER_HOST", ""));
/*      */ 
/*  520 */       ((Properties)localObject).setProperty("INSTANCE_NAME", ((Properties)localObject).getProperty("AUTH_SC_INSTANCE_NAME", ""));
/*      */ 
/*  524 */       ((Properties)localObject).setProperty("DATABASE_NAME", ((Properties)localObject).getProperty("AUTH_SC_DBUNIQUE_NAME", ""));
/*      */ 
/*  528 */       ((Properties)localObject).setProperty("SERVICE_NAME", ((Properties)localObject).getProperty("AUTH_SC_SERVICE_NAME", ""));
/*      */ 
/*  532 */       ((Properties)localObject).setProperty("SESSION_TIME_ZONE", this.sessionTimeZone);
/*      */ 
/*  534 */       this.connection.sessionProperties = ((Properties)localObject);
/*      */     }
/*  536 */     else if (getFunCode() == 118)
/*      */     {
/*  538 */       if (this.connection.net.getAuthenticationAdaptorName() != "RADIUS")
/*      */       {
/*  541 */         if ((this.outKeys == null) || (this.outKeys.length < 1))
/*      */         {
/*  543 */           localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 438);
/*  544 */           ((SQLException)localObject).fillInStackTrace();
/*  545 */           throw ((Throwable)localObject);
/*      */         }
/*      */ 
/*  552 */         int i = -1;
/*  553 */         int k = -1;
/*      */         try
/*      */         {
/*  557 */           for (int n = 0; n < this.outKeys.length; n++)
/*      */           {
/*  559 */             str3 = new String(this.outKeys[n], "US-ASCII");
/*      */ 
/*  561 */             if (str3.equals("AUTH_SESSKEY"))
/*      */             {
/*  563 */               i = n;
/*      */             }
/*  565 */             else if (str3.equals("AUTH_VFR_DATA"))
/*      */             {
/*  567 */               k = n;
/*      */             }
/*      */ 
/*  570 */             if ((k != -1) && (i != -1))
/*      */               break;
/*      */           }
/*      */         }
/*      */         catch (UnsupportedEncodingException localUnsupportedEncodingException)
/*      */         {
/*      */         }
/*      */         SQLException localSQLException;
/*  578 */         if (i == -1)
/*      */         {
/*  580 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 438);
/*  581 */           localSQLException.fillInStackTrace();
/*  582 */           throw localSQLException;
/*      */         }
/*      */ 
/*  585 */         this.encryptedSK = this.outValues[i];
/*      */ 
/*  587 */         if (k != -1)
/*      */         {
/*  589 */           this.bUseO5Logon = true;
/*  590 */           this.salt = this.outValues[k];
/*  591 */           this.verifierType = this.outFlags[k];
/*      */         }
/*      */ 
/*  594 */         if (!this.bUseO5Logon)
/*      */         {
/*  597 */           if ((this.encryptedSK == null) || (this.encryptedSK.length != 16))
/*      */           {
/*  599 */             localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 438);
/*  600 */             localSQLException.fillInStackTrace();
/*  601 */             throw localSQLException;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void doOAUTH(String paramString1, String paramString2, long paramLong)
/*      */     throws IOException, SQLException
/*      */   {
/*  614 */     byte[] arrayOfByte1 = null;
/*  615 */     if ((paramString1 != null) && (paramString1.length() > 0)) {
/*  616 */       arrayOfByte1 = this.meg.conv.StringToCharBytes(paramString1);
/*      */     }
/*  618 */     byte[] arrayOfByte2 = null;
/*  619 */     byte[] arrayOfByte3 = null;
/*  620 */     byte[] arrayOfByte4 = null;
/*      */ 
/*  622 */     String str1 = this.connection.net.getAuthenticationAdaptorName();
/*      */     Object localObject1;
/*      */     Object localObject2;
/*  626 */     if ((paramString1 != null) && (paramString1.length() != 0))
/*      */     {
/*  631 */       if ((str1 != "RADIUS") && (this.encryptedSK.length > 16) && (!this.bUseO5Logon))
/*      */       {
/*  635 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 413);
/*  636 */         ((SQLException)localObject1).fillInStackTrace();
/*  637 */         throw ((Throwable)localObject1);
/*      */       }
/*      */ 
/*  640 */       if ((this.bUseO5Logon) && ((this.encryptedSK == null) || ((this.encryptedSK.length != 64) && (this.encryptedSK.length != 96))))
/*      */       {
/*  643 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 413);
/*  644 */         ((SQLException)localObject1).fillInStackTrace();
/*  645 */         throw ((Throwable)localObject1);
/*      */       }
/*      */ 
/*  655 */       localObject1 = paramString1.trim();
/*  656 */       localObject2 = null;
/*  657 */       if (paramString2 != null)
/*      */       {
/*  660 */         localObject2 = paramString2.trim();
/*      */       }
/*  662 */       paramString2 = null;
/*      */ 
/*  664 */       Object localObject3 = localObject1;
/*  665 */       Object localObject4 = localObject2;
/*      */ 
/*  667 */       if ((((String)localObject1).startsWith("\"")) || (((String)localObject1).endsWith("\""))) {
/*  668 */         localObject3 = removeQuotes((String)localObject1);
/*      */       }
/*  670 */       if ((localObject2 != null) && (((String)localObject2).startsWith("\"")) && (((String)localObject2).endsWith("\"")))
/*      */       {
/*  672 */         localObject4 = removeQuotes((String)localObject2);
/*      */       }
/*      */ 
/*  678 */       if (localObject4 != null)
/*  679 */         arrayOfByte2 = this.meg.conv.StringToCharBytes((String)localObject4);
/*      */       Object localObject5;
/*  681 */       if (str1 != "RADIUS")
/*      */       {
/*  683 */         if (arrayOfByte2 == null)
/*      */         {
/*  685 */           arrayOfByte4 = null;
/*      */         }
/*      */         else
/*      */         {
/*      */           byte[] arrayOfByte5;
/*  687 */           if (this.bUseO5Logon)
/*      */           {
/*  689 */             if ((this.verifierType != 2361) && (this.verifierType != 40674) && (this.verifierType != 59694) && (this.verifierType != 45394) && (this.verifierType != 6949) && (this.verifierType != 18453))
/*      */             {
/*  699 */               SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 451);
/*  700 */               localSQLException1.fillInStackTrace();
/*  701 */               throw localSQLException1;
/*      */             }
/*      */ 
/*  705 */             this.encryptedKB = new byte[this.encryptedSK.length];
/*  706 */             for (int k = 0; k < this.encryptedKB.length; k++) this.encryptedKB[k] = 1;
/*      */ 
/*  708 */             localObject5 = new int[1];
/*  709 */             arrayOfByte5 = new byte[256];
/*  710 */             for (int n = 0; n < 256; n++) arrayOfByte5[n] = 0;
/*      */             try
/*      */             {
/*  713 */               this.o5logonHelper.generateOAuthResponse(this.verifierType, this.salt, (String)localObject3, (String)localObject4, arrayOfByte2, this.encryptedSK, this.encryptedKB, arrayOfByte5, (int[])localObject5, this.meg.conv.isServerCSMultiByte, this.serverCompileTimeCapabilities[4]);
/*      */             }
/*      */             catch (Exception localException2)
/*      */             {
/*      */             }
/*      */ 
/*  735 */             arrayOfByte4 = new byte[localObject5[0]];
/*  736 */             System.arraycopy(arrayOfByte5, 0, arrayOfByte4, 0, localObject5[0]);
/*      */           }
/*      */           else
/*      */           {
/*  740 */             localObject5 = new O3LoginClientHelper(this.meg.conv.isServerCSMultiByte);
/*      */ 
/*  742 */             arrayOfByte5 = ((O3LoginClientHelper)localObject5).getSessionKey((String)localObject3, (String)localObject4, this.encryptedSK);
/*      */             int i;
/*  748 */             if (arrayOfByte2.length % 8 > 0)
/*  749 */               i = (byte)(8 - arrayOfByte2.length % 8);
/*      */             else {
/*  751 */               i = 0;
/*      */             }
/*  753 */             arrayOfByte3 = new byte[arrayOfByte2.length + i];
/*      */ 
/*  755 */             System.arraycopy(arrayOfByte2, 0, arrayOfByte3, 0, arrayOfByte2.length);
/*      */ 
/*  760 */             byte[] arrayOfByte6 = ((O3LoginClientHelper)localObject5).getEPasswd(arrayOfByte5, arrayOfByte3);
/*      */ 
/*  763 */             arrayOfByte4 = new byte[2 * arrayOfByte3.length + 1];
/*      */ 
/*  766 */             if (arrayOfByte4.length < 2 * arrayOfByte6.length)
/*      */             {
/*  768 */               SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 413);
/*  769 */               localSQLException2.fillInStackTrace();
/*  770 */               throw localSQLException2;
/*      */             }
/*      */ 
/*  773 */             RepConversion.bArray2Nibbles(arrayOfByte6, arrayOfByte4);
/*      */ 
/*  776 */             arrayOfByte4[(arrayOfByte4.length - 1)] = RepConversion.nibbleToHex(i);
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*  782 */       else if (arrayOfByte2 != null)
/*      */       {
/*  784 */         if ((this.connection.net.getSessionAttributes().getNTAdapter() instanceof TcpsNTAdapter))
/*      */         {
/*  786 */           arrayOfByte4 = arrayOfByte2;
/*      */         }
/*      */         else
/*      */         {
/*      */           int j;
/*  794 */           if ((arrayOfByte2.length + 1) % 8 > 0)
/*  795 */             j = (byte)(8 - (arrayOfByte2.length + 1) % 8);
/*      */           else {
/*  797 */             j = 0;
/*      */           }
/*  799 */           arrayOfByte3 = new byte[arrayOfByte2.length + 1 + j];
/*      */ 
/*  801 */           System.arraycopy(arrayOfByte2, 0, arrayOfByte3, 0, arrayOfByte2.length);
/*  802 */           localObject5 = AuthenticationService.obfuscatePasswordForRadius(arrayOfByte3);
/*      */ 
/*  805 */           arrayOfByte4 = new byte[localObject5.length * 2];
/*      */ 
/*  807 */           for (int i2 = 0; i2 < localObject5.length; i2++)
/*      */           {
/*  809 */             int m = (byte)((localObject5[i2] & 0xF0) >> 4);
/*  810 */             int i1 = (byte)(localObject5[i2] & 0xF);
/*  811 */             arrayOfByte4[(i2 * 2)] = ((byte)(m < 10 ? m + 48 : m - 10 + 97));
/*      */ 
/*  813 */             arrayOfByte4[(i2 * 2 + 1)] = ((byte)(i1 < 10 ? i1 + 48 : i1 - 10 + 97));
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  821 */     doOAUTH(arrayOfByte1, arrayOfByte4, paramLong, str1, false, null, null, (byte[][])null, -1, -1);
/*      */ 
/*  832 */     if ((str1 != "RADIUS") && (this.bUseO5Logon))
/*      */     {
/*  834 */       String str2 = this.connection.sessionProperties.getProperty("AUTH_SVR_RESPONSE");
/*      */       try {
/*  836 */         if (!this.o5logonHelper.validateServerIdentity(str2))
/*      */         {
/*  839 */           localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 452);
/*  840 */           ((SQLException)localObject1).fillInStackTrace();
/*  841 */           throw ((Throwable)localObject1);
/*      */         }
/*      */       }
/*      */       catch (Exception localException1)
/*      */       {
/*  846 */         localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 452);
/*  847 */         ((SQLException)localObject2).fillInStackTrace();
/*  848 */         throw ((Throwable)localObject2);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void doOAUTH(int paramInt1, Properties paramProperties, int paramInt2, int paramInt3)
/*      */     throws IOException, SQLException
/*      */   {
/*  860 */     byte[] arrayOfByte1 = null;
/*  861 */     byte[] arrayOfByte2 = null;
/*  862 */     String[] arrayOfString = null;
/*  863 */     Object localObject1 = (byte[][])null;
/*  864 */     byte[] arrayOfByte3 = null;
/*      */     Object localObject2;
/*      */     String str;
/*  866 */     if (paramInt1 == 1)
/*      */     {
/*  868 */       localObject2 = paramProperties.getProperty("PROXY_USER_NAME");
/*  869 */       str = paramProperties.getProperty("PROXY_USER_PASSWORD");
/*  870 */       if (str != null)
/*  871 */         localObject2 = new StringBuilder().append((String)localObject2).append("/").append(str).toString();
/*  872 */       arrayOfByte3 = this.meg.conv.StringToCharBytes((String)localObject2);
/*      */     }
/*  874 */     else if (paramInt1 == 2)
/*      */     {
/*  876 */       localObject2 = paramProperties.getProperty("PROXY_DISTINGUISHED_NAME");
/*      */ 
/*  879 */       arrayOfByte1 = this.meg.conv.StringToCharBytes((String)localObject2);
/*      */     }
/*      */     else
/*      */     {
/*      */       try
/*      */       {
/*  885 */         arrayOfByte2 = (byte[])paramProperties.get("PROXY_CERTIFICATE");
/*      */ 
/*  887 */         localObject2 = new StringBuffer();
/*      */ 
/*  891 */         for (int k = 0; k < arrayOfByte2.length; k++)
/*      */         {
/*  893 */           str = Integer.toHexString(0xFF & arrayOfByte2[k]);
/*  894 */           int j = str.length();
/*      */ 
/*  896 */           if (j == 0) {
/*  897 */             ((StringBuffer)localObject2).append("00");
/*  898 */           } else if (j == 1)
/*      */           {
/*  900 */             ((StringBuffer)localObject2).append('0');
/*  901 */             ((StringBuffer)localObject2).append(str);
/*      */           }
/*      */           else {
/*  904 */             ((StringBuffer)localObject2).append(str);
/*      */           }
/*      */         }
/*  907 */         arrayOfByte2 = ((StringBuffer)localObject2).toString().getBytes();
/*      */       }
/*      */       catch (Exception localException1)
/*      */       {
/*      */       }
/*      */     }
/*      */     try
/*      */     {
/*  915 */       arrayOfString = (String[])paramProperties.get("PROXY_ROLES");
/*      */     }
/*      */     catch (Exception localException2) {
/*      */     }
/*  919 */     if (arrayOfString != null)
/*      */     {
/*  921 */       localObject1 = new byte[arrayOfString.length][];
/*      */ 
/*  923 */       for (int i = 0; i < arrayOfString.length; i++) {
/*  924 */         localObject1[i] = this.meg.conv.StringToCharBytes(arrayOfString[i]);
/*      */       }
/*      */     }
/*  927 */     doOAUTH(arrayOfByte3, null, 0L, null, true, arrayOfByte1, arrayOfByte2, (byte[][])localObject1, paramInt2, paramInt3);
/*      */   }
/*      */ 
/*      */   private void setSessionFields(T4CConnection paramT4CConnection)
/*      */     throws SQLException
/*      */   {
/*  951 */     String str1 = this.connection.thinVsessionTerminal;
/*  952 */     String str2 = this.connection.thinVsessionMachine;
/*  953 */     String str3 = this.connection.thinVsessionOsuser;
/*  954 */     String str4 = this.connection.thinVsessionProgram;
/*  955 */     String str5 = this.connection.thinVsessionProcess;
/*  956 */     String str6 = this.connection.thinVsessionIname;
/*  957 */     String str7 = this.connection.thinVsessionEname;
/*  958 */     String str8 = this.connection.proxyClientName;
/*  959 */     String str9 = this.connection.driverNameAttribute;
/*  960 */     String str10 = this.connection.editionName;
/*      */ 
/*  971 */     if (this.connection.enableTempLobRefCnt)
/*  972 */       this.enableTempLobRefCnt = new String("1").getBytes();
/*      */     else {
/*  974 */       this.enableTempLobRefCnt = new String("0").getBytes();
/*      */     }
/*  976 */     if (str2 == null)
/*      */     {
/*      */       try
/*      */       {
/*  981 */         str2 = InetAddress.getLocalHost().getHostName();
/*      */       }
/*      */       catch (Exception localException)
/*      */       {
/*  985 */         str2 = "jdbcclient";
/*      */       }
/*      */     }
/*      */ 
/*  989 */     if (str7 == null) {
/*  990 */       str7 = new StringBuilder().append("jdbc_").append(this.ressourceManagerId).toString();
/*      */     }
/*  992 */     if (str9 == null) {
/*  993 */       str9 = "jdbcthin";
/*      */     }
/*      */ 
/*  996 */     this.terminal = this.meg.conv.StringToCharBytes(str1);
/*  997 */     this.machine = this.meg.conv.StringToCharBytes(str2);
/*  998 */     this.sysUserName = this.meg.conv.StringToCharBytes(str3);
/*  999 */     this.programName = this.meg.conv.StringToCharBytes(str4);
/* 1000 */     this.processID = this.meg.conv.StringToCharBytes(str5);
/* 1001 */     this.internalName = this.meg.conv.StringToCharBytes(str6);
/* 1002 */     this.externalName = this.meg.conv.StringToCharBytes(str7);
/* 1003 */     if (str8 != null)
/* 1004 */       this.clientname = this.meg.conv.StringToCharBytes(str8);
/* 1005 */     if (str10 != null)
/* 1006 */       this.editionName = this.meg.conv.StringToCharBytes(str10);
/* 1007 */     this.driverName = this.meg.conv.StringToCharBytes(str9);
/*      */ 
/* 1009 */     TimeZone localTimeZone = TimeZone.getDefault();
/*      */ 
/* 1012 */     String str11 = localTimeZone.getID();
/*      */ 
/* 1014 */     if ((!ZONEIDMAP.isValidRegion(str11)) || (!paramT4CConnection.timezoneAsRegion))
/*      */     {
/* 1023 */       int i = localTimeZone.getOffset(System.currentTimeMillis());
/* 1024 */       int j = i / 3600000;
/* 1025 */       int k = i / 60000 % 60;
/*      */ 
/* 1027 */       str11 = new StringBuilder().append(j < 0 ? new StringBuilder().append("").append(j).toString() : new StringBuilder().append("+").append(j).toString()).append(k < 10 ? new StringBuilder().append(":0").append(k).toString() : new StringBuilder().append(":").append(k).toString()).toString();
/*      */     }
/*      */ 
/* 1031 */     this.sessionTimeZone = str11;
/* 1032 */     paramT4CConnection.sessionTimeZone = str11;
/*      */ 
/* 1034 */     String str12 = CharacterSetMetaData.getNLSLanguage(OracleLocale.getDefault());
/*      */ 
/* 1042 */     String str13 = CharacterSetMetaData.getNLSTerritory(OracleLocale.getDefault());
/*      */ 
/* 1050 */     if ((str12 == null) || (str13 == null))
/*      */     {
/* 1052 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 176);
/* 1053 */       localSQLException.fillInStackTrace();
/* 1054 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1057 */     this.alterSession = this.meg.conv.StringToCharBytes(new StringBuilder().append("ALTER SESSION SET ").append(this.isSessionTZ ? new StringBuilder().append("TIME_ZONE='").append(this.sessionTimeZone).append("'").toString() : "").append(" NLS_LANGUAGE='").append(str12).append("' NLS_TERRITORY='").append(str13).append("' ").toString());
/*      */ 
/* 1061 */     this.aclValue = this.meg.conv.StringToCharBytes("4400");
/* 1062 */     this.alterSession[(this.alterSession.length - 1)] = 0;
/*      */   }
/*      */ 
/*      */   String removeQuotes(String paramString)
/*      */   {
/* 1076 */     int i = 0; int j = paramString.length() - 1;
/*      */ 
/* 1078 */     for (int k = 0; k < paramString.length(); k++)
/*      */     {
/* 1080 */       if (paramString.charAt(k) != '"')
/*      */       {
/* 1082 */         i = k;
/*      */ 
/* 1084 */         break;
/*      */       }
/*      */     }
/*      */ 
/* 1088 */     for (k = paramString.length() - 1; k >= 0; k--)
/*      */     {
/* 1090 */       if (paramString.charAt(k) != '"')
/*      */       {
/* 1092 */         j = k;
/*      */ 
/* 1094 */         break;
/*      */       }
/*      */     }
/*      */ 
/* 1098 */     String str = paramString.substring(i, j + 1);
/*      */ 
/* 1100 */     return str;
/*      */   }
/*      */ 
/*      */   private int versionStringToInt(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1127 */     String[] arrayOfString = paramString.split("\\.");
/* 1128 */     int i = Integer.parseInt(arrayOfString[0].replaceAll("\\D", ""));
/* 1129 */     int j = Integer.parseInt(arrayOfString[1].replaceAll("\\D", ""));
/* 1130 */     int k = Integer.parseInt(arrayOfString[2].replaceAll("\\D", ""));
/* 1131 */     int m = Integer.parseInt(arrayOfString[3].replaceAll("\\D", ""));
/* 1132 */     int n = Integer.parseInt(arrayOfString[4].replaceAll("\\D", ""));
/* 1133 */     int i1 = i << 24 | j << 20 | k << 12 | m << 8 | n;
/*      */ 
/* 1138 */     return i1;
/*      */   }
/*      */ 
/*      */   private String versionIntToString(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1145 */     int i = (paramInt & 0xFF000000) >> 24 & 0xFF;
/* 1146 */     int j = (paramInt & 0xF00000) >> 20 & 0xFF;
/* 1147 */     int k = (paramInt & 0xFF000) >> 12 & 0xFF;
/* 1148 */     int m = (paramInt & 0xF00) >> 8 & 0xFF;
/* 1149 */     int n = paramInt & 0xFF;
/* 1150 */     String str = new StringBuilder().append("").append(i).append(".").append(j).append(".").append(k).append(".").append(m).append(".").append(n).toString();
/* 1151 */     return str;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1166 */     return this.connection;
/*      */   }
/*      */ 
/*      */   public byte[] getDerivedKeyJdbc(byte[] paramArrayOfByte, int paramInt)
/*      */     throws NoSuchAlgorithmException, InvalidKeySpecException, SQLException
/*      */   {
/* 1179 */     if (this.verifierType == 2361)
/*      */     {
/* 1181 */       paramInt |= 1;
/*      */     }
/*      */     else {
/* 1184 */       paramInt |= 0;
/*      */     }
/* 1186 */     return this.o5logonHelper.getDerivedKey(paramArrayOfByte, paramInt);
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIoauthenticate
 * JD-Core Version:    0.6.2
 */