/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ final class T4CTTIoaqnfy extends T4CTTIfun
/*     */ {
/*  35 */   byte[] clientId = null;
/*  36 */   boolean isMarshalOver = false;
/*  37 */   boolean needToBeClosed = false;
/*  38 */   OracleConnection conn = null;
/*  39 */   T4CTTIkpdnrnf notificationHeader = null;
/*  40 */   T4CTTIkpdnrmp messageProperties = null;
/*  41 */   T4CTTIkpdnrpay payload = null;
/*  42 */   NTFManager ntfManager = null;
/*     */   T4CMAREngine mar;
/*     */   String databaseUniqueIdentifier;
/*  46 */   NTFJMSPerDatabaseManager jmsPerDatabaseManager = null;
/*     */ 
/* 145 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIoaqnfy(T4CConnection paramT4CConnection, String paramString, NTFJMSPerDatabaseManager paramNTFJMSPerDatabaseManager)
/*     */     throws SQLException
/*     */   {
/*  51 */     super(paramT4CConnection, (byte)3);
/*     */ 
/*  54 */     assert ((paramT4CConnection != null) && (paramString != null)) : ("_connection is " + paramT4CConnection + ", _clientId is " + paramString);
/*  55 */     setFunCode((short)187);
/*  56 */     this.conn = paramT4CConnection;
/*  57 */     this.mar = paramT4CConnection.mare;
/*  58 */     this.clientId = this.mar.conv.StringToCharBytes(paramString);
/*  59 */     this.jmsPerDatabaseManager = paramNTFJMSPerDatabaseManager;
/*  60 */     this.databaseUniqueIdentifier = paramT4CConnection.databaseUniqueIdentifier;
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/*  66 */     T4CTTIkpdnrreq localT4CTTIkpdnrreq = new T4CTTIkpdnrreq((T4CConnection)this.conn);
/*  67 */     localT4CTTIkpdnrreq.send(this.clientId, T4CTTIkpdnrreq.OpCode.INIT_KPDNRREQ);
/*  68 */     this.isMarshalOver = true;
/*     */   }
/*     */ 
/*     */   void readOAC()
/*     */   {
/*     */     try
/*     */     {
/*     */       while (true)
/*     */       {
/*  87 */         this.notificationHeader = new T4CTTIkpdnrnf((T4CConnection)this.conn);
/*     */ 
/*  89 */         this.notificationHeader.receive();
/*  90 */         this.messageProperties = new T4CTTIkpdnrmp((T4CConnection)this.conn);
/*     */ 
/*  92 */         this.messageProperties.receive();
/*  93 */         this.payload = new T4CTTIkpdnrpay((T4CConnection)this.conn);
/*     */ 
/*  95 */         this.payload.receive();
/*     */ 
/*  97 */         createAndGenerateEvent();
/*     */       }
/*     */     }
/*     */     catch (Exception localException) {
/* 101 */       if (!this.needToBeClosed);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void createAndGenerateEvent()
/*     */     throws SQLException
/*     */   {
/* 118 */     NTFJMSEvent localNTFJMSEvent = new NTFJMSEvent(this);
/* 119 */     localNTFJMSEvent.setAqMessageProperites(this.messageProperties.getAqMessageProperties());
/* 120 */     localNTFJMSEvent.setJmsMessageProperties(this.messageProperties.getJmsMessageProperties());
/* 121 */     localNTFJMSEvent.setMessageId(this.messageProperties.getMessageId());
/* 122 */     localNTFJMSEvent.setPayload(this.payload.getRawPayload());
/* 123 */     localNTFJMSEvent.setConsumerName(this.notificationHeader.getConsumerName());
/* 124 */     localNTFJMSEvent.setQueueName(this.notificationHeader.getNotificationQueue());
/* 125 */     localNTFJMSEvent.setRegistration(this.notificationHeader.getNotificationQueue());
/* 126 */     int i = this.jmsPerDatabaseManager.getJDBCRegId(Long.valueOf(this.notificationHeader.getRegistrationId()));
/*     */ 
/* 128 */     NTFJMSRegistration localNTFJMSRegistration = (NTFJMSRegistration)PhysicalConnection.ntfManager.getRegistration(i);
/*     */ 
/* 130 */     localNTFJMSRegistration.notify(localNTFJMSEvent);
/*     */   }
/*     */ 
/*     */   public void stopListening()
/*     */   {
/* 140 */     while (!this.isMarshalOver);
/* 141 */     this.needToBeClosed = true;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIoaqnfy
 * JD-Core Version:    0.6.2
 */