/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.JMSEnqueueOptions;
/*     */ import oracle.jdbc.internal.JMSEnqueueOptions.DeliveryMode;
/*     */ import oracle.jdbc.internal.JMSEnqueueOptions.VisibilityOption;
/*     */ import oracle.jdbc.internal.JMSMessageProperties;
/*     */ import oracle.jdbc.internal.JMSMessageProperties.JMSMessageType;
/*     */ 
/*     */ public class T4CTTIoaqenq extends T4CTTIfun
/*     */ {
/*     */   T4CTTIaqm aqm;
/*     */   T4Ctoh toh;
/*     */   T4CTTIaqjms aqjms;
/*  67 */   private JMSEnqueueOptions enqueueOptions = null;
/*  68 */   private AQMessagePropertiesI messageProperties = null;
/*  69 */   private JMSMessageProperties jmsProp = null;
/*     */   private byte[] aqmcorBytes;
/*     */   private byte[] aqmeqnBytes;
/*  72 */   private byte[] senderAgentName = null;
/*  73 */   private byte[] senderAgentAddress = null;
/*  74 */   private byte senderAgentProtocol = 0;
/*  75 */   private byte[] messageData = null;
/*  76 */   private byte[] messageOid = null;
/*  77 */   private AQAgentI[] attrRecipientList = null;
/*  78 */   private byte[][] recipientTextValues = (byte[][])null;
/*  79 */   private byte[][] recipientBinaryValues = (byte[][])null;
/*  80 */   private int[] recipientKeywords = null;
/*  81 */   private byte[] queueNameBytes = null;
/*  82 */   private byte[] outMsgId = null;
/*  83 */   private int bitMappedEnqueueOption = 0;
/*     */   private byte[] headerPropBytes;
/*     */   private byte[] userPropBytes;
/*  86 */   private boolean retrieveMessageId = false;
/*     */ 
/*     */   T4CTTIoaqenq(T4CConnection paramT4CConnection) {
/*  89 */     super(paramT4CConnection, (byte)3);
/*  90 */     setFunCode((short)184);
/*  91 */     this.toh = new T4Ctoh();
/*  92 */     this.aqm = new T4CTTIaqm(this.connection, this.toh);
/*  93 */     this.aqjms = new T4CTTIaqjms(this.connection);
/*     */   }
/*     */ 
/*     */   void doJMSEnq(String paramString, JMSEnqueueOptions paramJMSEnqueueOptions, AQMessagePropertiesI paramAQMessagePropertiesI, JMSMessageProperties paramJMSMessageProperties, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*     */     throws SQLException, IOException
/*     */   {
/* 105 */     this.enqueueOptions = paramJMSEnqueueOptions;
/* 106 */     this.messageProperties = paramAQMessagePropertiesI;
/* 107 */     this.jmsProp = paramJMSMessageProperties;
/* 108 */     this.messageData = paramArrayOfByte2;
/*     */ 
/* 110 */     if (this.messageProperties != null) {
/* 111 */       String str1 = this.messageProperties.getCorrelation();
/*     */ 
/* 113 */       if ((str1 != null) && (str1.length() != 0))
/* 114 */         this.aqmcorBytes = this.meg.conv.StringToCharBytes(str1);
/*     */       else {
/* 116 */         this.aqmcorBytes = null;
/*     */       }
/* 118 */       String str2 = this.messageProperties.getExceptionQueue();
/* 119 */       if ((str2 != null) && (str2.length() != 0))
/* 120 */         this.aqmeqnBytes = this.meg.conv.StringToCharBytes(str2);
/*     */       else {
/* 122 */         this.aqmeqnBytes = null;
/*     */       }
/*     */ 
/* 125 */       AQAgentI localAQAgentI = (AQAgentI)this.messageProperties.getSender();
/* 126 */       if (localAQAgentI != null) {
/* 127 */         if (localAQAgentI.getName() != null) {
/* 128 */           this.senderAgentName = this.meg.conv.StringToCharBytes(localAQAgentI.getName());
/*     */         }
/*     */         else {
/* 131 */           this.senderAgentName = null;
/*     */         }
/* 133 */         if (localAQAgentI.getAddress() != null) {
/* 134 */           this.senderAgentAddress = this.meg.conv.StringToCharBytes(localAQAgentI.getAddress());
/*     */         }
/*     */         else {
/* 137 */           this.senderAgentAddress = null;
/*     */         }
/* 139 */         this.senderAgentProtocol = ((byte)localAQAgentI.getProtocol());
/*     */       } else {
/* 141 */         this.senderAgentName = null;
/* 142 */         this.senderAgentAddress = null;
/* 143 */         this.senderAgentProtocol = 0;
/*     */       }
/*     */ 
/* 146 */       this.attrRecipientList = ((AQAgentI[])this.messageProperties.getRecipientList());
/* 147 */       if ((this.attrRecipientList != null) && (this.attrRecipientList.length > 0)) {
/* 148 */         this.recipientTextValues = new byte[this.attrRecipientList.length * 3][];
/* 149 */         this.recipientBinaryValues = new byte[this.attrRecipientList.length * 3][];
/* 150 */         this.recipientKeywords = new int[this.attrRecipientList.length * 3];
/* 151 */         for (int i = 0; i < this.attrRecipientList.length; i++) {
/* 152 */           if (this.attrRecipientList[i].getName() != null) {
/* 153 */             this.recipientTextValues[(3 * i)] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i].getName());
/*     */           }
/*     */ 
/* 156 */           if (this.attrRecipientList[i].getAddress() != null) {
/* 157 */             this.recipientTextValues[(3 * i + 1)] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i].getAddress());
/*     */           }
/*     */ 
/* 160 */           this.recipientBinaryValues[(3 * i + 2)] = new byte[1];
/* 161 */           this.recipientBinaryValues[(3 * i + 2)][0] = ((byte)this.attrRecipientList[i].getProtocol());
/* 162 */           this.recipientKeywords[(3 * i)] = (3 * i);
/* 163 */           this.recipientKeywords[(3 * i + 1)] = (3 * i + 1);
/* 164 */           this.recipientKeywords[(3 * i + 2)] = (3 * i + 2);
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 170 */       this.aqmcorBytes = null;
/* 171 */       this.aqmeqnBytes = null;
/* 172 */       this.senderAgentName = null;
/* 173 */       this.senderAgentAddress = null;
/* 174 */       this.senderAgentProtocol = 0;
/*     */     }
/*     */ 
/* 178 */     this.messageData = paramArrayOfByte2;
/* 179 */     this.messageOid = paramArrayOfByte1;
/*     */ 
/* 181 */     if ((paramString != null) && (paramString.length() != 0))
/* 182 */       this.queueNameBytes = this.meg.conv.StringToCharBytes(paramString);
/*     */     else {
/* 184 */       this.queueNameBytes = null;
/*     */     }
/* 186 */     this.bitMappedEnqueueOption = (paramJMSEnqueueOptions.getDeliveryMode().getCode() + paramJMSEnqueueOptions.getVisibility().getCode());
/*     */ 
/* 188 */     if (this.jmsProp != null)
/*     */     {
/* 190 */       this.headerPropBytes = this.meg.conv.StringToCharBytes(this.jmsProp.getHeaderProperties());
/* 191 */       this.userPropBytes = this.meg.conv.StringToCharBytes(this.jmsProp.getUserProperties());
/*     */     }
/*     */     else
/*     */     {
/* 195 */       this.headerPropBytes = null;
/* 196 */       this.userPropBytes = null;
/*     */     }
/* 198 */     this.outMsgId = null;
/* 199 */     doRPC();
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 205 */     if ((this.queueNameBytes != null) && (this.queueNameBytes.length != 0)) {
/* 206 */       this.meg.marshalPTR();
/* 207 */       this.meg.marshalSWORD(this.queueNameBytes.length);
/*     */     } else {
/* 209 */       this.meg.marshalNULLPTR();
/* 210 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 213 */     this.aqm.initToDefaultValues();
/* 214 */     if (this.messageProperties != null)
/*     */     {
/* 216 */       this.aqm.aqmpri = this.messageProperties.getPriority();
/* 217 */       this.aqm.aqmdel = this.messageProperties.getDelay();
/* 218 */       this.aqm.aqmexp = this.messageProperties.getExpiration();
/* 219 */       this.aqm.originalMsgId = this.messageProperties.getPreviousQueueMessageId();
/*     */     }
/* 221 */     this.aqm.aqmcorBytes = this.aqmcorBytes;
/* 222 */     this.aqm.aqmeqnBytes = this.aqmeqnBytes;
/* 223 */     this.aqm.senderAgentName = this.senderAgentName;
/* 224 */     this.aqm.senderAgentAddress = this.senderAgentAddress;
/* 225 */     this.aqm.senderAgentProtocol = this.senderAgentProtocol;
/* 226 */     this.aqm.marshal();
/*     */ 
/* 230 */     this.meg.marshalSB4(this.bitMappedEnqueueOption);
/*     */ 
/* 233 */     if (this.jmsProp != null)
/*     */     {
/* 235 */       this.aqjms.aqjmsflags = this.jmsProp.getJMSMessageType().getCode();
/* 236 */       this.aqjms.aqjmshdrpcnt = 0;
/* 237 */       this.aqjms.aqjmsusrprpcnt = 0;
/*     */     }
/*     */     else
/*     */     {
/* 241 */       this.aqjms.aqjmsflags = 0;
/* 242 */       this.aqjms.aqjmshdrpcnt = 0;
/* 243 */       this.aqjms.aqjmsusrprpcnt = 0;
/*     */     }
/*     */ 
/* 246 */     this.aqjms.aqjmshdrprop = this.headerPropBytes;
/*     */ 
/* 248 */     this.aqjms.aqjmsuserprop = this.userPropBytes;
/* 249 */     this.aqjms.marshal();
/*     */ 
/* 254 */     if (this.messageOid != null)
/*     */     {
/* 256 */       this.meg.marshalPTR();
/* 257 */       this.meg.marshalSWORD(16);
/*     */     }
/*     */     else
/*     */     {
/* 261 */       this.meg.marshalNULLPTR();
/* 262 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 265 */     this.meg.marshalUB2(1);
/*     */ 
/* 268 */     this.meg.marshalNULLPTR();
/*     */ 
/* 271 */     if (this.messageData != null)
/*     */     {
/* 273 */       this.meg.marshalPTR();
/* 274 */       this.meg.marshalUB4(this.messageData.length);
/*     */     }
/*     */     else
/*     */     {
/* 278 */       this.meg.marshalNULLPTR();
/* 279 */       this.meg.marshalUB4(0L);
/*     */     }
/*     */ 
/* 285 */     this.meg.marshalSB4(0);
/*     */ 
/* 287 */     if (this.enqueueOptions.isRetrieveMessageId()) {
/* 288 */       this.retrieveMessageId = true;
/*     */ 
/* 290 */       this.meg.marshalPTR();
/*     */ 
/* 292 */       this.meg.marshalSWORD(16);
/*     */     } else {
/* 294 */       this.retrieveMessageId = false;
/*     */ 
/* 296 */       this.meg.marshalNULLPTR();
/*     */ 
/* 298 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 306 */     if ((this.queueNameBytes != null) && (this.queueNameBytes.length != 0)) {
/* 307 */       this.meg.marshalCHR(this.queueNameBytes);
/*     */     }
/*     */ 
/* 310 */     if (this.messageOid != null)
/*     */     {
/* 312 */       this.meg.marshalB1Array(this.messageOid);
/*     */     }
/*     */ 
/* 315 */     if (this.messageData != null)
/*     */     {
/* 317 */       this.meg.marshalB1Array(this.messageData);
/*     */     }
/*     */   }
/*     */ 
/*     */   void readRPA() throws SQLException, IOException {
/* 322 */     if (this.retrieveMessageId)
/*     */     {
/* 324 */       this.outMsgId = new byte[16];
/* 325 */       this.meg.unmarshalBuffer(this.outMsgId, 0, 16);
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte[] getMsgId() {
/* 330 */     return this.outMsgId;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIoaqenq
 * JD-Core Version:    0.6.2
 */