/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.aq.AQAgent;
/*     */ import oracle.jdbc.aq.AQMessageProperties.DeliveryMode;
/*     */ import oracle.jdbc.aq.AQMessageProperties.MessageState;
/*     */ import oracle.jdbc.internal.JMSDequeueOptions;
/*     */ import oracle.jdbc.internal.JMSDequeueOptions.DeliveryFilter;
/*     */ import oracle.jdbc.internal.JMSDequeueOptions.DequeueMode;
/*     */ import oracle.jdbc.internal.JMSDequeueOptions.VisibilityOption;
/*     */ import oracle.jdbc.internal.JMSMessageProperties.JMSMessageType;
/*     */ import oracle.sql.TIMESTAMP;
/*     */ 
/*     */ public class T4CTTIoaqdeq extends T4CTTIfun
/*     */ {
/*     */   static final int AQTTC_DEQ_OPTS_DEFAULT = 0;
/*     */   static final int AQTTC_DEQ_OPTS_ON_COMMIT = 1;
/*     */   static final int AQTTC_DEQ_OPTS_IMMEDIATE = 2;
/*     */   static final int AQTTC_DEQ_OPTS_FOREVER = 4;
/*     */   static final int AQTTC_DEQ_OPTS_BROWSE = 8;
/*     */   static final int AQTTC_DEQ_OPTS_LOCKED = 16;
/*     */   static final int AQTTC_DEQ_OPTS_REMOVE = 32;
/*     */   static final int AQTTC_DEQ_OPTS_REMOVE_NO_DATA = 64;
/*     */   static final int AQTTC_DEQ_OPTS_BUFFERED = 128;
/*     */   static final int AQTTC_DEQ_OPT_PERS_BUFF = 256;
/* 102 */   private T4Ctoh toh = null;
/* 103 */   private T4CTTIaqm aqm = null;
/* 104 */   private T4CTTIaqjms aqjms = null;
/* 105 */   private byte[] payloadToid = null;
/* 106 */   private byte[] payload = null;
/* 107 */   private byte[] dequeuedMessageId = null;
/* 108 */   private byte[] queueNameBytes = null;
/* 109 */   private byte[] consumerNameBytes = null;
/* 110 */   private byte[] correlationBytes = null;
/* 111 */   private byte[] conditionBytes = null;
/* 112 */   private byte[] jmsPropertyBytes = null;
/* 113 */   private boolean hasAMessageBeenDequeued = false;
/*     */   private String queueName;
/* 115 */   private JMSDequeueOptions dequeueOptions = null;
/* 116 */   private AQMessagePropertiesI aqMessageProperties = null;
/* 117 */   private JMSMessagePropertiesI jmsMessageProperties = null;
/*     */ 
/*     */   T4CTTIoaqdeq(T4CConnection paramT4CConnection)
/*     */   {
/* 121 */     super(paramT4CConnection, (byte)3);
/* 122 */     setFunCode((short)185);
/* 123 */     this.toh = new T4Ctoh();
/* 124 */     this.aqm = new T4CTTIaqm(this.connection, this.toh);
/*     */   }
/*     */ 
/*     */   public void doJMSDeq(String paramString, JMSDequeueOptions paramJMSDequeueOptions, byte[] paramArrayOfByte, AQMessagePropertiesI paramAQMessagePropertiesI, JMSMessagePropertiesI paramJMSMessagePropertiesI)
/*     */     throws SQLException, IOException
/*     */   {
/* 134 */     this.queueName = paramString;
/* 135 */     this.dequeueOptions = paramJMSDequeueOptions;
/* 136 */     this.payloadToid = paramArrayOfByte;
/* 137 */     this.aqMessageProperties = paramAQMessagePropertiesI;
/* 138 */     this.jmsMessageProperties = paramJMSMessagePropertiesI;
/*     */ 
/* 140 */     if ((this.queueName != null) && (this.queueName.length() != 0))
/*     */     {
/* 142 */       this.queueNameBytes = this.meg.conv.StringToCharBytes(this.queueName);
/*     */     }
/*     */     else
/*     */     {
/* 146 */       this.queueNameBytes = null;
/*     */     }
/*     */ 
/* 149 */     String str1 = this.dequeueOptions.getConsumerName();
/* 150 */     if ((str1 != null) && (str1.length() > 0))
/*     */     {
/* 152 */       this.consumerNameBytes = this.meg.conv.StringToCharBytes(str1);
/*     */     }
/*     */     else
/*     */     {
/* 156 */       this.consumerNameBytes = null;
/*     */     }
/*     */ 
/* 159 */     String str2 = this.dequeueOptions.getCorrelation();
/* 160 */     if ((str2 != null) && (str2.length() != 0))
/*     */     {
/* 162 */       this.correlationBytes = this.meg.conv.StringToCharBytes(str2);
/*     */     }
/*     */     else
/*     */     {
/* 166 */       this.correlationBytes = null;
/*     */     }
/*     */ 
/* 169 */     String str3 = this.dequeueOptions.getCondition();
/* 170 */     if ((str3 != null) && (str3.length() > 0))
/*     */     {
/* 172 */       this.conditionBytes = this.meg.conv.StringToCharBytes(str3);
/*     */     }
/*     */     else
/*     */     {
/* 176 */       this.conditionBytes = null;
/*     */     }
/*     */ 
/* 179 */     this.hasAMessageBeenDequeued = false;
/* 180 */     this.dequeuedMessageId = null;
/* 181 */     this.payload = null;
/*     */ 
/* 183 */     doRPC();
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 192 */     if ((this.queueNameBytes != null) && (this.queueNameBytes.length != 0))
/*     */     {
/* 194 */       this.meg.marshalPTR();
/* 195 */       this.meg.marshalSWORD(this.queueNameBytes.length);
/*     */     }
/*     */     else
/*     */     {
/* 199 */       this.meg.marshalNULLPTR();
/* 200 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 205 */     if ((this.consumerNameBytes != null) && (this.consumerNameBytes.length != 0))
/*     */     {
/* 207 */       this.meg.marshalPTR();
/* 208 */       this.meg.marshalSWORD(this.consumerNameBytes.length);
/*     */     }
/*     */     else
/*     */     {
/* 212 */       this.meg.marshalNULLPTR();
/* 213 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 219 */     byte[] arrayOfByte = this.dequeueOptions.getDequeueMessageId();
/* 220 */     int i = 0;
/* 221 */     if ((arrayOfByte != null) && (arrayOfByte.length > 0))
/*     */     {
/* 223 */       this.meg.marshalPTR();
/* 224 */       this.meg.marshalSWORD(arrayOfByte.length);
/* 225 */       i = 1;
/*     */     }
/*     */     else
/*     */     {
/* 229 */       this.meg.marshalNULLPTR();
/* 230 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 235 */     if ((this.correlationBytes != null) && (this.correlationBytes.length != 0))
/*     */     {
/* 237 */       this.meg.marshalPTR();
/* 238 */       this.meg.marshalSWORD(this.correlationBytes.length);
/*     */     }
/*     */     else
/*     */     {
/* 242 */       this.meg.marshalNULLPTR();
/* 243 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 248 */     int j = 0;
/* 249 */     if (this.connection.autocommit)
/*     */     {
/* 251 */       j = 2;
/*     */     }
/*     */     else
/*     */     {
/* 255 */       j = 1;
/*     */     }
/* 257 */     j |= this.dequeueOptions.getDeliveryMode().getCode();
/* 258 */     j |= this.dequeueOptions.getDequeueMode().getCode();
/* 259 */     j |= this.dequeueOptions.getVisibility().getCode();
/* 260 */     if (this.dequeueOptions.getWait() == 4)
/*     */     {
/* 262 */       j |= 4;
/* 263 */       this.meg.marshalUB4(j);
/* 264 */       this.meg.marshalSB4(-1);
/*     */     }
/*     */     else
/*     */     {
/* 268 */       this.meg.marshalUB4(j);
/* 269 */       this.meg.marshalSB4(this.dequeueOptions.getWait());
/*     */     }
/*     */ 
/* 274 */     if ((this.conditionBytes != null) && (this.conditionBytes.length > 0)) {
/* 275 */       this.meg.marshalPTR();
/* 276 */       this.meg.marshalSWORD(this.conditionBytes.length);
/*     */     } else {
/* 278 */       this.meg.marshalNULLPTR();
/* 279 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 284 */     if ((this.payloadToid != null) && (this.payloadToid.length > 0)) {
/* 285 */       this.meg.marshalPTR();
/*     */ 
/* 287 */       this.meg.marshalSWORD(this.payloadToid.length);
/*     */     } else {
/* 289 */       this.meg.marshalNULLPTR();
/* 290 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 294 */     this.meg.marshalUB2(1);
/*     */ 
/* 298 */     this.meg.marshalPTR();
/* 299 */     this.meg.marshalPTR();
/*     */ 
/* 303 */     this.meg.marshalNULLPTR();
/*     */ 
/* 307 */     if (this.dequeueOptions.isRetrieveMessageId())
/*     */     {
/* 309 */       this.meg.marshalPTR();
/* 310 */       this.meg.marshalSWORD(16);
/*     */     }
/*     */     else
/*     */     {
/* 314 */       this.meg.marshalNULLPTR();
/* 315 */       this.meg.marshalSWORD(0);
/*     */     }
/*     */ 
/* 319 */     this.meg.marshalUB4(0L);
/*     */ 
/* 325 */     this.meg.marshalPTR();
/* 326 */     this.meg.marshalPTR();
/* 327 */     this.meg.marshalPTR();
/* 328 */     this.meg.marshalPTR();
/*     */ 
/* 333 */     if ((this.queueNameBytes != null) && (this.queueNameBytes.length != 0)) {
/* 334 */       this.meg.marshalCHR(this.queueNameBytes);
/*     */     }
/*     */ 
/* 337 */     if ((this.consumerNameBytes != null) && (this.consumerNameBytes.length != 0)) {
/* 338 */       this.meg.marshalCHR(this.consumerNameBytes);
/*     */     }
/*     */ 
/* 341 */     if (i != 0) {
/* 342 */       this.meg.marshalB1Array(arrayOfByte);
/*     */     }
/*     */ 
/* 345 */     if ((this.correlationBytes != null) && (this.correlationBytes.length != 0)) {
/* 346 */       this.meg.marshalCHR(this.correlationBytes);
/*     */     }
/* 348 */     if ((this.conditionBytes != null) && (this.conditionBytes.length > 0)) {
/* 349 */       this.meg.marshalCHR(this.conditionBytes);
/*     */     }
/*     */ 
/* 352 */     this.meg.marshalB1Array(this.payloadToid);
/*     */   }
/*     */ 
/*     */   void readRPA()
/*     */     throws SQLException, IOException
/*     */   {
/* 358 */     this.hasAMessageBeenDequeued = true;
/* 359 */     int i = (int)this.meg.unmarshalUB4();
/*     */     Object localObject;
/* 360 */     if (i > 0)
/*     */     {
/* 362 */       this.aqm.initToDefaultValues();
/* 363 */       this.aqm.receive();
/* 364 */       this.aqMessageProperties.setPriority(this.aqm.aqmpri);
/* 365 */       this.aqMessageProperties.setDelay(this.aqm.aqmdel);
/* 366 */       this.aqMessageProperties.setExpiration(this.aqm.aqmexp);
/* 367 */       if (this.aqm.aqmcorBytes != null)
/*     */       {
/* 369 */         localObject = this.meg.conv.CharBytesToString(this.aqm.aqmcorBytes, this.aqm.aqmcorBytesLength, true);
/*     */ 
/* 371 */         this.aqMessageProperties.setCorrelation((String)localObject);
/*     */       }
/* 373 */       this.aqMessageProperties.setAttempts(this.aqm.aqmatt);
/* 374 */       if (this.aqm.aqmeqnBytes != null)
/*     */       {
/* 376 */         localObject = this.meg.conv.CharBytesToString(this.aqm.aqmeqnBytes, this.aqm.aqmeqnBytesLength, true);
/*     */ 
/* 378 */         this.aqMessageProperties.setExceptionQueue((String)localObject);
/*     */       }
/* 380 */       this.aqMessageProperties.setMessageState(AQMessageProperties.MessageState.getMessageState(this.aqm.aqmsta));
/* 381 */       if (this.aqm.aqmeqt != null)
/* 382 */         this.aqMessageProperties.setEnqueueTime(this.aqm.aqmeqt.timestampValue());
/* 383 */       localObject = new AQAgentI();
/* 384 */       if (this.aqm.senderAgentName != null) {
/* 385 */         ((AQAgentI)localObject).setName(this.meg.conv.CharBytesToString(this.aqm.senderAgentName, this.aqm.senderAgentNameLength, true));
/*     */       }
/*     */ 
/* 389 */       if (this.aqm.senderAgentAddress != null) {
/* 390 */         ((AQAgentI)localObject).setAddress(this.meg.conv.CharBytesToString(this.aqm.senderAgentAddress, this.aqm.senderAgentAddressLength, true));
/*     */       }
/*     */ 
/* 394 */       ((AQAgentI)localObject).setProtocol(this.aqm.senderAgentProtocol);
/*     */ 
/* 396 */       this.aqMessageProperties.setSender((AQAgent)localObject);
/* 397 */       this.aqMessageProperties.setPreviousQueueMessageId(this.aqm.originalMsgId);
/* 398 */       this.aqMessageProperties.setDeliveryMode(AQMessageProperties.DeliveryMode.getDeliveryMode(this.aqm.aqmflg));
/*     */ 
/* 401 */       if (this.aqm.aqmetiBytes != null)
/*     */       {
/* 403 */         String str1 = this.meg.conv.CharBytesToString(this.aqm.aqmetiBytes, this.aqm.aqmetiBytes.length, true);
/*     */ 
/* 405 */         this.aqMessageProperties.setTransactionGroup(str1);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 412 */     if (this.dequeueOptions.isRetrieveMessageId())
/*     */     {
/* 414 */       localObject = new byte[16];
/* 415 */       this.meg.unmarshalBuffer((byte[])localObject, 0, 16);
/* 416 */       this.dequeuedMessageId = ((byte[])localObject);
/*     */     }
/*     */ 
/* 419 */     int j = (int)this.meg.unmarshalUB4();
/* 420 */     if (j > 0)
/*     */     {
/* 422 */       this.payload = new byte[j];
/* 423 */       this.meg.unmarshalBuffer(this.payload, 0, this.payload.length);
/*     */     }
/* 425 */     int k = (int)this.meg.unmarshalUB4();
/* 426 */     if (k > 0)
/*     */     {
/* 428 */       this.aqjms = new T4CTTIaqjms(this.connection);
/* 429 */       this.aqjms.receive();
/* 430 */       String str2 = this.meg.conv.CharBytesToString(this.aqjms.aqjmshdrprop, this.aqjms.aqjmshdrprop.length, true);
/*     */ 
/* 434 */       this.jmsMessageProperties.setHeaderProperties(str2);
/* 435 */       String str3 = this.meg.conv.CharBytesToString(this.aqjms.aqjmsuserprop, this.aqjms.aqjmsuserprop.length, true);
/*     */ 
/* 439 */       this.jmsMessageProperties.setUserProperties(str3);
/* 440 */       this.jmsMessageProperties.setJMSMessageType(JMSMessageProperties.JMSMessageType.getJMSMessageType(this.aqjms.aqjmsflags));
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isHasAMessageBeenDequeued()
/*     */   {
/* 447 */     return this.hasAMessageBeenDequeued;
/*     */   }
/*     */ 
/*     */   public byte[] getPayload()
/*     */   {
/* 452 */     return this.payload;
/*     */   }
/*     */ 
/*     */   public byte[] getDequeuedMessageId()
/*     */   {
/* 457 */     return this.dequeuedMessageId;
/*     */   }
/*     */   public AQMessagePropertiesI getAQMessageProperties() {
/* 460 */     return this.aqMessageProperties;
/*     */   }
/*     */ 
/*     */   public JMSMessagePropertiesI getJMSMessageProperties() {
/* 464 */     return this.jmsMessageProperties;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIoaqdeq
 * JD-Core Version:    0.6.2
 */