/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.oracore.OracleTypeADT;
/*     */ 
/*     */ class T4CTTIoac
/*     */ {
/*     */   static final short UACFIND = 1;
/*     */   static final short UACFALN = 2;
/*     */   static final short UACFRCP = 4;
/*     */   static final short UACFBBV = 8;
/*     */   static final short UACFNCP = 16;
/*     */   static final short UACFBLP = 32;
/*     */   static final short UACFARR = 64;
/*     */   static final short UACFIGN = 128;
/*     */   static final int UACFNSCL = 1;
/*     */   static final int UACFBUC = 2;
/*     */   static final int UACFSKP = 4;
/*     */   static final int UACFCHRCNT = 8;
/*     */   static final int UACFNOADJ = 16;
/*     */   static final int UACFCUS = 4096;
/*     */   static final int UACFLSZ = 33554432;
/*     */   static final int UACFVFSP = 134217728;
/*  42 */   static final byte[] NO_BYTES = new byte[0];
/*     */   int oaccsi;
/*     */   short oaccsfrm;
/*     */   static int maxBindArrayLength;
/*     */   T4CMAREngine meg;
/*     */   T4CConnection connection;
/*     */   short oacdty;
/*     */   short oacflg;
/*     */   short oacpre;
/*     */   short oacscl;
/*     */   int oacmxl;
/*     */   int oacmxlc;
/*     */   int oacmal;
/*     */   int oacfl2;
/*     */   byte[] oactoid;
/*     */   int oactoidl;
/*     */   int oacvsn;
/* 370 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIoac(T4CConnection paramT4CConnection)
/*     */   {
/*  79 */     this.connection = paramT4CConnection;
/*  80 */     this.meg = this.connection.mare;
/*     */ 
/*  82 */     this.oactoid = NO_BYTES;
/*     */   }
/*     */ 
/*     */   void init(short paramShort, int paramInt)
/*     */   {
/* 103 */     if ((paramShort == 9) || (paramShort == 1) || (paramShort == 996))
/* 104 */       this.oacdty = 1;
/* 105 */     else if (paramShort == 104)
/* 106 */       this.oacdty = 11;
/* 107 */     else if ((paramShort == 6) || (paramShort == 2))
/* 108 */       this.oacdty = 2;
/* 109 */     else if (paramShort == 15)
/* 110 */       this.oacdty = 23;
/* 111 */     else if (paramShort == 116) {
/* 112 */       this.oacdty = 102;
/*     */     }
/*     */     else
/*     */     {
/* 116 */       this.oacdty = paramShort;
/*     */     }
/* 118 */     if ((this.oacdty == 1) || (this.oacdty == 96))
/*     */     {
/* 120 */       this.oacfl2 = 16;
/*     */     }
/* 122 */     if (this.oacdty == 102)
/* 123 */       this.oacmxl = 1;
/*     */     else {
/* 125 */       this.oacmxl = paramInt;
/*     */     }
/*     */ 
/* 128 */     this.oacflg = 3;
/*     */   }
/*     */ 
/*     */   boolean isOldSufficient(T4CTTIoac paramT4CTTIoac)
/*     */   {
/* 136 */     boolean bool = false;
/*     */ 
/* 138 */     if ((this.oactoidl != 0) || (paramT4CTTIoac.oactoidl != 0)) {
/* 139 */       return false;
/*     */     }
/* 141 */     if ((this.oaccsi == paramT4CTTIoac.oaccsi) && (this.oaccsfrm == paramT4CTTIoac.oaccsfrm) && (this.oacdty == paramT4CTTIoac.oacdty) && (this.oacflg == paramT4CTTIoac.oacflg) && (this.oacpre == paramT4CTTIoac.oacpre) && (this.oacscl <= paramT4CTTIoac.oacscl) && ((this.oacmxl == paramT4CTTIoac.oacmxl) || ((paramT4CTTIoac.oacmxl > this.oacmxl) && (paramT4CTTIoac.oacmxl < 4000))) && (this.oacmxlc == paramT4CTTIoac.oacmxlc) && (this.oacmal == paramT4CTTIoac.oacmal) && (this.oacfl2 == paramT4CTTIoac.oacfl2) && (this.oacvsn == paramT4CTTIoac.oacvsn))
/*     */     {
/* 148 */       bool = true;
/*     */     }
/* 150 */     return bool;
/*     */   }
/*     */ 
/*     */   boolean isNType()
/*     */   {
/* 161 */     boolean bool = this.oaccsfrm == 2;
/* 162 */     return bool;
/*     */   }
/*     */ 
/*     */   void unmarshal()
/*     */     throws IOException, SQLException
/*     */   {
/* 175 */     this.oacdty = this.meg.unmarshalUB1();
/* 176 */     this.oacflg = this.meg.unmarshalUB1();
/* 177 */     this.oacpre = this.meg.unmarshalUB1();
/*     */ 
/* 181 */     this.oacscl = ((short)this.meg.unmarshalSB1());
/* 182 */     this.oacmxl = this.meg.unmarshalSB4();
/* 183 */     this.oacmal = this.meg.unmarshalSB4();
/* 184 */     this.oacfl2 = this.meg.unmarshalSB4();
/* 185 */     this.oactoid = this.meg.unmarshalDALC();
/* 186 */     this.oactoidl = (this.oactoid == null ? 0 : this.oactoid.length);
/* 187 */     this.oacvsn = this.meg.unmarshalUB2();
/* 188 */     this.oaccsi = this.meg.unmarshalUB2();
/* 189 */     this.oaccsfrm = this.meg.unmarshalUB1();
/*     */ 
/* 191 */     if (this.connection.getTTCVersion() >= 2) {
/* 192 */       this.oacmxlc = ((int)this.meg.unmarshalUB4());
/*     */     }
/*     */ 
/* 211 */     if (this.oacmxl > 0)
/*     */     {
/* 213 */       switch (this.oacdty)
/*     */       {
/*     */       case 2:
/* 222 */         this.oacmxl = 22;
/*     */ 
/* 224 */         break;
/*     */       case 12:
/* 227 */         this.oacmxl = 7;
/*     */ 
/* 229 */         break;
/*     */       case 181:
/* 232 */         this.oacmxl = 13;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   void setMal(int paramInt)
/*     */   {
/* 252 */     this.oacmal = paramInt;
/*     */   }
/*     */ 
/*     */   void addFlg(short paramShort)
/*     */   {
/* 259 */     this.oacflg = ((short)(this.oacflg | paramShort));
/*     */   }
/*     */ 
/*     */   void addFlg2(int paramInt)
/*     */   {
/* 266 */     this.oacfl2 |= paramInt;
/*     */   }
/*     */ 
/*     */   void setFormOfUse(short paramShort)
/*     */   {
/* 273 */     this.oaccsfrm = paramShort;
/*     */   }
/*     */ 
/*     */   void setCharset(int paramInt)
/*     */   {
/* 280 */     this.oaccsi = paramInt;
/*     */   }
/*     */ 
/*     */   void setMxlc(int paramInt)
/*     */   {
/* 287 */     this.oacmxlc = paramInt;
/*     */   }
/*     */ 
/*     */   void setPrecision(short paramShort)
/*     */   {
/* 294 */     this.oacpre = paramShort;
/*     */   }
/*     */ 
/*     */   void setTimestampFractionalSecondsPrecision(short paramShort)
/*     */   {
/* 302 */     this.oacscl = paramShort;
/*     */   }
/*     */ 
/*     */   void setADT(OracleTypeADT paramOracleTypeADT)
/*     */   {
/* 308 */     this.oactoid = paramOracleTypeADT.getTOID();
/* 309 */     this.oacvsn = paramOracleTypeADT.getTypeVersion();
/* 310 */     this.oaccsi = 2;
/* 311 */     this.oaccsfrm = ((short)paramOracleTypeADT.getCharSetForm());
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 321 */     this.meg.marshalUB1(this.oacdty);
/* 322 */     this.meg.marshalUB1(this.oacflg);
/* 323 */     this.meg.marshalUB1(this.oacpre);
/*     */ 
/* 325 */     if ((this.oacdty == 2) || (this.oacdty == 180) || (this.oacdty == 181) || (this.oacdty == 231) || (this.oacdty == 183))
/*     */     {
/* 331 */       this.meg.marshalUB2(this.oacscl);
/*     */     }
/*     */     else
/*     */     {
/* 335 */       this.meg.marshalUB1(this.oacscl);
/*     */     }
/*     */ 
/* 338 */     this.meg.marshalUB4(this.oacmxl);
/*     */ 
/* 340 */     this.meg.marshalSB4(this.oacmal);
/* 341 */     this.meg.marshalSB4(this.oacfl2);
/*     */ 
/* 343 */     this.meg.marshalDALC(this.oactoid);
/*     */ 
/* 345 */     this.meg.marshalUB2(this.oacvsn);
/* 346 */     this.meg.marshalUB2(this.oaccsi);
/* 347 */     this.meg.marshalUB1(this.oaccsfrm);
/*     */ 
/* 349 */     if (this.connection.getTTCVersion() >= 2)
/* 350 */       this.meg.marshalUB4(this.oacmxlc);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIoac
 * JD-Core Version:    0.6.2
 */