/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ 
/*     */ class T4CTTIkpdnrreq
/*     */ {
/*     */   byte[] clientIdBytes;
/*     */   short registrationOpCode;
/*  55 */   boolean acknowledgement = false;
/*     */   T4CTTIkpdnrack notificationAcknowledgment;
/*     */   T4CMAREngine mar;
/* 104 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIkpdnrreq(T4CConnection paramT4CConnection)
/*     */   {
/*  62 */     this.mar = paramT4CConnection.mare;
/*     */   }
/*     */ 
/*     */   void send(byte[] paramArrayOfByte, OpCode paramOpCode)
/*     */     throws IOException
/*     */   {
/*  68 */     this.clientIdBytes = paramArrayOfByte;
/*  69 */     this.registrationOpCode = paramOpCode.getCode();
/*  70 */     marshal();
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/*  77 */     if ((this.clientIdBytes != null) && (this.clientIdBytes.length != 0))
/*     */     {
/*  79 */       this.mar.marshalUB2(this.clientIdBytes.length);
/*     */ 
/*  81 */       this.mar.marshalCLR(this.clientIdBytes, 0, this.clientIdBytes.length);
/*     */     }
/*     */     else {
/*  84 */       this.mar.marshalSWORD(0);
/*     */     }
/*     */ 
/*  88 */     this.mar.marshalUB1(this.registrationOpCode);
/*     */ 
/*  90 */     if (this.acknowledgement)
/*     */     {
/*  96 */       this.notificationAcknowledgment.send(null, 0L, null);
/*     */     }
/*     */     else
/*  99 */       this.mar.marshalSWORD(0);
/*     */   }
/*     */ 
/*     */   static enum OpCode
/*     */   {
/*  41 */     INIT_KPDNRREQ((short)1), 
/*  42 */     COMMIT_KPDNRREQ((short)2), 
/*  43 */     ROLLBACK_KPDNRREQ((short)3), 
/*  44 */     REINIT_KPDNRREQ((short)4);
/*     */ 
/*     */     private final short mode;
/*     */ 
/*  47 */     private OpCode(short paramShort) { this.mode = paramShort; }
/*     */ 
/*     */     public final short getCode() {
/*  50 */       return this.mode;
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIkpdnrreq
 * JD-Core Version:    0.6.2
 */