/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.aq.AQAgent;
/*     */ import oracle.jdbc.aq.AQFactory;
/*     */ import oracle.jdbc.aq.AQMessageProperties.DeliveryMode;
/*     */ import oracle.jdbc.aq.AQMessageProperties.MessageState;
/*     */ import oracle.jdbc.internal.JMSFactory;
/*     */ import oracle.jdbc.internal.JMSMessageProperties.JMSMessageType;
/*     */ import oracle.sql.TIMESTAMP;
/*     */ 
/*     */ class T4CTTIkpdnrmp
/*     */ {
/*     */   byte[] messageId;
/*     */   AQMessagePropertiesI aqMessageProperties;
/*     */   JMSMessagePropertiesI jmsMessageProperties;
/*  51 */   private T4CTTIaqm aqm = null;
/*  52 */   private T4CTTIaqjms aqjms = null;
/*  53 */   private T4Ctoh toh = null;
/*     */   T4CMAREngine mar;
/* 178 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIkpdnrmp(T4CConnection paramT4CConnection)
/*     */   {
/*  59 */     this.toh = new T4Ctoh();
/*  60 */     this.aqm = new T4CTTIaqm(paramT4CConnection, this.toh);
/*  61 */     this.mar = paramT4CConnection.mare;
/*  62 */     this.aqjms = new T4CTTIaqjms(paramT4CConnection);
/*     */   }
/*     */ 
/*     */   public void receive()
/*     */     throws SQLException, IOException
/*     */   {
/*  69 */     int i = this.mar.unmarshalSWORD();
/*  70 */     if (i > 0)
/*     */     {
/*  72 */       this.messageId = new byte[i];
/*  73 */       int[] arrayOfInt = new int[1];
/*     */ 
/*  76 */       this.mar.unmarshalCLR(this.messageId, 0, arrayOfInt, this.messageId.length);
/*  77 */       i = arrayOfInt[0];
/*     */     }
/*     */ 
/*  81 */     int j = this.mar.unmarshalSWORD();
/*  82 */     if (j > 0)
/*     */     {
/*  85 */       this.mar.unmarshalUB1();
/*     */ 
/*  88 */       this.aqm.receive();
/*     */ 
/*  91 */       this.aqMessageProperties = ((AQMessagePropertiesI)AQFactory.createAQMessageProperties());
/*  92 */       this.aqMessageProperties.setPriority(this.aqm.aqmpri);
/*  93 */       this.aqMessageProperties.setDelay(this.aqm.aqmdel);
/*  94 */       this.aqMessageProperties.setExpiration(this.aqm.aqmexp);
/*  95 */       if (this.aqm.aqmcorBytes != null)
/*     */       {
/*  97 */         localObject = this.mar.conv.CharBytesToString(this.aqm.aqmcorBytes, this.aqm.aqmcorBytesLength, true);
/*     */ 
/*  99 */         this.aqMessageProperties.setCorrelation((String)localObject);
/*     */       }
/* 101 */       this.aqMessageProperties.setAttempts(this.aqm.aqmatt);
/* 102 */       if (this.aqm.aqmeqnBytes != null)
/*     */       {
/* 104 */         localObject = this.mar.conv.CharBytesToString(this.aqm.aqmeqnBytes, this.aqm.aqmeqnBytesLength, true);
/*     */ 
/* 106 */         this.aqMessageProperties.setExceptionQueue((String)localObject);
/*     */       }
/* 108 */       this.aqMessageProperties.setMessageState(AQMessageProperties.MessageState.getMessageState(this.aqm.aqmsta));
/* 109 */       if (this.aqm.aqmeqt != null)
/* 110 */         this.aqMessageProperties.setEnqueueTime(this.aqm.aqmeqt.timestampValue());
/* 111 */       Object localObject = new AQAgentI();
/* 112 */       if (this.aqm.senderAgentName != null) {
/* 113 */         ((AQAgentI)localObject).setName(this.mar.conv.CharBytesToString(this.aqm.senderAgentName, this.aqm.senderAgentNameLength, true));
/*     */       }
/*     */ 
/* 117 */       if (this.aqm.senderAgentAddress != null) {
/* 118 */         ((AQAgentI)localObject).setAddress(this.mar.conv.CharBytesToString(this.aqm.senderAgentAddress, this.aqm.senderAgentAddressLength, true));
/*     */       }
/*     */ 
/* 122 */       ((AQAgentI)localObject).setProtocol(this.aqm.senderAgentProtocol);
/*     */ 
/* 124 */       this.aqMessageProperties.setSender((AQAgent)localObject);
/* 125 */       this.aqMessageProperties.setPreviousQueueMessageId(this.aqm.originalMsgId);
/* 126 */       this.aqMessageProperties.setDeliveryMode(AQMessageProperties.DeliveryMode.getDeliveryMode(this.aqm.aqmflg));
/*     */ 
/* 129 */       if (this.aqm.aqmetiBytes != null)
/*     */       {
/* 131 */         String str = this.mar.conv.CharBytesToString(this.aqm.aqmetiBytes, this.aqm.aqmetiBytes.length, true);
/*     */ 
/* 133 */         this.aqMessageProperties.setTransactionGroup(str);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 139 */     int k = this.mar.unmarshalSWORD();
/* 140 */     if (k > 0)
/*     */     {
/* 143 */       this.mar.unmarshalUB1();
/*     */ 
/* 146 */       this.aqjms.receive();
/*     */ 
/* 149 */       this.jmsMessageProperties = ((JMSMessagePropertiesI)JMSFactory.createJMSMessageProperties());
/* 150 */       this.jmsMessageProperties.setHeaderProperties(this.mar.conv.CharBytesToString(this.aqjms.aqjmshdrprop, this.aqjms.aqjmshdrprop.length));
/* 151 */       this.jmsMessageProperties.setUserProperties(this.mar.conv.CharBytesToString(this.aqjms.aqjmsuserprop, this.aqjms.aqjmsuserprop.length));
/* 152 */       this.jmsMessageProperties.setJMSMessageType(JMSMessageProperties.JMSMessageType.getJMSMessageType(this.aqjms.aqjmsflags));
/*     */     }
/*     */   }
/*     */ 
/*     */   public AQMessagePropertiesI getAqMessageProperties()
/*     */   {
/* 160 */     return this.aqMessageProperties;
/*     */   }
/*     */ 
/*     */   public JMSMessagePropertiesI getJmsMessageProperties()
/*     */   {
/* 167 */     return this.jmsMessageProperties;
/*     */   }
/*     */ 
/*     */   public byte[] getMessageId()
/*     */   {
/* 174 */     return this.messageId;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIkpdnrmp
 * JD-Core Version:    0.6.2
 */