/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.oracore.OracleTypeADT;
/*     */ 
/*     */ class T4CTTIiov extends T4CTTIMsg
/*     */ {
/*     */   T4C8TTIrxh rxh;
/*     */   T4CTTIrxd rxd;
/*  38 */   short bindtype = 0;
/*     */   byte[] iovector;
/*  41 */   int bindcnt = 0;
/*  42 */   int inbinds = 0;
/*  43 */   int outbinds = 0;
/*     */   static final byte BV_IN_V = 32;
/*     */   static final byte BV_OUT_V = 16;
/* 253 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIiov(T4CConnection paramT4CConnection, T4C8TTIrxh paramT4C8TTIrxh, T4CTTIrxd paramT4CTTIrxd)
/*     */     throws SQLException, IOException
/*     */   {
/*  59 */     super(paramT4CConnection, (byte)0);
/*     */ 
/*  61 */     this.rxh = paramT4C8TTIrxh;
/*  62 */     this.rxd = paramT4CTTIrxd;
/*     */   }
/*     */ 
/*     */   void init()
/*     */     throws SQLException, IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   Accessor[] processRXD(Accessor[] paramArrayOfAccessor, int paramInt1, byte[] paramArrayOfByte1, char[] paramArrayOfChar1, short[] paramArrayOfShort1, int paramInt2, DBConversion paramDBConversion, byte[] paramArrayOfByte2, byte[] paramArrayOfByte3, InputStream[][] paramArrayOfInputStream, byte[][][] paramArrayOfByte, OracleTypeADT[][] paramArrayOfOracleTypeADT, OracleStatement paramOracleStatement, byte[] paramArrayOfByte4, char[] paramArrayOfChar2, short[] paramArrayOfShort2)
/*     */     throws SQLException, IOException
/*     */   {
/*  97 */     if (paramArrayOfByte3 != null)
/*     */     {
/*  99 */       for (int i = 0; i < paramArrayOfByte3.length; i++)
/*     */       {
/* 101 */         if (((paramArrayOfByte3[i] & 0x10) != 0) && ((paramArrayOfAccessor == null) || (paramArrayOfAccessor.length <= i) || (paramArrayOfAccessor[i] == null)))
/*     */         {
/* 108 */           int j = paramInt2 + 5 + 10 * i;
/*     */ 
/* 113 */           int k = paramArrayOfShort1[(j + 0)] & 0xFFFF;
/*     */ 
/* 116 */           int m = k;
/*     */ 
/* 118 */           if (k == 9) {
/* 119 */             k = 1;
/*     */           }
/* 121 */           Accessor localAccessor = paramOracleStatement.allocateAccessor(k, k, i, 0, (short)0, null, false);
/*     */ 
/* 130 */           localAccessor.rowSpaceIndicator = null;
/*     */ 
/* 132 */           if (paramArrayOfAccessor == null)
/*     */           {
/* 134 */             paramArrayOfAccessor = new Accessor[i + 1];
/* 135 */             paramArrayOfAccessor[i] = localAccessor;
/*     */           }
/* 137 */           else if (paramArrayOfAccessor.length <= i)
/*     */           {
/* 139 */             Accessor[] arrayOfAccessor = new Accessor[i + 1];
/*     */ 
/* 141 */             arrayOfAccessor[i] = localAccessor;
/*     */ 
/* 143 */             for (int n = 0; n < paramArrayOfAccessor.length; n++)
/*     */             {
/* 145 */               if (paramArrayOfAccessor[n] != null) {
/* 146 */                 arrayOfAccessor[n] = paramArrayOfAccessor[n];
/*     */               }
/*     */             }
/* 149 */             paramArrayOfAccessor = arrayOfAccessor;
/*     */           }
/*     */           else
/*     */           {
/* 155 */             paramArrayOfAccessor[i] = localAccessor;
/*     */           }
/*     */         }
/* 158 */         else if (((paramArrayOfByte3[i] & 0x10) == 0) && (paramArrayOfAccessor != null) && (i < paramArrayOfAccessor.length) && (paramArrayOfAccessor[i] != null))
/*     */         {
/* 164 */           paramArrayOfAccessor[i].isUseLess = true;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 171 */     return paramArrayOfAccessor;
/*     */   }
/*     */ 
/*     */   void unmarshalV10()
/*     */     throws IOException, SQLException
/*     */   {
/* 180 */     this.rxh.unmarshalV10(this.rxd);
/*     */ 
/* 182 */     this.bindcnt = this.rxh.numRqsts;
/*     */ 
/* 192 */     this.iovector = new byte[this.connection.all8.numberOfBindPositions];
/*     */ 
/* 194 */     for (int i = 0; i < this.iovector.length; i++)
/*     */     {
/* 198 */       if ((this.bindtype = this.meg.unmarshalUB1()) == 0)
/*     */       {
/* 202 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401);
/* 203 */         localSQLException.fillInStackTrace();
/* 204 */         throw localSQLException;
/*     */       }
/*     */ 
/* 210 */       if ((this.bindtype & 0x20) > 0)
/*     */       {
/*     */         int tmp97_96 = i;
/*     */         byte[] tmp97_93 = this.iovector; tmp97_93[tmp97_96] = ((byte)(tmp97_93[tmp97_96] | 0x20));
/* 213 */         this.inbinds += 1;
/*     */       }
/*     */ 
/* 216 */       if ((this.bindtype & 0x10) > 0)
/*     */       {
/*     */         int tmp129_128 = i;
/*     */         byte[] tmp129_125 = this.iovector; tmp129_125[tmp129_128] = ((byte)(tmp129_125[tmp129_128] | 0x10));
/* 219 */         this.outbinds += 1;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   byte[] getIOVector()
/*     */   {
/* 237 */     return this.iovector;
/*     */   }
/*     */ 
/*     */   boolean isIOVectorEmpty()
/*     */   {
/* 248 */     return this.iovector.length == 0;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIiov
 * JD-Core Version:    0.6.2
 */