/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLRecoverableException;
/*     */ import java.sql.SQLWarning;
/*     */ import java.util.Arrays;
/*     */ import java.util.EnumSet;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.net.ns.BreakNetException;
/*     */ 
/*     */ abstract class T4CTTIfun extends T4CTTIMsg
/*     */ {
/*     */   static final short OOPEN = 2;
/*     */   static final short OFETCH = 5;
/*     */   static final short OCLOSE = 8;
/*     */   static final short OLOGOFF = 9;
/*     */   static final short OCOMON = 12;
/*     */   static final short OCOMOFF = 13;
/*     */   static final short OCOMMIT = 14;
/*     */   static final short OROLLBACK = 15;
/*     */   static final short OCANCEL = 20;
/*     */   static final short ODSCRARR = 43;
/*     */   static final short OVERSION = 59;
/*     */   static final short OK2RPC = 67;
/*     */   static final short OALL7 = 71;
/*     */   static final short OSQL7 = 74;
/*     */   static final short O3LOGON = 81;
/*     */   static final short O3LOGA = 82;
/*     */   static final short OKOD = 92;
/*     */   static final short OALL8 = 94;
/*     */   static final short OLOBOPS = 96;
/*     */   static final short ODNY = 98;
/*     */   static final short OTXSE = 103;
/*     */   static final short OTXEN = 104;
/*     */   static final short OCCA = 105;
/*     */   static final short O80SES = 107;
/*     */   static final short OAUTH = 115;
/*     */   static final short OSESSKEY = 118;
/*     */   static final short OCANA = 120;
/*     */   static final short OKPN = 125;
/*     */   static final short OOTCM = 127;
/*     */   static final short OSCID = 135;
/*     */   static final short OSPFPPUT = 138;
/*     */   static final short OKPFC = 139;
/*     */   static final short OPING = 147;
/*     */   static final short OKEYVAL = 154;
/*     */   static final short OXSSCS = 155;
/*     */   static final short OXSSRO = 156;
/*     */   static final short OXSSPO = 157;
/*     */   static final short OAQEQ = 121;
/*     */   static final short OAQDQ = 122;
/*     */   static final short OAQGPS = 132;
/*     */   static final short OAQLS = 126;
/*     */   static final short OAQXQ = 145;
/*     */   static final short OSESSGET = 162;
/*     */   static final short OSESSRLS = 163;
/*     */   static final short OXSNSO = 172;
/*     */   static final short OXSNS = 178;
/*     */   static final short OXSSYNC = 176;
/*     */   static final short OXSATT = 180;
/*     */   static final short OXSCRE = 179;
/*     */   static final short OXSDET = 181;
/*     */   static final short OXSDES = 182;
/*     */   static final short OXSSET = 183;
/*     */   static final short OSESSSTATE = 176;
/*     */   static final short OAPPCONTREPLAY = 177;
/*     */   static final short OAQENQ = 184;
/*     */   static final short OAQDEQ = 185;
/*     */   static final short OAQEMNDEQ = 186;
/*     */   static final short OAQNFY = 187;
/*     */   private short funCode;
/*     */   protected final T4CTTIoer oer;
/* 311 */   int receiveState = 0;
/*     */   static final int IDLE_RECEIVE_STATE = 0;
/*     */   static final int ACTIVE_RECEIVE_STATE = 1;
/*     */   static final int READROW_RECEIVE_STATE = 2;
/*     */   static final int STREAM_RECEIVE_STATE = 3;
/* 323 */   boolean rpaProcessed = false;
/* 324 */   boolean rxhProcessed = false;
/* 325 */   boolean iovProcessed = false;
/*     */   private final short[] ttiList;
/* 355 */   private int ttiListEnd = 0;
/*     */ 
/* 965 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIfun(T4CConnection paramT4CConnection, byte paramByte)
/*     */   {
/* 147 */     super(paramT4CConnection, paramByte);
/*     */ 
/* 149 */     this.oer = paramT4CConnection.getT4CTTIoer();
/* 150 */     this.ttiList = paramT4CConnection.ttiList;
/*     */   }
/*     */ 
/*     */   final void setFunCode(short paramShort)
/*     */   {
/* 157 */     this.funCode = paramShort;
/*     */   }
/*     */ 
/*     */   final short getFunCode()
/*     */   {
/* 163 */     return this.funCode;
/*     */   }
/*     */ 
/*     */   private final void marshalFunHeader()
/*     */     throws IOException
/*     */   {
/* 178 */     this.connection.setExecutingRPCFunctionCode(this.funCode);
/*     */ 
/* 180 */     marshalTTCcode();
/* 181 */     this.meg.marshalUB1(this.funCode);
/* 182 */     this.meg.marshalUB1((short)this.connection.getNextSeqNumber());
/*     */   }
/*     */ 
/*     */   abstract void marshal()
/*     */     throws IOException;
/*     */ 
/*     */   final void doRPC()
/*     */     throws IOException, SQLException
/*     */   {
/* 199 */     if (getTTCCode() == 17)
/*     */     {
/* 202 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401);
/* 203 */       localSQLException1.fillInStackTrace();
/* 204 */       throw localSQLException1;
/*     */     }
/*     */ 
/* 208 */     this.connection.sendPiggyBackedMessages();
/*     */ 
/* 240 */     for (int i = 0; i < 5; i++)
/*     */     {
/* 242 */       init();
/* 243 */       marshalFunHeader();
/*     */       try
/*     */       {
/* 246 */         this.connection.pipeState = 1;
/* 247 */         marshal();
/* 248 */         this.connection.pipeState = 2;
/* 249 */         receive();
/*     */       }
/*     */       catch (SQLException localSQLException2)
/*     */       {
/* 253 */         synchronized (this.connection.cancelInProgressLockForThin)
/*     */         {
/* 256 */           if ((localSQLException2.getErrorCode() == 1013) || ((this.connection.cancelInProgressFlag) && (localSQLException2.getMessage() != null) && (localSQLException2.getMessage().contains("ORA-01013"))))
/*     */           {
/* 260 */             this.connection.cancelInProgressFlag = false;
/*     */ 
/* 263 */             if ((this.funCode == 15) || (this.funCode == 12) || (this.funCode == 13) || (this.funCode == 14) || (this.funCode == 59))
/*     */             {
/* 265 */               if ((this.oer.callNumber != this.connection.currentTTCSeqNumber) || (this.connection.statementCancel))
/*     */               {
/* 274 */                 this.connection.pipeState = -1; continue;
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/* 270 */         throw localSQLException2;
/*     */       }
/*     */       finally
/*     */       {
/* 274 */         this.connection.pipeState = -1;
/*     */       }
/* 276 */       break;
/*     */     }
/*     */   }
/*     */ 
/*     */   final void doPigRPC()
/*     */     throws IOException
/*     */   {
/* 284 */     init();
/* 285 */     marshalFunHeader();
/* 286 */     marshal();
/*     */   }
/*     */ 
/*     */   final void doOneWayRPC()
/*     */     throws IOException, SQLException
/*     */   {
/* 293 */     this.connection.sendPiggyBackedMessages();
/* 294 */     init();
/* 295 */     marshalFunHeader();
/* 296 */     marshal();
/*     */ 
/* 299 */     this.meg.flush();
/*     */   }
/*     */ 
/*     */   private void init()
/*     */   {
/* 335 */     this.rpaProcessed = false;
/* 336 */     this.rxhProcessed = false;
/* 337 */     this.iovProcessed = false;
/* 338 */     this.ttiListEnd = 0;
/*     */   }
/*     */ 
/*     */   void resumeReceive()
/*     */     throws SQLException, IOException
/*     */   {
/* 350 */     receive();
/*     */   }
/*     */ 
/*     */   private final String ttiListString()
/*     */   {
/* 359 */     String str = "[ ";
/* 360 */     for (int i = 0; i < this.ttiListEnd; i++) str = str + this.ttiList[i] + ", ";
/* 361 */     str = str + "]";
/* 362 */     return str;
/*     */   }
/*     */ 
/*     */   private void receive()
/*     */     throws SQLException, IOException
/*     */   {
/* 373 */     ReplayContext localReplayContext = null;
/*     */ 
/* 376 */     this.receiveState = 1;
/*     */     try
/*     */     {
/* 383 */       Object localObject1 = null;
/*     */       while (true)
/*     */       {
/*     */         try
/*     */         {
/* 390 */           int i = this.meg.unmarshalUB1();
/* 391 */           if (this.ttiListEnd < this.ttiList.length) this.ttiList[(this.ttiListEnd++)] = i;
/*     */ 
/* 394 */           switch (i)
/*     */           {
/*     */           case 8:
/* 399 */             if (this.rpaProcessed)
/*     */             {
/* 401 */               SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401);
/* 402 */               localSQLException2.fillInStackTrace();
/* 403 */               throw localSQLException2;
/*     */             }
/* 405 */             readRPA();
/*     */             try {
/* 407 */               processRPA();
/*     */             }
/*     */             catch (SQLException localSQLException3)
/*     */             {
/* 411 */               localObject1 = localSQLException3;
/*     */             }
/* 413 */             this.rpaProcessed = true;
/* 414 */             break;
/*     */           case 21:
/* 419 */             readBVC();
/* 420 */             break;
/*     */           case 11:
/* 423 */             readIOV();
/* 424 */             this.iovProcessed = true;
/* 425 */             break;
/*     */           case 6:
/* 429 */             readRXH();
/* 430 */             this.rxhProcessed = true;
/* 431 */             break;
/*     */           case 12:
/* 433 */             processSLG();
/* 434 */             break;
/*     */           case 7:
/* 438 */             this.receiveState = 2;
/*     */ 
/* 441 */             if (readRXD())
/*     */             {
/* 445 */               this.receiveState = 3;
/*     */               return;
/*     */             }
/*     */ 
/* 452 */             this.receiveState = 1;
/*     */ 
/* 454 */             break;
/*     */           case 16:
/* 458 */             readDCB();
/* 459 */             break;
/*     */           case 14:
/* 461 */             readLOBD();
/* 462 */             break;
/*     */           case 23:
/* 466 */             int j = (byte)this.meg.unmarshalUB1();
/*     */             int k;
/*     */             int m;
/*     */             Object localObject3;
/*     */             Object localObject2;
/*     */             int i1;
/*     */             int i2;
/* 467 */             switch (j)
/*     */             {
/*     */             case 1:
/* 470 */               k = this.meg.unmarshalUB2();
/* 471 */               m = (byte)this.meg.unmarshalUB1();
/*     */ 
/* 483 */               int n = 0; if (n < k) {
/* 484 */                 localObject3 = new T4CTTIidc(this.connection);
/* 485 */                 ((T4CTTIidc)localObject3).unmarshal();
/*     */ 
/* 483 */                 n++;
/*     */               }
/*     */ 
/* 488 */               break;
/*     */             case 2:
/* 492 */               k = this.meg.unmarshalUB2();
/* 493 */               m = (byte)this.meg.unmarshalUB1();
/*     */ 
/* 495 */               localObject2 = this.meg.unmarshalNBytes(k);
/*     */ 
/* 498 */               break;
/*     */             case 4:
/* 501 */               this.connection.ocsessret.receive();
/*     */ 
/* 503 */               break;
/*     */             case 5:
/* 507 */               k = this.meg.unmarshalUB2();
/* 508 */               m = (byte)this.meg.unmarshalUB1();
/*     */ 
/* 514 */               localObject2 = new T4CTTIkvarr(this.connection);
/* 515 */               ((T4CTTIkvarr)localObject2).unmarshal();
/*     */ 
/* 517 */               break;
/*     */             case 7:
/* 528 */               byte[] arrayOfByte1 = this.meg.unmarshalDALC();
/* 529 */               m = Arrays.hashCode(arrayOfByte1);
/* 530 */               if (this.connection.thinACLastLtxidHash != m)
/*     */               {
/* 536 */                 localObject2 = new LogicalTransactionId(arrayOfByte1);
/*     */ 
/* 538 */                 this.connection.thinACCurrentLTXID = ((LogicalTransactionId)localObject2);
/* 539 */                 localObject3 = new NTFLTXIDEvent(this.connection, (LogicalTransactionId)localObject2);
/* 540 */                 this.connection.notify((NTFLTXIDEvent)localObject3);
/* 541 */                 this.connection.thinACLastLtxidHash = m;
/*     */               }
/* 543 */               break;
/*     */             case 9:
/* 548 */               i1 = this.meg.unmarshalUB2();
/* 549 */               i2 = (byte)this.meg.unmarshalUB1();
/* 550 */               int i3 = 0; if (i3 < i1) {
/* 551 */                 NTFXSEvent localNTFXSEvent = new NTFXSEvent(this.connection);
/* 552 */                 this.connection.notify(localNTFXSEvent);
/*     */ 
/* 550 */                 i3++;
/*     */               }
/*     */ 
/* 555 */               break;
/*     */             case 8:
/* 585 */               i1 = this.meg.unmarshalUB2();
/* 586 */               i2 = (byte)this.meg.unmarshalUB1();
/* 587 */               long l1 = this.meg.unmarshalUB4();
/* 588 */               long l2 = this.meg.unmarshalUB4();
/* 589 */               short s2 = this.meg.unmarshalUB1();
/* 590 */               byte[] arrayOfByte2 = this.meg.unmarshalDALC();
/* 591 */               localReplayContext = new ReplayContext(l1, s2, arrayOfByte2, l2);
/*     */ 
/* 597 */               break;
/*     */             case 3:
/*     */             case 6:
/*     */             default:
/* 604 */               SQLException localSQLException6 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401, ttiListString());
/* 605 */               localSQLException6.fillInStackTrace();
/* 606 */               throw localSQLException6;
/*     */             }
/*     */ 
/* 609 */             break;
/*     */           case 19:
/* 612 */             this.meg.marshalUB1((short)19);
/* 613 */             break;
/*     */           case 27:
/* 622 */             readIMPLRES();
/* 623 */             break;
/*     */           case 15:
/* 628 */             this.oer.init();
/* 629 */             this.oer.unmarshalWarning();
/*     */             try
/*     */             {
/* 632 */               this.oer.processWarning();
/*     */             } catch (SQLWarning localSQLWarning) {
/* 634 */               this.connection.setWarnings(DatabaseError.addSqlWarning(this.connection.getWarnings(), localSQLWarning));
/*     */             }
/*     */ 
/*     */           case 9:
/* 639 */             processEOCS();
/* 640 */             if (this.connection.getTTCVersion() >= 3) {
/* 641 */               short s1 = (short)this.meg.unmarshalUB2();
/* 642 */               this.connection.endToEndECIDSequenceNumber = s1;
/*     */             }
/*     */ 
/* 678 */             this.connection.sentCancel = false; break;
/*     */           case 13:
/* 647 */             readOAC();
/* 648 */             break;
/*     */           case 4:
/* 651 */             processEOCS();
/* 652 */             this.oer.init();
/* 653 */             this.oer.unmarshal();
/*     */             try {
/* 655 */               processError();
/*     */             }
/*     */             catch (SQLException localSQLException4)
/*     */             {
/* 660 */               localObject1 = localSQLException4;
/*     */             }
/*     */ 
/* 678 */             this.connection.sentCancel = false; break;
/*     */           case 5:
/*     */           case 10:
/*     */           case 17:
/*     */           case 18:
/*     */           case 20:
/*     */           case 22:
/*     */           case 24:
/*     */           case 25:
/*     */           case 26:
/*     */           default:
/* 668 */             SQLException localSQLException5 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401, ttiListString());
/* 669 */             localSQLException5.fillInStackTrace();
/* 670 */             throw localSQLException5;
/*     */           }
/*     */         }
/*     */         catch (BreakNetException localBreakNetException)
/*     */         {
/*     */         }
/*     */         finally
/*     */         {
/* 678 */           this.connection.sentCancel = false;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 684 */       this.receiveState = 0;
/*     */ 
/* 686 */       if (localObject1 != null) {
/* 687 */         throw localObject1;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (SQLRecoverableException localSQLRecoverableException)
/*     */     {
/* 702 */       throw localSQLRecoverableException;
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 706 */       if (localReplayContext != null)
/* 707 */         handleReplayContext(localReplayContext);
/* 708 */       throw localIOException;
/*     */     } catch (SQLException localSQLException1) {
/* 710 */       if (localReplayContext != null) {
/* 711 */         handleReplayContext(localReplayContext);
/*     */       }
/*     */ 
/* 717 */       this.connection.setExecutingRPCFunctionCode((short)0);
/* 718 */       this.connection.setExecutingRPCSQL(null);
/*     */ 
/* 720 */       throw localSQLException1;
/*     */     }
/* 722 */     if (localReplayContext != null) {
/* 723 */       handleReplayContext(localReplayContext);
/*     */     }
/*     */ 
/* 737 */     this.connection.setExecutingRPCFunctionCode((short)0);
/* 738 */     this.connection.setExecutingRPCSQL(null);
/*     */   }
/*     */ 
/*     */   private final void handleReplayContext(ReplayContext paramReplayContext)
/*     */   {
/* 750 */     if (this.connection.replayModes.contains(T4CConnection.ReplayMode.NONREQUEST)) {
/* 751 */       return;
/*     */     }
/*     */ 
/* 759 */     assert (((paramReplayContext.flags_kpdxcAppContCtl & 0x4) != 0L) || (paramReplayContext.errcode_kpdxcAppContCtl != 41406L) || (!this.connection.replayModes.contains(T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED))) : ("Server disabled replay with error " + paramReplayContext.errcode_kpdxcAppContCtl + " but our replayModes=" + this.connection.replayModes);
/*     */ 
/* 768 */     assert ((paramReplayContext.replayctx_kpdxcAppContCtl == null) || (paramReplayContext.replayctx_kpdxcAppContCtl.length <= 0) || (this.connection.getExecutingRPCFunctionCode() == 115) || (this.connection.replayModes.contains(T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED))) : ("Server is sending a non-null replay context but our replayModes=" + this.connection.replayModes);
/*     */ 
/* 770 */     if (this.connection.thinACReplayContextReceived.length == this.connection.thinACReplayContextReceivedCurrent)
/*     */     {
/* 772 */       ReplayContext[] arrayOfReplayContext = new ReplayContext[this.connection.thinACReplayContextReceived.length * 2];
/* 773 */       System.arraycopy(this.connection.thinACReplayContextReceived, 0, arrayOfReplayContext, 0, this.connection.thinACReplayContextReceived.length);
/* 774 */       this.connection.thinACReplayContextReceived = arrayOfReplayContext;
/*     */     }
/* 776 */     this.connection.thinACReplayContextReceived[(this.connection.thinACReplayContextReceivedCurrent++)] = paramReplayContext;
/*     */ 
/* 778 */     if ((paramReplayContext.flags_kpdxcAppContCtl & 0x4) == 0L)
/*     */     {
/* 780 */       this.connection.replayModes.remove(T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED);
/* 781 */       this.connection.replayModes.remove(T4CConnection.ReplayMode.RUNTIME_OR_REPLAYING_STATIC);
/*     */     }
/*     */ 
/* 788 */     if ((paramReplayContext.replayctx_kpdxcAppContCtl != null) && (paramReplayContext.replayctx_kpdxcAppContCtl.length > 0) && ((this.connection.getExecutingRPCFunctionCode() != 115) || (!this.connection.ignoreReplayContextFromAuthentication)))
/*     */     {
/* 792 */       this.connection.thinACLastReplayContextReceived = paramReplayContext;
/*     */     }
/*     */   }
/*     */ 
/*     */   private final void processEOCS()
/*     */     throws SQLException, IOException
/*     */   {
/* 803 */     if (this.connection.hasServerCompileTimeCapability(15, 1))
/*     */     {
/* 805 */       int i = (int)this.meg.unmarshalUB4();
/* 806 */       this.connection.eocs = i;
/* 807 */       if ((i & 0x8) != 0)
/*     */       {
/* 811 */         long l = this.meg.unmarshalSB8();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   void processRPA()
/*     */     throws SQLException
/*     */   {
/*     */   }
/*     */ 
/*     */   void readOAC()
/*     */   {
/*     */   }
/*     */ 
/*     */   void readRPA()
/*     */     throws IOException, SQLException
/*     */   {
/*     */   }
/*     */ 
/*     */   void readBVC()
/*     */     throws IOException, SQLException
/*     */   {
/* 849 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401);
/* 850 */     localSQLException.fillInStackTrace();
/* 851 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   void readLOBD()
/*     */     throws IOException, SQLException
/*     */   {
/* 860 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401);
/* 861 */     localSQLException.fillInStackTrace();
/* 862 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   void readIOV()
/*     */     throws IOException, SQLException
/*     */   {
/* 871 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401);
/* 872 */     localSQLException.fillInStackTrace();
/* 873 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   void readRXH()
/*     */     throws IOException, SQLException
/*     */   {
/* 882 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401);
/* 883 */     localSQLException.fillInStackTrace();
/* 884 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   boolean readRXD()
/*     */     throws IOException, SQLException
/*     */   {
/* 893 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401);
/* 894 */     localSQLException.fillInStackTrace();
/* 895 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   void readIMPLRES()
/*     */     throws IOException, SQLException
/*     */   {
/* 904 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401);
/* 905 */     localSQLException.fillInStackTrace();
/* 906 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   void readDCB()
/*     */     throws IOException, SQLException
/*     */   {
/* 915 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401);
/* 916 */     localSQLException.fillInStackTrace();
/* 917 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   void processSLG()
/*     */     throws IOException, SQLException
/*     */   {
/* 926 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401);
/* 927 */     localSQLException.fillInStackTrace();
/* 928 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   void processError()
/*     */     throws SQLException
/*     */   {
/* 938 */     this.oer.processError();
/*     */   }
/*     */ 
/*     */   final int getErrorCode()
/*     */     throws SQLException
/*     */   {
/* 945 */     return this.oer.retCode;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 960 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIfun
 * JD-Core Version:    0.6.2
 */