/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.sql.SQLException;
/*      */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*      */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*      */ import oracle.jdbc.oracore.OracleTypeADT;
/*      */ 
/*      */ class T4CTTIdcb extends T4CTTIMsg
/*      */ {
/*      */   static final int DCBRXFR = 1;
/*      */   static final int DCBFIOT = 2;
/*      */   static final int DCBFHAVECOOKIE = 4;
/*      */   static final int DCBFNEWCOOKIE = 8;
/*      */   static final int DCBFREM = 16;
/*      */   int numuds;
/*      */   int colOffset;
/*      */   byte[] ignoreBuff;
/*  120 */   OracleStatement statement = null;
/*      */ 
/* 1103 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   T4CTTIdcb(T4CConnection paramT4CConnection)
/*      */   {
/*  125 */     super(paramT4CConnection, (byte)16);
/*      */ 
/*  127 */     this.ignoreBuff = new byte[40];
/*      */   }
/*      */ 
/*      */   void init(OracleStatement paramOracleStatement, int paramInt)
/*      */   {
/*  134 */     this.statement = paramOracleStatement;
/*  135 */     this.colOffset = paramInt;
/*      */   }
/*      */ 
/*      */   Accessor[] receive(Accessor[] paramArrayOfAccessor)
/*      */     throws SQLException, IOException
/*      */   {
/*  145 */     int i = this.meg.unmarshalUB1();
/*      */ 
/*  147 */     if (this.ignoreBuff.length < i) {
/*  148 */       this.ignoreBuff = new byte[i];
/*      */     }
/*  150 */     this.meg.unmarshalNBytes(this.ignoreBuff, 0, i);
/*      */ 
/*  152 */     int j = (int)this.meg.unmarshalUB4();
/*      */ 
/*  154 */     paramArrayOfAccessor = receiveCommon(paramArrayOfAccessor, false);
/*      */ 
/*  156 */     return paramArrayOfAccessor;
/*      */   }
/*      */ 
/*      */   Accessor[] receiveFromRefCursor(Accessor[] paramArrayOfAccessor)
/*      */     throws SQLException, IOException
/*      */   {
/*  164 */     int i = this.meg.unmarshalUB1();
/*  165 */     int j = (int)this.meg.unmarshalUB4();
/*      */ 
/*  167 */     paramArrayOfAccessor = receiveCommon(paramArrayOfAccessor, false);
/*      */ 
/*  169 */     return paramArrayOfAccessor;
/*      */   }
/*      */ 
/*      */   Accessor[] receiveCommon(Accessor[] paramArrayOfAccessor, boolean paramBoolean)
/*      */     throws SQLException, IOException
/*      */   {
/*  178 */     if (paramBoolean) {
/*  179 */       this.numuds = this.meg.unmarshalUB2();
/*      */     }
/*      */     else {
/*  182 */       this.numuds = ((int)this.meg.unmarshalUB4());
/*  183 */       if (this.numuds > 0)
/*      */       {
/*  187 */         int i = this.meg.unmarshalUB1();
/*      */       }
/*      */     }
/*      */ 
/*  191 */     if (this.statement.needToPrepareDefineBuffer)
/*      */     {
/*  195 */       if ((paramArrayOfAccessor == null) || (paramArrayOfAccessor.length != this.numuds + this.colOffset))
/*      */       {
/*  197 */         localObject = new Accessor[this.numuds + this.colOffset];
/*  198 */         if ((paramArrayOfAccessor != null) && (paramArrayOfAccessor.length == this.colOffset))
/*      */         {
/*  200 */           System.arraycopy(paramArrayOfAccessor, 0, localObject, 0, this.colOffset);
/*      */         }
/*  202 */         paramArrayOfAccessor = (Accessor[])localObject;
/*      */       }
/*      */     }
/*      */ 
/*  206 */     Object localObject = new T4C8TTIuds((T4CConnection)this.statement.connection);
/*      */ 
/*  208 */     long l = this.statement.checkSum;
/*  209 */     for (int j = 0; j < this.numuds; j++)
/*      */     {
/*  211 */       ((T4C8TTIuds)localObject).unmarshal();
/*  212 */       String str = this.meg.conv.CharBytesToString(((T4C8TTIuds)localObject).getColumName(), ((T4C8TTIuds)localObject).getColumNameByteLength());
/*      */ 
/*  215 */       if (this.statement.needToPrepareDefineBuffer)
/*  216 */         l = fillupAccessors(paramArrayOfAccessor, this.colOffset + j, (T4C8TTIuds)localObject, str, l);
/*      */     }
/*  218 */     this.statement.checkSum = l;
/*      */ 
/*  220 */     if (!paramBoolean)
/*      */     {
/*  223 */       byte[] arrayOfByte1 = this.meg.unmarshalDALC();
/*      */ 
/*  226 */       if (this.connection.getTTCVersion() >= 3)
/*      */       {
/*  228 */         int k = (int)this.meg.unmarshalUB4();
/*  229 */         int m = (int)this.meg.unmarshalUB4();
/*      */ 
/*  232 */         if (this.connection.getTTCVersion() >= 4)
/*      */         {
/*  234 */           int n = (int)this.meg.unmarshalUB4();
/*  235 */           int i1 = (int)this.meg.unmarshalUB4();
/*      */ 
/*  237 */           if (this.connection.getTTCVersion() >= 5)
/*      */           {
/*  243 */             byte[] arrayOfByte2 = this.meg.unmarshalDALC();
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  268 */     if (this.statement.needToPrepareDefineBuffer)
/*      */     {
/*  274 */       if (!paramBoolean)
/*      */       {
/*  276 */         this.statement.rowPrefetchInLastFetch = -1;
/*  277 */         this.statement.describedWithNames = true;
/*  278 */         this.statement.described = true;
/*  279 */         this.statement.numberOfDefinePositions = this.numuds;
/*  280 */         this.statement.accessors = paramArrayOfAccessor;
/*      */ 
/*  285 */         this.statement.prepareAccessors();
/*      */ 
/*  288 */         this.statement.allocateTmpByteArray();
/*      */       }
/*      */     }
/*      */ 
/*  292 */     return paramArrayOfAccessor;
/*      */   }
/*      */ 
/*      */   long fillupAccessors(Accessor[] paramArrayOfAccessor, int paramInt, T4C8TTIuds paramT4C8TTIuds, String paramString, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  304 */     int[] arrayOfInt1 = this.statement.definedColumnType;
/*  305 */     int[] arrayOfInt2 = this.statement.definedColumnSize;
/*  306 */     int[] arrayOfInt3 = this.statement.definedColumnFormOfUse;
/*  307 */     int i = this.statement.isRowidPrepended ? 1 : 0;
/*      */ 
/*  310 */     String str1 = null;
/*  311 */     String str2 = null;
/*  312 */     String str3 = null;
/*      */ 
/*  319 */     int m = 0;
/*  320 */     int n = 0;
/*  321 */     int i1 = 0;
/*      */     int i2;
/*  326 */     if (paramInt >= i)
/*      */     {
/*  328 */       i2 = paramInt - i;
/*  329 */       if ((arrayOfInt1 != null) && (arrayOfInt1.length > i2) && (arrayOfInt1[i2] != 0))
/*      */       {
/*  332 */         m = arrayOfInt1[i2];
/*      */       }
/*  334 */       if ((arrayOfInt2 != null) && (arrayOfInt2.length > i2) && (arrayOfInt2[i2] > 0))
/*      */       {
/*  337 */         n = arrayOfInt2[i2];
/*      */       }
/*  339 */       if ((arrayOfInt3 != null) && (arrayOfInt3.length > i2) && (arrayOfInt3[i2] > 0))
/*      */       {
/*  342 */         i1 = arrayOfInt3[i2];
/*      */       }
/*      */     }
/*  345 */     int j = paramT4C8TTIuds.udsoac.oacmxl;
/*      */     int k;
/*  347 */     switch (paramT4C8TTIuds.udsoac.oacdty)
/*      */     {
/*      */     case 96:
/*  361 */       if ((paramT4C8TTIuds.udsoac.oacmxlc != 0) && (paramT4C8TTIuds.udsoac.oacmxlc < j))
/*      */       {
/*  367 */         j = 2 * paramT4C8TTIuds.udsoac.oacmxlc;
/*      */       }
/*      */ 
/*  372 */       k = j;
/*      */ 
/*  377 */       if (((m == 1) || (m == 12)) && (n > 0) && (n < j))
/*      */       {
/*  382 */         k = n;
/*      */       }
/*  384 */       paramArrayOfAccessor[paramInt] = new T4CCharAccessor(this.statement, k, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, j, m, n, this.meg);
/*      */ 
/*  399 */       if (((paramT4C8TTIuds.udsoac.oacfl2 & 0x1000) == 4096) || (paramT4C8TTIuds.udsoac.oacmxlc != 0))
/*      */       {
/*  401 */         paramArrayOfAccessor[paramInt].setDisplaySize(paramT4C8TTIuds.udsoac.oacmxlc); } break;
/*      */     case 2:
/*  407 */       paramArrayOfAccessor[paramInt] = new T4CNumberAccessor(this.statement, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  421 */       break;
/*      */     case 1:
/*  426 */       if ((paramT4C8TTIuds.udsoac.oacmxlc != 0) && (paramT4C8TTIuds.udsoac.oacmxlc < j)) {
/*  427 */         j = 2 * paramT4C8TTIuds.udsoac.oacmxlc;
/*      */       }
/*  429 */       k = j;
/*      */ 
/*  431 */       if (((m == 1) || (m == 12)) && (n > 0) && (n < j))
/*      */       {
/*  435 */         k = n;
/*      */       }
/*  437 */       paramArrayOfAccessor[paramInt] = new T4CVarcharAccessor(this.statement, k, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, j, m, n, this.meg);
/*      */ 
/*  452 */       if (((paramT4C8TTIuds.udsoac.oacfl2 & 0x1000) == 4096) || (paramT4C8TTIuds.udsoac.oacmxlc != 0))
/*      */       {
/*  454 */         paramArrayOfAccessor[paramInt].setDisplaySize(paramT4C8TTIuds.udsoac.oacmxlc); } break;
/*      */     case 8:
/*  459 */       if ((this.statement.isFetchStreams) || (((m == 1) || (m == 12)) && (this.connection.versionNumber >= 9000) && (n < 4001)))
/*      */       {
/*  474 */         if (n > 0) {
/*  475 */           k = n;
/*      */         }
/*      */         else
/*      */         {
/*  479 */           k = 32767;
/*      */         }
/*      */ 
/*  485 */         j = -1;
/*  486 */         paramArrayOfAccessor[paramInt] = new T4CVarcharAccessor(this.statement, k, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, j, m, n, this.meg);
/*      */ 
/*  500 */         paramArrayOfAccessor[paramInt].describeType = 8;
/*      */       }
/*      */       else
/*      */       {
/*  507 */         j = 0;
/*      */ 
/*  509 */         paramArrayOfAccessor[paramInt] = new T4CLongAccessor(this.statement, paramInt + 1, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */       }
/*      */ 
/*  525 */       break;
/*      */     case 6:
/*  528 */       paramArrayOfAccessor[paramInt] = new T4CVarnumAccessor(this.statement, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  542 */       break;
/*      */     case 100:
/*  545 */       paramArrayOfAccessor[paramInt] = new T4CBinaryFloatAccessor(this.statement, 4, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  564 */       break;
/*      */     case 101:
/*  567 */       paramArrayOfAccessor[paramInt] = new T4CBinaryDoubleAccessor(this.statement, 8, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  582 */       break;
/*      */     case 23:
/*  585 */       paramArrayOfAccessor[paramInt] = new T4CRawAccessor(this.statement, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  599 */       break;
/*      */     case 24:
/*  602 */       if ((this.statement.isFetchStreams) || ((m == -2) && (n < 2001) && (this.connection.versionNumber >= 9000)))
/*      */       {
/*  610 */         j = -1;
/*  611 */         paramArrayOfAccessor[paramInt] = new T4CRawAccessor(this.statement, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  624 */         paramArrayOfAccessor[paramInt].describeType = 24;
/*      */       }
/*      */       else {
/*  627 */         paramArrayOfAccessor[paramInt] = new T4CLongRawAccessor(this.statement, paramInt + 1, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */       }
/*      */ 
/*  642 */       break;
/*      */     case 11:
/*      */     case 104:
/*      */     case 208:
/*  647 */       paramArrayOfAccessor[paramInt] = new T4CRowidAccessor(this.statement, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  661 */       if (paramT4C8TTIuds.udsoac.oacdty == 208)
/*  662 */         paramArrayOfAccessor[paramInt].describeType = 208; break;
/*      */     case 102:
/*  667 */       paramArrayOfAccessor[paramInt] = new T4CResultSetAccessor(this.statement, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  681 */       break;
/*      */     case 12:
/*  684 */       paramArrayOfAccessor[paramInt] = new T4CDateAccessor(this.statement, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  698 */       break;
/*      */     case 113:
/*  701 */       if ((m == -4) && (this.connection.versionNumber >= 9000))
/*      */       {
/*  706 */         paramArrayOfAccessor[paramInt] = new T4CLongRawAccessor(this.statement, paramInt + 1, 2147483647, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  721 */         paramArrayOfAccessor[paramInt].describeType = 113;
/*      */       }
/*  723 */       else if ((m == -3) && (this.connection.versionNumber >= 9000))
/*      */       {
/*  728 */         paramArrayOfAccessor[paramInt] = new T4CRawAccessor(this.statement, 4000, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  741 */         paramArrayOfAccessor[paramInt].describeType = 113;
/*      */       }
/*      */       else
/*      */       {
/*  745 */         paramArrayOfAccessor[paramInt] = new T4CBlobAccessor(this.statement, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  759 */         if ((this.connection.useLobPrefetch) && (m == 2004))
/*      */         {
/*  761 */           paramArrayOfAccessor[paramInt].setPrefetchLength(n);
/*      */         }
/*      */         else
/*      */         {
/*  765 */           paramArrayOfAccessor[paramInt].setNoPrefetch();
/*      */         }
/*      */       }
/*  768 */       break;
/*      */     case 112:
/*  771 */       i2 = 1;
/*  772 */       if (i1 != 0) {
/*  773 */         i2 = (short)i1;
/*      */       }
/*  775 */       if (((m == -1) || (m == -16)) && (this.connection.versionNumber >= 9000))
/*      */       {
/*  781 */         j = 0;
/*  782 */         paramArrayOfAccessor[paramInt] = new T4CLongAccessor(this.statement, paramInt + 1, 2147483647, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, i2, m, n, this.meg);
/*      */ 
/*  798 */         paramArrayOfAccessor[paramInt].describeType = 112;
/*      */       }
/*  800 */       else if (((m == 12) || (m == 1) || (m == -15) || (m == -9)) && (this.connection.versionNumber >= 9000))
/*      */       {
/*  808 */         k = 32767;
/*  809 */         if ((n > 0) && (n < k))
/*      */         {
/*  811 */           k = n;
/*      */         }
/*  813 */         paramArrayOfAccessor[paramInt] = new T4CVarcharAccessor(this.statement, k, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, i2, 32767, m, n, this.meg);
/*      */ 
/*  828 */         paramArrayOfAccessor[paramInt].describeType = 112;
/*      */       }
/*      */       else {
/*  831 */         paramArrayOfAccessor[paramInt] = new T4CClobAccessor(this.statement, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  844 */         if ((this.connection.useLobPrefetch) && ((m == 2005) || (m == 2011)))
/*      */         {
/*  849 */           paramArrayOfAccessor[paramInt].setPrefetchLength(n);
/*      */         }
/*      */         else {
/*  852 */           paramArrayOfAccessor[paramInt].setNoPrefetch();
/*      */         }
/*      */       }
/*  855 */       break;
/*      */     case 114:
/*  858 */       paramArrayOfAccessor[paramInt] = new T4CBfileAccessor(this.statement, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  871 */       if ((this.connection.useLobPrefetch) && (m == -13))
/*      */       {
/*  873 */         paramArrayOfAccessor[paramInt].setPrefetchLength(n);
/*      */       }
/*  875 */       else paramArrayOfAccessor[paramInt].setNoPrefetch();
/*      */ 
/*  877 */       break;
/*      */     case 109:
/*  880 */       str1 = this.meg.conv.CharBytesToString(paramT4C8TTIuds.getTypeName(), paramT4C8TTIuds.getTypeCharLength());
/*      */ 
/*  884 */       str2 = this.meg.conv.CharBytesToString(paramT4C8TTIuds.getSchemaName(), paramT4C8TTIuds.getSchemaCharLength());
/*      */ 
/*  887 */       str3 = str2 + "." + str1;
/*      */ 
/*  889 */       paramArrayOfAccessor[paramInt] = new T4CNamedTypeAccessor(this.statement, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, str3, m, n, this.meg);
/*      */ 
/*  904 */       break;
/*      */     case 111:
/*  907 */       str1 = this.meg.conv.CharBytesToString(paramT4C8TTIuds.getTypeName(), paramT4C8TTIuds.getTypeCharLength());
/*      */ 
/*  911 */       str2 = this.meg.conv.CharBytesToString(paramT4C8TTIuds.getSchemaName(), paramT4C8TTIuds.getSchemaCharLength());
/*      */ 
/*  914 */       str3 = str2 + "." + str1;
/*      */ 
/*  916 */       paramArrayOfAccessor[paramInt] = new T4CRefTypeAccessor(this.statement, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, str3, m, n, this.meg);
/*      */ 
/*  931 */       break;
/*      */     case 180:
/*  934 */       paramArrayOfAccessor[paramInt] = new T4CTimestampAccessor(this.statement, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  948 */       break;
/*      */     case 181:
/*  951 */       paramArrayOfAccessor[paramInt] = new T4CTimestamptzAccessor(this.statement, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  965 */       break;
/*      */     case 231:
/*  968 */       paramArrayOfAccessor[paramInt] = new T4CTimestampltzAccessor(this.statement, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  982 */       break;
/*      */     case 182:
/*  985 */       paramArrayOfAccessor[paramInt] = new T4CIntervalymAccessor(this.statement, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/*  999 */       break;
/*      */     case 183:
/* 1002 */       paramArrayOfAccessor[paramInt] = new T4CIntervaldsAccessor(this.statement, j, paramT4C8TTIuds.udsnull, paramT4C8TTIuds.udsoac.oacflg, paramT4C8TTIuds.udsoac.oacpre, paramT4C8TTIuds.udsoac.oacscl, paramT4C8TTIuds.udsoac.oacfl2, paramT4C8TTIuds.udsoac.oacmal, paramT4C8TTIuds.udsoac.oaccsfrm, m, n, this.meg);
/*      */ 
/* 1016 */       break;
/*      */     default:
/* 1021 */       if (!$assertionsDisabled) throw new AssertionError("ud.udsoac.oacdty: " + paramT4C8TTIuds.udsoac.oacdty);
/* 1022 */       paramArrayOfAccessor[paramInt] = null;
/*      */     }
/*      */ 
/* 1028 */     if (paramT4C8TTIuds.udsoac.oactoid.length > 0)
/*      */     {
/* 1030 */       paramArrayOfAccessor[paramInt].internalOtype = new OracleTypeADT(paramT4C8TTIuds.udsoac.oactoid, paramT4C8TTIuds.udsoac.oacvsn, paramT4C8TTIuds.udsoac.oaccsi, paramT4C8TTIuds.udsoac.oaccsfrm, str2 + "." + str1);
/*      */     }
/*      */     else
/*      */     {
/* 1035 */       paramArrayOfAccessor[paramInt].internalOtype = null;
/*      */     }
/*      */ 
/* 1038 */     paramArrayOfAccessor[paramInt].columnName = paramString;
/*      */ 
/* 1041 */     paramArrayOfAccessor[paramInt].securityAttribute = OracleResultSetMetaData.SecurityAttribute.NONE;
/*      */ 
/* 1043 */     if ((paramT4C8TTIuds.udsflg & 0x1) != 0) {
/* 1044 */       paramArrayOfAccessor[paramInt].securityAttribute = OracleResultSetMetaData.SecurityAttribute.ENABLED;
/*      */     }
/* 1046 */     else if ((paramT4C8TTIuds.udsflg & 0x2) != 0) {
/* 1047 */       paramArrayOfAccessor[paramInt].securityAttribute = OracleResultSetMetaData.SecurityAttribute.UNKNOWN;
/*      */     }
/*      */ 
/* 1051 */     paramArrayOfAccessor[paramInt].setColumnInvisible((paramT4C8TTIuds.udsflg & 0x8) != 0);
/*      */ 
/* 1056 */     if (paramT4C8TTIuds.udsoac.oacmxl == 0) {
/* 1057 */       paramArrayOfAccessor[paramInt].isNullByDescribe = true;
/*      */     }
/* 1059 */     paramArrayOfAccessor[paramInt].udskpos = paramT4C8TTIuds.getKernelPosition();
/*      */ 
/* 1076 */     if (this.connection.checksumMode.needToCalculateFetchChecksum())
/*      */     {
/* 1078 */       paramLong = CRC64.updateChecksum(paramLong, paramT4C8TTIuds.udsoac.oacdty);
/*      */ 
/* 1080 */       paramLong = CRC64.updateChecksum(paramLong, paramT4C8TTIuds.udsoac.oacmxl);
/*      */ 
/* 1082 */       paramLong = CRC64.updateChecksum(paramLong, paramT4C8TTIuds.udsoac.oacpre);
/*      */ 
/* 1084 */       paramLong = CRC64.updateChecksum(paramLong, paramT4C8TTIuds.udsoac.oacscl);
/*      */ 
/* 1086 */       paramLong = CRC64.updateChecksum(paramLong, paramT4C8TTIuds.udsoac.oaccsfrm);
/*      */ 
/* 1088 */       if (str1 != null)
/*      */       {
/* 1090 */         paramLong = CRC64.updateChecksum(paramLong, str2 + "." + str1);
/*      */       }
/*      */ 
/* 1094 */       paramLong = CRC64.updateChecksum(paramLong, paramString);
/*      */     }
/*      */ 
/* 1098 */     return paramLong;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIdcb
 * JD-Core Version:    0.6.2
 */