/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.sql.TIMESTAMP;
/*     */ 
/*     */ class T4CTTIaqm
/*     */ {
/*     */   static final int ATTR_ORIGINAL_MSGID = 69;
/*     */   static final byte ATTR_AGENT_NAME = 64;
/*     */   static final byte ATTR_AGENT_ADDRESS = 65;
/*     */   static final byte ATTR_AGENT_PROTOCOL = 66;
/*     */   static final int AQM_MSG_NO_DELAY = 0;
/*     */   static final int AQM_MSG_NO_EXPIRATION = -1;
/*     */   static final int AQM_MSGPROP_CORRID_SIZE = 128;
/*     */   int aqmpri;
/*     */   int aqmdel;
/*     */   int aqmexp;
/*     */   byte[] aqmcorBytes;
/*     */   int aqmcorBytesLength;
/*     */   int aqmatt;
/*     */   byte[] aqmeqnBytes;
/*     */   int aqmeqnBytesLength;
/*     */   int aqmsta;
/* 109 */   private byte[] aqmeqtBuffer = new byte[7];
/* 110 */   private int[] retInt = new int[1];
/*     */   TIMESTAMP aqmeqt;
/*     */   byte[] aqmetiBytes;
/* 117 */   byte[] senderAgentName = null;
/* 118 */   int senderAgentNameLength = 0;
/* 119 */   byte[] senderAgentAddress = null;
/* 120 */   int senderAgentAddressLength = 0;
/* 121 */   byte senderAgentProtocol = 0;
/*     */   byte[] originalMsgId;
/*     */   T4Ctoh toh;
/*     */   int aqmcsn;
/*     */   int aqmdsn;
/*     */   int aqmflg;
/*     */   T4CMAREngine mar;
/*     */   T4CConnection connection;
/* 385 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIaqm(T4CConnection paramT4CConnection, T4Ctoh paramT4Ctoh)
/*     */   {
/* 136 */     this.toh = paramT4Ctoh;
/* 137 */     this.connection = paramT4CConnection;
/* 138 */     this.mar = this.connection.mare;
/*     */   }
/*     */ 
/*     */   void initToDefaultValues()
/*     */   {
/* 145 */     this.aqmpri = 0;
/* 146 */     this.aqmdel = 0;
/* 147 */     this.aqmexp = -1;
/* 148 */     this.aqmcorBytes = null;
/* 149 */     this.aqmcorBytesLength = 0;
/* 150 */     this.aqmatt = 0;
/* 151 */     this.aqmeqnBytes = null;
/* 152 */     this.aqmeqnBytesLength = 0;
/* 153 */     this.aqmsta = 0;
/* 154 */     this.aqmeqt = null;
/* 155 */     this.aqmetiBytes = null;
/* 156 */     this.senderAgentName = null;
/* 157 */     this.senderAgentNameLength = 0;
/* 158 */     this.senderAgentAddress = null;
/* 159 */     this.senderAgentAddressLength = 0;
/* 160 */     this.senderAgentProtocol = 0;
/* 161 */     this.originalMsgId = null;
/* 162 */     this.aqmcsn = 0;
/* 163 */     this.aqmdsn = 0;
/* 164 */     this.aqmflg = 0;
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 172 */     this.mar.marshalSB4(this.aqmpri);
/* 173 */     this.mar.marshalSB4(this.aqmdel);
/* 174 */     this.mar.marshalSB4(this.aqmexp);
/* 175 */     if ((this.aqmcorBytes != null) && (this.aqmcorBytes.length != 0))
/*     */     {
/* 177 */       this.mar.marshalSWORD(this.aqmcorBytes.length);
/* 178 */       this.mar.marshalCLR(this.aqmcorBytes, 0, this.aqmcorBytes.length);
/*     */     }
/*     */     else {
/* 181 */       this.mar.marshalSWORD(0);
/*     */     }
/*     */ 
/* 184 */     this.mar.marshalSB4(0);
/*     */ 
/* 186 */     if ((this.aqmeqnBytes != null) && (this.aqmeqnBytes.length != 0))
/*     */     {
/* 188 */       this.mar.marshalSWORD(this.aqmeqnBytes.length);
/* 189 */       this.mar.marshalCLR(this.aqmeqnBytes, 0, this.aqmeqnBytes.length);
/*     */     }
/*     */     else {
/* 192 */       this.mar.marshalSWORD(0);
/*     */     }
/*     */ 
/* 195 */     this.mar.marshalSB4(this.aqmsta);
/*     */ 
/* 198 */     this.mar.marshalSWORD(0);
/*     */ 
/* 200 */     if (this.connection.getTTCVersion() >= 3)
/*     */     {
/* 202 */       if ((this.aqmetiBytes != null) && (this.aqmetiBytes.length > 0))
/*     */       {
/* 204 */         this.mar.marshalSWORD(this.aqmetiBytes.length);
/* 205 */         this.mar.marshalCLR(this.aqmetiBytes, 0, this.aqmetiBytes.length);
/*     */       }
/*     */       else {
/* 208 */         this.mar.marshalSWORD(0);
/*     */       }
/*     */     }
/* 211 */     int i = 4;
/* 212 */     byte[][] arrayOfByte1 = new byte[i][];
/* 213 */     byte[][] arrayOfByte2 = new byte[i][];
/* 214 */     int[] arrayOfInt = new int[i];
/* 215 */     arrayOfByte1[0] = this.senderAgentName;
/* 216 */     arrayOfByte2[0] = null;
/* 217 */     arrayOfInt[0] = 64;
/* 218 */     arrayOfByte1[1] = this.senderAgentAddress;
/* 219 */     arrayOfByte2[1] = null;
/* 220 */     arrayOfInt[1] = 65;
/* 221 */     arrayOfByte1[2] = null;
/* 222 */     arrayOfByte2[2] = new byte[1];
/* 223 */     arrayOfByte2[2][0] = this.senderAgentProtocol;
/* 224 */     arrayOfInt[2] = 66;
/*     */ 
/* 226 */     arrayOfByte1[3] = null;
/* 227 */     arrayOfByte2[3] = this.originalMsgId;
/* 228 */     arrayOfInt[3] = 69;
/*     */ 
/* 231 */     this.mar.marshalSWORD(i);
/*     */ 
/* 233 */     this.mar.marshalUB1((short)14);
/*     */ 
/* 237 */     this.mar.marshalKPDKV(arrayOfByte1, arrayOfByte2, arrayOfInt);
/*     */ 
/* 239 */     if (this.connection.getTTCVersion() >= 3)
/*     */     {
/* 245 */       this.mar.marshalUB4(1L);
/*     */ 
/* 247 */       this.toh.init(T4Ctoh.ANYDATA_TOID, 0);
/* 248 */       this.toh.marshal(this.mar);
/*     */ 
/* 252 */       this.mar.marshalUB4(0L);
/*     */ 
/* 254 */       this.mar.marshalUB4(0L);
/*     */ 
/* 256 */       if (this.connection.getTTCVersion() >= 4)
/*     */       {
/* 260 */         this.mar.marshalUB4(0L);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   void receive()
/*     */     throws SQLException, IOException
/*     */   {
/* 269 */     this.aqmpri = this.mar.unmarshalSB4();
/* 270 */     this.aqmdel = this.mar.unmarshalSB4();
/* 271 */     this.aqmexp = this.mar.unmarshalSB4();
/* 272 */     int i = this.mar.unmarshalSWORD();
/* 273 */     if (i > 0)
/*     */     {
/* 275 */       this.aqmcorBytes = new byte[i];
/* 276 */       int[] arrayOfInt1 = new int[1];
/* 277 */       this.mar.unmarshalCLR(this.aqmcorBytes, 0, arrayOfInt1, this.aqmcorBytes.length);
/* 278 */       this.aqmcorBytesLength = arrayOfInt1[0];
/*     */     }
/*     */     else {
/* 281 */       this.aqmcorBytes = null;
/*     */     }
/* 283 */     this.aqmatt = this.mar.unmarshalSB4();
/* 284 */     int j = this.mar.unmarshalSWORD();
/* 285 */     if (j > 0)
/*     */     {
/* 287 */       this.aqmeqnBytes = new byte[j];
/* 288 */       int[] arrayOfInt2 = new int[1];
/* 289 */       this.mar.unmarshalCLR(this.aqmeqnBytes, 0, arrayOfInt2, this.aqmeqnBytes.length);
/* 290 */       this.aqmeqnBytesLength = arrayOfInt2[0];
/*     */     }
/*     */     else {
/* 293 */       this.aqmeqnBytes = null;
/*     */     }
/* 295 */     this.aqmsta = this.mar.unmarshalSB4();
/* 296 */     int k = this.mar.unmarshalSB4();
/* 297 */     if (k > 0)
/*     */     {
/* 299 */       this.mar.unmarshalCLR(this.aqmeqtBuffer, 0, this.retInt, 7);
/* 300 */       this.aqmeqt = new TIMESTAMP(this.aqmeqtBuffer);
/*     */     }
/*     */     Object localObject;
/* 303 */     if (this.connection.getTTCVersion() >= 3)
/*     */     {
/* 305 */       m = this.mar.unmarshalSWORD();
/* 306 */       if (m > 0)
/*     */       {
/* 308 */         this.aqmetiBytes = new byte[m];
/* 309 */         localObject = new int[1];
/* 310 */         this.mar.unmarshalCLR(this.aqmetiBytes, 0, (int[])localObject, this.aqmetiBytes.length);
/*     */       }
/*     */       else {
/* 313 */         this.aqmetiBytes = null;
/*     */       }
/*     */     }
/* 315 */     int m = this.mar.unmarshalSWORD();
/* 316 */     if (m > 0)
/*     */     {
/* 318 */       this.mar.unmarshalUB1();
/* 319 */       localObject = new byte[m][];
/* 320 */       int[] arrayOfInt3 = new int[m];
/* 321 */       byte[][] arrayOfByte = new byte[m][];
/* 322 */       int[] arrayOfInt4 = new int[m];
/* 323 */       this.mar.unmarshalKPDKV((byte[][])localObject, arrayOfInt3, arrayOfByte, arrayOfInt4);
/*     */ 
/* 328 */       for (int i1 = 0; i1 < m; i1++)
/*     */       {
/* 330 */         if ((arrayOfInt4[i1] == 64) && (localObject[i1] != null) && (arrayOfInt3[i1] > 0))
/*     */         {
/* 334 */           this.senderAgentName = localObject[i1];
/* 335 */           this.senderAgentNameLength = arrayOfInt3[i1];
/*     */         }
/*     */ 
/* 339 */         if ((arrayOfInt4[i1] == 65) && (localObject[i1] != null) && (arrayOfInt3[i1] > 0))
/*     */         {
/* 343 */           this.senderAgentAddress = localObject[i1];
/* 344 */           this.senderAgentAddressLength = arrayOfInt3[i1];
/*     */         }
/*     */ 
/* 349 */         if ((arrayOfInt4[i1] == 66) && (arrayOfByte[i1] != null) && (arrayOfByte[i1].length > 0))
/*     */         {
/* 352 */           this.senderAgentProtocol = arrayOfByte[i1][0];
/* 353 */         }if ((arrayOfInt4[i1] == 69) && (arrayOfByte[i1] != null) && (arrayOfByte[i1].length > 0))
/*     */         {
/* 356 */           this.originalMsgId = arrayOfByte[i1];
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 366 */     if (this.connection.getTTCVersion() >= 3)
/*     */     {
/* 368 */       int n = this.mar.unmarshalSWORD();
/*     */ 
/* 370 */       this.aqmcsn = ((int)this.mar.unmarshalUB4());
/* 371 */       this.aqmdsn = ((int)this.mar.unmarshalUB4());
/* 372 */       if (this.connection.getTTCVersion() >= 4)
/*     */       {
/* 379 */         this.aqmflg = ((int)this.mar.unmarshalUB4());
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIaqm
 * JD-Core Version:    0.6.2
 */