/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ final class T4CTTIOtxse extends T4CTTIfun
/*     */ {
/*     */   static final int OTXSTA = 1;
/*     */   static final int OTXDET = 2;
/*     */   static final int OCI_TRANS_NEW = 1;
/*     */   static final int OCI_TRANS_JOIN = 2;
/*     */   static final int OCI_TRANS_RESUME = 4;
/*     */   static final int OCI_TRANS_STARTMASK = 255;
/*     */   static final int OCI_TRANS_READONLY = 256;
/*     */   static final int OCI_TRANS_READWRITE = 512;
/*     */   static final int OCI_TRANS_SERIALIZABLE = 1024;
/*     */   static final int OCI_TRANS_ISOLMASK = 65280;
/*     */   static final int OCI_TRANS_LOOSE = 65536;
/*     */   static final int OCI_TRANS_TIGHT = 131072;
/*     */   static final int OCI_TRANS_TYPEMASK = 983040;
/*     */   static final int OCI_TRANS_NOMIGRATE = 1048576;
/*     */   static final int OCI_TRANS_SEPARABLE = 2097152;
/* 118 */   boolean sendTransactionContext = false;
/*     */   private int operation;
/*     */   private int formatId;
/*     */   private int gtridLength;
/*     */   private int bqualLength;
/*     */   private int timeout;
/*     */   private int flag;
/* 128 */   private int[] xidapp = null;
/*     */   private byte[] transactionContext;
/* 129 */   private byte[] xid = null;
/*     */ 
/* 132 */   private int applicationValue = -1;
/* 133 */   private byte[] ctx = null;
/*     */ 
/* 323 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIOtxse(T4CConnection paramT4CConnection)
/*     */   {
/* 122 */     super(paramT4CConnection, (byte)3);
/*     */ 
/* 124 */     setFunCode((short)103);
/*     */   }
/*     */ 
/*     */   void doOTXSE(int paramInt1, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int[] paramArrayOfInt)
/*     */     throws IOException, SQLException
/*     */   {
/* 141 */     if ((paramInt1 != 1) && (paramInt1 != 2))
/* 142 */       throw new SQLException("Invalid operation.");
/* 143 */     this.operation = paramInt1;
/* 144 */     this.formatId = paramInt2;
/* 145 */     this.gtridLength = paramInt3;
/* 146 */     this.bqualLength = paramInt4;
/* 147 */     this.timeout = paramInt5;
/* 148 */     this.flag = paramInt6;
/* 149 */     this.xidapp = paramArrayOfInt;
/* 150 */     this.transactionContext = paramArrayOfByte1;
/* 151 */     this.xid = paramArrayOfByte2;
/*     */ 
/* 154 */     this.applicationValue = -1;
/* 155 */     this.ctx = null;
/*     */ 
/* 157 */     if ((this.operation == 2) && (this.transactionContext == null))
/*     */     {
/* 159 */       throw new SQLException("Transaction context cannot be null when detach is called.");
/*     */     }
/* 161 */     doRPC();
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 170 */     int i = this.operation;
/*     */ 
/* 172 */     this.meg.marshalSWORD(i);
/*     */ 
/* 175 */     if (this.operation == 2)
/*     */     {
/* 177 */       this.sendTransactionContext = true;
/*     */ 
/* 179 */       this.meg.marshalPTR();
/*     */     }
/*     */     else
/*     */     {
/* 183 */       this.sendTransactionContext = false;
/*     */ 
/* 185 */       this.meg.marshalNULLPTR();
/*     */     }
/*     */ 
/* 189 */     if (this.transactionContext == null)
/* 190 */       this.meg.marshalUB4(0L);
/*     */     else {
/* 192 */       this.meg.marshalUB4(this.transactionContext.length);
/*     */     }
/*     */ 
/* 195 */     this.meg.marshalUB4(this.formatId);
/*     */ 
/* 198 */     this.meg.marshalUB4(this.gtridLength);
/*     */ 
/* 201 */     this.meg.marshalUB4(this.bqualLength);
/*     */ 
/* 204 */     if (this.xid != null)
/* 205 */       this.meg.marshalPTR();
/*     */     else {
/* 207 */       this.meg.marshalNULLPTR();
/*     */     }
/*     */ 
/* 210 */     if (this.xid != null)
/* 211 */       this.meg.marshalUB4(this.xid.length);
/*     */     else {
/* 213 */       this.meg.marshalUB4(0L);
/*     */     }
/*     */ 
/* 216 */     this.meg.marshalUB4(this.flag);
/*     */ 
/* 219 */     this.meg.marshalUWORD(this.timeout);
/*     */ 
/* 222 */     if (this.xidapp != null)
/* 223 */       this.meg.marshalPTR();
/*     */     else {
/* 225 */       this.meg.marshalNULLPTR();
/*     */     }
/* 227 */     this.meg.marshalPTR();
/* 228 */     this.meg.marshalPTR();
/*     */ 
/* 230 */     int j = 0;
/* 231 */     int k = 0;
/*     */ 
/* 233 */     if (this.connection.getTTCVersion() >= 5)
/*     */     {
/* 235 */       if (this.connection.internalName != null)
/*     */       {
/* 237 */         j = 1;
/* 238 */         this.meg.marshalPTR();
/* 239 */         this.meg.marshalUB4(this.connection.internalName.length);
/*     */       }
/*     */       else
/*     */       {
/* 243 */         this.meg.marshalNULLPTR();
/* 244 */         this.meg.marshalUB4(0L);
/*     */       }
/* 246 */       if (this.connection.externalName != null)
/*     */       {
/* 248 */         k = 1;
/* 249 */         this.meg.marshalPTR();
/* 250 */         this.meg.marshalUB4(this.connection.externalName.length);
/*     */       }
/*     */       else
/*     */       {
/* 254 */         this.meg.marshalNULLPTR();
/* 255 */         this.meg.marshalUB4(0L);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 261 */     if (this.sendTransactionContext) {
/* 262 */       this.meg.marshalB1Array(this.transactionContext);
/*     */     }
/* 264 */     if (this.xid != null) {
/* 265 */       this.meg.marshalB1Array(this.xid);
/*     */     }
/* 267 */     if (this.xidapp != null) {
/* 268 */       this.meg.marshalUB4(this.xidapp[0]);
/*     */     }
/* 270 */     if (this.connection.getTTCVersion() >= 5)
/*     */     {
/* 272 */       if (j != 0)
/* 273 */         this.meg.marshalCHR(this.connection.internalName);
/* 274 */       if (k != 0)
/* 275 */         this.meg.marshalCHR(this.connection.externalName);
/*     */     }
/*     */   }
/*     */ 
/*     */   byte[] getContext()
/*     */   {
/* 284 */     return this.ctx;
/*     */   }
/*     */ 
/*     */   int getApplicationValue()
/*     */   {
/* 290 */     return this.applicationValue;
/*     */   }
/*     */ 
/*     */   void readRPA()
/*     */     throws IOException, SQLException
/*     */   {
/* 297 */     this.applicationValue = ((int)this.meg.unmarshalUB4());
/*     */ 
/* 300 */     int i = this.meg.unmarshalUB2();
/*     */ 
/* 302 */     this.ctx = this.meg.unmarshalNBytes(i);
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 318 */     return this.connection;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIOtxse
 * JD-Core Version:    0.6.2
 */