/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ final class T4CTTIOtxen extends T4CTTIfun
/*     */ {
/*     */   static final int OTXCOMIT = 1;
/*     */   static final int OTXABORT = 2;
/*     */   static final int OTXPREPA = 3;
/*     */   static final int OTXFORGT = 4;
/*     */   static final int OTXRECOV = 5;
/*     */   static final int OTXMLPRE = 6;
/*     */   static final int K2CMDprepare = 0;
/*     */   static final int K2CMDrqcommit = 1;
/*     */   static final int K2CMDcommit = 2;
/*     */   static final int K2CMDabort = 3;
/*     */   static final int K2CMDrdonly = 4;
/*     */   static final int K2CMDforget = 5;
/*     */   static final int K2CMDrecovered = 7;
/*     */   static final int K2CMDtimeout = 8;
/*     */   static final int K2STAidle = 0;
/*     */   static final int K2STAcollecting = 1;
/*     */   static final int K2STAprepared = 2;
/*     */   static final int K2STAcommitted = 3;
/*     */   static final int K2STAhabort = 4;
/*     */   static final int K2STAhcommit = 5;
/*     */   static final int K2STAhdamage = 6;
/*     */   static final int K2STAtimeout = 7;
/*     */   static final int K2STAinactive = 9;
/*     */   static final int K2STAactive = 10;
/*     */   static final int K2STAptprepared = 11;
/*     */   static final int K2STAptcommitted = 12;
/*     */   static final int K2STAmax = 13;
/*     */   static final int OTXNDEF_F_CWRBATCH = 1;
/*     */   static final int OTXNDEF_F_CWRBATOPT = 2;
/*     */   static final int OTXNDEF_F_CWRNOWAIT = 4;
/*     */   static final int OTXNDEF_F_CWRWATOPT = 8;
/*     */   static final int OTXNDEF_F_CWRBATMSK = 3;
/*     */   static final int OTXNDEF_F_CWRWATMSK = 12;
/*     */   private int operation;
/*     */   private int formatId;
/*     */   private int gtridLength;
/*     */   private int bqualLength;
/*     */   private int timeout;
/*     */   private int inState;
/*     */   private int txnflg;
/*     */   private byte[] transactionContext;
/* 138 */   private byte[] xid = null;
/* 139 */   private int outState = -1;
/*     */ 
/* 277 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CTTIOtxen(T4CConnection paramT4CConnection)
/*     */   {
/* 131 */     super(paramT4CConnection, (byte)3);
/*     */ 
/* 133 */     setFunCode((short)104);
/*     */   }
/*     */ 
/*     */   void doOTXEN(int paramInt1, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7)
/*     */     throws IOException, SQLException
/*     */   {
/* 147 */     if ((paramInt1 != 1) && (paramInt1 != 2) && (paramInt1 != 3) && (paramInt1 != 4) && (paramInt1 != 5) && (paramInt1 != 6))
/*     */     {
/* 152 */       throw new SQLException("Invalid operation.");
/* 153 */     }this.operation = paramInt1;
/* 154 */     this.formatId = paramInt2;
/* 155 */     this.gtridLength = paramInt3;
/* 156 */     this.bqualLength = paramInt4;
/* 157 */     this.timeout = paramInt5;
/* 158 */     this.inState = paramInt6;
/* 159 */     this.txnflg = paramInt7;
/*     */ 
/* 161 */     this.transactionContext = paramArrayOfByte1;
/* 162 */     this.xid = paramArrayOfByte2;
/*     */ 
/* 165 */     this.outState = -1;
/* 166 */     doRPC();
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 175 */     int i = this.operation;
/*     */ 
/* 177 */     this.meg.marshalSWORD(i);
/*     */ 
/* 180 */     if (this.transactionContext == null)
/* 181 */       this.meg.marshalNULLPTR();
/*     */     else {
/* 183 */       this.meg.marshalPTR();
/*     */     }
/*     */ 
/* 186 */     if (this.transactionContext == null)
/* 187 */       this.meg.marshalUB4(0L);
/*     */     else {
/* 189 */       this.meg.marshalUB4(this.transactionContext.length);
/*     */     }
/*     */ 
/* 192 */     this.meg.marshalUB4(this.formatId);
/*     */ 
/* 195 */     this.meg.marshalUB4(this.gtridLength);
/*     */ 
/* 198 */     this.meg.marshalUB4(this.bqualLength);
/*     */ 
/* 201 */     if (this.xid != null)
/* 202 */       this.meg.marshalPTR();
/*     */     else {
/* 204 */       this.meg.marshalNULLPTR();
/*     */     }
/*     */ 
/* 207 */     if (this.xid != null)
/* 208 */       this.meg.marshalUB4(this.xid.length);
/*     */     else {
/* 210 */       this.meg.marshalUB4(0L);
/*     */     }
/*     */ 
/* 213 */     this.meg.marshalUWORD(this.timeout);
/*     */ 
/* 216 */     this.meg.marshalUB4(this.inState);
/*     */ 
/* 219 */     this.meg.marshalPTR();
/*     */ 
/* 221 */     if (this.connection.getTTCVersion() >= 4)
/*     */     {
/* 234 */       this.meg.marshalUB4(this.txnflg);
/*     */     }
/*     */ 
/* 239 */     if (this.transactionContext != null) {
/* 240 */       this.meg.marshalB1Array(this.transactionContext);
/*     */     }
/* 242 */     if (this.xid != null)
/* 243 */       this.meg.marshalB1Array(this.xid);
/*     */   }
/*     */ 
/*     */   void readRPA()
/*     */     throws IOException, SQLException
/*     */   {
/* 251 */     this.outState = ((int)this.meg.unmarshalUB4());
/*     */   }
/*     */ 
/*     */   int getOutStateFromServer()
/*     */   {
/* 257 */     return this.outState;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 272 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CTTIOtxen
 * JD-Core Version:    0.6.2
 */