/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.sql.SQLException;
/*      */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*      */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*      */ import oracle.jdbc.oracore.OracleTypeADT;
/*      */ 
/*      */ class T4CStatement extends OracleStatement
/*      */ {
/*   22 */   static final byte[][][] parameterDatum = (byte[][][])null;
/*   23 */   static final OracleTypeADT[][] parameterOtype = (OracleTypeADT[][])null;
/*      */ 
/*   33 */   static final byte[] EMPTY_BYTE = new byte[0];
/*      */   T4CConnection t4Connection;
/* 1180 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   void doOall8(boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3, boolean paramBoolean4, boolean paramBoolean5)
/*      */     throws SQLException, IOException
/*      */   {
/*   45 */     doOall8(paramBoolean1, paramBoolean2, paramBoolean3, paramBoolean4, paramBoolean5, 0);
/*      */   }
/*      */ 
/*      */   void doOall8(boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3, boolean paramBoolean4, boolean paramBoolean5, int paramInt)
/*      */     throws SQLException, IOException
/*      */   {
/*   59 */     if ((paramBoolean1) || (paramBoolean4) || (!paramBoolean2)) {
/*   60 */       this.oacdefSent = null;
/*      */     }
/*   62 */     this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.doOall8");
/*      */ 
/*   64 */     if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED)
/*      */     {
/*   68 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 439, "sqlKind = " + this.sqlKind);
/*   69 */       localSQLException1.fillInStackTrace();
/*   70 */       throw localSQLException1;
/*      */     }
/*      */ 
/*   74 */     int i = this.rowPrefetch;
/*   75 */     if (paramBoolean3) {
/*   76 */       if ((this.maxRows > 0) && (this.maxRows <= this.indexOfFirstRow + this.storedRowCount + this.rowPrefetch))
/*      */       {
/*   78 */         i = this.maxRows - (this.indexOfFirstRow + this.storedRowCount);
/*   79 */         this.isComplete = true;
/*      */       }
/*   81 */       this.rowPrefetchInLastFetch = i;
/*   82 */       if ((i == 0) && (this.isComplete))
/*   83 */         return;
/*      */     }
/*   85 */     int j = this.numberOfDefinePositions;
/*      */ 
/*   87 */     if (this.sqlKind.isDML())
/*   88 */       j = 0;
/*      */     int k;
/*   91 */     if (this.accessors != null)
/*   92 */       for (k = 0; k < this.accessors.length; k++)
/*   93 */         if (this.accessors[k] != null)
/*   94 */           this.accessors[k].lastRowProcessed = paramInt;
/*   95 */     if (this.outBindAccessors != null)
/*   96 */       for (k = 0; k < this.outBindAccessors.length; k++)
/*   97 */         if (this.outBindAccessors[k] != null)
/*   98 */           this.outBindAccessors[k].lastRowProcessed = 0;
/*      */     int i2;
/*  105 */     if (this.bindIndicators != null)
/*      */     {
/*  107 */       k = ((this.bindIndicators[(this.bindIndicatorSubRange + 3)] & 0xFFFF) << 16) + (this.bindIndicators[(this.bindIndicatorSubRange + 4)] & 0xFFFF);
/*      */ 
/*  110 */       int m = 0;
/*      */ 
/*  112 */       if (this.ibtBindChars != null) {
/*  113 */         m = this.ibtBindChars.length * this.connection.conversion.cMaxCharSize;
/*      */       }
/*  115 */       for (int n = 0; n < this.numberOfBindPositions; n++)
/*      */       {
/*  117 */         int i1 = this.bindIndicatorSubRange + 5 + 10 * n;
/*      */ 
/*  121 */         i2 = this.bindIndicators[(i1 + 2)] & 0xFFFF;
/*      */ 
/*  125 */         if (i2 != 0)
/*      */         {
/*  128 */           int i3 = this.bindIndicators[(i1 + 9)] & 0xFFFF;
/*      */ 
/*  132 */           if (i3 == 2)
/*      */           {
/*  134 */             m = Math.max(i2 * this.connection.conversion.maxNCharSize, m);
/*      */           }
/*      */           else
/*      */           {
/*  139 */             m = Math.max(i2 * this.connection.conversion.cMaxCharSize, m);
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  145 */       if (this.tmpBindsByteArray == null)
/*      */       {
/*  147 */         this.tmpBindsByteArray = new byte[m];
/*      */       }
/*  149 */       else if (this.tmpBindsByteArray.length < m)
/*      */       {
/*  151 */         this.tmpBindsByteArray = null;
/*  152 */         this.tmpBindsByteArray = new byte[m];
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  164 */       this.tmpBindsByteArray = null;
/*      */     }
/*      */ 
/*  169 */     int[] arrayOfInt1 = this.definedColumnType;
/*  170 */     int[] arrayOfInt2 = this.definedColumnSize;
/*  171 */     int[] arrayOfInt3 = this.definedColumnFormOfUse;
/*      */ 
/*  177 */     if ((paramBoolean5) && (paramBoolean4) && (this.isRowidPrepended))
/*      */     {
/*  182 */       arrayOfInt1 = new int[this.definedColumnType.length + 1];
/*  183 */       System.arraycopy(this.definedColumnType, 0, arrayOfInt1, 1, this.definedColumnType.length);
/*  184 */       arrayOfInt1[0] = -8;
/*  185 */       arrayOfInt2 = new int[this.definedColumnSize.length + 1];
/*  186 */       System.arraycopy(this.definedColumnSize, 0, arrayOfInt2, 1, this.definedColumnSize.length);
/*  187 */       arrayOfInt3 = new int[this.definedColumnFormOfUse.length + 1];
/*  188 */       System.arraycopy(this.definedColumnFormOfUse, 0, arrayOfInt3, 1, this.definedColumnFormOfUse.length);
/*      */     }
/*      */ 
/*  194 */     allocateTmpByteArray();
/*      */ 
/*  196 */     T4C8Oall localT4C8Oall = this.t4Connection.all8;
/*      */     try
/*      */     {
/*  202 */       localT4C8Oall.doOALL(paramBoolean1, paramBoolean2, paramBoolean3, paramBoolean4, paramBoolean5, this.sqlKind, this.cursorId, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals), i, this.outBindAccessors, this.numberOfBindPositions, this.accessors, j, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.connection.conversion, this.tmpBindsByteArray, this.parameterStream, parameterDatum, parameterOtype, this, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, this.oacdefSent, arrayOfInt1, arrayOfInt2, arrayOfInt3, this.registration);
/*      */ 
/*  214 */       i2 = localT4C8Oall.getCursorId();
/*  215 */       if ((i2 != 0) && (this.implicitResultSetStatements == null)) {
/*  216 */         this.cursorId = i2;
/*      */       }
/*  218 */       this.oacdefSent = localT4C8Oall.oacdefBindsSent;
/*  219 */       if (this.connection.isPDBChanged) {
/*  220 */         NTFPDBChangeEvent localNTFPDBChangeEvent = new NTFPDBChangeEvent(this.connection);
/*      */ 
/*  222 */         ((T4CConnection)this.connection).notify(localNTFPDBChangeEvent);
/*  223 */         this.connection.isPDBChanged = false;
/*      */       }
/*      */     }
/*      */     catch (SQLException localSQLException2)
/*      */     {
/*  228 */       int i4 = localT4C8Oall.getCursorId();
/*  229 */       if (i4 != 0) {
/*  230 */         this.cursorId = i4;
/*      */       }
/*  232 */       if (localSQLException2.getErrorCode() == DatabaseError.getVendorCode(110))
/*      */       {
/*  235 */         this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
/*      */       }
/*      */       else
/*      */       {
/*  240 */         throw localSQLException2;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void allocateTmpByteArray()
/*      */   {
/*  250 */     if (this.tmpByteArray == null)
/*      */     {
/*  253 */       this.tmpByteArray = new byte[this.sizeTmpByteArray];
/*      */     }
/*  255 */     else if (this.sizeTmpByteArray > this.tmpByteArray.length)
/*      */     {
/*  259 */       this.tmpByteArray = new byte[this.sizeTmpByteArray];
/*      */     }
/*      */   }
/*      */ 
/*      */   void releaseBuffers()
/*      */   {
/*  271 */     super.releaseBuffers();
/*  272 */     this.tmpByteArray = null;
/*  273 */     this.tmpBindsByteArray = null;
/*      */ 
/*  275 */     if (this.t4Connection != null)
/*      */     {
/*  277 */       this.t4Connection.all8.bindChars = null;
/*  278 */       this.t4Connection.all8.bindBytes = null;
/*  279 */       this.t4Connection.all8.tmpBindsByteArray = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   void allocateRowidAccessor()
/*      */     throws SQLException
/*      */   {
/*  287 */     this.accessors[0] = new T4CRowidAccessor(this, 128, 1, -8, false, this.t4Connection.mare);
/*      */   }
/*      */ 
/*      */   void reparseOnRedefineIfNeeded()
/*      */     throws SQLException
/*      */   {
/*  300 */     this.needToParse = true;
/*      */   }
/*      */ 
/*      */   protected void defineColumnTypeInternal(int paramInt1, int paramInt2, int paramInt3, short paramShort, boolean paramBoolean, String paramString)
/*      */     throws SQLException
/*      */   {
/*  311 */     if (this.connection.disableDefinecolumntype)
/*      */     {
/*  314 */       return;
/*      */     }
/*  316 */     if ((paramInt2 == -15) || (paramInt2 == -9) || (paramInt2 == -16))
/*      */     {
/*  318 */       paramShort = 2;
/*      */     }
/*      */     SQLException localSQLException;
/*  323 */     if (paramInt1 < 1)
/*      */     {
/*  325 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  326 */       localSQLException.fillInStackTrace();
/*  327 */       throw localSQLException;
/*      */     }
/*      */ 
/*  330 */     if ((this.currentResultSet != null) && (!this.currentResultSet.closed))
/*      */     {
/*  332 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 28);
/*  333 */       localSQLException.fillInStackTrace();
/*  334 */       throw localSQLException;
/*      */     }
/*      */ 
/*  341 */     int i = paramInt1 - 1;
/*      */     int[] arrayOfInt;
/*  343 */     if ((this.definedColumnType == null) || (this.definedColumnType.length <= i))
/*      */     {
/*  345 */       if (this.definedColumnType == null)
/*      */       {
/*  347 */         this.definedColumnType = new int[(i + 1) * 4];
/*      */       }
/*      */       else
/*      */       {
/*  359 */         arrayOfInt = new int[(i + 1) * 4];
/*      */ 
/*  361 */         System.arraycopy(this.definedColumnType, 0, arrayOfInt, 0, this.definedColumnType.length);
/*      */ 
/*  364 */         this.definedColumnType = arrayOfInt;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  370 */     this.definedColumnType[i] = paramInt2;
/*      */ 
/*  372 */     if ((this.definedColumnSize == null) || (this.definedColumnSize.length <= i))
/*      */     {
/*  374 */       if (this.definedColumnSize == null) {
/*  375 */         this.definedColumnSize = new int[(i + 1) * 4];
/*      */       }
/*      */       else
/*      */       {
/*  379 */         arrayOfInt = new int[(i + 1) * 4];
/*      */ 
/*  381 */         System.arraycopy(this.definedColumnSize, 0, arrayOfInt, 0, this.definedColumnSize.length);
/*      */ 
/*  384 */         this.definedColumnSize = arrayOfInt;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  389 */     this.definedColumnSize[i] = ((paramInt2 == 2005) || (paramInt2 == 2004) ? paramInt3 : -1);
/*      */ 
/*  391 */     if ((this.definedColumnFormOfUse == null) || (this.definedColumnFormOfUse.length <= i))
/*      */     {
/*  393 */       if (this.definedColumnFormOfUse == null) {
/*  394 */         this.definedColumnFormOfUse = new int[(i + 1) * 4];
/*      */       }
/*      */       else
/*      */       {
/*  398 */         arrayOfInt = new int[(i + 1) * 4];
/*      */ 
/*  400 */         System.arraycopy(this.definedColumnFormOfUse, 0, arrayOfInt, 0, this.definedColumnFormOfUse.length);
/*      */ 
/*  403 */         this.definedColumnFormOfUse = arrayOfInt;
/*      */       }
/*      */     }
/*      */ 
/*  407 */     this.definedColumnFormOfUse[i] = paramShort;
/*      */ 
/*  409 */     if ((this.accessors != null) && (i < this.accessors.length) && (this.accessors[i] != null))
/*      */     {
/*  411 */       this.accessors[i].definedColumnSize = paramInt3;
/*      */ 
/*  416 */       if (((this.accessors[i].internalType == 96) || (this.accessors[i].internalType == 1)) && ((paramInt2 == 1) || (paramInt2 == 12)))
/*      */       {
/*  420 */         if (paramInt3 <= this.accessors[i].oacmxl)
/*      */         {
/*  426 */           this.needToPrepareDefineBuffer = true;
/*  427 */           this.columnsDefinedByUser = true;
/*      */ 
/*  429 */           this.accessors[i].initForDataAccess(paramInt2, paramInt3, null);
/*  430 */           this.accessors[i].calculateSizeTmpByteArray();
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  435 */     this.executeDoneForDefines = false;
/*      */   }
/*      */ 
/*      */   public void clearDefines() throws SQLException
/*      */   {
/*  440 */     synchronized (this.connection)
/*      */     {
/*  442 */       super.clearDefines();
/*  443 */       this.definedColumnType = null;
/*  444 */       this.definedColumnSize = null;
/*  445 */       this.definedColumnFormOfUse = null;
/*  446 */       if ((this.t4Connection != null) && (this.t4Connection.all8 != null))
/*  447 */         this.t4Connection.all8.definesAccessors = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   void doSetSnapshotSCN(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  456 */     this.inScn = paramLong;
/*      */   }
/*      */ 
/*      */   Accessor allocateAccessor(int paramInt1, int paramInt2, int paramInt3, int paramInt4, short paramShort, String paramString, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  476 */     Object localObject = null;
/*      */     SQLException localSQLException;
/*  478 */     switch (paramInt1)
/*      */     {
/*      */     case 96:
/*  482 */       localObject = new T4CCharAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  485 */       break;
/*      */     case 8:
/*  488 */       if (!paramBoolean)
/*      */       {
/*  490 */         localObject = new T4CLongAccessor(this, paramInt3, paramInt4, paramShort, paramInt2, this.t4Connection.mare);
/*      */       }
/*      */ 
/*  493 */       break;
/*      */     case 1:
/*  498 */       localObject = new T4CVarcharAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  501 */       break;
/*      */     case 2:
/*  504 */       localObject = new T4CNumberAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  507 */       break;
/*      */     case 6:
/*  510 */       localObject = new T4CVarnumAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  513 */       break;
/*      */     case 24:
/*  516 */       if (!paramBoolean)
/*      */       {
/*  518 */         localObject = new T4CLongRawAccessor(this, paramInt3, paramInt4, paramShort, paramInt2, this.t4Connection.mare);
/*      */       }
/*      */ 
/*  521 */       break;
/*      */     case 23:
/*  526 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/*  528 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/*  529 */         localSQLException.fillInStackTrace();
/*  530 */         throw localSQLException;
/*      */       }
/*      */ 
/*  533 */       if (paramBoolean) {
/*  534 */         localObject = new T4COutRawAccessor(this, paramInt4, paramShort, paramInt2, this.t4Connection.mare);
/*      */       }
/*      */       else {
/*  537 */         localObject = new T4CRawAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */       }
/*      */ 
/*  540 */       break;
/*      */     case 100:
/*  543 */       localObject = new T4CBinaryFloatAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  546 */       break;
/*      */     case 101:
/*  549 */       localObject = new T4CBinaryDoubleAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  552 */       break;
/*      */     case 104:
/*  555 */       if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK)
/*      */       {
/*  561 */         localObject = new T4CVarcharAccessor(this, 18, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  565 */         ((Accessor)localObject).definedColumnType = -8;
/*      */       }
/*      */       else {
/*  568 */         localObject = new T4CRowidAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */       }
/*      */ 
/*  572 */       break;
/*      */     case 102:
/*  575 */       localObject = new T4CResultSetAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  578 */       break;
/*      */     case 12:
/*  581 */       localObject = new T4CDateAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  584 */       break;
/*      */     case 113:
/*  587 */       localObject = new T4CBlobAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  590 */       break;
/*      */     case 112:
/*  593 */       localObject = new T4CClobAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  596 */       break;
/*      */     case 114:
/*  599 */       localObject = new T4CBfileAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  602 */       break;
/*      */     case 109:
/*  605 */       localObject = new T4CNamedTypeAccessor(this, paramString, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  608 */       ((Accessor)localObject).initMetadata();
/*      */ 
/*  610 */       break;
/*      */     case 111:
/*  613 */       localObject = new T4CRefTypeAccessor(this, paramString, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  616 */       ((Accessor)localObject).initMetadata();
/*      */ 
/*  618 */       break;
/*      */     case 180:
/*  623 */       localObject = new T4CTimestampAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  626 */       break;
/*      */     case 181:
/*  629 */       localObject = new T4CTimestamptzAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  632 */       break;
/*      */     case 231:
/*  635 */       localObject = new T4CTimestampltzAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  638 */       break;
/*      */     case 182:
/*  641 */       localObject = new T4CIntervalymAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  644 */       break;
/*      */     case 183:
/*  647 */       localObject = new T4CIntervaldsAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  650 */       break;
/*      */     case 995:
/*  663 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 89);
/*  664 */       localSQLException.fillInStackTrace();
/*  665 */       throw localSQLException;
/*      */     }
/*      */ 
/*  669 */     return localObject;
/*      */   }
/*      */ 
/*      */   void doDescribe(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  695 */     if (!this.isOpen)
/*      */     {
/*  699 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 144);
/*  700 */       localSQLException1.fillInStackTrace();
/*  701 */       throw localSQLException1;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  708 */       this.t4Connection.needLine();
/*  709 */       this.t4Connection.describe.doODNY(this, 0, this.accessors, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals));
/*  710 */       this.accessors = this.t4Connection.describe.getAccessors();
/*      */ 
/*  712 */       this.numberOfDefinePositions = this.t4Connection.describe.numuds;
/*      */ 
/*  714 */       for (int i = 0; i < this.numberOfDefinePositions; i++)
/*  715 */         this.accessors[i].initMetadata();
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  719 */       ((T4CConnection)this.connection).handleIOException(localIOException);
/*      */ 
/*  722 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  723 */       localSQLException2.fillInStackTrace();
/*  724 */       throw localSQLException2;
/*      */     }
/*      */ 
/*  728 */     this.describedWithNames = true;
/*  729 */     this.described = true;
/*      */   }
/*      */ 
/*      */   void executeForDescribe()
/*      */     throws SQLException
/*      */   {
/*  764 */     this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.execute_for_describe");
/*      */     try {
/*  766 */       doOall8(true, true, this.definedColumnType != null, true, this.definedColumnType != null);
/*      */     }
/*      */     catch (SQLException localSQLException1)
/*      */     {
/*      */       long l1;
/*  775 */       throw localSQLException1;
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  779 */       ((T4CConnection)this.connection).handleIOException(localIOException);
/*      */ 
/*  781 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  782 */       localSQLException2.fillInStackTrace();
/*  783 */       throw localSQLException2;
/*      */     }
/*      */     finally
/*      */     {
/*  788 */       this.rowsProcessed = this.t4Connection.all8.rowsProcessed;
/*  789 */       this.validRows = this.t4Connection.all8.getNumRows();
/*  790 */       if (this.connection.checksumMode.needToCalculateFetchChecksum()) {
/*  791 */         if (this.validRows > 0) {
/*  792 */           calculateCheckSum();
/*  793 */         } else if (this.rowsProcessed > 0) {
/*  794 */           long l2 = CRC64.updateChecksum(this.checkSum, this.rowsProcessed);
/*      */ 
/*  796 */           this.checkSum = l2;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  801 */     this.needToParse = false;
/*      */ 
/*  811 */     if (this.definedColumnType == null) {
/*  812 */       this.implicitDefineForLobPrefetchDone = false;
/*      */     }
/*  814 */     this.aFetchWasDoneDuringDescribe = false;
/*  815 */     if (this.t4Connection.all8.aFetchWasDone)
/*      */     {
/*  817 */       this.aFetchWasDoneDuringDescribe = true;
/*  818 */       this.rowPrefetchInLastFetch = this.rowPrefetch;
/*      */     }
/*      */ 
/*  822 */     for (int i = 0; i < this.numberOfDefinePositions; i++) {
/*  823 */       this.accessors[i].initMetadata();
/*      */     }
/*  825 */     this.needToPrepareDefineBuffer = false;
/*      */   }
/*      */ 
/*      */   void executeForRows(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/*      */       try
/*      */       {
/*  867 */         boolean bool = false;
/*  868 */         if (this.columnsDefinedByUser) {
/*  869 */           this.needToPrepareDefineBuffer = false;
/*      */         }
/*  889 */         else if ((this.t4Connection.useLobPrefetch) && (this.accessors != null) && (this.defaultLobPrefetchSize != -1) && (!this.implicitDefineForLobPrefetchDone) && (!this.aFetchWasDoneDuringDescribe) && (this.definedColumnType == null))
/*      */         {
/*  897 */           int i = 0;
/*  898 */           int[] arrayOfInt1 = new int[this.accessors.length];
/*  899 */           int[] arrayOfInt2 = new int[this.accessors.length];
/*  900 */           int[] arrayOfInt3 = new int[this.accessors.length];
/*      */ 
/*  902 */           for (int j = 0; j < this.accessors.length; j++) {
/*  903 */             if (this.accessors[j] != null)
/*      */             {
/*  907 */               arrayOfInt1[j] = getJDBCType(this.accessors[j].internalType);
/*  908 */               arrayOfInt3[j] = this.accessors[j].formOfUse;
/*  909 */               if ((this.accessors[j].internalType == 113) || (this.accessors[j].internalType == 112) || (this.accessors[j].internalType == 114))
/*      */               {
/*  915 */                 i = 1;
/*      */ 
/*  917 */                 this.accessors[j].setPrefetchLength(this.defaultLobPrefetchSize);
/*  918 */                 arrayOfInt2[j] = this.defaultLobPrefetchSize;
/*      */               }
/*      */             }
/*      */           }
/*  922 */           if (i != 0)
/*      */           {
/*  924 */             this.definedColumnType = arrayOfInt1;
/*  925 */             this.definedColumnSize = arrayOfInt2;
/*  926 */             this.definedColumnFormOfUse = arrayOfInt3;
/*  927 */             bool = true;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  933 */         doOall8(this.needToParse, !paramBoolean, true, false, bool);
/*      */ 
/*  935 */         this.needToParse = false;
/*  936 */         if (bool)
/*  937 */           this.implicitDefineForLobPrefetchDone = true;
/*      */       }
/*      */       finally
/*      */       {
/*  941 */         if (this.implicitResultSetStatements == null)
/*  942 */           this.validRows = this.t4Connection.all8.getNumRows();
/*      */         else
/*  944 */           this.validRows = 0;
/*  945 */         calculateCheckSum();
/*      */       }
/*      */     }
/*      */     catch (SQLException localSQLException1)
/*      */     {
/*  950 */       throw localSQLException1;
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  954 */       ((T4CConnection)this.connection).handleIOException(localIOException);
/*      */ 
/*  956 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  957 */       localSQLException2.fillInStackTrace();
/*  958 */       throw localSQLException2;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void fetch(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  984 */     if (this.rowData != null)
/*  985 */       if (paramBoolean)
/*      */       {
/*  987 */         this.rowData.setPosition(this.rowData.length());
/*      */       }
/*  989 */       else this.rowData.reset();
/*      */     SQLException localSQLException;
/*  993 */     if (this.streamList != null)
/*      */     {
/*  995 */       while (this.nextStream != null) {
/*      */         try {
/*  997 */           this.nextStream.close();
/*      */         }
/*      */         catch (IOException localIOException1) {
/* 1000 */           ((T4CConnection)this.connection).handleIOException(localIOException1);
/*      */ 
/* 1002 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException1);
/* 1003 */           localSQLException.fillInStackTrace();
/* 1004 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1007 */         this.nextStream = this.nextStream.nextStream;
/*      */       }
/*      */     }
/*      */     try
/*      */     {
/* 1012 */       doOall8(false, false, true, false, false, paramInt);
/* 1013 */       this.validRows = this.t4Connection.all8.getNumRows();
/* 1014 */       if (this.validRows != -2) this.validRows -= paramInt;
/* 1015 */       calculateCheckSum();
/*      */     }
/*      */     catch (IOException localIOException2) {
/* 1018 */       ((T4CConnection)this.connection).handleIOException(localIOException2);
/*      */ 
/* 1020 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException2);
/* 1021 */       localSQLException.fillInStackTrace();
/* 1022 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   void continueReadRow(int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 1041 */       if (!this.isFetchStreams)
/*      */       {
/* 1043 */         T4C8Oall localT4C8Oall = this.t4Connection.all8;
/*      */ 
/* 1045 */         localT4C8Oall.continueReadRow(paramInt, this);
/*      */       }
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 1050 */       ((T4CConnection)this.connection).handleIOException(localIOException);
/*      */ 
/* 1052 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1053 */       localSQLException2.fillInStackTrace();
/* 1054 */       throw localSQLException2;
/*      */     }
/*      */     catch (SQLException localSQLException1)
/*      */     {
/* 1059 */       if (localSQLException1.getErrorCode() == DatabaseError.getVendorCode(110))
/*      */       {
/* 1062 */         this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
/*      */       }
/*      */       else
/*      */       {
/* 1067 */         throw localSQLException1;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void doClose()
/*      */     throws SQLException
/*      */   {
/* 1091 */     this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.do_close");
/* 1092 */     if (this.cursorId != 0)
/*      */     {
/* 1094 */       this.t4Connection.closeCursor(this.cursorId);
/*      */     }
/*      */ 
/* 1097 */     this.tmpByteArray = null;
/* 1098 */     this.tmpBindsByteArray = null;
/* 1099 */     this.definedColumnType = null;
/* 1100 */     this.definedColumnSize = null;
/* 1101 */     this.definedColumnFormOfUse = null;
/* 1102 */     this.oacdefSent = null;
/*      */   }
/*      */ 
/*      */   void closeQuery()
/*      */     throws SQLException
/*      */   {
/* 1121 */     this.connection.registerHeartbeat();
/* 1122 */     this.connection.needLine();
/* 1123 */     this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.closeQuery");
/*      */ 
/* 1125 */     if (this.streamList != null)
/*      */     {
/* 1127 */       while (this.nextStream != null) {
/*      */         try {
/* 1129 */           this.nextStream.close();
/*      */         }
/*      */         catch (IOException localIOException) {
/* 1132 */           ((T4CConnection)this.connection).handleIOException(localIOException);
/*      */ 
/* 1134 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1135 */           localSQLException.fillInStackTrace();
/* 1136 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1139 */         this.nextStream = this.nextStream.nextStream;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   T4CStatement(PhysicalConnection paramPhysicalConnection, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1152 */     super(paramPhysicalConnection, 1, paramPhysicalConnection.defaultRowPrefetch, paramInt1, paramInt2);
/*      */ 
/* 1154 */     this.nbPostPonedColumns = new int[1];
/* 1155 */     this.nbPostPonedColumns[0] = 0;
/* 1156 */     this.indexOfPostPonedColumn = new int[1][3];
/* 1157 */     this.t4Connection = ((T4CConnection)paramPhysicalConnection);
/*      */   }
/*      */ 
/*      */   void closeCursorOnPlainStatement()
/*      */     throws SQLException
/*      */   {
/* 1172 */     if ((this.cursorId != 0) && (this.t4Connection.isLoggedOn())) {
/* 1173 */       this.t4Connection.closeCursor(this.cursorId);
/* 1174 */       setCursorId(0);
/*      */     }
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CStatement
 * JD-Core Version:    0.6.2
 */