/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import oracle.net.ns.BreakNetException;
/*     */ import oracle.net.ns.NetException;
/*     */ import oracle.net.ns.NetOutputStream;
/*     */ 
/*     */ class T4CSocketOutputStreamWrapper extends NetOutputStream
/*     */ {
/*     */   static final int MAX_BUFFER_SIZE = 2048;
/*  45 */   NetOutputStream os = null;
/*     */ 
/*  47 */   byte[] buffer = new byte[2048];
/*  48 */   int bIndex = 0;
/*     */ 
/*     */   T4CSocketOutputStreamWrapper(NetOutputStream paramNetOutputStream)
/*     */     throws IOException
/*     */   {
/*  53 */     this.os = paramNetOutputStream;
/*     */   }
/*     */ 
/*     */   public void write(int paramInt) throws IOException
/*     */   {
/*  58 */     if (this.bIndex + 1 >= 2048) {
/*  59 */       flush();
/*     */     }
/*  61 */     this.buffer[(this.bIndex++)] = ((byte)(paramInt & 0xFF));
/*     */   }
/*     */ 
/*     */   public void write(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException
/*     */   {
/*  67 */     if (paramInt2 > 2048)
/*     */     {
/*  73 */       flush();
/*     */ 
/*  76 */       this.os.write(paramArrayOfByte, paramInt1, paramInt2);
/*  77 */     } else if (this.bIndex + paramInt2 < 2048)
/*     */     {
/*  79 */       System.arraycopy(paramArrayOfByte, paramInt1, this.buffer, this.bIndex, paramInt2);
/*  80 */       this.bIndex += paramInt2;
/*     */     }
/*     */     else {
/*  83 */       flush();
/*  84 */       System.arraycopy(paramArrayOfByte, paramInt1, this.buffer, this.bIndex, paramInt2);
/*  85 */       this.bIndex += paramInt2;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void flush() throws IOException
/*     */   {
/*  91 */     flush(false);
/*     */   }
/*     */ 
/*     */   public void flush(boolean paramBoolean) throws IOException
/*     */   {
/*  96 */     if (this.bIndex > 0)
/*     */     {
/*  98 */       this.os.write(this.buffer, 0, this.bIndex);
/*  99 */       this.bIndex = 0;
/*     */     }
/* 101 */     if (paramBoolean)
/* 102 */       this.os.flush();
/*     */   }
/*     */ 
/*     */   public void close() throws IOException
/*     */   {
/* 107 */     this.os.close();
/* 108 */     super.close();
/*     */   }
/*     */ 
/*     */   public void writeZeroCopyIO(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException, NetException, BreakNetException
/*     */   {
/* 114 */     flush(true);
/* 115 */     this.os.writeZeroCopyIO(paramArrayOfByte, paramInt1, paramInt2);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CSocketOutputStreamWrapper
 * JD-Core Version:    0.6.2
 */