/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import oracle.net.ns.BreakNetException;
/*     */ import oracle.net.ns.NetException;
/*     */ import oracle.net.ns.NetInputStream;
/*     */ 
/*     */ class T4CSocketInputStreamWrapper extends NetInputStream
/*     */ {
/*     */   static final int MAX_BUFFER_SIZE = 2048;
/*  50 */   NetInputStream is = null;
/*  51 */   T4CSocketOutputStreamWrapper os = null;
/*  52 */   boolean eof = false;
/*     */ 
/*  54 */   byte[] buffer = new byte[2048];
/*     */ 
/*  56 */   int bIndex = 0;
/*     */   int bytesAvailable;
/*     */ 
/*     */   T4CSocketInputStreamWrapper(NetInputStream paramNetInputStream, T4CSocketOutputStreamWrapper paramT4CSocketOutputStreamWrapper)
/*     */     throws IOException
/*     */   {
/*  64 */     this.is = paramNetInputStream;
/*  65 */     this.os = paramT4CSocketOutputStreamWrapper;
/*     */   }
/*     */ 
/*     */   public final int read()
/*     */     throws IOException
/*     */   {
/*  74 */     if (this.eof) {
/*  75 */       return -1;
/*     */     }
/*  77 */     if (this.bytesAvailable < 1)
/*     */     {
/*  79 */       readNextPacket();
/*  80 */       if (this.eof)
/*  81 */         return -1;
/*     */     }
/*  83 */     this.bytesAvailable -= 1;
/*  84 */     return this.buffer[(this.bIndex++)] & 0xFF;
/*     */   }
/*     */ 
/*     */   public final int read(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException
/*     */   {
/*  90 */     if (this.eof) {
/*  91 */       return 0;
/*     */     }
/*  93 */     if (this.bytesAvailable < paramInt2)
/*     */     {
/*  95 */       int i = this.bytesAvailable;
/*     */ 
/*  98 */       System.arraycopy(this.buffer, this.bIndex, paramArrayOfByte, paramInt1, i);
/*  99 */       paramInt1 += i;
/* 100 */       this.bIndex += i;
/* 101 */       this.bytesAvailable -= i;
/*     */ 
/* 104 */       this.is.read(paramArrayOfByte, paramInt1, paramInt2 - i);
/*     */     }
/*     */     else {
/* 107 */       System.arraycopy(this.buffer, this.bIndex, paramArrayOfByte, paramInt1, paramInt2);
/* 108 */       this.bIndex += paramInt2;
/* 109 */       this.bytesAvailable -= paramInt2;
/*     */     }
/*     */ 
/* 112 */     return paramInt2;
/*     */   }
/*     */ 
/*     */   void readNextPacket()
/*     */     throws IOException
/*     */   {
/* 119 */     this.os.flush();
/*     */ 
/* 123 */     int i = this.is.read();
/*     */ 
/* 126 */     if (i == -1)
/*     */     {
/* 128 */       this.eof = true;
/* 129 */       return;
/*     */     }
/*     */ 
/* 132 */     this.buffer[0] = ((byte)i);
/*     */ 
/* 134 */     this.bytesAvailable = (this.is.available() + 1);
/*     */ 
/* 138 */     this.bytesAvailable = (this.bytesAvailable > 2048 ? 2048 : this.bytesAvailable);
/*     */ 
/* 141 */     if (this.bytesAvailable > 1) {
/* 142 */       this.is.read(this.buffer, 1, this.bytesAvailable - 1);
/*     */     }
/*     */ 
/* 145 */     this.bIndex = 0;
/*     */   }
/*     */ 
/*     */   public int readB1() throws IOException
/*     */   {
/* 150 */     return read();
/*     */   }
/*     */ 
/*     */   public long readLongLSB(int paramInt) throws IOException
/*     */   {
/* 155 */     long l = 0L;
/* 156 */     int i = 0;
/*     */ 
/* 158 */     if ((paramInt & 0x80) > 0)
/*     */     {
/* 160 */       paramInt &= 127;
/* 161 */       i = 1;
/*     */     }
/*     */ 
/* 166 */     int j = paramInt; for (int k = 0; j > 0; k++)
/*     */     {
/* 168 */       if (this.bytesAvailable < 1)
/*     */       {
/* 170 */         readNextPacket();
/*     */       }
/* 172 */       l |= (this.buffer[(this.bIndex++)] & 0xFF) << 8 * k;
/* 173 */       this.bytesAvailable -= 1;
/*     */ 
/* 166 */       j--;
/*     */     }
/*     */ 
/* 177 */     return (i != 0 ? -1 : 1) * l;
/*     */   }
/*     */ 
/*     */   public long readLongMSB(int paramInt) throws IOException
/*     */   {
/* 182 */     long l = 0L;
/* 183 */     int i = 0;
/*     */ 
/* 186 */     if ((paramInt & 0x80) > 0)
/*     */     {
/* 188 */       paramInt &= 127;
/* 189 */       i = 1;
/*     */     }
/*     */ 
/* 194 */     for (int j = paramInt; j > 0; j--)
/*     */     {
/* 196 */       if (this.bytesAvailable < 1)
/*     */       {
/* 198 */         readNextPacket();
/*     */       }
/* 200 */       l |= (this.buffer[(this.bIndex++)] & 0xFF) << 8 * (j - 1);
/*     */ 
/* 202 */       this.bytesAvailable -= 1;
/*     */     }
/*     */ 
/* 206 */     return (i != 0 ? -1 : 1) * l;
/*     */   }
/*     */ 
/*     */   public boolean readZeroCopyIO(byte[] paramArrayOfByte, int paramInt, int[] paramArrayOfInt)
/*     */     throws IOException, NetException, BreakNetException
/*     */   {
/* 212 */     this.os.flush();
/* 213 */     return this.is.readZeroCopyIO(paramArrayOfByte, paramInt, paramArrayOfInt);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CSocketInputStreamWrapper
 * JD-Core Version:    0.6.2
 */