/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.sql.SQLException;
/*      */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*      */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*      */ 
/*      */ class T4CRowidAccessor extends RowidAccessor
/*      */ {
/*      */   T4CMAREngine mare;
/*  194 */   final int[] meta = new int[1];
/*      */   static final int KGRD_EXTENDED_OBJECT = 6;
/*      */   static final int KGRD_EXTENDED_BLOCK = 6;
/*      */   static final int KGRD_EXTENDED_FILE = 3;
/*      */   static final int KGRD_EXTENDED_SLOT = 3;
/*      */   static final int kd4_ubridtype_physical = 1;
/*      */   static final int kd4_ubridtype_logical = 2;
/*      */   static final int kd4_ubridtype_remote = 3;
/*      */   static final int kd4_ubridtype_exttab = 4;
/*      */   static final int kd4_ubridtype_future2 = 5;
/*      */   static final int kd4_ubridtype_max = 5;
/*      */   static final int kd4_ubridlen_typeind = 1;
/* 1039 */   static final byte[] kgrd_indbyte_char = { 65, 42, 45, 40, 41 };
/*      */ 
/* 1046 */   static final byte[] kgrd_basis_64 = { 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47 };
/*      */ 
/* 1061 */   static final byte[] kgrd_index_64 = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1 };
/*      */ 
/* 1087 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   T4CRowidAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean, T4CMAREngine paramT4CMAREngine)
/*      */     throws SQLException
/*      */   {
/*   35 */     super(paramOracleStatement, paramInt1, paramShort, paramInt2, paramBoolean);
/*      */ 
/*   37 */     this.mare = paramT4CMAREngine;
/*   38 */     this.defineType = 104;
/*      */   }
/*      */ 
/*      */   T4CRowidAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, int paramInt7, int paramInt8, T4CMAREngine paramT4CMAREngine)
/*      */     throws SQLException
/*      */   {
/*   48 */     super(paramOracleStatement, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort);
/*      */ 
/*   51 */     this.mare = paramT4CMAREngine;
/*   52 */     this.definedColumnType = paramInt7;
/*   53 */     this.definedColumnSize = paramInt8;
/*   54 */     this.defineType = 104;
/*      */   }
/*      */ 
/*      */   public T4CMAREngine getMAREngine() {
/*   58 */     return this.mare;
/*      */   }
/*      */ 
/*      */   public void unmarshalColumnMetadata()
/*      */     throws SQLException, IOException
/*      */   {
/*   67 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*      */     {
/*   70 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*      */     }
/*      */   }
/*      */ 
/*      */   public void processIndicator(int paramInt)
/*      */     throws IOException, SQLException
/*      */   {
/*   77 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*      */     {
/*   84 */       this.mare.unmarshalUB2();
/*   85 */       this.mare.unmarshalUB2();
/*      */     }
/*   87 */     else if (this.statement.connection.versionNumber < 9200)
/*      */     {
/*   91 */       this.mare.unmarshalSB2();
/*      */ 
/*   93 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/*   94 */         this.mare.unmarshalSB2();
/*      */     }
/*   96 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/*   97 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   int getPreviousRowProcessed()
/*      */   {
/*  103 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/*  104 */     return this.previousRowProcessed;
/*      */   }
/*      */ 
/*      */   boolean unmarshalOneRow()
/*      */     throws SQLException, IOException
/*      */   {
/*  120 */     boolean bool = false;
/*  121 */     if (!isUseless())
/*      */     {
/*  127 */       if (isUnexpected())
/*      */       {
/*  130 */         long l = this.rowData.getPosition();
/*  131 */         unmarshalColumnMetadata();
/*  132 */         unmarshalBytes();
/*  133 */         this.rowData.setPosition(l);
/*  134 */         setNull(this.lastRowProcessed, true);
/*      */       }
/*  136 */       else if (isNullByDescribe())
/*      */       {
/*  139 */         setNull(this.lastRowProcessed, true);
/*  140 */         unmarshalColumnMetadata();
/*  141 */         if (this.statement.connection.versionNumber < 9200) processIndicator(0);
/*      */       }
/*      */       else
/*      */       {
/*  145 */         unmarshalColumnMetadata();
/*  146 */         bool = unmarshalBytes();
/*      */       }
/*      */     }
/*  148 */     this.previousRowProcessed = this.lastRowProcessed;
/*  149 */     this.lastRowProcessed += 1;
/*  150 */     return bool;
/*      */   }
/*      */ 
/*      */   void copyRow()
/*      */     throws SQLException, IOException
/*      */   {
/*  159 */     if (this.isNullByDescribe) {
/*  160 */       setNull(this.lastRowProcessed, true);
/*      */     }
/*  162 */     else if (this.lastRowProcessed == 0)
/*      */     {
/*  167 */       if (this.previousRowProcessed == -1)
/*  168 */         this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/*  169 */       long l = getOffset(this.previousRowProcessed);
/*  170 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/*  171 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/*  172 */       if (!isNull(this.previousRowProcessed)) {
/*  173 */         setOffset(this.lastRowProcessed);
/*  174 */         ((DynamicByteArray)this.rowData).copyLeft(l, getLength(this.previousRowProcessed));
/*  175 */         setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  180 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/*  181 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/*  182 */       setOffset(this.lastRowProcessed, getOffset(this.previousRowProcessed));
/*  183 */       setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*      */     }
/*  185 */     this.previousRowProcessed = this.lastRowProcessed;
/*  186 */     this.lastRowProcessed += 1;
/*      */   }
/*      */ 
/*      */   boolean unmarshalBytes()
/*      */     throws SQLException, IOException
/*      */   {
/*  205 */     setOffset(this.lastRowProcessed);
/*      */ 
/*  207 */     this.rowData.putShort((short)0);
/*      */     int i;
/*  208 */     if (this.describeType == 208)
/*      */     {
/*  210 */       i = (int)this.mare.unmarshalUB4();
/*  211 */       if (i > 0)
/*  212 */         ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare, i);
/*      */     }
/*      */     else
/*      */     {
/*  216 */       i = this.mare.unmarshalUB1();
/*      */ 
/*  219 */       if (i > 0) {
/*  220 */         this.rowData.putInt((int)this.mare.unmarshalUB4());
/*  221 */         this.rowData.putShort((short)this.mare.unmarshalUB2());
/*  222 */         this.rowData.put((byte)this.mare.unmarshalUB1());
/*  223 */         this.rowData.putInt((int)this.mare.unmarshalUB4());
/*  224 */         this.rowData.putShort((short)this.mare.unmarshalUB2());
/*      */       }
/*      */     }
/*  227 */     processIndicator(i);
/*  228 */     this.rowData.putShort(getOffset(this.lastRowProcessed), (short)i);
/*  229 */     setLength(this.lastRowProcessed, (int)(this.rowData.getPosition() - getOffset(this.lastRowProcessed)));
/*  230 */     setNull(this.lastRowProcessed, i == 0);
/*  231 */     return false;
/*      */   }
/*      */ 
/*      */   byte[] getDecodedBytes(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  239 */     this.rowData.setPosition(getOffset(paramInt));
/*  240 */     int i = this.rowData.getShort();
/*  241 */     if (this.describeType == 208)
/*      */     {
/*  243 */       byte[] arrayOfByte1 = getBytesInternal(paramInt);
/*  244 */       byte[] arrayOfByte2 = new byte[4096];
/*  245 */       i = kgrdub2c(arrayOfByte1, i, 2, arrayOfByte2, 2);
/*  246 */       arrayOfByte2[0] = ((byte)(i >> 8 & 0xFF));
/*  247 */       arrayOfByte2[1] = ((byte)(i & 0xFF));
/*  248 */       byte[] arrayOfByte3 = new byte[i + 2];
/*  249 */       System.arraycopy(arrayOfByte2, 0, arrayOfByte3, 0, arrayOfByte3.length);
/*  250 */       return arrayOfByte3;
/*      */     }
/*      */ 
/*  254 */     int j = (short)i;
/*  255 */     long l1 = 0L;
/*  256 */     int k = 0;
/*  257 */     int m = 0;
/*  258 */     long l2 = 0L;
/*  259 */     int n = 0;
/*      */ 
/*  263 */     if (j > 0) {
/*  264 */       l1 = this.rowData.getInt() & 0xFFFFFFFF;
/*  265 */       k = this.rowData.getShort() & 0xFFFF;
/*  266 */       m = (short)(this.rowData.get() & 0xFF);
/*  267 */       l2 = this.rowData.getInt() & 0xFFFFFFFF;
/*  268 */       n = this.rowData.getShort() & 0xFFFF;
/*      */     }
/*      */ 
/*  272 */     if ((l1 == 0L) && (k == 0) && (m == 0) && (l2 == 0L) && (n == 0))
/*      */     {
/*  274 */       return null;
/*      */     }
/*      */ 
/*  277 */     long[] arrayOfLong = { l1, k, l2, n };
/*      */ 
/*  281 */     byte[] arrayOfByte4 = rowidToString(arrayOfLong);
/*  282 */     int i1 = 18;
/*      */ 
/*  284 */     if (this.byteLength - 2 < 18)
/*  285 */       i1 = this.byteLength - 2;
/*  286 */     byte[] arrayOfByte5 = new byte[i1 + 2];
/*  287 */     System.arraycopy(arrayOfByte4, 0, arrayOfByte5, 2, i1);
/*  288 */     arrayOfByte5[0] = ((byte)((i1 & 0xFF00) >> 8));
/*  289 */     arrayOfByte5[1] = ((byte)(i1 & 0xFF));
/*  290 */     return arrayOfByte5;
/*      */   }
/*      */ 
/*      */   String getString(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  304 */     if (isNull(paramInt)) return null;
/*      */ 
/*  306 */     long l = getOffset(paramInt);
/*      */ 
/*  308 */     if ((this.describeType == 208) && (this.rowData.get(l) != 1))
/*      */     {
/*  311 */       byte[] arrayOfByte1 = getDecodedBytes(paramInt);
/*  312 */       if (arrayOfByte1 == null)
/*  313 */         return null;
/*  314 */       int j = (arrayOfByte1[0] & 0xFF) << 8 | arrayOfByte1[1] & 0xFF;
/*  315 */       return new String(arrayOfByte1, 2, j);
/*      */     }
/*      */ 
/*  318 */     int i = getLength(paramInt);
/*  319 */     byte[] arrayOfByte2 = getDecodedBytes(paramInt);
/*  320 */     if (arrayOfByte2 == null)
/*  321 */       return null;
/*  322 */     String str = new String(arrayOfByte2, 2, arrayOfByte2.length - 2);
/*  323 */     long[] arrayOfLong = stringToRowid(str.getBytes(), 0, str.length());
/*      */ 
/*  328 */     return new String(rowidToString(arrayOfLong));
/*      */   }
/*      */ 
/*      */   Object getObject(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  339 */     if (this.definedColumnType == 0) {
/*  340 */       return super.getObject(paramInt);
/*      */     }
/*  342 */     if (isNull(paramInt)) return null;
/*      */ 
/*  344 */     switch (this.definedColumnType)
/*      */     {
/*      */     case -15:
/*      */     case -9:
/*      */     case -1:
/*      */     case 1:
/*      */     case 12:
/*  351 */       return getString(paramInt);
/*      */     case -8:
/*  354 */       return getROWID(paramInt);
/*      */     }
/*      */ 
/*  358 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/*  359 */     localSQLException.fillInStackTrace();
/*  360 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   byte[] getBytes(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  371 */     if (isNull(paramInt)) return null;
/*      */ 
/*  373 */     byte[] arrayOfByte1 = getDecodedBytes(paramInt);
/*  374 */     if (arrayOfByte1 == null)
/*  375 */       return null;
/*  376 */     byte[] arrayOfByte2 = new byte[arrayOfByte1.length - 2];
/*  377 */     System.arraycopy(arrayOfByte1, 2, arrayOfByte2, 0, arrayOfByte2.length);
/*  378 */     return arrayOfByte2;
/*      */   }
/*      */ 
/*      */   static final byte[] rowidToString(long[] paramArrayOfLong)
/*      */   {
/*  390 */     long l1 = paramArrayOfLong[0];
/*      */ 
/*  393 */     long l2 = paramArrayOfLong[1];
/*      */ 
/*  396 */     long l3 = paramArrayOfLong[2];
/*      */ 
/*  399 */     long l4 = paramArrayOfLong[3];
/*      */ 
/*  401 */     int i = 18;
/*      */ 
/*  405 */     byte[] arrayOfByte = new byte[i];
/*  406 */     int j = 0;
/*      */ 
/*  408 */     j = kgrd42b(arrayOfByte, l1, 6, j);
/*      */ 
/*  411 */     j = kgrd42b(arrayOfByte, l2, 3, j);
/*      */ 
/*  414 */     j = kgrd42b(arrayOfByte, l3, 6, j);
/*      */ 
/*  417 */     j = kgrd42b(arrayOfByte, l4, 3, j);
/*      */ 
/*  421 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   static final long[] rcToRowid(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  437 */     int i = 18;
/*      */ 
/*  439 */     if (paramInt2 != i)
/*      */     {
/*  441 */       throw new SQLException("Rowid size incorrect.");
/*      */     }
/*      */ 
/*  444 */     long[] arrayOfLong = new long[3];
/*  445 */     String str = new String(paramArrayOfByte, paramInt1, paramInt2);
/*      */ 
/*  448 */     long l1 = Long.parseLong(str.substring(0, 8), 16);
/*  449 */     long l2 = Long.parseLong(str.substring(9, 13), 16);
/*  450 */     long l3 = Long.parseLong(str.substring(14, 8), 16);
/*      */ 
/*  452 */     arrayOfLong[0] = l3;
/*  453 */     arrayOfLong[1] = l1;
/*  454 */     arrayOfLong[2] = l2;
/*      */ 
/*  456 */     return arrayOfLong;
/*      */   }
/*      */ 
/*      */   static final void kgrdr2rc(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, byte[] paramArrayOfByte, int paramInt6)
/*      */     throws SQLException
/*      */   {
/*  476 */     paramInt6 = lmx42h(paramArrayOfByte, paramInt4, 8, paramInt6);
/*  477 */     paramArrayOfByte[(paramInt6++)] = 46;
/*      */ 
/*  479 */     paramInt6 = lmx42h(paramArrayOfByte, paramInt5, 4, paramInt6);
/*  480 */     paramArrayOfByte[(paramInt6++)] = 46;
/*      */ 
/*  482 */     paramInt6 = lmx42h(paramArrayOfByte, paramInt2, 4, paramInt6);
/*      */   }
/*      */ 
/*      */   static final int lmx42h(byte[] paramArrayOfByte, long paramLong, int paramInt1, int paramInt2)
/*      */   {
/*  497 */     String str = Long.toHexString(paramLong).toUpperCase();
/*      */ 
/*  500 */     int i = paramInt1;
/*  501 */     int j = 0;
/*      */     do
/*      */     {
/*  505 */       if (j < str.length())
/*      */       {
/*  507 */         paramArrayOfByte[(paramInt2 + paramInt1 - 1)] = ((byte)str.charAt(str.length() - j - 1));
/*      */ 
/*  509 */         j++;
/*      */       }
/*      */       else
/*      */       {
/*  513 */         paramArrayOfByte[(paramInt2 + paramInt1 - 1)] = 48;
/*      */       }
/*      */ 
/*  516 */       paramInt1--; } while (paramInt1 > 0);
/*      */ 
/*  518 */     return i + paramInt2;
/*      */   }
/*      */ 
/*      */   static final int kgrdc2ub(byte[] paramArrayOfByte1, int paramInt1, byte[] paramArrayOfByte2, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/*  535 */     int i = getRowidType(paramArrayOfByte1, paramInt1);
/*  536 */     byte[] arrayOfByte1 = paramArrayOfByte2;
/*  537 */     int j = paramInt3 - 1;
/*  538 */     int k = 0;
/*      */ 
/*  543 */     byte[] arrayOfByte2 = kgrd_index_64;
/*      */ 
/*  550 */     int i2 = 1 + (3 * ((paramInt3 - 1) / 4) + ((paramInt3 - 1) % 4 != 0 ? (paramInt3 - 1) % 4 - 1 : 0));
/*      */     SQLException localSQLException;
/*  556 */     if (j == 0)
/*      */     {
/*  559 */       localSQLException = DatabaseError.createSqlException(null, 132);
/*  560 */       localSQLException.fillInStackTrace();
/*  561 */       throw localSQLException;
/*      */     }
/*      */ 
/*  566 */     arrayOfByte1[(paramInt2 + 0)] = i;
/*      */ 
/*  574 */     k = paramInt1 + 1;
/*  575 */     int i1 = 1;
/*      */ 
/*  577 */     while (j > 0)
/*      */     {
/*  580 */       if (j == 1)
/*      */       {
/*  583 */         localSQLException = DatabaseError.createSqlException(null, 132);
/*  584 */         localSQLException.fillInStackTrace();
/*  585 */         throw localSQLException;
/*      */       }
/*      */ 
/*  590 */       int m = arrayOfByte2[paramArrayOfByte1[k]];
/*  591 */       if (m == -1)
/*      */       {
/*  594 */         localSQLException = DatabaseError.createSqlException(null, 132);
/*  595 */         localSQLException.fillInStackTrace();
/*  596 */         throw localSQLException;
/*      */       }
/*      */ 
/*  600 */       k++;
/*  601 */       int n = arrayOfByte2[paramArrayOfByte1[k]];
/*  602 */       if (n == -1)
/*      */       {
/*  605 */         localSQLException = DatabaseError.createSqlException(null, 132);
/*  606 */         localSQLException.fillInStackTrace();
/*  607 */         throw localSQLException;
/*      */       }
/*      */ 
/*  615 */       arrayOfByte1[(paramInt2 + i1)] = ((byte)((m & 0xFF) << 2 | (n & 0x30) >> 4));
/*      */ 
/*  618 */       if (j == 2)
/*      */       {
/*      */         break;
/*      */       }
/*      */ 
/*  625 */       i1++;
/*  626 */       m = n;
/*  627 */       k++;
/*  628 */       n = arrayOfByte2[paramArrayOfByte1[k]];
/*  629 */       if (n == -1)
/*      */       {
/*  632 */         localSQLException = DatabaseError.createSqlException(null, 132);
/*  633 */         localSQLException.fillInStackTrace();
/*  634 */         throw localSQLException;
/*      */       }
/*      */ 
/*  638 */       arrayOfByte1[(paramInt2 + i1)] = ((byte)((m & 0xFF) << 4 | (n & 0x3C) >> 2));
/*      */ 
/*  641 */       if (j == 3)
/*      */       {
/*      */         break;
/*      */       }
/*      */ 
/*  646 */       i1++;
/*  647 */       m = n;
/*  648 */       k++;
/*  649 */       n = arrayOfByte2[paramArrayOfByte1[k]];
/*  650 */       if (n == -1)
/*      */       {
/*  653 */         localSQLException = DatabaseError.createSqlException(null, 132);
/*  654 */         localSQLException.fillInStackTrace();
/*  655 */         throw localSQLException;
/*      */       }
/*      */ 
/*  658 */       arrayOfByte1[(paramInt2 + i1)] = ((byte)((m & 0x3) << 6 | n));
/*      */ 
/*  662 */       j -= 4;
/*  663 */       k++;
/*  664 */       i1++;
/*      */     }
/*      */ 
/*  667 */     return i2;
/*      */   }
/*      */ 
/*      */   static final long[] stringToRowid(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  677 */     int i = 18;
/*      */ 
/*  682 */     if (paramInt2 != i)
/*      */     {
/*  684 */       throw new SQLException("Rowid size incorrect.");
/*      */     }
/*      */ 
/*  687 */     long[] arrayOfLong = new long[4];
/*      */     try
/*      */     {
/*  693 */       arrayOfLong[0] = kgrdb42(paramArrayOfByte, 6, paramInt1);
/*      */ 
/*  696 */       paramInt1 += 6;
/*      */ 
/*  699 */       arrayOfLong[1] = kgrdb42(paramArrayOfByte, 3, paramInt1);
/*      */ 
/*  702 */       paramInt1 += 3;
/*      */ 
/*  705 */       arrayOfLong[2] = kgrdb42(paramArrayOfByte, 6, paramInt1);
/*      */ 
/*  708 */       paramInt1 += 6;
/*      */ 
/*  711 */       arrayOfLong[3] = kgrdb42(paramArrayOfByte, 3, paramInt1);
/*      */ 
/*  714 */       paramInt1 += 3;
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/*  718 */       arrayOfLong[0] = 0L;
/*  719 */       arrayOfLong[1] = 0L;
/*  720 */       arrayOfLong[2] = 0L;
/*  721 */       arrayOfLong[3] = 0L;
/*      */     }
/*      */ 
/*  724 */     return arrayOfLong;
/*      */   }
/*      */ 
/*      */   static final int kgrd42b(byte[] paramArrayOfByte, long paramLong, int paramInt1, int paramInt2)
/*      */   {
/*  736 */     int i = paramInt1;
/*  737 */     long l = paramLong;
/*      */ 
/*  739 */     for (; paramInt1 > 0; paramInt1--)
/*      */     {
/*  741 */       paramArrayOfByte[(paramInt2 + paramInt1 - 1)] = kgrd_basis_64[((int)l & 0x3F)];
/*  742 */       l = l >>> 6 & 0x3FFFFFF;
/*      */     }
/*      */ 
/*  748 */     return i + paramInt2;
/*      */   }
/*      */ 
/*      */   static final long kgrdb42(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  759 */     long l = 0L;
/*      */ 
/*  761 */     for (int i = 0; i < paramInt1; i++)
/*      */     {
/*  763 */       int j = paramArrayOfByte[(paramInt2 + i)];
/*      */ 
/*  765 */       j = kgrd_index_64[j];
/*      */ 
/*  767 */       if (j == -1) {
/*  768 */         throw new SQLException("Char data to rowid conversion failed.");
/*      */       }
/*  770 */       l <<= 6;
/*  771 */       l |= j;
/*      */     }
/*      */ 
/*  774 */     return l;
/*      */   }
/*      */ 
/*      */   static final void kgrdr2ec(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, byte[] paramArrayOfByte, int paramInt6)
/*      */     throws SQLException
/*      */   {
/*  787 */     paramInt6 = kgrd42b(paramInt1, paramArrayOfByte, paramInt6, 6);
/*  788 */     paramInt6 = kgrd42b(paramInt2, paramArrayOfByte, paramInt6, 3);
/*  789 */     paramInt6 = kgrd42b(paramInt4, paramArrayOfByte, paramInt6, 6);
/*  790 */     paramInt6 = kgrd42b(paramInt5, paramArrayOfByte, paramInt6, 3);
/*      */   }
/*      */ 
/*      */   static final int kgrd42b(int paramInt1, byte[] paramArrayOfByte, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/*  801 */     int i = paramInt3;
/*  802 */     while (paramInt3 > 0)
/*      */     {
/*  804 */       paramInt3--;
/*  805 */       paramArrayOfByte[(paramInt2 + paramInt3)] = kgrd_basis_64[(paramInt1 & 0x3F)];
/*      */ 
/*  807 */       paramInt1 >>= 6;
/*      */     }
/*      */ 
/*  810 */     return paramInt2 + i;
/*      */   }
/*      */ 
/*      */   static final int kgrdub2c(byte[] paramArrayOfByte1, int paramInt1, int paramInt2, byte[] paramArrayOfByte2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/*  823 */     int i = -1;
/*  824 */     int j = paramArrayOfByte1[paramInt2];
/*      */     int m;
/*      */     int n;
/*      */     int i1;
/*      */     int i2;
/*      */     int i3;
/*  826 */     if (j == 1)
/*      */     {
/*  830 */       int[] arrayOfInt = new int[paramArrayOfByte1.length];
/*  831 */       for (m = 0; m < paramArrayOfByte1.length; m++) paramArrayOfByte1[m] &= 255;
/*      */ 
/*  833 */       m = paramInt2 + 1;
/*      */ 
/*  841 */       n = (((arrayOfInt[(m + 0)] << 8) + arrayOfInt[(m + 1)] << 8) + arrayOfInt[(m + 2)] << 8) + arrayOfInt[(m + 3)];
/*      */ 
/*  846 */       m = paramInt2 + 5;
/*      */ 
/*  848 */       i1 = (arrayOfInt[(m + 0)] << 8) + arrayOfInt[(m + 1)];
/*  849 */       i2 = 0;
/*      */ 
/*  852 */       m = paramInt2 + 7;
/*  853 */       i3 = (((arrayOfInt[(m + 0)] << 8) + arrayOfInt[(m + 1)] << 8) + arrayOfInt[(m + 2)] << 8) + arrayOfInt[(m + 3)];
/*      */ 
/*  858 */       m = paramInt2 + 11;
/*      */ 
/*  860 */       int i4 = (arrayOfInt[(m + 0)] << 8) + arrayOfInt[(m + 1)];
/*      */ 
/*  869 */       if (n == 0) {
/*  870 */         kgrdr2rc(n, i1, i2, i3, i4, paramArrayOfByte2, paramInt3);
/*      */       }
/*      */       else
/*      */       {
/*  878 */         kgrdr2ec(n, i1, i2, i3, i4, paramArrayOfByte2, paramInt3);
/*      */       }
/*      */ 
/*  886 */       i = 18;
/*      */     }
/*      */     else
/*      */     {
/*  892 */       int k = 0;
/*  893 */       m = paramInt1 - 1;
/*  894 */       n = 4 * (paramInt1 / 3) + (paramInt1 % 3 == 0 ? paramInt1 % 3 + 1 : 0);
/*      */ 
/*  896 */       i1 = 1 + n - 1;
/*      */ 
/*  898 */       if (i1 != 0)
/*      */       {
/*  900 */         paramArrayOfByte2[(paramInt3 + 0)] = kgrd_indbyte_char[(j - 1)];
/*      */ 
/*  914 */         i2 = paramInt2 + 1;
/*      */ 
/*  916 */         k = 1;
/*      */ 
/*  918 */         i3 = 0;
/*      */ 
/*  920 */         while (m > 0)
/*      */         {
/*  922 */           paramArrayOfByte2[(paramInt3 + k++)] = kgrd_basis_64[((paramArrayOfByte1[i2] & 0xFF) >> 2)];
/*      */ 
/*  926 */           if (m == 1)
/*      */           {
/*  930 */             paramArrayOfByte2[(paramInt3 + k++)] = kgrd_basis_64[((paramArrayOfByte1[i2] & 0x3) << 4)];
/*      */ 
/*  933 */             break;
/*      */           }
/*      */ 
/*  937 */           i3 = (byte)(paramArrayOfByte1[(i2 + 1)] & 0xFF);
/*      */ 
/*  939 */           paramArrayOfByte2[(paramInt3 + k++)] = kgrd_basis_64[((paramArrayOfByte1[i2] & 0x3) << 4 | (i3 & 0xF0) >> 4)];
/*      */ 
/*  943 */           if (m == 2)
/*      */           {
/*  945 */             paramArrayOfByte2[(paramInt3 + k++)] = kgrd_basis_64[((i3 & 0xF) << 2)];
/*      */ 
/*  948 */             break;
/*      */           }
/*      */ 
/*  955 */           i2 += 2;
/*  956 */           paramArrayOfByte2[(paramInt3 + k++)] = kgrd_basis_64[((i3 & 0xF) << 2 | (paramArrayOfByte1[i2] & 0xC0) >> 6)];
/*      */ 
/*  960 */           paramArrayOfByte2[(paramInt3 + k)] = kgrd_basis_64[(paramArrayOfByte1[i2] & 0x3F)];
/*      */ 
/*  964 */           m -= 3;
/*  965 */           i2++;
/*  966 */           k++;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  972 */       i = k;
/*      */     }
/*      */ 
/*  975 */     return i;
/*      */   }
/*      */ 
/*      */   static final boolean isUROWID(byte[] paramArrayOfByte, int paramInt)
/*      */   {
/*  981 */     return getRowidType(paramArrayOfByte, paramInt) == 2;
/*      */   }
/*      */ 
/*      */   static final byte getRowidType(byte[] paramArrayOfByte, int paramInt)
/*      */   {
/*  987 */     byte b = 5;
/*  988 */     switch (paramArrayOfByte[paramInt])
/*      */     {
/*      */     case 65:
/*  991 */       b = 1;
/*  992 */       break;
/*      */     case 42:
/*  995 */       b = 2;
/*  996 */       break;
/*      */     case 45:
/*  999 */       b = 3;
/* 1000 */       break;
/*      */     case 40:
/* 1003 */       b = 4;
/* 1004 */       break;
/*      */     case 41:
/* 1007 */       b = 5;
/*      */     }
/*      */ 
/* 1011 */     return b;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CRowidAccessor
 * JD-Core Version:    0.6.2
 */