/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ 
/*     */ class T4CResultSetAccessor extends ResultSetAccessor
/*     */ {
/*     */   T4CMAREngine mare;
/*  22 */   OracleStatement[] newstmt = null;
/*  23 */   byte[] empty = { 0 };
/*     */ 
/*  39 */   boolean underlyingLongRaw = false;
/*     */ 
/* 357 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CResultSetAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  45 */     super(paramOracleStatement, paramInt1, paramShort, paramInt2, paramBoolean);
/*     */ 
/*  47 */     this.mare = paramT4CMAREngine;
/*     */   }
/*     */ 
/*     */   T4CResultSetAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, int paramInt7, int paramInt8, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  56 */     super(paramOracleStatement, paramInt1 == -1 ? paramInt8 : paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort);
/*     */ 
/*  59 */     this.mare = paramT4CMAREngine;
/*     */ 
/*  62 */     if ((paramOracleStatement != null) && (paramOracleStatement.implicitDefineForLobPrefetchDone))
/*     */     {
/*  64 */       this.definedColumnType = 0;
/*  65 */       this.definedColumnSize = 0;
/*     */     }
/*     */     else
/*     */     {
/*  69 */       this.definedColumnType = paramInt7;
/*  70 */       this.definedColumnSize = paramInt8;
/*     */     }
/*     */ 
/*  73 */     if (paramInt1 == -1)
/*  74 */       this.underlyingLongRaw = true;
/*     */   }
/*     */ 
/*     */   public T4CMAREngine getMAREngine() {
/*  78 */     return this.mare;
/*     */   }
/*     */ 
/*     */   public void unmarshalColumnMetadata()
/*     */     throws SQLException, IOException
/*     */   {
/*  87 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*     */     {
/*  90 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processIndicator(int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/*  97 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*     */     {
/* 104 */       this.mare.unmarshalUB2();
/* 105 */       this.mare.unmarshalUB2();
/*     */     }
/* 107 */     else if (this.statement.connection.versionNumber < 9200)
/*     */     {
/* 111 */       this.mare.unmarshalSB2();
/*     */ 
/* 113 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/* 114 */         this.mare.unmarshalSB2();
/*     */     }
/* 116 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/* 117 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getPreviousRowProcessed()
/*     */   {
/* 123 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 124 */     return this.previousRowProcessed;
/*     */   }
/*     */ 
/*     */   boolean unmarshalOneRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 140 */     boolean bool = false;
/* 141 */     if (!isUseless())
/*     */     {
/* 147 */       if (isUnexpected())
/*     */       {
/* 150 */         long l = this.rowData.getPosition();
/* 151 */         unmarshalColumnMetadata();
/* 152 */         unmarshalBytes();
/* 153 */         this.rowData.setPosition(l);
/* 154 */         setNull(this.lastRowProcessed, true);
/*     */       }
/* 156 */       else if (isNullByDescribe())
/*     */       {
/* 159 */         setNull(this.lastRowProcessed, true);
/* 160 */         unmarshalColumnMetadata();
/* 161 */         if (this.statement.connection.versionNumber < 9200) processIndicator(0);
/*     */       }
/*     */       else
/*     */       {
/* 165 */         unmarshalColumnMetadata();
/* 166 */         bool = unmarshalBytes();
/*     */       }
/*     */     }
/* 168 */     this.previousRowProcessed = this.lastRowProcessed;
/* 169 */     this.lastRowProcessed += 1;
/* 170 */     return bool;
/*     */   }
/*     */ 
/*     */   void copyRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 179 */     if (this.isNullByDescribe) {
/* 180 */       setNull(this.lastRowProcessed, true);
/*     */     }
/* 182 */     else if (this.lastRowProcessed == 0)
/*     */     {
/* 187 */       if (this.previousRowProcessed == -1)
/* 188 */         this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 189 */       long l = getOffset(this.previousRowProcessed);
/* 190 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 191 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 192 */       if (!isNull(this.previousRowProcessed)) {
/* 193 */         setOffset(this.lastRowProcessed);
/* 194 */         ((DynamicByteArray)this.rowData).copyLeft(l, getLength(this.previousRowProcessed));
/* 195 */         setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 200 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 201 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 202 */       setOffset(this.lastRowProcessed, getOffset(this.previousRowProcessed));
/* 203 */       setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */     }
/* 205 */     this.previousRowProcessed = this.lastRowProcessed;
/* 206 */     this.lastRowProcessed += 1;
/*     */   }
/*     */ 
/*     */   void setCapacity(int paramInt)
/*     */   {
/* 223 */     super.setCapacity(paramInt);
/* 224 */     if ((this.newstmt == null) || (this.newstmt.length < paramInt)) {
/* 225 */       OracleStatement[] arrayOfOracleStatement = new OracleStatement[paramInt];
/* 226 */       if (this.newstmt != null) System.arraycopy(this.newstmt, 0, arrayOfOracleStatement, 0, this.newstmt.length);
/* 227 */       this.newstmt = arrayOfOracleStatement;
/*     */     }
/*     */   }
/*     */ 
/*     */   Accessor copyForDefine(OracleStatement paramOracleStatement)
/*     */   {
/* 240 */     T4CResultSetAccessor localT4CResultSetAccessor = (T4CResultSetAccessor)super.copyForDefine(paramOracleStatement);
/* 241 */     localT4CResultSetAccessor.newstmt = null;
/* 242 */     return localT4CResultSetAccessor;
/*     */   }
/*     */ 
/*     */   protected void copyFromInternal(Accessor paramAccessor, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 259 */     super.copyFromInternal(paramAccessor, paramInt1, paramInt2);
/*     */ 
/* 261 */     this.newstmt[paramInt2] = ((T4CResultSetAccessor)paramAccessor).newstmt[paramInt1];
/*     */   }
/*     */ 
/*     */   void deleteRow(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 277 */     super.deleteRow(paramInt);
/*     */ 
/* 279 */     if (this.newstmt[paramInt] != null) this.newstmt[paramInt].close();
/* 280 */     delete(this.newstmt, paramInt);
/*     */   }
/*     */ 
/*     */   boolean unmarshalBytes()
/*     */     throws SQLException, IOException
/*     */   {
/* 294 */     this.newstmt[this.lastRowProcessed] = this.statement.connection.RefCursorBytesToStatement(this.empty, this.statement);
/*     */ 
/* 296 */     this.newstmt[this.lastRowProcessed].needToSendOalToFetch = true;
/*     */ 
/* 298 */     T4CTTIdcb localT4CTTIdcb = new T4CTTIdcb((T4CConnection)this.statement.connection);
/*     */ 
/* 300 */     localT4CTTIdcb.init(this.newstmt[this.lastRowProcessed], 0);
/*     */ 
/* 302 */     this.newstmt[this.lastRowProcessed].accessors = localT4CTTIdcb.receiveFromRefCursor(this.newstmt[this.lastRowProcessed].accessors);
/*     */ 
/* 304 */     this.newstmt[this.lastRowProcessed].numberOfDefinePositions = this.newstmt[this.lastRowProcessed].accessors.length;
/*     */ 
/* 306 */     this.newstmt[this.lastRowProcessed].describedWithNames = true;
/* 307 */     this.newstmt[this.lastRowProcessed].described = true;
/*     */ 
/* 309 */     int i = (int)this.mare.unmarshalUB4();
/*     */ 
/* 311 */     this.newstmt[this.lastRowProcessed].setCursorId(i);
/*     */ 
/* 313 */     if (i > 0) {
/* 314 */       this.rowData.putShort((short)i);
/* 315 */       setLength(this.lastRowProcessed, 2);
/* 316 */       processIndicator(2);
/*     */     }
/*     */     else {
/* 319 */       this.newstmt[this.lastRowProcessed].close();
/* 320 */       this.newstmt[this.lastRowProcessed] = null;
/* 321 */       setNull(this.lastRowProcessed, true);
/* 322 */       processIndicator(0);
/*     */     }
/*     */ 
/* 325 */     return false;
/*     */   }
/*     */ 
/*     */   ResultSet getCursor(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 333 */     Object localObject = null;
/*     */ 
/* 335 */     if (this.newstmt[paramInt] != null)
/*     */     {
/* 337 */       for (int i = 0; i < this.newstmt[paramInt].numberOfDefinePositions; i++) {
/* 338 */         this.newstmt[paramInt].accessors[i].initMetadata();
/*     */       }
/* 340 */       this.newstmt[paramInt].prepareAccessors();
/* 341 */       this.newstmt[paramInt].setPrefetchInternal(this.statement.getFetchSize(), false, false);
/*     */ 
/* 343 */       this.newstmt[paramInt].closeOnCompletion();
/*     */ 
/* 345 */       OracleResultSet localOracleResultSet = OracleResultSet.createResultSet(this.newstmt[paramInt]);
/*     */ 
/* 347 */       this.newstmt[paramInt].currentResultSet = localOracleResultSet;
/* 348 */       localObject = localOracleResultSet;
/*     */     }
/*     */ 
/* 351 */     return localObject;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CResultSetAccessor
 * JD-Core Version:    0.6.2
 */