/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ 
/*     */ class T4CRefTypeAccessor extends RefTypeAccessor
/*     */ {
/*     */   static final int MAXLENGTH = 4000;
/*     */   T4CMAREngine mare;
/*  25 */   final int[] meta = new int[1];
/*     */ 
/* 241 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public T4CMAREngine getMAREngine()
/*     */   {
/*  37 */     return this.mare;
/*     */   }
/*     */ 
/*     */   public void unmarshalColumnMetadata()
/*     */     throws SQLException, IOException
/*     */   {
/*  46 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*     */     {
/*  49 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processIndicator(int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/*  56 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*     */     {
/*  63 */       this.mare.unmarshalUB2();
/*  64 */       this.mare.unmarshalUB2();
/*     */     }
/*  66 */     else if (this.statement.connection.versionNumber < 9200)
/*     */     {
/*  70 */       this.mare.unmarshalSB2();
/*     */ 
/*  72 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/*  73 */         this.mare.unmarshalSB2();
/*     */     }
/*  75 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/*  76 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getPreviousRowProcessed()
/*     */   {
/*  82 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/*  83 */     return this.previousRowProcessed;
/*     */   }
/*     */ 
/*     */   boolean unmarshalOneRow()
/*     */     throws SQLException, IOException
/*     */   {
/*  99 */     boolean bool = false;
/* 100 */     if (!isUseless())
/*     */     {
/* 106 */       if (isUnexpected())
/*     */       {
/* 109 */         long l = this.rowData.getPosition();
/* 110 */         unmarshalColumnMetadata();
/* 111 */         unmarshalBytes();
/* 112 */         this.rowData.setPosition(l);
/* 113 */         setNull(this.lastRowProcessed, true);
/*     */       }
/* 115 */       else if (isNullByDescribe())
/*     */       {
/* 118 */         setNull(this.lastRowProcessed, true);
/* 119 */         unmarshalColumnMetadata();
/* 120 */         if (this.statement.connection.versionNumber < 9200) processIndicator(0);
/*     */       }
/*     */       else
/*     */       {
/* 124 */         unmarshalColumnMetadata();
/* 125 */         bool = unmarshalBytes();
/*     */       }
/*     */     }
/* 127 */     this.previousRowProcessed = this.lastRowProcessed;
/* 128 */     this.lastRowProcessed += 1;
/* 129 */     return bool;
/*     */   }
/*     */ 
/*     */   void copyRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 138 */     if (this.isNullByDescribe) {
/* 139 */       setNull(this.lastRowProcessed, true);
/*     */     }
/* 141 */     else if (this.lastRowProcessed == 0)
/*     */     {
/* 146 */       if (this.previousRowProcessed == -1)
/* 147 */         this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 148 */       long l = getOffset(this.previousRowProcessed);
/* 149 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 150 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 151 */       if (!isNull(this.previousRowProcessed)) {
/* 152 */         setOffset(this.lastRowProcessed);
/* 153 */         ((DynamicByteArray)this.rowData).copyLeft(l, getLength(this.previousRowProcessed));
/* 154 */         setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 159 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 160 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 161 */       setOffset(this.lastRowProcessed, getOffset(this.previousRowProcessed));
/* 162 */       setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */     }
/* 164 */     this.previousRowProcessed = this.lastRowProcessed;
/* 165 */     this.lastRowProcessed += 1;
/*     */   }
/*     */ 
/*     */   T4CRefTypeAccessor(OracleStatement paramOracleStatement, String paramString, short paramShort, int paramInt, boolean paramBoolean, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/* 180 */     super(paramOracleStatement, paramString, paramShort, paramInt, paramBoolean);
/*     */ 
/* 182 */     this.mare = paramT4CMAREngine;
/* 183 */     this.byteLength = 4000;
/*     */   }
/*     */ 
/*     */   T4CRefTypeAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, String paramString, int paramInt7, int paramInt8, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/* 202 */     super(paramOracleStatement, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, paramString);
/*     */ 
/* 213 */     this.mare = paramT4CMAREngine;
/* 214 */     this.definedColumnType = paramInt7;
/* 215 */     this.definedColumnSize = paramInt8;
/* 216 */     this.byteLength = 4000;
/*     */   }
/*     */ 
/*     */   boolean unmarshalBytes()
/*     */     throws SQLException, IOException
/*     */   {
/* 228 */     setOffset(this.lastRowProcessed);
/*     */ 
/* 231 */     int i = ((DynamicByteArray)this.rowData).unmarshalCLRforREFS(this.mare);
/* 232 */     setLength(this.lastRowProcessed, i);
/* 233 */     setNull(this.lastRowProcessed, i == 0);
/* 234 */     processIndicator(i);
/* 235 */     return false;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CRefTypeAccessor
 * JD-Core Version:    0.6.2
 */