/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ 
/*     */ class T4CRawAccessor extends RawAccessor
/*     */   implements T4CAccessor
/*     */ {
/*     */   T4CMAREngine mare;
/*  34 */   boolean underlyingLongRaw = false;
/*     */ 
/* 182 */   private T4CMarshaller marshaller = null;
/*     */ 
/* 237 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CRawAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  40 */     super(paramOracleStatement, paramInt1, paramShort, paramInt2, paramBoolean);
/*     */ 
/*  42 */     this.mare = paramT4CMAREngine;
/*     */   }
/*     */ 
/*     */   T4CRawAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, int paramInt7, int paramInt8, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  51 */     super(paramOracleStatement, paramInt1 == -1 ? paramInt8 : paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort);
/*     */ 
/*  54 */     this.mare = paramT4CMAREngine;
/*     */ 
/*  57 */     if ((paramOracleStatement != null) && (paramOracleStatement.implicitDefineForLobPrefetchDone))
/*     */     {
/*  59 */       this.definedColumnType = 0;
/*  60 */       this.definedColumnSize = 0;
/*     */     }
/*     */     else
/*     */     {
/*  64 */       this.definedColumnType = paramInt7;
/*  65 */       this.definedColumnSize = paramInt8;
/*     */     }
/*     */ 
/*  68 */     if (paramInt1 == -1)
/*  69 */       this.underlyingLongRaw = true;
/*     */   }
/*     */ 
/*     */   public T4CMAREngine getMAREngine() {
/*  73 */     return this.mare;
/*     */   }
/*     */ 
/*     */   public void unmarshalColumnMetadata()
/*     */     throws SQLException, IOException
/*     */   {
/*  82 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*     */     {
/*  85 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processIndicator(int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/*  92 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*     */     {
/*  99 */       this.mare.unmarshalUB2();
/* 100 */       this.mare.unmarshalUB2();
/*     */     }
/* 102 */     else if (this.statement.connection.versionNumber < 9200)
/*     */     {
/* 106 */       this.mare.unmarshalSB2();
/*     */ 
/* 108 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/* 109 */         this.mare.unmarshalSB2();
/*     */     }
/* 111 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/* 112 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getPreviousRowProcessed()
/*     */   {
/* 118 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 119 */     return this.previousRowProcessed;
/*     */   }
/*     */ 
/*     */   void copyRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 129 */     if (this.isNullByDescribe) {
/* 130 */       setNull(this.lastRowProcessed, true);
/*     */     }
/* 132 */     else if (this.lastRowProcessed == 0)
/*     */     {
/* 137 */       if (this.previousRowProcessed == -1)
/* 138 */         this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 139 */       long l = getOffset(this.previousRowProcessed);
/* 140 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 141 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 142 */       if (!isNull(this.previousRowProcessed)) {
/* 143 */         setOffset(this.lastRowProcessed);
/* 144 */         ((DynamicByteArray)this.rowData).copyLeft(l, getLength(this.previousRowProcessed));
/* 145 */         setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 150 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 151 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 152 */       setOffset(this.lastRowProcessed, getOffset(this.previousRowProcessed));
/* 153 */       setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */     }
/* 155 */     this.previousRowProcessed = this.lastRowProcessed;
/* 156 */     this.lastRowProcessed += 1;
/*     */   }
/*     */ 
/*     */   boolean unmarshalOneRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 165 */     return getMarshaller().unmarshalOneRow(this);
/*     */   }
/*     */ 
/*     */   int readStreamFromWire(byte[] paramArrayOfByte, int paramInt1, int paramInt2, int[] paramArrayOfInt, boolean[] paramArrayOfBoolean1, boolean[] paramArrayOfBoolean2, T4CMAREngine paramT4CMAREngine, T4CTTIoer paramT4CTTIoer)
/*     */     throws SQLException, IOException
/*     */   {
/* 176 */     return getMarshaller().readStreamFromWire(paramArrayOfByte, paramInt1, paramInt2, paramArrayOfInt, paramArrayOfBoolean1, paramArrayOfBoolean2, paramT4CMAREngine, paramT4CTTIoer);
/*     */   }
/*     */ 
/*     */   private final T4CMarshaller getMarshaller()
/*     */   {
/* 184 */     if (this.marshaller == null) this.marshaller = (this.describeType == 24 ? T4CMarshaller.LONG_RAW : T4CMarshaller.RAW);
/* 185 */     return this.marshaller;
/*     */   }
/*     */ 
/*     */   String getString(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 191 */     String str = super.getString(paramInt);
/*     */ 
/* 195 */     if ((str != null) && (this.definedColumnSize > 0) && (str.length() > this.definedColumnSize * 2))
/*     */     {
/* 197 */       str = str.substring(0, this.definedColumnSize * 2);
/*     */     }
/* 199 */     return str;
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 205 */     if (this.definedColumnType == 0)
/* 206 */       return super.getObject(paramInt);
/* 207 */     if (isNull(paramInt)) return null;
/*     */ 
/* 209 */     switch (this.definedColumnType)
/*     */     {
/*     */     case -16:
/*     */     case -15:
/*     */     case -9:
/*     */     case -1:
/*     */     case 1:
/*     */     case 12:
/* 217 */       return getString(paramInt);
/*     */     case -4:
/*     */     case -2:
/* 221 */       return getRAW(paramInt);
/*     */     case -14:
/*     */     case -13:
/*     */     case -12:
/*     */     case -11:
/*     */     case -10:
/*     */     case -8:
/*     */     case -7:
/*     */     case -6:
/*     */     case -5:
/*     */     case -3:
/*     */     case 0:
/*     */     case 2:
/*     */     case 3:
/*     */     case 4:
/*     */     case 5:
/*     */     case 6:
/*     */     case 7:
/*     */     case 8:
/*     */     case 9:
/*     */     case 10:
/* 225 */     case 11: } SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 226 */     localSQLException.fillInStackTrace();
/* 227 */     throw localSQLException;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CRawAccessor
 * JD-Core Version:    0.6.2
 */