/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.sql.SQLException;
/*      */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*      */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*      */ 
/*      */ class T4CPreparedStatement extends OraclePreparedStatement
/*      */ {
/*   46 */   static final byte[] EMPTY_BYTE = new byte[0];
/*      */   T4CConnection t4Connection;
/* 1184 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   T4CPreparedStatement(PhysicalConnection paramPhysicalConnection, String paramString, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*   28 */     super(paramPhysicalConnection, paramString, paramPhysicalConnection.defaultExecuteBatch, paramPhysicalConnection.defaultRowPrefetch, paramInt1, paramInt2);
/*      */ 
/*   31 */     this.nbPostPonedColumns = new int[1];
/*   32 */     this.nbPostPonedColumns[0] = 0;
/*   33 */     this.indexOfPostPonedColumn = new int[1][3];
/*   34 */     this.t4Connection = ((T4CConnection)paramPhysicalConnection);
/*      */ 
/*   36 */     this.theRowidBinder = theStaticT4CRowidBinder;
/*   37 */     this.theRowidNullBinder = theStaticT4CRowidNullBinder;
/*   38 */     this.theURowidBinder = theStaticT4CURowidBinder;
/*   39 */     this.theURowidNullBinder = theStaticT4CURowidNullBinder;
/*      */   }
/*      */ 
/*      */   void doOall8(boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3, boolean paramBoolean4, boolean paramBoolean5)
/*      */     throws SQLException, IOException
/*      */   {
/*   58 */     doOall8(paramBoolean1, paramBoolean2, paramBoolean3, paramBoolean4, paramBoolean5, 0);
/*      */   }
/*      */ 
/*      */   void doOall8(boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3, boolean paramBoolean4, boolean paramBoolean5, int paramInt)
/*      */     throws SQLException, IOException
/*      */   {
/*   72 */     if ((paramBoolean1) || (paramBoolean4) || (!paramBoolean2)) {
/*   73 */       this.oacdefSent = null;
/*      */     }
/*   75 */     this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.doOall8");
/*      */ 
/*   77 */     if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED)
/*      */     {
/*   81 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 439, "sqlKind = " + this.sqlKind);
/*   82 */       localSQLException1.fillInStackTrace();
/*   83 */       throw localSQLException1;
/*      */     }
/*      */ 
/*   87 */     int i = this.rowPrefetch;
/*   88 */     if (paramBoolean3) {
/*   89 */       if ((this.maxRows > 0) && (this.maxRows <= this.indexOfFirstRow + this.storedRowCount + this.rowPrefetch))
/*      */       {
/*   91 */         i = this.maxRows - (this.indexOfFirstRow + this.storedRowCount);
/*   92 */         this.isComplete = true;
/*      */       }
/*   94 */       this.rowPrefetchInLastFetch = i;
/*   95 */       if ((i == 0) && (this.isComplete))
/*   96 */         return;
/*      */     }
/*   98 */     int j = this.numberOfDefinePositions;
/*      */ 
/*  100 */     if (this.sqlKind.isDML())
/*  101 */       j = 0;
/*      */     int k;
/*  104 */     if (this.accessors != null)
/*  105 */       for (k = 0; k < this.accessors.length; k++)
/*  106 */         if (this.accessors[k] != null)
/*  107 */           this.accessors[k].lastRowProcessed = paramInt;
/*  108 */     if (this.outBindAccessors != null)
/*  109 */       for (k = 0; k < this.outBindAccessors.length; k++)
/*  110 */         if (this.outBindAccessors[k] != null)
/*  111 */           this.outBindAccessors[k].lastRowProcessed = 0;
/*      */     int i2;
/*  118 */     if (this.bindIndicators != null)
/*      */     {
/*  120 */       k = ((this.bindIndicators[(this.bindIndicatorSubRange + 3)] & 0xFFFF) << 16) + (this.bindIndicators[(this.bindIndicatorSubRange + 4)] & 0xFFFF);
/*      */ 
/*  123 */       int m = 0;
/*      */ 
/*  125 */       if (this.ibtBindChars != null) {
/*  126 */         m = this.ibtBindChars.length * this.connection.conversion.cMaxCharSize;
/*      */       }
/*  128 */       for (int n = 0; n < this.numberOfBindPositions; n++)
/*      */       {
/*  130 */         int i1 = this.bindIndicatorSubRange + 5 + 10 * n;
/*      */ 
/*  134 */         i2 = this.bindIndicators[(i1 + 2)] & 0xFFFF;
/*      */ 
/*  138 */         if (i2 != 0)
/*      */         {
/*  141 */           int i3 = this.bindIndicators[(i1 + 9)] & 0xFFFF;
/*      */ 
/*  145 */           if (i3 == 2)
/*      */           {
/*  147 */             m = Math.max(i2 * this.connection.conversion.maxNCharSize, m);
/*      */           }
/*      */           else
/*      */           {
/*  152 */             m = Math.max(i2 * this.connection.conversion.cMaxCharSize, m);
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  158 */       if (this.tmpBindsByteArray == null)
/*      */       {
/*  160 */         this.tmpBindsByteArray = new byte[m];
/*      */       }
/*  162 */       else if (this.tmpBindsByteArray.length < m)
/*      */       {
/*  164 */         this.tmpBindsByteArray = null;
/*  165 */         this.tmpBindsByteArray = new byte[m];
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  177 */       this.tmpBindsByteArray = null;
/*      */     }
/*      */ 
/*  182 */     int[] arrayOfInt1 = this.definedColumnType;
/*  183 */     int[] arrayOfInt2 = this.definedColumnSize;
/*  184 */     int[] arrayOfInt3 = this.definedColumnFormOfUse;
/*      */ 
/*  190 */     if ((paramBoolean5) && (paramBoolean4) && (this.isRowidPrepended))
/*      */     {
/*  195 */       arrayOfInt1 = new int[this.definedColumnType.length + 1];
/*  196 */       System.arraycopy(this.definedColumnType, 0, arrayOfInt1, 1, this.definedColumnType.length);
/*  197 */       arrayOfInt1[0] = -8;
/*  198 */       arrayOfInt2 = new int[this.definedColumnSize.length + 1];
/*  199 */       System.arraycopy(this.definedColumnSize, 0, arrayOfInt2, 1, this.definedColumnSize.length);
/*  200 */       arrayOfInt3 = new int[this.definedColumnFormOfUse.length + 1];
/*  201 */       System.arraycopy(this.definedColumnFormOfUse, 0, arrayOfInt3, 1, this.definedColumnFormOfUse.length);
/*      */     }
/*      */ 
/*  207 */     allocateTmpByteArray();
/*      */ 
/*  209 */     T4C8Oall localT4C8Oall = this.t4Connection.all8;
/*      */     try
/*      */     {
/*  215 */       localT4C8Oall.doOALL(paramBoolean1, paramBoolean2, paramBoolean3, paramBoolean4, paramBoolean5, this.sqlKind, this.cursorId, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals), i, this.outBindAccessors, this.numberOfBindPositions, this.accessors, j, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.connection.conversion, this.tmpBindsByteArray, this.parameterStream, this.parameterDatum, this.parameterOtype, this, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, this.oacdefSent, arrayOfInt1, arrayOfInt2, arrayOfInt3, this.registration);
/*      */ 
/*  227 */       i2 = localT4C8Oall.getCursorId();
/*  228 */       if ((i2 != 0) && (this.implicitResultSetStatements == null)) {
/*  229 */         this.cursorId = i2;
/*      */       }
/*  231 */       this.oacdefSent = localT4C8Oall.oacdefBindsSent;
/*  232 */       if (this.connection.isPDBChanged) {
/*  233 */         NTFPDBChangeEvent localNTFPDBChangeEvent = new NTFPDBChangeEvent(this.connection);
/*      */ 
/*  235 */         ((T4CConnection)this.connection).notify(localNTFPDBChangeEvent);
/*  236 */         this.connection.isPDBChanged = false;
/*      */       }
/*      */     }
/*      */     catch (SQLException localSQLException2)
/*      */     {
/*  241 */       int i4 = localT4C8Oall.getCursorId();
/*  242 */       if (i4 != 0) {
/*  243 */         this.cursorId = i4;
/*      */       }
/*  245 */       if (localSQLException2.getErrorCode() == DatabaseError.getVendorCode(110))
/*      */       {
/*  248 */         this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
/*      */       }
/*      */       else
/*      */       {
/*  253 */         throw localSQLException2;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void allocateTmpByteArray()
/*      */   {
/*  263 */     if (this.tmpByteArray == null)
/*      */     {
/*  266 */       this.tmpByteArray = new byte[this.sizeTmpByteArray];
/*      */     }
/*  268 */     else if (this.sizeTmpByteArray > this.tmpByteArray.length)
/*      */     {
/*  272 */       this.tmpByteArray = new byte[this.sizeTmpByteArray];
/*      */     }
/*      */   }
/*      */ 
/*      */   void releaseBuffers()
/*      */   {
/*  284 */     super.releaseBuffers();
/*  285 */     this.tmpByteArray = null;
/*  286 */     this.tmpBindsByteArray = null;
/*      */ 
/*  288 */     if (this.t4Connection != null)
/*      */     {
/*  290 */       this.t4Connection.all8.bindChars = null;
/*  291 */       this.t4Connection.all8.bindBytes = null;
/*  292 */       this.t4Connection.all8.tmpBindsByteArray = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   void allocateRowidAccessor()
/*      */     throws SQLException
/*      */   {
/*  300 */     this.accessors[0] = new T4CRowidAccessor(this, 128, 1, -8, false, this.t4Connection.mare);
/*      */   }
/*      */ 
/*      */   void reparseOnRedefineIfNeeded()
/*      */     throws SQLException
/*      */   {
/*  313 */     this.needToParse = true;
/*      */   }
/*      */ 
/*      */   protected void defineColumnTypeInternal(int paramInt1, int paramInt2, int paramInt3, short paramShort, boolean paramBoolean, String paramString)
/*      */     throws SQLException
/*      */   {
/*  324 */     if (this.connection.disableDefinecolumntype)
/*      */     {
/*  327 */       return;
/*      */     }
/*  329 */     if ((paramInt2 == -15) || (paramInt2 == -9) || (paramInt2 == -16))
/*      */     {
/*  331 */       paramShort = 2;
/*      */     }
/*      */     SQLException localSQLException;
/*  336 */     if (paramInt1 < 1)
/*      */     {
/*  338 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  339 */       localSQLException.fillInStackTrace();
/*  340 */       throw localSQLException;
/*      */     }
/*      */ 
/*  343 */     if ((this.currentResultSet != null) && (!this.currentResultSet.closed))
/*      */     {
/*  345 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 28);
/*  346 */       localSQLException.fillInStackTrace();
/*  347 */       throw localSQLException;
/*      */     }
/*      */ 
/*  354 */     int i = paramInt1 - 1;
/*      */     int[] arrayOfInt;
/*  356 */     if ((this.definedColumnType == null) || (this.definedColumnType.length <= i))
/*      */     {
/*  358 */       if (this.definedColumnType == null)
/*      */       {
/*  360 */         this.definedColumnType = new int[(i + 1) * 4];
/*      */       }
/*      */       else
/*      */       {
/*  372 */         arrayOfInt = new int[(i + 1) * 4];
/*      */ 
/*  374 */         System.arraycopy(this.definedColumnType, 0, arrayOfInt, 0, this.definedColumnType.length);
/*      */ 
/*  377 */         this.definedColumnType = arrayOfInt;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  383 */     this.definedColumnType[i] = paramInt2;
/*      */ 
/*  385 */     if ((this.definedColumnSize == null) || (this.definedColumnSize.length <= i))
/*      */     {
/*  387 */       if (this.definedColumnSize == null) {
/*  388 */         this.definedColumnSize = new int[(i + 1) * 4];
/*      */       }
/*      */       else
/*      */       {
/*  392 */         arrayOfInt = new int[(i + 1) * 4];
/*      */ 
/*  394 */         System.arraycopy(this.definedColumnSize, 0, arrayOfInt, 0, this.definedColumnSize.length);
/*      */ 
/*  397 */         this.definedColumnSize = arrayOfInt;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  402 */     this.definedColumnSize[i] = ((paramInt2 == 2005) || (paramInt2 == 2004) ? paramInt3 : -1);
/*      */ 
/*  404 */     if ((this.definedColumnFormOfUse == null) || (this.definedColumnFormOfUse.length <= i))
/*      */     {
/*  406 */       if (this.definedColumnFormOfUse == null) {
/*  407 */         this.definedColumnFormOfUse = new int[(i + 1) * 4];
/*      */       }
/*      */       else
/*      */       {
/*  411 */         arrayOfInt = new int[(i + 1) * 4];
/*      */ 
/*  413 */         System.arraycopy(this.definedColumnFormOfUse, 0, arrayOfInt, 0, this.definedColumnFormOfUse.length);
/*      */ 
/*  416 */         this.definedColumnFormOfUse = arrayOfInt;
/*      */       }
/*      */     }
/*      */ 
/*  420 */     this.definedColumnFormOfUse[i] = paramShort;
/*      */ 
/*  422 */     if ((this.accessors != null) && (i < this.accessors.length) && (this.accessors[i] != null))
/*      */     {
/*  424 */       this.accessors[i].definedColumnSize = paramInt3;
/*      */ 
/*  429 */       if (((this.accessors[i].internalType == 96) || (this.accessors[i].internalType == 1)) && ((paramInt2 == 1) || (paramInt2 == 12)))
/*      */       {
/*  433 */         if (paramInt3 <= this.accessors[i].oacmxl)
/*      */         {
/*  439 */           this.needToPrepareDefineBuffer = true;
/*  440 */           this.columnsDefinedByUser = true;
/*      */ 
/*  442 */           this.accessors[i].initForDataAccess(paramInt2, paramInt3, null);
/*  443 */           this.accessors[i].calculateSizeTmpByteArray();
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  448 */     this.executeDoneForDefines = false;
/*      */   }
/*      */ 
/*      */   public void clearDefines() throws SQLException
/*      */   {
/*  453 */     synchronized (this.connection)
/*      */     {
/*  455 */       super.clearDefines();
/*  456 */       this.definedColumnType = null;
/*  457 */       this.definedColumnSize = null;
/*  458 */       this.definedColumnFormOfUse = null;
/*  459 */       if ((this.t4Connection != null) && (this.t4Connection.all8 != null))
/*  460 */         this.t4Connection.all8.definesAccessors = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   void doSetSnapshotSCN(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  469 */     this.inScn = paramLong;
/*      */   }
/*      */ 
/*      */   Accessor allocateAccessor(int paramInt1, int paramInt2, int paramInt3, int paramInt4, short paramShort, String paramString, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  489 */     Object localObject = null;
/*      */     SQLException localSQLException;
/*  491 */     switch (paramInt1)
/*      */     {
/*      */     case 96:
/*  495 */       localObject = new T4CCharAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  498 */       break;
/*      */     case 8:
/*  501 */       if (!paramBoolean)
/*      */       {
/*  503 */         localObject = new T4CLongAccessor(this, paramInt3, paramInt4, paramShort, paramInt2, this.t4Connection.mare);
/*      */       }
/*      */ 
/*  506 */       break;
/*      */     case 1:
/*  511 */       localObject = new T4CVarcharAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  514 */       break;
/*      */     case 2:
/*  517 */       localObject = new T4CNumberAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  520 */       break;
/*      */     case 6:
/*  523 */       localObject = new T4CVarnumAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  526 */       break;
/*      */     case 24:
/*  529 */       if (!paramBoolean)
/*      */       {
/*  531 */         localObject = new T4CLongRawAccessor(this, paramInt3, paramInt4, paramShort, paramInt2, this.t4Connection.mare);
/*      */       }
/*      */ 
/*  534 */       break;
/*      */     case 23:
/*  539 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/*  541 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/*  542 */         localSQLException.fillInStackTrace();
/*  543 */         throw localSQLException;
/*      */       }
/*      */ 
/*  546 */       if (paramBoolean) {
/*  547 */         localObject = new T4COutRawAccessor(this, paramInt4, paramShort, paramInt2, this.t4Connection.mare);
/*      */       }
/*      */       else {
/*  550 */         localObject = new T4CRawAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */       }
/*      */ 
/*  553 */       break;
/*      */     case 100:
/*  556 */       localObject = new T4CBinaryFloatAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  559 */       break;
/*      */     case 101:
/*  562 */       localObject = new T4CBinaryDoubleAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  565 */       break;
/*      */     case 104:
/*  568 */       if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK)
/*      */       {
/*  574 */         localObject = new T4CVarcharAccessor(this, 18, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  578 */         ((Accessor)localObject).definedColumnType = -8;
/*      */       }
/*      */       else {
/*  581 */         localObject = new T4CRowidAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */       }
/*      */ 
/*  585 */       break;
/*      */     case 102:
/*  588 */       localObject = new T4CResultSetAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  591 */       break;
/*      */     case 12:
/*  594 */       localObject = new T4CDateAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  597 */       break;
/*      */     case 113:
/*  600 */       localObject = new T4CBlobAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  603 */       break;
/*      */     case 112:
/*  606 */       localObject = new T4CClobAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  609 */       break;
/*      */     case 114:
/*  612 */       localObject = new T4CBfileAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  615 */       break;
/*      */     case 109:
/*  618 */       localObject = new T4CNamedTypeAccessor(this, paramString, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  621 */       ((Accessor)localObject).initMetadata();
/*      */ 
/*  623 */       break;
/*      */     case 111:
/*  626 */       localObject = new T4CRefTypeAccessor(this, paramString, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  629 */       ((Accessor)localObject).initMetadata();
/*      */ 
/*  631 */       break;
/*      */     case 180:
/*  636 */       localObject = new T4CTimestampAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  639 */       break;
/*      */     case 181:
/*  642 */       localObject = new T4CTimestamptzAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  645 */       break;
/*      */     case 231:
/*  648 */       localObject = new T4CTimestampltzAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  651 */       break;
/*      */     case 182:
/*  654 */       localObject = new T4CIntervalymAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  657 */       break;
/*      */     case 183:
/*  660 */       localObject = new T4CIntervaldsAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  663 */       break;
/*      */     case 995:
/*  676 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 89);
/*  677 */       localSQLException.fillInStackTrace();
/*  678 */       throw localSQLException;
/*      */     }
/*      */ 
/*  682 */     return localObject;
/*      */   }
/*      */ 
/*      */   void doDescribe(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  708 */     if (!this.isOpen)
/*      */     {
/*  711 */       this.connection.open(this);
/*  712 */       this.isOpen = true;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  718 */       this.t4Connection.needLine();
/*  719 */       this.t4Connection.describe.doODNY(this, 0, this.accessors, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals));
/*  720 */       this.accessors = this.t4Connection.describe.getAccessors();
/*      */ 
/*  722 */       this.numberOfDefinePositions = this.t4Connection.describe.numuds;
/*      */ 
/*  724 */       for (int i = 0; i < this.numberOfDefinePositions; i++)
/*  725 */         this.accessors[i].initMetadata();
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  729 */       ((T4CConnection)this.connection).handleIOException(localIOException);
/*      */ 
/*  732 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  733 */       localSQLException.fillInStackTrace();
/*  734 */       throw localSQLException;
/*      */     }
/*      */ 
/*  738 */     this.describedWithNames = true;
/*  739 */     this.described = true;
/*      */   }
/*      */ 
/*      */   void executeForDescribe()
/*      */     throws SQLException
/*      */   {
/*  774 */     this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.execute_for_describe");
/*      */     try {
/*  776 */       doOall8(true, true, this.definedColumnType != null, true, this.definedColumnType != null);
/*      */     }
/*      */     catch (SQLException localSQLException1)
/*      */     {
/*      */       long l1;
/*  785 */       throw localSQLException1;
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  789 */       ((T4CConnection)this.connection).handleIOException(localIOException);
/*      */ 
/*  791 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  792 */       localSQLException2.fillInStackTrace();
/*  793 */       throw localSQLException2;
/*      */     }
/*      */     finally
/*      */     {
/*  798 */       this.rowsProcessed = this.t4Connection.all8.rowsProcessed;
/*  799 */       this.validRows = this.t4Connection.all8.getNumRows();
/*  800 */       if (this.connection.checksumMode.needToCalculateFetchChecksum()) {
/*  801 */         if (this.validRows > 0) {
/*  802 */           calculateCheckSum();
/*  803 */         } else if (this.rowsProcessed > 0) {
/*  804 */           long l2 = CRC64.updateChecksum(this.checkSum, this.rowsProcessed);
/*      */ 
/*  806 */           this.checkSum = l2;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  811 */     this.needToParse = false;
/*      */ 
/*  821 */     if (this.definedColumnType == null) {
/*  822 */       this.implicitDefineForLobPrefetchDone = false;
/*      */     }
/*  824 */     this.aFetchWasDoneDuringDescribe = false;
/*  825 */     if (this.t4Connection.all8.aFetchWasDone)
/*      */     {
/*  827 */       this.aFetchWasDoneDuringDescribe = true;
/*  828 */       this.rowPrefetchInLastFetch = this.rowPrefetch;
/*      */     }
/*      */ 
/*  832 */     for (int i = 0; i < this.numberOfDefinePositions; i++) {
/*  833 */       this.accessors[i].initMetadata();
/*      */     }
/*  835 */     this.needToPrepareDefineBuffer = false;
/*      */   }
/*      */ 
/*      */   void executeForRows(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/*      */       try
/*      */       {
/*  877 */         boolean bool = false;
/*  878 */         if (this.columnsDefinedByUser) {
/*  879 */           this.needToPrepareDefineBuffer = false;
/*      */         }
/*  899 */         else if ((this.t4Connection.useLobPrefetch) && (this.accessors != null) && (this.defaultLobPrefetchSize != -1) && (!this.implicitDefineForLobPrefetchDone) && (!this.aFetchWasDoneDuringDescribe) && (this.definedColumnType == null))
/*      */         {
/*  907 */           int i = 0;
/*  908 */           int[] arrayOfInt1 = new int[this.accessors.length];
/*  909 */           int[] arrayOfInt2 = new int[this.accessors.length];
/*  910 */           int[] arrayOfInt3 = new int[this.accessors.length];
/*      */ 
/*  912 */           for (int j = 0; j < this.accessors.length; j++) {
/*  913 */             if (this.accessors[j] != null)
/*      */             {
/*  917 */               arrayOfInt1[j] = getJDBCType(this.accessors[j].internalType);
/*  918 */               arrayOfInt3[j] = this.accessors[j].formOfUse;
/*  919 */               if ((this.accessors[j].internalType == 113) || (this.accessors[j].internalType == 112) || (this.accessors[j].internalType == 114))
/*      */               {
/*  925 */                 i = 1;
/*      */ 
/*  927 */                 this.accessors[j].setPrefetchLength(this.defaultLobPrefetchSize);
/*  928 */                 arrayOfInt2[j] = this.defaultLobPrefetchSize;
/*      */               }
/*      */             }
/*      */           }
/*  932 */           if (i != 0)
/*      */           {
/*  934 */             this.definedColumnType = arrayOfInt1;
/*  935 */             this.definedColumnSize = arrayOfInt2;
/*  936 */             this.definedColumnFormOfUse = arrayOfInt3;
/*  937 */             bool = true;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  943 */         doOall8(this.needToParse, !paramBoolean, true, false, bool);
/*      */ 
/*  945 */         this.needToParse = false;
/*  946 */         if (bool)
/*  947 */           this.implicitDefineForLobPrefetchDone = true;
/*      */       }
/*      */       finally
/*      */       {
/*  951 */         if (this.implicitResultSetStatements == null)
/*  952 */           this.validRows = this.t4Connection.all8.getNumRows();
/*      */         else
/*  954 */           this.validRows = 0;
/*  955 */         calculateCheckSum();
/*      */       }
/*      */     }
/*      */     catch (SQLException localSQLException1)
/*      */     {
/*  960 */       throw localSQLException1;
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  964 */       ((T4CConnection)this.connection).handleIOException(localIOException);
/*      */ 
/*  966 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  967 */       localSQLException2.fillInStackTrace();
/*  968 */       throw localSQLException2;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void fetch(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  994 */     if (this.rowData != null)
/*  995 */       if (paramBoolean)
/*      */       {
/*  997 */         this.rowData.setPosition(this.rowData.length());
/*      */       }
/*  999 */       else this.rowData.reset();
/*      */     SQLException localSQLException;
/* 1003 */     if (this.streamList != null)
/*      */     {
/* 1005 */       while (this.nextStream != null) {
/*      */         try {
/* 1007 */           this.nextStream.close();
/*      */         }
/*      */         catch (IOException localIOException1) {
/* 1010 */           ((T4CConnection)this.connection).handleIOException(localIOException1);
/*      */ 
/* 1012 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException1);
/* 1013 */           localSQLException.fillInStackTrace();
/* 1014 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1017 */         this.nextStream = this.nextStream.nextStream;
/*      */       }
/*      */     }
/*      */     try
/*      */     {
/* 1022 */       doOall8(false, false, true, false, false, paramInt);
/* 1023 */       this.validRows = this.t4Connection.all8.getNumRows();
/* 1024 */       if (this.validRows != -2) this.validRows -= paramInt;
/* 1025 */       calculateCheckSum();
/*      */     }
/*      */     catch (IOException localIOException2) {
/* 1028 */       ((T4CConnection)this.connection).handleIOException(localIOException2);
/*      */ 
/* 1030 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException2);
/* 1031 */       localSQLException.fillInStackTrace();
/* 1032 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   void continueReadRow(int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 1051 */       if (!this.isFetchStreams)
/*      */       {
/* 1053 */         T4C8Oall localT4C8Oall = this.t4Connection.all8;
/*      */ 
/* 1055 */         localT4C8Oall.continueReadRow(paramInt, this);
/*      */       }
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 1060 */       ((T4CConnection)this.connection).handleIOException(localIOException);
/*      */ 
/* 1062 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1063 */       localSQLException2.fillInStackTrace();
/* 1064 */       throw localSQLException2;
/*      */     }
/*      */     catch (SQLException localSQLException1)
/*      */     {
/* 1069 */       if (localSQLException1.getErrorCode() == DatabaseError.getVendorCode(110))
/*      */       {
/* 1072 */         this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
/*      */       }
/*      */       else
/*      */       {
/* 1077 */         throw localSQLException1;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void doClose()
/*      */     throws SQLException
/*      */   {
/* 1101 */     this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.do_close");
/* 1102 */     if (this.cursorId != 0)
/*      */     {
/* 1104 */       this.t4Connection.closeCursor(this.cursorId);
/*      */     }
/*      */ 
/* 1107 */     this.tmpByteArray = null;
/* 1108 */     this.tmpBindsByteArray = null;
/* 1109 */     this.definedColumnType = null;
/* 1110 */     this.definedColumnSize = null;
/* 1111 */     this.definedColumnFormOfUse = null;
/* 1112 */     this.oacdefSent = null;
/*      */   }
/*      */ 
/*      */   void closeQuery()
/*      */     throws SQLException
/*      */   {
/* 1131 */     this.connection.registerHeartbeat();
/* 1132 */     this.connection.needLine();
/* 1133 */     this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.closeQuery");
/*      */ 
/* 1135 */     if (this.streamList != null)
/*      */     {
/* 1137 */       while (this.nextStream != null) {
/*      */         try {
/* 1139 */           this.nextStream.close();
/*      */         }
/*      */         catch (IOException localIOException) {
/* 1142 */           ((T4CConnection)this.connection).handleIOException(localIOException);
/*      */ 
/* 1144 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1145 */           localSQLException.fillInStackTrace();
/* 1146 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1149 */         this.nextStream = this.nextStream.nextStream;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   Binder getRowidNullBinder(int paramInt)
/*      */   {
/* 1160 */     if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK)
/*      */     {
/* 1163 */       this.currentRowCharLens[paramInt] = 1;
/* 1164 */       return this.theVarcharNullBinder;
/*      */     }
/*      */ 
/* 1167 */     return this.theRowidNullBinder;
/*      */   }
/*      */ 
/*      */   void doLocalInitialization()
/*      */   {
/* 1176 */     super.doLocalInitialization();
/*      */ 
/* 1178 */     this.t4Connection.all8.bindChars = this.bindChars;
/* 1179 */     this.t4Connection.all8.bindBytes = this.bindBytes;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CPreparedStatement
 * JD-Core Version:    0.6.2
 */