/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ 
/*     */ class T4CPlsqlIndexTableAccessor extends PlsqlIndexTableAccessor
/*     */ {
/*     */   T4CMAREngine mare;
/* 215 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CPlsqlIndexTableAccessor(OracleStatement paramOracleStatement, PlsqlIbtBindInfo paramPlsqlIbtBindInfo, short paramShort, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  40 */     super(paramOracleStatement, paramPlsqlIbtBindInfo, paramShort);
/*     */ 
/*  42 */     calculateSizeTmpByteArray();
/*     */ 
/*  44 */     this.mare = paramT4CMAREngine;
/*     */   }
/*     */ 
/*     */   public T4CMAREngine getMAREngine()
/*     */   {
/*  51 */     return this.mare;
/*     */   }
/*     */ 
/*     */   public void unmarshalColumnMetadata()
/*     */     throws SQLException, IOException
/*     */   {
/*  60 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*     */     {
/*  63 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processIndicator(int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/*  70 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*     */     {
/*  77 */       this.mare.unmarshalUB2();
/*  78 */       this.mare.unmarshalUB2();
/*     */     }
/*  80 */     else if (this.statement.connection.versionNumber < 9200)
/*     */     {
/*  84 */       this.mare.unmarshalSB2();
/*     */ 
/*  86 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/*  87 */         this.mare.unmarshalSB2();
/*     */     }
/*  89 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/*  90 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getPreviousRowProcessed()
/*     */   {
/*  96 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/*  97 */     return this.previousRowProcessed;
/*     */   }
/*     */ 
/*     */   boolean unmarshalOneRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 112 */     boolean bool = false;
/* 113 */     if (!isUseless())
/*     */     {
/* 119 */       if (isUnexpected())
/*     */       {
/* 122 */         long l = this.rowData.getPosition();
/* 123 */         unmarshalColumnMetadata();
/* 124 */         unmarshalBytes();
/* 125 */         this.rowData.setPosition(l);
/* 126 */         setNull(this.lastRowProcessed, true);
/*     */       }
/* 128 */       else if (isNullByDescribe())
/*     */       {
/* 131 */         setNull(this.lastRowProcessed, true);
/* 132 */         unmarshalColumnMetadata();
/* 133 */         if (this.statement.connection.versionNumber < 9200) processIndicator(0);
/*     */       }
/*     */       else
/*     */       {
/* 137 */         unmarshalColumnMetadata();
/* 138 */         bool = unmarshalBytes();
/*     */       }
/*     */     }
/* 140 */     this.previousRowProcessed = this.lastRowProcessed;
/* 141 */     this.lastRowProcessed += 1;
/* 142 */     return bool;
/*     */   }
/*     */ 
/*     */   boolean unmarshalBytes()
/*     */     throws SQLException, IOException
/*     */   {
/* 154 */     int i = (int)this.mare.unmarshalUB4();
/* 155 */     if (i != 0) {
/* 156 */       setOffset(this.lastRowProcessed);
/* 157 */       this.rowData.putInt(i);
/* 158 */       j = 0;
/*     */       while (true) {
/* 160 */         long l = this.rowData.getPosition();
/* 161 */         this.rowData.putShort((short)0);
/* 162 */         int k = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
/* 163 */         this.rowData.putShort(l, (short)k);
/*     */ 
/* 165 */         processIndicator(k);
/* 166 */         j++; if (j == i) break;
/*     */       }
/*     */     }
/* 169 */     int j = (int)(this.rowData.getPosition() - getOffset(this.lastRowProcessed));
/* 170 */     setLength(this.lastRowProcessed, j);
/* 171 */     setNull(this.lastRowProcessed, j == 0);
/* 172 */     return false;
/*     */   }
/*     */ 
/*     */   void copyRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 181 */     if (this.isNullByDescribe) {
/* 182 */       setNull(this.lastRowProcessed, true);
/*     */     }
/* 184 */     else if (this.lastRowProcessed == 0)
/*     */     {
/* 189 */       if (this.previousRowProcessed == -1)
/* 190 */         this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 191 */       long l = getOffset(this.previousRowProcessed);
/* 192 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 193 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 194 */       if (!isNull(this.previousRowProcessed)) {
/* 195 */         setOffset(this.lastRowProcessed);
/* 196 */         ((DynamicByteArray)this.rowData).copyLeft(l, getLength(this.previousRowProcessed));
/* 197 */         setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 202 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 203 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 204 */       setOffset(this.lastRowProcessed, getOffset(this.previousRowProcessed));
/* 205 */       setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */     }
/* 207 */     this.previousRowProcessed = this.lastRowProcessed;
/* 208 */     this.lastRowProcessed += 1;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CPlsqlIndexTableAccessor
 * JD-Core Version:    0.6.2
 */