/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ 
/*     */ class T4COutRawAccessor extends OutRawAccessor
/*     */ {
/*     */   T4CMAREngine mare;
/* 235 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4COutRawAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  38 */     super(paramOracleStatement, paramInt1, paramShort, paramInt2);
/*     */ 
/*  40 */     this.mare = paramT4CMAREngine;
/*     */   }
/*     */ 
/*     */   public T4CMAREngine getMAREngine() {
/*  44 */     return this.mare;
/*     */   }
/*     */ 
/*     */   public void unmarshalColumnMetadata()
/*     */     throws SQLException, IOException
/*     */   {
/*  53 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*     */     {
/*  56 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processIndicator(int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/*  63 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*     */     {
/*  70 */       this.mare.unmarshalUB2();
/*  71 */       this.mare.unmarshalUB2();
/*     */     }
/*  73 */     else if (this.statement.connection.versionNumber < 9200)
/*     */     {
/*  77 */       this.mare.unmarshalSB2();
/*     */ 
/*  79 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/*  80 */         this.mare.unmarshalSB2();
/*     */     }
/*  82 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/*  83 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getPreviousRowProcessed()
/*     */   {
/*  89 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/*  90 */     return this.previousRowProcessed;
/*     */   }
/*     */ 
/*     */   boolean unmarshalOneRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 105 */     boolean bool = false;
/* 106 */     if (!isUseless())
/*     */     {
/* 112 */       if (isUnexpected())
/*     */       {
/* 115 */         long l = this.rowData.getPosition();
/* 116 */         unmarshalColumnMetadata();
/* 117 */         unmarshalBytes();
/* 118 */         this.rowData.setPosition(l);
/* 119 */         setNull(this.lastRowProcessed, true);
/*     */       }
/* 121 */       else if (isNullByDescribe())
/*     */       {
/* 124 */         setNull(this.lastRowProcessed, true);
/* 125 */         unmarshalColumnMetadata();
/* 126 */         if (this.statement.connection.versionNumber < 9200) processIndicator(0);
/*     */       }
/*     */       else
/*     */       {
/* 130 */         unmarshalColumnMetadata();
/* 131 */         bool = unmarshalBytes();
/*     */       }
/*     */     }
/* 133 */     this.previousRowProcessed = this.lastRowProcessed;
/* 134 */     this.lastRowProcessed += 1;
/* 135 */     return bool;
/*     */   }
/*     */ 
/*     */   boolean unmarshalBytes()
/*     */     throws SQLException, IOException
/*     */   {
/* 147 */     setOffset(this.lastRowProcessed);
/*     */     int i;
/* 148 */     if (this.statement.maxFieldSize > 0)
/* 149 */       i = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare, this.statement.maxFieldSize);
/*     */     else
/* 151 */       i = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
/* 152 */     processIndicator(i);
/* 153 */     setLength(this.lastRowProcessed, i);
/* 154 */     setNull(this.lastRowProcessed, i == 0);
/* 155 */     return false;
/*     */   }
/*     */ 
/*     */   void copyRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 164 */     if (this.isNullByDescribe) {
/* 165 */       setNull(this.lastRowProcessed, true);
/*     */     }
/* 167 */     else if (this.lastRowProcessed == 0)
/*     */     {
/* 172 */       if (this.previousRowProcessed == -1)
/* 173 */         this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 174 */       long l = getOffset(this.previousRowProcessed);
/* 175 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 176 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 177 */       if (!isNull(this.previousRowProcessed)) {
/* 178 */         setOffset(this.lastRowProcessed);
/* 179 */         ((DynamicByteArray)this.rowData).copyLeft(l, getLength(this.previousRowProcessed));
/* 180 */         setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 185 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 186 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 187 */       setOffset(this.lastRowProcessed, getOffset(this.previousRowProcessed));
/* 188 */       setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */     }
/* 190 */     this.previousRowProcessed = this.lastRowProcessed;
/* 191 */     this.lastRowProcessed += 1;
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 202 */     if (this.definedColumnType == 0)
/* 203 */       return super.getObject(paramInt);
/* 204 */     if (isNull(paramInt)) return null;
/*     */ 
/* 206 */     switch (this.definedColumnType)
/*     */     {
/*     */     case -1:
/*     */     case 1:
/*     */     case 12:
/* 211 */       return getString(paramInt);
/*     */     case -2:
/* 214 */       return getRAW(paramInt);
/*     */     case -4:
/*     */     case -3:
/* 219 */       return getBytes(paramInt);
/*     */     case 0:
/*     */     case 2:
/*     */     case 3:
/*     */     case 4:
/*     */     case 5:
/*     */     case 6:
/*     */     case 7:
/*     */     case 8:
/*     */     case 9:
/*     */     case 10:
/* 223 */     case 11: } SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 224 */     localSQLException.fillInStackTrace();
/* 225 */     throw localSQLException;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4COutRawAccessor
 * JD-Core Version:    0.6.2
 */